// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	<Xm/Text.h>
#include	"widget.h"
#include	"widgetargs.h"
#include	"widgettext.h"
#include	"widgetresource.h"

static const char rcsid[]="$Id: widgettext.C,v 1.5 1999/06/14 02:11:49 mrsam Exp $";


static void OnModifiedCallback(Widget, XtPointer clientData, XtPointer)
{
	((CTextWidget *)clientData)->OnModified();
}

static void OnVerifyCallback(Widget, XtPointer clientData, XtPointer ptr)
{
	((CTextWidget *)clientData)->Verify(
		(XmTextVerifyCallbackStruct *)ptr);
}

WidgetClass CTextWidget::Class()
{
	return (xmTextWidgetClass);
}

CTextWidget::CTextWidget(const char * str) : CWidget(str),
	m_hresize(FALSE),
	m_vresize(FALSE),
	m_wrap(FALSE),
	m_multiline(FALSE),
	m_hscroll(TRUE),
	m_vscroll(TRUE)
{
}

CTextWidget::~CTextWidget()
{
}

void CTextWidget::Create(CWidget *parent, size_t ncols, size_t nrows)
{
CWidgetArgs	args;

	args.Add(XmNresizeWidth, m_hresize);
	args.Add(XmNresizeHeight, m_vresize);
	args.Add(XmNwordWrap, m_wrap);
	args.Add(XmNeditMode, m_multiline ? (int)XmMULTI_LINE_EDIT:
			(int)XmSINGLE_LINE_EDIT);
	args.Add(XmNscrollHorizontal, m_hscroll);
	args.Add(XmNscrollVertical, m_vscroll);

	if (nrows)
		args.Add(XmNrows, nrows);
	if (ncols)
		args.Add(XmNcolumns, ncols);
	CWidget::Create(parent, args);
	installActivateCallback();
	installFocusCallback();
	XtAddCallback(wid(), XmNvalueChangedCallback, &OnModifiedCallback,
			(XtPointer)this);
	XtAddCallback(wid(), XmNmodifyVerifyCallback, &OnVerifyCallback,
			(XtPointer)this);
	VisibleCursor(FALSE);

CWidgetResource res[2]={ 
	CWidgetResource("initialValid", CString("")),
	CWidgetResource("allValid", CString("")),
	} ;

	GetResources(res, 2);
	m_initialValid=res[0].Str();
	m_allValid=res[1].Str();
}

void CTextWidget::MaxLength(size_t cnt)
{
	if (!wid())	AfxThrowInternalException();

	XmTextSetMaxLength( wid(), cnt);
}

void CTextWidget::CursorPos(size_t cnt)
{
	if (!wid())	AfxThrowInternalException();

	XmTextSetInsertionPosition( wid(), cnt);
}

size_t CTextWidget::CursorPos()
{
	if (!wid())	AfxThrowInternalException();
	return (XmTextGetInsertionPosition(wid()));
}

void CTextWidget::TopPos(size_t cnt)
{
	if (!wid())	AfxThrowInternalException();

	XmTextSetTopCharacter( wid(), cnt);
}

size_t CTextWidget::TopPos()
{
	if (!wid())	AfxThrowInternalException();
	return (XmTextGetTopCharacter(wid()));
}

CString CTextWidget::Value()
{
	if (!wid())	AfxThrowInternalException();

char *str=XmTextGetString(wid());
CString	s;

	try
	{
		s=str;
		XtFree(str);
	}
	catch (...)
	{
		XtFree(str);
		throw;
	}
	return (s);
}

void CTextWidget::Value(CString str)
{
	if (!wid())	AfxThrowInternalException();

	XmTextSetString(wid(), (char *)(const char *)str);
}

void CTextWidget::Editable(AFXBOOL flag)
{
	if (!wid())	AfxThrowInternalException();

	XmTextSetEditable(wid(), flag);
}

void CTextWidget::VisibleCursor(AFXBOOL flag)
{
	if (!wid())	AfxThrowInternalException();

CWidgetArgs	args;

	args.Add(XmNcursorPositionVisible, flag);
	SetValues(args);
}

size_t CTextWidget::LastPosition()
{
	if (!wid())	AfxThrowInternalException();
	return (XmTextGetLastPosition(wid()));
}

void CTextWidget::Redisplay(AFXBOOL flag)
{
	if (!wid())	return;
	if (flag)
		XmTextEnableRedisplay(wid());
	else
		XmTextDisableRedisplay(wid());
}

void CTextWidget::GetSelected(size_t &start, size_t &end)
{
XmTextPosition s, e;

	if (!wid())	AfxThrowInternalException();
	XmTextGetSelectionPosition( wid(), &s, &e);
	start=s;
	end=e;
}

void CTextWidget::SetSelected(size_t start, size_t end)
{
	if (!wid())	AfxThrowInternalException();
	XmTextSetSelection( wid(), start, end, CurrentTime);
}

void CTextWidget::InsertAt(size_t pos, CString str)
{
	if (!wid())	AfxThrowInternalException();

	XmTextInsert(wid(), pos, (char *)(const char *)str);
}

void CTextWidget::OnModified()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// Default OnGotFocus()/OnLostFocus() turn visible cursor on/off.  This
// activity gets rid of the shadow cursor.

void CTextWidget::OnLostFocus()
{
	VisibleCursor(FALSE);
}

void CTextWidget::OnGotFocus()
{
	VisibleCursor(TRUE);
}

AFXBOOL CTextWidget::OnVerify(CString, CString prop, size_t, size_t, CString &)
{
	if (prop.GetLength() > 0)
	{
		if (m_initialValid.GetLength() > 0)
			if (!strchr(m_initialValid, prop[0]))
				return (FALSE);

		if (m_allValid.GetLength() > 0)
		{
		size_t i, n=prop.GetLength();

			for (i=1; i<n; i++)
				if (!strchr(m_allValid, prop[i]))
					return (FALSE);
		}
	}
	return (TRUE);
}

void CTextWidget::Verify(XmTextVerifyCallbackStruct *p)
{
	if (p->reason != XmCR_MODIFYING_TEXT_VALUE)
	{
		p->doit=FALSE;
		return;
	}

CString	str="";

	if (p->text && p->text->length && p->text->format == XmFMT_8_BIT)
		str=CString(p->text->ptr, p->text->length);

	m_verifystr=str;

	// Calculate new would-be contents

CString	new_value(Value());

	p->doit=OnVerify(str,
			new_value.Left(p->startPos) + str
				+ new_value.Mid(p->endPos),
			p->startPos, p->endPos, m_verifystr);
	if (p->doit && str != m_verifystr && p->text)
	{
		p->text->length=m_verifystr.GetLength();

	char	*q=XtRealloc(p->text->ptr, p->text->length);

		if (!q)	AfxThrowMemoryException();

		strcpy(q, m_verifystr);
		p->text->ptr=q;
	}
}

CPasswordTextWidget::CPasswordTextWidget(const char * str) : CTextWidget(str)
{
}

CPasswordTextWidget::~CPasswordTextWidget()
{
}

void CPasswordTextWidget::Create(CWidget *parent, size_t ncols)
{
	m_password="";
	CTextWidget::Create(parent, ncols);
}

AFXBOOL CPasswordTextWidget::OnVerify(CString str, CString full,
	size_t start, size_t end, CString &retstring)
{
	if (!CTextWidget::OnVerify(str, full, start, end, retstring))
		return (FALSE);

	if (str.Find('\n') >= 0 || str.Find('\t') >= 0 ||
		start > end || end > (size_t)m_password.GetLength())
		return (FALSE);

	m_password=m_password.Left(start) + str + m_password.Mid(end);
	if (str.GetLength() > 0)
		retstring=CString('*', str.GetLength());
	return (TRUE);
}

void CPasswordTextWidget::Value(CString str)
{
	CTextWidget::Value(CString('*', str.GetLength()));
	m_password=str;
}

CString	CPasswordTextWidget::Value()
{
	return (m_password);
}

void CPasswordTextWidget::OnActivate()
{
}
