// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetshell_h
#define	widgetshell_h

static const char widgetshell_h_rcsid[]="$Id: widgetshell.h,v 1.4 1999/04/12 04:38:22 mrsam Exp $";

#include	"afx.h"
#include	"afxtempl.h"
#include	"widgettimer.h"
#include	<X11/Intrinsic.h>

////////////////////////////////////////////////////////////////////////
//
//  A shell widget represents an additional top-level window in the app

class CShellWidget;

class CShellWidget : public CWidget {

	CString	m_class;
	CAfxAutoObj<CXmIcon>	m_icon;

	CXmTimeout<CShellWidget> m_autoiconify_timeout;	// Automatic iconify
	CXmTimeout<CShellWidget> m_autoclose_timeout;	// Automatic close
	AFXBOOL	m_auto_deiconify;	// Flag - automatic deiconify
	unsigned m_auto_iconify_seconds;
	unsigned m_auto_close_seconds;
protected:
	void	OnClose();
	void	OnDestroy();
public:
	CShellWidget(const char *);
	~CShellWidget();
	void	Create(CString name);
	void	Realize();
	CString	ClassName();
	int	Iconic();
	virtual void Iconify();
	virtual void DeIconify();

	void	AutoDeIconify(AFXBOOL);
	void	AutoIconify(unsigned);	// # of seconds, 0 to turn off
	void	AutoClose(unsigned);	// # of seconds
	virtual void AutoClose();	// Callback
	void	Activity();
	void	OnMapped();
	void	OnUnmapped();
private:
	void	iconify();
	void	close();
} ;

#endif
