// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetresource_h
#define	widgetresource_h

static const char widgetresource_h_rcsid[]="$Id: widgetresource.h,v 1.3 1999/03/24 05:28:43 mrsam Exp $";


#include	"afx.h"
#include	<X11/Intrinsic.h>

///////////////////////////////////////////////////////////////////////////
//
//  Here's an interface to XtGetSubResources

class CWidgetResource {

	enum { intresource, stringresource } m_type;
	CString m_name;
	CString m_class;
	CString	m_strdefault;

	char	*m_strval;
	int	m_intval;

public:
	CWidgetResource() : m_type(intresource)	{}
	~CWidgetResource() {}
	CWidgetResource(const CWidgetResource &c)
		{
			operator=(c);
		}

	CWidgetResource &operator=(const CWidgetResource &c)
		{
			m_type=c.m_type;
			m_name=c.m_name;
			m_class=c.m_class;
			m_strdefault=c.m_strdefault;
			m_strval=c.m_strval;
			m_intval=c.m_intval;
			return (*this);
		}

	CWidgetResource(CString name, CString defaultVal)
		{
			Create(name, defaultVal);
		}

	CWidgetResource(CString name, CString cl, CString defaultVal)
		{
			Create(name, cl, defaultVal);
		}

	CWidgetResource(CString name, int defaultVal)
		{
			Create(name, defaultVal);
		}

	CWidgetResource(CString name, CString cl, int defaultVal)
		{
			Create(name, cl, defaultVal);
		}

	void Create(CString name, CString defaultVal)
		{
			Create(name, CString(""), defaultVal);
		}

	void Create(CString name, int defaultVal)
		{
			Create(name, CString(""), defaultVal);
		}

	void Create(CString name, CString cl, CString defaultVal);
	void Create(CString name, CString cl, int defaultVal);

	CString	Str()	{ return (m_strval); }
	int	Int()	{ return (m_intval); }

	friend class CWidget;
} ;
#endif
