// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	<Xm/Label.h>
#include	<Xm/LabelG.h>
#include	<Xm/PushB.h>
#include	<Xm/PushBG.h>
#include	<Xm/ToggleB.h>
#include	<Xm/ToggleBG.h>
#include	<Xm/CascadeB.h>
#include	<Xm/CascadeBG.h>
#include	<Xm/Separator.h>
#include	<Xm/SeparatoG.h>
#include	<Xm/Form.h>
#include	"afx.h"
#include	"widget.h"
#include	"widgetprim.h"
#include	"widgetargs.h"
#include	"widgetresource.h"

static const char rcsid[]="$Id: widgetprim.C,v 1.6 1999/06/14 02:11:49 mrsam Exp $";

////////////////////////////////////////////////////////////////////////

void CLabelWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
}

CLabelWidget::CLabelWidget(const char * name) : CWidget(name)
{
}

CLabelWidget::~CLabelWidget()
{
}

WidgetClass CLabelWidget::Class()
{
	return (xmLabelWidgetClass);
}

////////////////////////////////////////////////////////////////////////

WidgetClass CSeparatorWidget::Class()
{
	return (IsGadget() ? xmSeparatorGadgetClass:xmSeparatorWidgetClass);
}

CSeparatorWidget::CSeparatorWidget(const char * str) : CWidget(str)
{
}

CSeparatorWidget::~CSeparatorWidget()
{
}

void CSeparatorWidget::Create(CWidget *parent, separator_orientation type)
{
	if (!parent || !parent->wid())
		AfxThrowInternalException();

CWidgetArgs	args;

	args.Add(XmNorientation,
		(type == horizontal ? (int)XmHORIZONTAL:(int)XmVERTICAL) );
	CWidget::Create(parent, args);
}

////////////////////////////////////////////////////////////////////////

void CPushButtonWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
	installActivateCallback();
}

CPushButtonWidget::CPushButtonWidget(const char * name) : CWidget(name)
{
}

CPushButtonWidget::~CPushButtonWidget()
{
}

WidgetClass CPushButtonWidget::Class()
{
	return (IsGadget() ?
		xmPushButtonGadgetClass:
		xmPushButtonWidgetClass);
}

////////////////////////////////////////////////////////////////////////

static void OnValueChangedCallback(Widget, XtPointer clientData, XtPointer)
{
	((CWidget *)clientData)->OnActivate();
}

void CToggleButtonWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);

	XtAddCallback(wid(), XmNvalueChangedCallback,
		&OnValueChangedCallback, (XtPointer)(CWidget *)this);
}

CToggleButtonWidget::CToggleButtonWidget(const char * name) : CWidget(name)
{
}

CToggleButtonWidget::~CToggleButtonWidget()
{
}

WidgetClass CToggleButtonWidget::Class()
{
	return (IsGadget() ?
		xmToggleButtonGadgetClass:
		xmToggleButtonWidgetClass);
}

AFXBOOL	CToggleButtonWidget::IsSet()
{
	return (GetValueInt(XmNset));
}

void	CToggleButtonWidget::Set(AFXBOOL n)
{
CWidgetArgs args;

	args.Add(XmNset, n);
	SetValues(args);
}


////////////////////////////////////////////////////////////////////////

void CCascadeButtonWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
}

CCascadeButtonWidget::CCascadeButtonWidget(const char * name) : CWidget(name)
{
}

CCascadeButtonWidget::~CCascadeButtonWidget()
{
}

WidgetClass CCascadeButtonWidget::Class()
{
	return (IsGadget() ?
		xmCascadeButtonGadgetClass:
		xmCascadeButtonWidgetClass);
}

////////////////////////////////////////////////////////////////////////

void CFormWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
}

CFormWidget::CFormWidget(const char * name) : CWidget(name),
					m_autoDialogUnmanage(FALSE)
{
}

CFormWidget::~CFormWidget()
{
}

WidgetClass CFormWidget::Class()
{
	return (xmFormWidgetClass);
}

Widget	CFormWidget::CreateWidget(const char * name, Widget parent,
				CWidgetArgs *args)
{
	if (!IsDialog())
		return (CWidget::CreateWidget(name, parent, args));

CWidgetArgs	dummy_args;

	if (!args)	args= &dummy_args;

	args->Add(XmNautoUnmanage, m_autoDialogUnmanage);

Arg	*argp;
int	argn;

	GetArgs(args, argp, argn);
	return ( XmCreateFormDialog(parent, (String)name, argp, argn));
}
