// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetmenu_h
#define	widgetmenu_h

static const char widgetmenu_h_rcsid[]="$Id: widgetmenu.h,v 1.3 1999/04/09 02:25:54 mrsam Exp $";


#include	"afx.h"
#include	"afxtempl.h"

#include	<X11/Intrinsic.h>
#include	<Xm/Xm.h>

class CCascadeButtonWidget;

class CWidgetArgs;

/////////////////////////////////////////////////////////////////////
//
// Here's a menubar widget

class CMenuBarWidget : public CWidget {

	Widget CreateWidget(const char *, Widget, CWidgetArgs *);
			// Override for special creation

	CArray<CCascadeButtonWidget *, CCascadeButtonWidget *> m_menus;
	CStringArray	m_buttonLabels;
	CWidget *Button(size_t);
public:
	friend class CPulldownMenuWidget;

	CMenuBarWidget(const char *);
	~CMenuBarWidget();
	void	Create(CWidget *parent, size_t nMenus);

private:
	void	RemoveChildren();
} ;

/////////////////////////////////////////////////////////////////////
//
// Here's a pulldown menu widget

class CPulldownMenuWidget : public CWidget {

	Widget CreateWidget(const char *, Widget, CWidgetArgs *);
			// Override for special creation

//	CMenuBarWidget	*m_mbar;
//	int		m_nMenu;
public:
	CPulldownMenuWidget(const char *);
	~CPulldownMenuWidget();
	void	Create(CMenuBarWidget &, int);
	void	Create(CWidget *);
} ;

/////////////////////////////////////////////////////////////////////
//
// Here's a popup menu widget

class CPopupMenuWidget : public CWidget {

	Widget CreateWidget(const char *, Widget, CWidgetArgs *);
			// Override for special creation

public:
	CPopupMenuWidget(const char *);
	~CPopupMenuWidget();
	void	Create(CWidget *parent);
	void	Manage();
			// This one _BETTER_ be called in response
			// to a button event!!!
} ;

//////////////////////////////////////////////////////////////////////////
//
//  Here's an OptionMenu widget.

class COptionMenuWidget : public CWidget {

	Widget CreateWidget(const char *, Widget, CWidgetArgs *);
public:
	COptionMenuWidget(const char *);
	~COptionMenuWidget();
	void	Create(CWidget *parent, CPulldownMenuWidget *pulldown);
} ;

#endif
