// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	<Xm/RowColumn.h>
#include	<iostream.h>
#include	<strstream.h>
#include	"widget.h"
#include	"widgetmenu.h"
#include	"widgetprim.h"
#include	"widgetargs.h"
#include	"widgetresource.h"
#include	"afxtempl.h"

static const char rcsid[]="$Id: widgetmenu.C,v 1.5 1999/06/14 02:11:49 mrsam Exp $";

////////////////////////////////////////////////////////////////////////

CWidget *CMenuBarWidget::Button(size_t n)
{
	return (m_menus[n]);
}

Widget CMenuBarWidget::CreateWidget(const char * strName, Widget parent,
	CWidgetArgs *args)
{
Arg	*argp;
int	argn;

	GetArgs(args, argp, argn);
	return (XmCreateMenuBar(parent, (String)strName, argp, argn));
}

CMenuBarWidget::CMenuBarWidget(const char * name) : CWidget(name)
{
}

CMenuBarWidget::~CMenuBarWidget()
{
	RemoveChildren();
}

void CMenuBarWidget::RemoveChildren()
{
size_t	n=m_menus.GetSize();
size_t	i;

	for (i=0; i<n; i++)
		if (m_menus[i])
			delete m_menus[i];
	m_menus.RemoveAll();
}

void CMenuBarWidget::Create(CWidget *parent, size_t n)
{
	CWidget::Create(parent);

	try
	{
		m_menus.SetSize(n);
		m_buttonLabels.SetSize(n);

	size_t	i;

		for (i=0; i<n; i++)
			m_menus[i]=NULL;

		for (i=0; i<n; i++)
		{
		char	buf[40];

			ostrstream(buf, sizeof(buf)) << "button_" << i << '\0';

			m_buttonLabels[i]=buf;
			if ((m_menus[i]=new CCascadeButtonWidget(
					m_buttonLabels[i])) == NULL)
				AfxThrowMemoryException();
		}

		for (i=0; i<n; i++)
		{
			m_menus[i]->IsGadget(TRUE);
			m_menus[i]->Create(this);
			m_menus[i]->Manage();
		}

	// Our private resource - helpIndex, specifies the index of the help
	// button.

	CWidgetResource wir("helpIndex", -1);

		GetResource(wir);

	long	n=wir.Int();

		if (n >= 0)
		{
		CWidgetArgs	args;

			args.Add(XmNmenuHelpWidget, m_menus[n]->wid());
			SetValues(args);
		}
	}
	catch (...)
	{
		RemoveChildren();
		throw;
	}
}

//////////////////////////////////////////////////////////////////////////

Widget CPulldownMenuWidget::CreateWidget(const char * strName,
					Widget w, CWidgetArgs *args)
{
Arg	*argp;
int	argn;

	GetArgs(args, argp, argn);

	if (!w)	AfxThrowInternalException();

	return (XmCreatePulldownMenu(w, (String)strName, argp, argn));
}

CPulldownMenuWidget::CPulldownMenuWidget(const char * name) : CWidget(name)
{
}

CPulldownMenuWidget::~CPulldownMenuWidget()
{
}

void	CPulldownMenuWidget::Create(CMenuBarWidget &mbar, int nmenu)
{
	CWidget::Create(&mbar);

CWidgetArgs	args;

	args.Add(XmNsubMenuId, wid());
	mbar.Button(nmenu)->SetValues(args);
}

void	CPulldownMenuWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
}

//////////////////////////////////////////////////////////////////////////

Widget CPopupMenuWidget::CreateWidget(const char * strName,
					Widget w, CWidgetArgs *args)
{
Arg	*argp;
int	argn;
CWidgetArgs	dummy_args;

	if (!args)	args= &dummy_args;

	args->Add(XmNpopupEnabled, (int)XmPOPUP_AUTOMATIC);
	GetArgs(args, argp, argn);

	if (!w)	AfxThrowInternalException();

	return (XmCreatePopupMenu(w, (String)strName, argp, argn));
}

CPopupMenuWidget::CPopupMenuWidget(const char * name) : CWidget(name)
{
}

CPopupMenuWidget::~CPopupMenuWidget()
{
}

void	CPopupMenuWidget::Create(CWidget *parent)
{
	CWidget::Create(parent);
}

void	CPopupMenuWidget::Manage()
{
	if (!wid())	AfxThrowInternalException();
	XmMenuPosition(wid(),
		&XtLastEventProcessed( XtDisplay(wid()) )->xbutton);
	CWidget::Manage();
}

//////////////////////////////////////////////////////////////////////////

Widget COptionMenuWidget::CreateWidget(const char * strName,
					Widget w, CWidgetArgs *args)
{
Arg	*argp;
int	argn;

	GetArgs(args, argp, argn);
	return (XmCreateOptionMenu(w, (String)strName, argp, argn));
}

COptionMenuWidget::COptionMenuWidget(const char * name) : CWidget(name)
{
}

COptionMenuWidget::~COptionMenuWidget()
{
}

void	COptionMenuWidget::Create(CWidget *parent,
	CPulldownMenuWidget *pulldown)
{
CWidgetArgs	args;

	args.Add(XmNsubMenuId, pulldown->wid());
	CWidget::Create(parent, args);
}
