// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetlist_h
#define	widgetlist_h

static const char widgetlist_h_rcsid[]="$Id: widgetlist.h,v 1.5 1999/04/09 02:32:28 mrsam Exp $";

#include	"afx.h"
#include	"widget.h"
#include	<X11/Intrinsic.h>

class CXmString;
class CWidgetArgs;

/////////////////////////////////////////////////////////////////////
//
//  Here's a list widget
//

class CListWidget : public CWidget {

	WidgetClass	Class();
public:
	CListWidget(const char *);
	~CListWidget();
	void	Create(CWidget *parent);
	void	Create(CWidget *parent, CWidgetArgs &args);
	void	AddItem(const CXmString &item, size_t pos);
	void	AddItems(const CXmString *item, size_t cnt, size_t pos);
	void	DeleteItem(size_t pos);
	void	RemoveAll();
	int	NumSelected();
	size_t	*GetSelected();
	XmString GetItem(size_t);
	size_t	NumItems();
	AFXBOOL	OnPopup(CPopupMenuWidget *&);

virtual	void	OnClick(int, int *, XmString *, int);
virtual	void	OnDoubleClick(int, int *, XmString *, int);
} ;

///////////////////////////////////////////////////////////////////////
//
//  Here's a template to redirect all clicks from a CListWidget
//  into a method calls of another class.

template<class T> class CListWidgetRedirect : public CListWidget {
	T *m_instance;
	void (T::*m_click)(int, int *, XmString *, int);
	void (T::*m_click2)(int, int *, XmString *, int);
public:
	CListWidgetRedirect(const char *c) : CListWidget(c),
			m_instance(NULL),
			m_click( ( void (T::*)(int, int *, XmString *, int))
					NULL),
			m_click2( ( void (T::*)(int, int *, XmString *, int))
					NULL)	{}
			
	~CListWidgetRedirect()	{}
	void	operator=(T *p)	{ m_instance=p; }
	void	Click( void (T::*p)(int, int *, XmString *, int) )
		{
			m_click=p;
		}
	void	DoubleClick( void (T::*p)(int, int *, XmString *, int) )
		{
			m_click2=p;
		}
	void	OnClick(int n, int *p, XmString *sp, int b);
	void	OnDoubleClick(int n, int *p, XmString *sp, int b);
} ;

template<class T> void CListWidgetRedirect<T>
	::OnClick(int n, int *p, XmString *sp, int b)
{
	if (m_instance && m_click)
		(m_instance->*m_click)(n,p,sp,b);
}

template<class T> void CListWidgetRedirect<T>
	::OnDoubleClick(int n, int *p, XmString *sp, int b)
{
	if (m_instance && m_click2)
		(m_instance->*m_click2)(n,p,sp,b);
}

#endif
