// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widgetinput.h"
#include	"widgetapp.h"
#include	"afxtempl.h"
#include	<unistd.h>
#include	<errno.h>
#include	<iostream.h>
#include	<iomanip.h>

static const char rcsid[]="$Id: widgetinput.C,v 1.7 1999/04/09 02:32:28 mrsam Exp $";

CList<CXmInputBase *, CXmInputBase *> CXmInputBase::m_list;
		// Keep track of all outstanding inputs

void CXmInputBase::readon()
{
	if (!m_canRead && m_fd >= 0)
	{
		m_readId=XtAppAddInput( CApplicationWidget::Context(), m_fd,
			(XtPointer)(XtInputReadMask), &read_proc,
			(XtPointer) this );
		m_canRead=TRUE;
	}
}

void CXmInputBase::readoff()
{
	if (m_canRead)
		XtRemoveInput(m_readId);
	m_canRead=FALSE;
}

void CXmInputBase::writeon()
{
	if (!m_canWrite && m_fd >= 0)
	{
		m_writeId=XtAppAddInput( CApplicationWidget::Context(), m_fd,
			(XtPointer)(XtInputWriteMask), &write_proc,
			(XtPointer) this );
		m_canWrite=TRUE;
	}
}

void CXmInputBase::writeoff()
{
	if (m_canWrite)
	{
		m_canWrite=TRUE;
		XtRemoveInput(m_writeId);
	}
	m_canWrite=FALSE;
}

CXmInputBase::~CXmInputBase()
{
	readoff();
	writeoff();
	fd(-1);
}

void CXmInputBase::fd(int f)
{
	readoff();
	writeoff();
	m_writeCnt=m_writeBuf.GetLength();
	m_readBuf="";

	// Keep track of open files

	if (m_fd < 0 && f >= 0)
		m_pos=m_list.AddTail(this);
	if (m_fd >= 0 && f < 0)
		m_list.RemoveAt(m_pos);
	m_fd=f;
}

// After forking, child should call CXmInputBase::Forked() to close off
// inherited descriptors

void CXmInputBase::Forked()
{
	while (!m_list.IsEmpty())
	{
	CXmInputBase	*p=m_list.GetHead();

		close (p->fd());
		p->fd(-1);
	}
}

void CXmInputBase::CanRead(AFXBOOL flag)
{
	if (flag)	readon();
	else		readoff();
}

void CXmInputBase::CanWrite(AFXBOOL flag)
{
	if (flag)	writeon();
	else		writeoff();
}

void CXmInputBase::read_proc(CXmInputBase *p, int *, XtInputId *)
{
	p->Read();
}

void CXmInputBase::write_proc(CXmInputBase *p, int *, XtInputId *)
{
	p->Write();
}

void CXmInputBase::Read()
{
	CanRead(FALSE);
	errno=0;
	if (ReadBuffer() <= 0)
	{
		CanRead(FALSE);
		m_readBuf="";
	}
	ProcessRead(m_readBuf);
}

int CXmInputBase::ReadBuffer()
{
size_t	cnt=m_readBuf.GetLength();
char *p=m_readBuf.GetBuffer(cnt+256);

int	n= ::read( fd(), p+cnt, 256);

	if (n < 0)	n=0;
	m_readBuf.ReleaseBuffer(cnt+n);
	return (n);
}

void CXmInputBase::Write()
{
	if ( m_writeCnt < (size_t)m_writeBuf.GetLength() )
	{
	int	cnt= ::write( fd(), (const char *)m_writeBuf + m_writeCnt,
			m_writeBuf.GetLength() - m_writeCnt );
		if (cnt <= 0)
		{
			// WRITE error on pipe, exit gracefully
			m_writeCnt=m_writeBuf.GetLength();
			return;
		}
		m_writeCnt += cnt;
		return;
	}

	CanWrite(FALSE);

CString	buf=GetWrite();

	if (buf.GetLength())
	{
		m_writeCnt=0;
		m_writeBuf=buf;
		CanWrite(TRUE);
	}
}

void CXmInputBase::findabug()
{
POSITION	p;

	cerr << "findabug enter" << endl;
	for (p=m_list.GetHeadPosition(); p; )
	{
	CXmInputBase &ib= *m_list.GetNext(p);

		if (ib.m_canRead)
		{
			ib.readoff();
			ib.readon();
		}
		if (ib.m_canWrite)
		{
			ib.writeoff();
			ib.writeon();
		}
	}
	cerr << "findabug exit" << endl;
}
