// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetgc_h
#define	widgetgc_h

static const char widgetgc_h_rcsid[]="$Id: widgetgc.h,v 1.2 1998/06/26 03:06:55 mrsam Exp $";

#include	<X11/Intrinsic.h>
#include	"afx.h"

class	CWidget;

///////////////////////////////////////////////////////////////////////
//
// Encapsulate GC

class CXmGC {

	Display	*m_disp;
	GC	m_gc;
	Drawable m_d;

public:
	CXmGC():m_disp(0), m_gc(0), m_d(0)	{}
	~CXmGC()	{ Destroy(); }
	void Destroy();
	void Create(CWidget *);
	void Create(Display *, Drawable);

	void Change(unsigned long n, const XGCValues &v)
		{
			XChangeGC(m_disp, m_gc, n, (XGCValues *)&v);
		}
	void Get(unsigned long n, XGCValues &v)
		{
			if (!m_disp || !m_gc)
				AfxThrowInternalException();

			if (XGetGCValues(m_disp, m_gc, n, &v))
				AfxThrowInternalException();
		}

	void ChangeFunction(unsigned long n)
		{
		XGCValues	v;

			v.function=n;
			Change(GCFunction, v);
		}
	operator GC() { return (m_gc); }

	void	operator=(CXmGC &old)
		{
			Create(m_disp, m_d);
			XCopyGC(m_disp, old.m_gc, ~0, m_gc);
		}
	void	Copy(CWidget *w, GC gc)
		{
			Create(w);
			XCopyGC(m_disp, gc, ~0, m_gc);
		}

	friend	class CXmSaveGC;
} ;

///////////////////////////////////////////////////////////////////////
//
// Temporarily save GC attributes

class CXmSaveGC {

	Display	*m_disp;
	GC	m_gc;
	XGCValues m_values;
	unsigned long m_valmask;
public:
	CXmSaveGC(Display *disp, GC gc,
		unsigned long mask=GCForeground|GCBackground|GCFunction);
	CXmSaveGC(const CXmGC &gc,
		unsigned long mask=GCForeground|GCBackground|GCFunction);
	~CXmSaveGC();
} ;
#endif
