// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widget.h"
#include	"widgetgc.h"

static const char rcsid[]="$Id: widgetgc.C,v 1.1 1997/07/14 02:48:59 mrsam Exp $";

void CXmGC::Destroy()
{
	if (m_gc)
	{
		XFreeGC(m_disp, m_gc);
		m_gc=NULL;
	}
}

void CXmGC::Create(CWidget *w)
{
Widget	ww=w->wid();

	if (!ww)	AfxThrowInternalException();

	Create(XtDisplay(ww), XtWindow(ww));
}

void CXmGC::Create(Display *disp, Drawable d)
{
	Destroy();
	m_disp=disp;
	m_d=d;
	m_gc=XCreateGC(disp, d, 0, NULL);
	if (!m_gc)
		AfxThrowMemoryException();
}

/////////////////////////////////////////////////////////////////////

CXmSaveGC::CXmSaveGC(Display *disp, GC gc, unsigned long mask)
	: m_disp(disp), m_gc(gc), m_valmask(mask)
{
	XGetGCValues(m_disp, m_gc, m_valmask, &m_values);
}

CXmSaveGC::CXmSaveGC(const CXmGC &gc, unsigned long mask)
	: m_disp(gc.m_disp), m_gc(gc.m_gc), m_valmask(mask)
{
	XGetGCValues(m_disp, m_gc, m_valmask, &m_values);
}

CXmSaveGC::~CXmSaveGC()
{
	XChangeGC(m_disp, m_gc, m_valmask, &m_values);
}
