// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widgetfr.h"
#include	"widgetresource.h"
#include	"afxregex.h"
#include	<dirent.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/param.h>
#include	<sys/stat.h>

#include	<Xm/RowColumn.h>

COptionMenuWidgetExtended::COptionMenuWidgetExtended(const char * s)
		: CFormWidget(s),
		m_options(NULL),
		m_optionMenu("optionmenu"),
		m_pulldown("pulldown"),
		m_maskText("optiontext")
{
	m_options=this;
	m_options= &OnOptionActivate;

	m_maskText=this;
	m_maskText=&OnActivate;
}

COptionMenuWidgetExtended::~COptionMenuWidgetExtended()
{
}

void COptionMenuWidgetExtended::Create(CWidget *parent)
{
	CFormWidget::Create(parent);

	m_pulldown.Create(parent);
	m_optionMenu.Create(this, &m_pulldown);
	m_optionArray=CStringSplit( m_optionStr, '|' );

unsigned cnt= m_optionArray.GetSize()/2;
unsigned i;
size_t	maxl=4;

	for (i=0; i<cnt; i++)
	{
	CString	&s=m_optionArray[i*2+1];

		if ((size_t)s.GetLength() > maxl)
			maxl=s.GetLength();
	}

	m_optionMenu.Attach( CWidgetToForm, NULL, NULL, CWidgetToForm);
	m_options.Create(&m_pulldown, cnt);
	m_maskText.Create(this, maxl);
	m_maskText.Attach( m_optionMenu, CWidgetToForm, NULL, CWidgetToForm);
	m_optionMenu.Manage();
	m_maskText.Manage();

CXmString	xms;

	for (i=0; i < cnt; i++)
	{
	Arg	arg;

		xms=m_optionArray[i*2];
		XtSetArg(arg, XmNlabelString, (XmString)xms);
		XtSetValues(m_options[i]->wid(), &arg, 1);
	}

	// Pretend to select the first option, in order to initialize the rest

	if (cnt > 0)
	{
		m_options.m_activatedIndex=1;
		OnOptionActivate();
	}
}

void COptionMenuWidgetExtended::OnOptionActivate()
{
	m_maskText.Value(m_optionArray[
			m_options.m_activatedIndex*2-1]);
	OnActivate();
}

void COptionMenuWidgetExtended::OnActivate()
{
}

CFileRequesterWidget::CFileRequesterWidget(const char *)
	: CFormWidget("fileRequester"),
	m_dirname_form("dirnameform"),
	m_dirname_label("dirnamelabel"),
	m_dirname_text("dirnametext"),
	m_mask("mask"),
	m_sep1("sep1"),
	m_pane("pane"),
	m_dirscroll("dirscroll"), m_filescroll("filescroll"),
	m_dirlist("dirlist"), m_filelist("filelist"),
	m_sep2("sep2"),
	m_filename_form("filenameform"),
	m_filename_label("filenamelabel"),
	m_filename_text("filenametext"),
	m_buttons("buttons"),
	m_ok("ok"),
	m_cancel("cancel")
{
	m_dirlist=this;
	m_filelist=this;
	m_dirname_text=this;
	m_filename_text=this;
	m_mask=this;
	m_ok=this;
	m_cancel=this;

	m_dirlist.DoubleClick( &OnDirListDoubleClick );
	m_filelist.DoubleClick( &OnFileListDoubleClick );
	m_filelist.Click( &OnFileListClick );
	m_dirname_text=&OnDirNameActivate;
	m_mask= &OnMaskChange;
	m_filename_text=&OnFilenameOk;
	m_ok=&OnFilenameOk;
	m_cancel=&OnFilenameCancel;
}

CFileRequesterWidget::~CFileRequesterWidget()
{
}

void CFileRequesterWidget::Create(CWidget *parent)
{
	CFormWidget::Create(parent);
	m_dirname_form.Create(this);
	m_dirname_label.Create(&m_dirname_form);

	m_dirname_text.Create(&m_dirname_form);

	{
	CWidgetResource filter_list("filterList", "All files (*)|*");

		GetResource(filter_list);

		m_mask.m_optionStr=filter_list.Str();
	}
	m_mask.Create(&m_dirname_form);

	m_dirname_label.Attach(CWidgetToForm, NULL, CWidgetToForm,
						m_dirname_text);
	m_dirname_text.Attach(CWidgetToForm, m_mask, NULL, CWidgetToForm);

	m_mask.Attach(NULL, CWidgetToForm, CWidgetToForm, CWidgetToForm);
	m_sep1.Create(this);

	m_dirname_form.Attach(CWidgetToForm, CWidgetToForm, CWidgetToForm,
					NULL);
	m_pane.Create(this);

	m_sep1.Attach( CWidgetToForm, CWidgetToForm, m_dirname_form, NULL);
	m_sep2.Create(this);
	m_pane.Attach( CWidgetToForm, CWidgetToForm, m_sep1, m_sep2 );

	m_dirscroll.Create(&m_pane);
	m_filescroll.Create(&m_pane);

	m_dirlist.Create(&m_dirscroll);
	m_filelist.Create(&m_filescroll);

	m_filename_form.Create(this);

	m_sep2.Attach( CWidgetToForm, CWidgetToForm, NULL, m_filename_form);

	m_filename_label.Create(&m_filename_form);
	m_filename_text.Create(&m_filename_form);

	m_filename_label.Attach(CWidgetToForm, NULL, CWidgetToForm, NULL);
	m_filename_text.Attach( CWidgetToForm, CWidgetToForm,
				m_filename_label, CWidgetToForm);

	m_buttons.Create(this);

	m_filename_form.Attach( CWidgetToForm, CWidgetToForm, NULL, m_buttons);

	m_buttons.Attach(CWidgetToForm, CWidgetToForm, NULL, CWidgetToForm);

	m_ok.Create(&m_buttons);
	m_cancel.Create(&m_buttons);

	m_ok.Attach(CWidgetToForm, NULL, CWidgetToForm, CWidgetToForm);
	m_cancel.Attach(NULL, CWidgetToForm, CWidgetToForm, CWidgetToForm);

	m_mask.Manage();
	m_dirname_text.Manage();
	m_dirname_label.Manage();
	m_dirname_form.Manage();
	m_sep1.Manage();
	m_dirlist.Manage();
	m_filelist.Manage();
	m_dirscroll.Manage();
	m_filescroll.Manage();
	m_pane.Manage();
	m_sep2.Manage();

	m_filename_label.Manage();
	m_filename_text.Manage();
	m_filename_form.Manage();

	m_ok.Manage();
	m_cancel.Manage();
	m_buttons.Manage();

	if (m_curdir.GetLength() == 0)
	{
	char	pathbuf[MAXPATHLEN];
	char	*p;

	// Initialize for the current directory

		m_curdir="/";
		p=realpath(".", pathbuf);
		if (p)
			m_curdir=p;
	}
	Chdir(".");
}

void CFileRequesterWidget::OnDirNameActivate()
{
	Chdir(m_dirname_text.Value());
}

void CFileRequesterWidget::Chdir(CString newdir)
{
	if (!wid())	return;
	if (!XtWindow(wid()))
	{
		DoChdir(newdir);
		return;
	}

	BusyCursor();
	try
	{
		DoChdir(newdir);
		RemoveCursor();
	}
	catch (...)
	{
		RemoveCursor();
		throw;
	}
}

void CFileRequesterWidget::DoChdir(CString newdir)
{
int	ncontents=0;

	if ( *(const char *)newdir != '/')
		newdir= m_curdir + '/' + newdir;

CString	dirbuf("");
char *p=dirbuf.GetBuffer(newdir.GetLength() + MAXPATHLEN );

	if (!p)	AfxThrowMemoryException();
	p=realpath( (char *)(const char *)newdir, p);
	dirbuf.ReleaseBuffer(-1);
	if (!p)
		return;

struct	dirent **dircontents;

	ncontents=scandir( dirbuf, &dircontents, &select_contents, &alphasort);

	if (ncontents < 0)	return;

CRegex	regexp;

	regexp.FilenamePattern( m_mask.Value() );

	try
	{
	int	i;
	CString	new_name;
	struct	stat	stat_buf;

		m_dirlist.RemoveAll();
		m_filelist.RemoveAll();
		m_files.RemoveAll();
		m_dirs.RemoveAll();
		for (i=0; i<ncontents; i++)
		{
			new_name=dirbuf + '/' + dircontents[i]->d_name;
			if (stat( new_name, &stat_buf) == 0 &&
				S_ISDIR(stat_buf.st_mode))
				m_dirs.AddTail( dircontents[i]->d_name );
			else
			{
				if (regexp.Match(dircontents[i]->d_name))
					m_files.AddTail(
						dircontents[i]->d_name );
			}
		}

		for (i=0; i<ncontents; i++)
			free(dircontents[i]);
		free(dircontents);
	}
	catch (...)
	{
	int	i;

		for (i=0; i<ncontents; i++)
			free(dircontents[i]);
		free(dircontents);
		throw;
	}
	m_filesArray.SetSize(m_files.GetCount());
	m_dirsArray.SetSize(m_dirs.GetCount());

int	i;
POSITION pos;
CXmString xms;

	for (i=0, pos=m_files.GetHeadPosition(); pos; i++)
	{
		xms=m_files.GetNext(pos);
		m_filesArray[i]=xms;
	}

	for (i=0, pos=m_dirs.GetHeadPosition(); pos; i++)
	{
		xms=m_dirs.GetNext(pos);
		m_dirsArray[i]=xms;
	}

	m_filelist.AddItems(m_filesArray.GetData(), m_filesArray.GetSize(), 0);
	m_dirlist.AddItems(m_dirsArray.GetData(), m_dirsArray.GetSize(), 0);
	m_curdir=dirbuf;
	m_dirname_text.Value(m_curdir);
	m_filename_text.Value(CString(""));
}

int	CFileRequesterWidget::select_contents(const struct dirent *)
{
	return (1);
}

void CFileRequesterWidget::OnMaskChange()
{
	if (m_filelist.wid())	// Ignore spurious call while constructing
		Chdir( m_curdir );	// Reread current directory
}

void CFileRequesterWidget::OnDirListDoubleClick(int nselected, int *selp,
						XmString *, int)
{
	if (nselected && *selp <= (int)m_dirs.GetCount())
		Chdir( m_dirs.GetAt(m_dirs.FindIndex( *selp - 1)));
}

void CFileRequesterWidget::OnFileListDoubleClick(int nselected, int *selp,
					XmString *xs, int xn)
{
	if (nselected && *selp <= (int)m_files.GetCount())
	{
		OnFileListClick(nselected, selp, xs, xn);
		OnFilenameOk();
	}
}

void CFileRequesterWidget::OnFileListClick(int nselected, int *selp, XmString *, int)
{
	if (nselected && *selp <= (int)m_files.GetCount())
		m_filename_text.Value(m_files.GetAt(
				m_files.FindIndex( *selp - 1)));
}

void CFileRequesterWidget::OnFilenameOk()
{
	m_filename=m_filename_text.Value();

	if ( *(const char *)m_filename != '/')
		m_filename=m_curdir + (m_curdir == "/" ? "":"/")
				+ m_filename;
	OnOk();
}

void CFileRequesterWidget::OnFilenameCancel()
{
	OnCancel();
}

void CFileRequesterWidget::OnOk()
{
}

void CFileRequesterWidget::OnCancel()
{
}
