// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widget.h"
#include	"widgetfont.h"
#include	"afx.h"
#include	"afxtempl.h"

static const char rcsid[]="$Id: widgetfont.C,v 1.4 1999/04/09 02:32:28 mrsam Exp $";

CXFontSet::~CXFontSet()
{
	if (xfs)
		XFreeFontSet(xdisp, xfs);
}

AFXBOOL CXFontSet::Create(CWidget &w, CString font_name)
{
	return (Create(w.wid(), font_name));
}

AFXBOOL CXFontSet::Create(Widget w, CString font_name)
{
	if (xfs)
		XFreeFontSet(xdisp, xfs);
	xfs=NULL;
	xdisp=XtDisplay(w);
	
char	**missing_list;
int	missing_cnt;

	xfs=XCreateFontSet(xdisp,
		(const char *)font_name, &missing_list, &missing_cnt, NULL);

	if (!xfs && missing_list)	XFreeStringList(missing_list);
	return (xfs != NULL);
}

CArray<XRectangle, XRectangle &> CXFontSet::TextMetrics(CString s)
{
CArray<XRectangle, XRectangle &> log;

	TextMetrics(log, s);
	return (log);
}

void	CXFontSet::TextMetrics(CArray<XRectangle, XRectangle &> &a, CString s)
{
CArray<XRectangle, XRectangle &> ink;

	TextMetrics(a, ink, s);
}

void CXFontSet::TextMetrics(CArray<XRectangle, XRectangle &> &a,
		CArray<XRectangle, XRectangle &> &ink, CString s)
{
	if (!xfs)
	{
		a.SetSize(0);
		return;
	}

int	cnt;

	XmbTextPerCharExtents(xfs, (const char *)s, s.GetLength(),
		ink.GetData(), a.GetData(), 0, &cnt, NULL, NULL);

	ink.SetSize(cnt);
	a.SetSize(cnt);

	XmbTextPerCharExtents(xfs, (const char *)s, s.GetLength(),
		ink.GetData(), a.GetData(), cnt, &cnt, NULL, NULL);
}
