// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetbasetextcol_h
#define	widgetbasetextcol_h

static const char widgetbasetextcol_h_rcsid[]="$Id: widgetbasetextcol.h,v 1.3 1999/04/09 02:25:54 mrsam Exp $";


//---------------------------------------------------------------------
// Derive from CBaseTextWidget, provide code to display data in
// tabular format.  The bulk of CBaseTextWidget still has to be derived,
// this is an abstract class that helps in rendering tabular output
// only.
//---------------------------------------------------------------------

#include	"widgetbasetext.h"

class CBaseTextColWidget : public CBaseTextWidget {

	CUIntArray	m_colwidths;
	unsigned	m_gap;
	CArray<size_t, size_t>	m_sizes;
	CArray<XRectangle, const XRectangle &> m_rects;

protected:
	// I define the semantics of the following.
	size_t Height(POSITION);
	void	DrawText(POSITION, size_t,
			unsigned, unsigned, unsigned, unsigned,
			GC, XmRenderTable, unsigned char, size_t, size_t);

	// And specify the semantics of the following:
	virtual void Height(POSITION, size_t *)=0;
			// Return height of each column

	virtual void DrawColText(POSITION pos, size_t index,
		unsigned x, unsigned y, unsigned width, unsigned height,
		GC gc, XmRenderTable render_table,
		unsigned char layout_direction,
		const XRectangle *metrics)=0;
			// Render columns at these positions.  If metrics->
			// width is zero, it's off the screen.

public:
	CBaseTextColWidget(const char *name) : CBaseTextWidget(name)	{}
	~CBaseTextColWidget();

	void Create(CWidget *parent, CString default_widths,
			CString default_gap="1fu");
		// NOTE: default_widths is used to set # of columns!
} ;
#endif
