// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetbasetext_h
#define	widgetbasetext_h

static const char widgetbasetext_h_rcsid[]="$Id: widgetbasetext.h,v 1.4 1999/04/09 02:32:28 mrsam Exp $";


/////////////////////////////////////////////////////////////////////////
//
// Common functions for derived classed of BaseWindowWidget that display
// lines of text.

#include	<X11/Intrinsic.h>
#include	<Xm/Xm.h>
#include	"afx.h"
#include	"afxtempl.h"
#include	"widgetbase.h"
#include	"widgetcursor.h"

class	CXmStringMetrics;

class CBaseTextWidget : public CBaseWindowWidget {

protected:
	size_t	m_width, m_height;	// Last known width/height
	void	OnDestroy();
private:
	POSITION	m_top_pos;
	POSITION	m_bot_pos;
	size_t		m_top_linenum;
	size_t		m_bot_linenum;
	CList<size_t, size_t>
			m_rows;		// Cache of drawn rows.
	virtual POSITION LastPos()=0;
	virtual POSITION FirstPos()=0;
	virtual size_t NextPos(POSITION &)=0;
	virtual size_t PrevPos(POSITION &)=0;
	virtual size_t Height(POSITION)=0;
	virtual CXmStringMetrics *GetMetrics (POSITION, size_t);

	virtual void	DrawText(POSITION, size_t,
			unsigned, unsigned, unsigned, unsigned,
			GC, XmRenderTable, unsigned char,
			size_t, size_t)=0;

	// Here's the desired cursor location

	CXmTextCursor	m_cursor;
	AFXBOOL		m_cursor_on;		// Flag - user moved cursor
	size_t		m_cursor_linenum;
	POSITION	m_cursor_linepos;
	size_t		m_cursor_col;
	AFXBOOL		m_cursor_onscreen;	// Flag - cursor is onscreen
	CXmTimeout<CBaseTextWidget> m_cursor_timer;
	int		m_cursor_timer_rate;

	// When there is a selection, here it is

	size_t		m_selcursor_linenum;
	POSITION	m_selcursor_linepos;
	size_t		m_selcursor_col;
	size_t		m_selcursor_x;
public:
	AFXBOOL		HasSelection()
		{
			return (m_cursor_linenum != m_selcursor_linenum ||
				m_cursor_col != m_selcursor_col);
		}
private:
	void		SelectionOff();
	void		DoSelectionOff()
		{
			m_selcursor_linenum=m_cursor_linenum;
			m_selcursor_linepos=m_cursor_linepos;
			m_selcursor_col=m_cursor_col;
			m_selcursor_x=m_cursor_x;
		}
public:
	void	GetSelection(size_t &, size_t &, size_t &, size_t &);
private:
	// Here's the current cursor location

	AFXBOOL		m_cursor_isshown;
	int		m_cursor_x;
	int		m_cursor_y;

	void		ShowCursor();	// Show cursor on/off

	void		ShowCursorOff()	// Turn off cursor
		{
			if (m_cursor_isshown)	ShowCursor();
			m_cursor_timer.Cancel();
		}

	void		ResetCursor()	// Turn cursor off, and force it
					// to reload
		{
			if (m_cursor_isshown)	ShowCursor();
			m_cursor.Destroy();
		}

	void	OnGotFocus();
	void	OnLostFocus();
	void	Blink();
	void	DoMoveCursor(size_t, POSITION, size_t, AFXBOOL);
protected:
	void	TopRow(size_t, POSITION);
	void	Inserted(POSITION, size_t, size_t);
	AFXBOOL	WillDelete(size_t, POSITION, size_t, POSITION);
	void	MoveCursor(size_t linenum, POSITION pos, size_t col,
		AFXBOOL doselect);
public:
	void	CursorOff()
		{
			m_cursor_on=FALSE;
			ShowCursorOff();
		}
	void	CursorOn()
		{
			m_cursor_on=TRUE;
			Blink();
		}
protected:
	void	Deleted();
	size_t	LastRow()
		{
		size_t l;

			FindLastRow(l);
			return (l);
		}

virtual	void	OnBaseTextButtonDown(int, int, size_t, POSITION, int);
virtual	void	OnBaseTextButtonUp(int, int, size_t, POSITION, int);
virtual	void	OnBaseTextMotion(int, size_t, POSITION, int);
private:
	POSITION	FindLastRow(size_t &);
					// Find last row that should remain
					// visible as the top line
	void	OnDraw();
protected:
	void	RedrawLines(size_t, size_t);
private:
	void	OnResize(unsigned, unsigned);
	void	VRecalc();		// Recalculate based on height change
	void	OnButtonDown(int nButton, int x, int y, int buttonMask);
	void	OnButtonUp(int nButton, int x, int y, int buttonMask);
	void	OnMotion(int x, int y, int buttonMask);
	AFXBOOL	FindRow(int, size_t &, POSITION &);
public:
	CBaseTextWidget(const char *);
	virtual ~CBaseTextWidget();
	void	Create(CWidget *);
	void	ReInit();
	size_t	TopRow();
	size_t	NumRows();
	void	ShowLastRow();	// Show end of buffer
	AFXBOOL	ShowingLastRow()	// Return TRUE if last row is visible
		{
		POSITION p=m_bot_pos;

			if (p)	NextPos(p);
			return (p ? FALSE:TRUE);
		}

	size_t	CursorLineNum() { return (m_cursor_linenum); }
	size_t	CursorCol()	{ return (m_cursor_col); }

virtual	void	OnStatusChange(size_t, size_t, size_t, size_t);

virtual	size_t	TotalRows()=0;

	} ;

// Redirect OnStatusChange to another class.
// base_class can be any class derived from CBaseTextWidget

template<class T, class base_class>
	class CBaseTextWidgetRedirect : public base_class {

	T * m_instance;
	void (T::*m_method)(size_t, size_t, size_t, size_t);
public:
	CBaseTextWidgetRedirect(const char *s) : base_class(s),
		m_instance(0), m_method( (void (T::*)(size_t, size_t, size_t,
						size_t)) 0)	{}
	~CBaseTextWidgetRedirect()	{}
	void operator=(T *p) { m_instance=p; }
	void operator=(void (T::*p)(size_t, size_t, size_t, size_t))
			{ m_method=p; }
	void OnStatusChange(size_t a, size_t b, size_t c, size_t d)
		{
			if (m_instance && m_method)
				(m_instance->*m_method)(a,b,c,d);
		}
} ;
#endif
