// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"widget.h"
#include	"widgetresource.h"
#include	"widgetxms.h"
#include	"widgetbasetext.h"
#include	"afxdebug.h"

static const char rcsid[]="$Id: widgetbasetext.C,v 1.4 1999/04/09 02:32:28 mrsam Exp $";


CBaseTextWidget::CBaseTextWidget(const char *m)
	: CBaseWindowWidget(m), m_width(0), m_height(0),
	m_top_pos(NULL), m_bot_pos(NULL), m_top_linenum(0), m_bot_linenum(0),
	m_cursor_on(FALSE),
	m_cursor_linenum(0), m_cursor_linepos(NULL), m_cursor_onscreen(FALSE),
	m_selcursor_linenum(0), m_selcursor_linepos(NULL),
	m_cursor_isshown(FALSE)
{
	m_cursor_timer=this;
}

CBaseTextWidget::~CBaseTextWidget()
{
}

// When we go away, make sure to disable any blinking cursor

void CBaseTextWidget::OnDestroy()
{
	m_cursor_timer.Cancel();
	CBaseWindowWidget::OnDestroy();
}

void CBaseTextWidget::Create(CWidget *parent)
{
	m_top_pos=FirstPos();
	m_top_linenum=0;
	m_cursor_isshown=FALSE;
	m_cursor_linenum=0;
	m_cursor_linepos=m_top_pos;
	m_cursor_col=0;

	CBaseWindowWidget::Create(parent);

CWidgetResource	blinkres (XmNblinkRate, "BlinkRate", 500);

	GetResource(blinkres);
	m_cursor_timer_rate=blinkres.Int();
	VRecalc();
}

void CBaseTextWidget::ReInit()
{
	m_top_pos=FirstPos();
	m_top_linenum=0;
	m_cursor_isshown=FALSE;
	m_cursor_linenum=0;
	m_cursor_linepos=m_top_pos;
	m_cursor_col=0;
	VRecalc();
	Draw();
	OnStatusChange(TotalRows(), TopRow(),
		LastRow(), NumRows());
}

void CBaseTextWidget::OnStatusChange(size_t, size_t, size_t, size_t)
{
}

// Calculate the last possible row that can be on the first line.
// If total # of lines fits within the window, this is always 0.

POSITION CBaseTextWidget::FindLastRow(size_t &line_num)
{
TRACE_FUNCTION("FindLastRow")
POSITION p=LastPos(), prevp=p;
size_t	h=0;

	line_num=TotalRows();
	while (p)
	{
	POSITION lastp=p;

		h += PrevPos(p);
		if (h > m_height)	break;
		--line_num;
		prevp=lastp;
	}
	return (prevp);
}

// If we have a selection get start/end

void CBaseTextWidget::GetSelection(
		size_t	&line1, size_t &col1, size_t &line2, size_t &col2)
{
	line1=m_cursor_linenum;
	col1=m_cursor_x;
	line2=m_selcursor_linenum;
	col2=m_selcursor_x;

	if (line1 > line2 || (line1 == line2 && col1 > col2))
	{
	size_t	n=line1;

		line1=line2;
		line2=n;
		n=col1;
		col1=col2;
		col2=n;
	}
}

// Make sure the last row is visible

void CBaseTextWidget::ShowLastRow()
{
	m_top_pos=FindLastRow(m_top_linenum);
	VRecalc();
	Draw();
}

// Recalculate which lines on the screen.
// If cursor should be on one of these lines, recalculate cursor size/position

void CBaseTextWidget::VRecalc()
{
TRACE_FUNCTION("VRecalc");

	m_bot_pos=m_top_pos;
	m_bot_linenum=m_top_linenum;

	// If cursor is currently shown, turn it off

	if (m_cursor_isshown)
		ShowCursor();

	m_cursor_onscreen=FALSE;
	m_cursor.Destroy();

size_t	tr=TotalRows();

	if (m_cursor_linenum >= tr)
	{
		m_cursor_linenum=tr;
		m_cursor_col=0;
		if (m_cursor_linenum)	--m_cursor_linenum;
		m_cursor_linepos=NULL;
		if (tr)
			m_cursor_linepos=LastPos();
	}

POSITION p=m_bot_pos;
size_t	l=m_bot_linenum;
size_t	h=0;

	m_rows.RemoveAll();

	while (p)
	{
	POSITION lastp=p;
	size_t	height=NextPos(p);
		h += height;
		if (h > m_height)	break;

		m_rows.AddTail(height);

		if (l == m_cursor_linenum)
		{
			m_cursor_linepos=lastp;	// Just in case...
			m_cursor_onscreen=TRUE;
		}

		m_bot_pos=lastp;
		m_bot_linenum=l++;
	}
}

void	CBaseTextWidget::SelectionOff()
{
	if (HasSelection())
	{
	size_t	sline=m_selcursor_linenum;

		ResetCursor();
		DoSelectionOff();
		RedrawLines(sline, m_cursor_linenum);
	}
}

void	CBaseTextWidget::MoveCursor(size_t linenum, POSITION pos, size_t col,
				AFXBOOL doselect)
{
	if (!doselect && HasSelection())
		SelectionOff();

	if (m_cursor_linenum != linenum || m_cursor_col != col)
	{
		if (HasSelection() || doselect)
			ResetCursor();

	size_t	line1=m_cursor_linenum;
	size_t	line2=m_selcursor_linenum;

		DoMoveCursor(linenum, pos, col, doselect);
		if (!doselect)
		{
			line1=m_cursor_linenum;
			line2=line1;
		}
		else
		{
		size_t	lo=m_cursor_linenum;

			if (line1 < lo)	lo=line1;
			if (line2 < lo)	lo=line2;

		size_t	hi=m_cursor_linenum;

			if (line1 > hi)	hi=line1;
			if (line2 > hi)	hi=line2;

			line1=lo;
			line2=hi;
		}
		RedrawLines(line1, line2);
	}
}

// Recalculate cursor position

void	CBaseTextWidget::DoMoveCursor(size_t linenum,
	POSITION pos, size_t column, AFXBOOL doSelect)
{
TRACE_FUNCTION("DoMoveCursor");

	ShowCursorOff();
	m_cursor_onscreen=FALSE;
	if (linenum >= TotalRows())
		return;

	m_cursor_linenum=linenum;
	m_cursor_linepos=pos;
	m_cursor_col=column;

	if (!doSelect)	DoSelectionOff();
	VRecalc();
	RedrawLines(linenum, linenum);
	if (!doSelect)	DoSelectionOff();	// Once again to pick up _x
	if (HasFocus())
		Blink();
}

void	CBaseTextWidget::OnGotFocus()
{
	Blink();
	CBaseWindowWidget::OnGotFocus();
}

void	CBaseTextWidget::OnLostFocus()
{
	ShowCursorOff();
	CBaseWindowWidget::OnLostFocus();
}

void	CBaseTextWidget::Blink()
{
TRACE_FUNCTION("Blink");
	if (m_cursor_onscreen)
	{
		m_cursor_timer.Arm_ms( &Blink, m_cursor_timer_rate );
		ShowCursor();
	}
}


void	CBaseTextWidget::ShowCursor()
{
TRACE_FUNCTION("ShowCursor");

	if (!m_cursor_isshown)	// Should we actually show it???
	{
		if (!m_cursor_on)	return;	// User sez no.
		if (!m_cursor_onscreen)	return;	// NOPE!!!
		if (!(Pixmap)m_cursor)	return;	// Shouldn't happen
	}

	if (m_cursor_isshown)
		m_cursor.Off();
	else
		m_cursor.On();
	m_cursor_isshown= !m_cursor_isshown;
}

void	CBaseTextWidget::OnDraw()
{
	RedrawLines(m_top_linenum, m_bot_linenum);
}

void	CBaseTextWidget::RedrawLines(size_t top, size_t bot)
{
TRACE_FUNCTION("RedrawLines");
AFXBOOL	was_cursor_shown=m_cursor_isshown;

	if (!wid())	AfxThrowInternalException();
	if (!XtWindow(wid()))	return;	// Can happen

	if (was_cursor_shown)
		ShowCursor();		// Da cursor should be off

	if (bot < top)
	{
	size_t	s=bot;

		bot=top;
		top=s;
	}

ExmBaseDrawInfo	*draw=GetDrawInfo();
size_t	y=draw->y;

size_t	curlinenum=m_top_linenum;
POSITION p=m_top_pos;

	while (p)
	{
	POSITION curpos=p;
	size_t maxheight=NextPos(p);

		if (maxheight + y > draw->y + draw->height)
			break;

		if (curlinenum == m_cursor_linenum)
		{
			m_cursor_y=y;

			if (!(Pixmap)m_cursor)
			{
			CXmStringMetrics *xsm=GetMetrics(m_cursor_linepos,
					m_cursor_linenum);

				m_cursor_x=0;

			size_t	l=xsm ? xsm->m_metrics.GetSize():0;

				if (l)
					m_cursor_x=xsm->m_metrics[l-1].x
						+xsm->m_metrics[l-1].width;
				if (m_cursor_col < l)
					m_cursor_x=
						xsm->m_metrics[m_cursor_col].x;
				m_cursor_x += draw->x;
			}
		}

		if (curlinenum >= top && curlinenum <= bot)
		{
		size_t	hcol1=0, hcol2=0;

			if (HasSelection())
			{
			size_t	line1, col1, line2, col2;

				GetSelection(line1, col1, line2, col2);
				if (curlinenum >= line1 && curlinenum <= line2)
				{
					if (curlinenum > line1)
						col1=draw->x;
					if (curlinenum < line2)
						col2=draw->x+draw->width;

					hcol1=col1;
					hcol2=col2;
				}
			}

			DrawText(curpos, curlinenum,
				draw->x, y, draw->width, maxheight,
				draw->gc, draw->render_table,
				draw->layout_direction, hcol1, hcol2);
		}
		++curlinenum;
		y += maxheight;
	}

	if (y < draw->y + draw->height)
		XClearArea(*this, XtWindow(wid()),
			draw->x, y, draw->width,
			draw->height - (y-draw->y), FALSE);

	if (m_cursor_onscreen && !(Pixmap)m_cursor)
	{
	size_t	h=Height(m_cursor_linepos);
	size_t	w=h/4;

		if (w < 8)	w=8;

	XRectangle	r;

		r.x=m_cursor_x;
		r.y=m_cursor_y;
		r.width=w;
		r.height=h;

	XRectangle	clipr;

		clipr.x=draw->x;
		clipr.y=draw->y;
		clipr.width=draw->width;
		clipr.height=draw->height;

		m_cursor.Create(*this, r, clipr);
	}

	if (was_cursor_shown && (Pixmap)m_cursor)
		ShowCursor();
}

CXmStringMetrics *CBaseTextWidget::GetMetrics(POSITION, size_t)
{
	return (NULL);
}

void	CBaseTextWidget::OnResize(unsigned w, unsigned h)
{
	m_width=w;
	m_height=h;

	if (ShowingLastRow())
		ShowLastRow();
	else
	{
		VRecalc();
		Draw(TRUE);
	}
	OnStatusChange(TotalRows(), TopRow(), LastRow(), NumRows());
}

void	CBaseTextWidget::TopRow(size_t row, POSITION p)
{
size_t last_row_num;
POSITION last_row_pos=FindLastRow(last_row_num);

	if (last_row_num < row)
	{
		row=last_row_num;
		p=last_row_pos;
	}

	if (m_top_linenum != row)
	{
		m_top_linenum=row;
		m_top_pos=p;
		VRecalc();
		Draw(TRUE);
		OnStatusChange(TotalRows(), TopRow(), LastRow(), NumRows());
	}
}

// Advisory:  rows were inserted

void	CBaseTextWidget::Inserted(POSITION, size_t line, size_t count)
{
	// First line ever added:

	if (m_top_pos == NULL)
	{
		m_top_pos=FirstPos();
		m_top_linenum=0;
		m_cursor_linenum=0;
		m_cursor_linepos=m_top_pos;
		m_cursor_col=0;
		m_selcursor_linenum=0;
		m_selcursor_linepos=0;
		m_selcursor_col=0;
		VRecalc();
		Draw();
		return;
	}

	if (line <= m_cursor_linenum)
		m_cursor_linenum += count;	// Update cursor position
	if (HasSelection())
	{
		if (line <= m_selcursor_linenum)
			m_selcursor_linenum += count;
	}
	else	DoSelectionOff();		// Reset selection PTR


	if (line > m_bot_linenum)
	{
		if (line == m_bot_linenum+1)
		{	// Maybe the added lines can fit on the screen???
			VRecalc();
			if (m_bot_linenum >= line)
//				RedrawLines(line, m_bot_linenum);
				Draw();
		}
		return;
	}

	if (line <= m_top_linenum)
	{
		m_top_linenum += count;
		m_bot_linenum += count;
		return;
	}
	VRecalc();
	Draw();
}

// Advisory: about to delete lines

AFXBOOL	CBaseTextWidget::WillDelete(size_t first_line, POSITION first_pos,
			size_t last_line, POSITION last_pos)
{
	if (HasSelection())	// See if this affects us
	{
	size_t	line1, line2, dummy;

		GetSelection(line1, dummy, line2, dummy);

		if (line1 <= last_line && line2 >= first_line)
			SelectionOff();
	}

	// Update cursor location

AFXBOOL	had_selection=HasSelection();

	if (had_selection && m_selcursor_linenum > last_line)
		m_selcursor_linenum -= last_line - first_line+1;

	if (m_cursor_linenum > last_line)
	{
		m_cursor_linenum -= last_line - first_line+1;
		if (!had_selection)
			DoSelectionOff();	// Reset selection PTR.
	}
	else if (m_cursor_linenum >= first_line)
	{
		// Cursor is position within the line about to be deleted.

	POSITION	p=last_pos;

		(void)NextPos(p);
		if (p)
		{
			m_cursor_linepos=p;
			m_cursor_linenum=first_line;
		}
		else
		{
			p=first_pos;
			(void)PrevPos(p);
			m_cursor_linepos=p;
			m_cursor_linenum=first_line;
			if (m_cursor_linenum)	--m_cursor_linenum;
		}
		m_cursor_col=0;
		if (!had_selection)
			DoSelectionOff();	// Reset selection ptr.
	}

	if (m_top_linenum < first_line)
	{
		if (m_bot_linenum < first_line)
			return (FALSE);	// I don't care at all
		return (TRUE);	// Should call Deleted()
	}

	if (m_top_linenum > last_line)	// I care a little
	{
		m_top_linenum -= last_line - first_line + 1;
		m_bot_linenum -= last_line - first_line + 1;
		return (FALSE);
	}

	m_top_linenum=first_line;
	m_top_pos=last_pos;
	(void)NextPos(m_top_pos);
	if (!m_top_pos)	// Oops
	{
		m_top_linenum=first_line;
		m_top_pos=first_pos;
		--m_top_linenum;
		(void)PrevPos(m_top_pos);
	}
	return (TRUE);
}

// Advisory: deletion is complete.

void	CBaseTextWidget::Deleted()
{
	if (!m_top_pos)
	{
		m_top_linenum=0;
		m_bot_pos=NULL;
		m_bot_linenum=0;

		m_cursor_linenum=0;
		m_cursor_linepos=0;
		m_cursor_onscreen=FALSE;
		m_cursor_col=0;
		DoSelectionOff();
		DoMoveCursor(0, NULL, 0, FALSE);
		Draw();
		return;
	}

size_t		l;
POSITION	p=FindLastRow(l);

	if (l < m_top_linenum)
	{
		m_top_linenum=l;
		m_top_pos=p;
	}
	VRecalc();
	Draw();
}

size_t	CBaseTextWidget::TopRow()
{
	return (m_top_linenum);
}

size_t	CBaseTextWidget::NumRows()
{
	return (m_bot_linenum - m_top_linenum+1);
}

void	CBaseTextWidget::OnButtonDown(int nButton, int x, int y, int buttonMask)
{
size_t	linenum;
POSITION pos;

	CBaseWindowWidget::OnButtonDown(nButton, x, y, buttonMask);
	if (FindRow(y, linenum, pos))
		OnBaseTextButtonDown(nButton, x, linenum, pos, buttonMask);
}

void	CBaseTextWidget::OnButtonUp(int nButton, int x, int y, int buttonMask)
{
size_t	linenum;
POSITION pos;

	if (FindRow(y, linenum, pos))
		OnBaseTextButtonUp(nButton, x, linenum, pos, buttonMask);
}

void	CBaseTextWidget::OnMotion(int x, int y, int buttonMask)
{
size_t	linenum;
POSITION pos;

	if (FindRow(y, linenum, pos))
		OnBaseTextMotion(x, linenum, pos, buttonMask);
}

AFXBOOL	CBaseTextWidget::FindRow(int clicky, size_t &current_linenum,
	POSITION &pos)
{
ExmBaseDrawInfo	*draw=GetDrawInfo();

	if (clicky < 0 || (unsigned)clicky < draw->y)	return (FALSE);

POSITION p=m_top_pos;

unsigned current_row=draw->y;

	current_linenum=m_top_linenum;

	while (p)
	{
		pos=p;

	unsigned l=NextPos(p);

		if ((unsigned)clicky < current_row + l)
			return (TRUE);
		current_row += l;
		++current_linenum;
	}
	return (FALSE);	// Below the watermark
}

void	CBaseTextWidget::OnBaseTextButtonDown(int, int, size_t, POSITION, int)
{
}

void	CBaseTextWidget::OnBaseTextButtonUp(int, int, size_t, POSITION, int)
{
}

void	CBaseTextWidget::OnBaseTextMotion(int, size_t, POSITION, int)
{
}
