// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetbase_h
#define	widgetbase_h

static const char wdigetbaset_h_rcsid[]="$Id: widgetbase.h,v 1.4 1999/04/09 02:32:28 mrsam Exp $";

#include	"widget.h"
#include	"widgettimer.h"
#include	"Base.h"

///////////////////////////////////////////////////////////////////
//
// The C++ side of the 'Base' widget, a translation mechanism from
// the Xt/Xm object-oriented methodology into native C++.
//
// One value-added feature here is worth noting - delayed redraws.
// The derived function defines how the widget looks like, however,
// to redraw the widget, we go through the Xt/X11 'Expose' mechanism.
// The derived function calls Draw(), which generates the Expose
// event, which eventually ends up calling OnDraw().  This doesn't
// really take up much time, however, the actual redrawing may be
// quite CPU intensive, so, we provide a delayed redraw.  By default,
// Draw() will set a timer, and, the expose event is generated only
// when the timer goes off.  In the meantime, any additional Draw()s
// are quietly ignored.

class CBaseWindowWidget;

class CBaseWindowWidget  : public CWidget {
	WidgetClass	Class();

	CXmTimeout<CBaseWindowWidget>	m_timer;

	void	DelayedDraw();

public:

static int	redraw_frequency;

	CBaseWindowWidget(const char *);
	virtual ~CBaseWindowWidget();
	void	Create(CWidget *parent);
	void	Draw(AFXBOOL immediate=FALSE);

	ExmBaseDrawInfo *GetDrawInfo();

virtual void	OnDraw();
virtual void	OnResize(unsigned, unsigned);
virtual void	OnDefaultSize(unsigned &, unsigned &);
virtual void	OnButtonDown(int nButton, int x, int y, int buttonMask);
virtual void	OnButtonUp(int nButton, int x, int y, int buttonMask);
virtual void	OnMotion(int x, int y, int buttonMask);
virtual void	OnCut();
virtual void	OnCopy();
virtual void	OnPaste();
} ;

#endif
