// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	widgetarray_h
#define	widgetarray_h

static const char widgetarray_h_rcsid[]="$Id: widgetarray.h,v 1.4 1999/04/09 02:25:54 mrsam Exp $";

#include	"afx.h"
#include	"afxtempl.h"
#include	"widget.h"
#include	<X11/Intrinsic.h>

/////////////////////////////////////////////////////////////////////////
//
// Sometimes we need to create an array of widgets which will be
// autodestructed (pulldown menu, for example).
// The CWidgetArray provides such a service.  This is an array of CWidget
// pointers, which can be destroyed no matter what the actual widget is,
// because we have virtual destructors.
// The array is initialized to NULL pointers, and it is up to the caller
// to fill it in.  However, when the object goes away, we automatically
// delete any NULL pointers here

class	CWidgetArray {
	CArray<CWidget *, CWidget *> m_array;

	void	operator=(const CWidgetArray &);	//UNDEFINED
	CWidgetArray(const CWidgetArray &);		//UNDEFINED
public:
	CWidgetArray()	{}
	~CWidgetArray()	{ SetSize(0); }
	void	SetSize(unsigned cnt);
	unsigned GetSize() { return (m_array.GetSize()); }
	CWidget **Ptr() { return (m_array.GetData()); }
	CWidget *operator[](unsigned n) { return (m_array[n]); }
	void	Set(unsigned n, CWidget *p) { m_array[n]=p; }
} ;

// Extend CWidgetArray to automatically create buttons &/| separators

class	CWidgetArrayMenu : public CWidgetArray {

	CStringArray	m_names;	// Where we store names
public:
	CWidgetArrayMenu()		{}
	CWidgetArrayMenu(const char *)	{}	// CActivateRedirect hack
	virtual ~CWidgetArrayMenu();
	void	Create(CWidget *, unsigned nbuttons);
					// Create only buttons
	void	Create(CWidget *, const char *);	// Create buttons/separators
					// String has one character for each
					// button/separator - B: button
					// S: separator

	virtual void	OnActivate();	// Pushbuttons' OnActivate()s get
					// redirected here
	unsigned	m_activatedIndex;
} ;

#endif
