// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<Xm/Xm.h>
#include	"widgetargs.h"
#include	"widgetxms.h"
#include	"afx.h"
#include	"afxtempl.h"

static const char rcsid[]="$Id: widgetargs.C,v 1.4 1999/04/09 02:32:28 mrsam Exp $";

////////////////////////////////////////////////////////////////////////
//
//  The ArgList is, perhaps, the ugliest implementation

class CWidgetArg {
public:
	const char *m_name;
	XtArgVal m_value;
	CXmString m_string;
	} ;

class CWidgetArgsInternal {
public:
	CList<CWidgetArg, const CWidgetArg &> m_list;
	CArray<Arg, Arg &> m_args;

	CWidgetArgsInternal()	{}
	~CWidgetArgsInternal()	{}

	Arg	*Args(int &n);
	} ;

void CWidgetArgs::init()
{
	if (m_ptr)	return;

	m_ptr=new CWidgetArgsInternal;
	if (!m_ptr)	AfxThrowMemoryException();
}

void CWidgetArgs::AddStringLocalized(const char *name, CString value)
{
	init();

CWidgetArg	arg;

	arg.m_name=name;
	arg.m_value=(XtArgVal)NULL;
	arg.m_string=value;
	m_ptr->m_list.AddTail(arg);
}

void CWidgetArgs::Add(const char *name, long val)
{
	init();

CWidgetArg	arg;

	arg.m_name=name;
	arg.m_value=(XtArgVal)val;
	m_ptr->m_list.AddTail(arg);
}

void CWidgetArgs::Add(const char *name, void *val)
{
	init();

POSITION p;

	// If we redefine an argument, delete the old value

	for (p=m_ptr->m_list.GetHeadPosition(); p; )
	{
	POSITION savepos=p;

		if (strcmp(m_ptr->m_list.GetNext(p).m_name, name) == 0)
		{
			m_ptr->m_list.RemoveAt(savepos);
			break;
		}
	}

CWidgetArg	arg;

	arg.m_name=name;
	arg.m_value=(XtArgVal)val;
	m_ptr->m_list.AddTail(arg);
}

CWidgetArgs::~CWidgetArgs()
{
	if (m_ptr)
		delete m_ptr;
}

Arg	*CWidgetArgs::Args(int &n) const
{
	n=0;
	if (!m_ptr)	return (NULL);
	return (m_ptr->Args(n));
}

//  Time to put together an Arg array.

Arg	*CWidgetArgsInternal::Args(int &n)
{
	m_args.SetSize(m_list.GetCount());

	n=0;
POSITION p;

	for (p=m_list.GetHeadPosition(); p; )
	{
	CWidgetArg	&arg=m_list.GetNext(p);
	XtArgVal	argval=
			( (XmString)arg.m_string ?
				(XtArgVal)(XmString)arg.m_string:arg.m_value);

		XtSetArg(m_args[n], (char *) arg.m_name, argval);
		++n;
	}
	return (m_args.GetData());
}
