// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef _ExmBase_h
#define _ExmBase_h

static const char Base_h_rcsid[]="$Id: Base.h,v 1.1 1997/07/14 02:48:59 mrsam Exp $";

///////////////////////////////////////////////////////////////////////
//
// The 'Base' widget is basically a stub to translate Xm/Xt object
// methodology into C++ methodology.  Normal functions which are
// performed by a widget implementation - redraw/resize, etc, are
// translated into Xt/X11 callback functions, which are picked up
// by the CBaseWidget class, and translated into virtual functions.

#include <Xm/Xm.h>  /* public header file for the XmPrimitive widget */


#ifdef __cplusplus
extern "C" {
#endif


/* Define the widget class and widget record. */
externalref WidgetClass exmBaseWidgetClass;

typedef struct _ExmBaseClassRec *ExmBaseWidgetClass;
typedef struct _ExmBaseRec *ExmBaseWidget;


/* Define an IsSubclass macro. */
#ifndef ExmIsBase
#define ExmIsBase(w) XtIsSubclass(w, exmBaseWidgetClass)
#endif

extern Widget ExmCreateBase(Widget, char *, Arg *, Cardinal);

#define	ExmNredisplay "redisplay"
#define	ExmNdrawCallback "statusCallback"
#define	ExmNresizeCallback "resizeCallback"
#define	ExmNdefaultSizeCallback "defaultSizeCallback"
#define ExmNenterCallback	"enterCallback"
#define ExmNleaveCallback	"leaveCallback"
#define ExmNbuttonDownCallback	"buttonDownCallback"
#define ExmNbuttonUpCallback	"buttonUpCallback"
#define ExmNmotionCallback	"motionCallback"
#define	ExmNdrawingArea		"drawingArea"
#define	ExmNcutCallback		"cutCallback"
#define	ExmNcopyCallback	"copyCallback"
#define	ExmNpasteCallback	"pasteCallback"

typedef struct {
	unsigned	x, y, width, height;
	GC		gc;
	XmRenderTable	render_table;
	unsigned char	layout_direction;
} ExmBaseDrawInfo;

#ifdef __cplusplus
}
#endif
#endif
