// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include "BaseP.h"
#include <Xm/DrawP.h>
#include <Xm/Screen.h>
#include <Xm/TraitP.h>
#include <Xm/CareVisualT.h>
#include <Xm/ContItemT.h>
#include <Xm/ContainerT.h>
#include <Xm/SpecRenderT.h>

static const char rcsid[]="$Id: Base.C,v 1.1 1997/07/14 02:48:59 mrsam Exp $";


#define        INITIAL_WIDTH   100
#define        INITIAL_HEIGHT  50

static void DefaultFont(Widget,int,XrmValue *);
static void ClassInitialize(void);
static void ClassPartInitialize(WidgetClass);
static void Initialize(Widget,Widget,ArgList,Cardinal *);
static void Destroy(Widget);
static void Realize(Widget,XtValueMask *,XSetWindowAttributes *);
static void Resize(Widget);
static void Redisplay(Widget,XEvent *,Region);
static Boolean SetValues(Widget,Widget,Widget,ArgList,Cardinal *);
static XtGeometryResult QueryGeometry(Widget,XtWidgetGeometry *,
XtWidgetGeometry *);
static void DrawVisual(Widget);
static void GetDrawingArea(Widget, int, XtArgVal *);
static void DrawShadow(Widget);
static void CreateGC(Widget);
static void DestroyGC(Widget);
static GC SelectGC(Widget);
static void CalcVisualSize(Widget);
static void CalcWidgetSize(Widget);
static Boolean WidgetDisplayRect(Widget,XRectangle  *);
static void Reconfigure(WidgetClass,Widget,Widget);
static void ContItemSetValues(Widget,XmContainerItemData);
static void ContItemGetValues(Widget,XmContainerItemData);

static Boolean HandleRedraw(Widget,Widget,Widget,Mask);
static void SetSelectedVisual(Widget) ;

static void ExmBaseEnter( Widget, XEvent *, String *, Cardinal *);
static void ExmBaseLeave( Widget, XEvent *, String *, Cardinal *);
static void ExmBaseFocusIn( Widget, XEvent *, String *, Cardinal *);
static void ExmBaseFocusOut( Widget, XEvent *, String *, Cardinal *);
static void ExmBaseButtonDown( Widget, XEvent *, String *, Cardinal *);
static void ExmBaseButtonUp( Widget, XEvent *, String *, Cardinal *);
static void ExmBaseMotion( Widget, XEvent *, String *, Cardinal *);
static void ExmBaseCut( Widget, XEvent *, String *, Cardinal *);
static void ExmBaseCopy( Widget, XEvent *, String *, Cardinal *);
static void ExmBasePaste( Widget, XEvent *, String *, Cardinal *);

//  Default translations for the base widget - basic primitive mappings

static char defaultTranslations[] =
"<Unmap>:                       PrimitiveUnmap()\n\
<Enter>:                        ExmBaseEnter()\n\
<Leave>:                        ExmBaseLeave()\n\
<FocusIn>:                      ExmBaseFocusIn()\n\
<FocusOut>:                     ExmBaseFocusOut()\n\
<BtnDown>:			ExmBaseButtonDown()\n\
<BtnUp>:			ExmBaseButtonUp()\n\
<Motion>:			ExmBaseMotion()\n\
:<Key>osfActivate:              PrimitiveParentActivate()\n\
:<Key>osfHelp:                  PrimitiveHelp()\n\
:<Key>osfCancel:                PrimitiveParentCancel()\n\
:<Key>osfBeginLine:             PrimitiveTraverseHome()\n\
:<Key>osfUp:                    PrimitiveTraverseUp()\n\
:<Key>osfDown:                  PrimitiveTraverseDown()\n\
:<Key>osfLeft:                  PrimitiveTraverseLeft()\n\
:<Key>osfRight:                 PrimitiveTraverseRight()\n\
:<Key>osfCut:                   ExmBaseCut()\n\
:<Key>osfCopy:                  ExmBaseCopy()\n\
:<Key>osfPaste:                 ExmBasePaste()\n\
~s ~m ~a <Key>Return:           PrimitiveParentActivate()\n\
s ~m ~a <Key>Tab:               PrimitivePrevTabGroup()\n\
~m ~a <Key>Tab:                 PrimitiveNextTabGroup()";

static XtActionsRec actions[] = {
	{"ExmBaseEnter",	ExmBaseEnter},
	{"ExmBaseLeave",	ExmBaseLeave},
	{"ExmBaseFocusIn",	ExmBaseFocusIn},
	{"ExmBaseFocusOut",	ExmBaseFocusOut},
	{"ExmBaseButtonDown",	ExmBaseButtonDown},
	{"ExmBaseButtonUp",	ExmBaseButtonUp},
	{"ExmBaseMotion",	ExmBaseMotion},
	{"ExmBaseCut",		ExmBaseCut},
	{"ExmBaseCopy",		ExmBaseCopy},
	{"ExmBasePaste",	ExmBasePaste},
} ;

//////////////////////////////////////////////////////////////////////
//
// Define resources

static XtResource resources[] =
{
	{
		XmNrenderTable,
		XmCRenderTable,
		XmRRenderTable,
		sizeof(XmRenderTable),
		XtOffsetOf( ExmBaseRec, base.render_table),
		XtRCallProc,
		(XtPointer) DefaultFont
	},
	{
		XmNmarginWidth,
		XmCMarginWidth,
		XmRHorizontalDimension,
		sizeof (Dimension),
		XtOffsetOf( ExmBaseRec, base.margin_width),
		XmRImmediate,
		(XtPointer) 4
	},
	{
		XmNmarginHeight,
		XmCMarginHeight,
		XmRVerticalDimension,
		sizeof (Dimension),
		XtOffsetOf( ExmBaseRec, base.margin_height),
		XmRImmediate,
		(XtPointer) 4
	},
	{
		XmNnavigationType,
		XmCNavigationType,
		XmRNavigationType,
		sizeof(unsigned char),
		XtOffsetOf(ExmBaseRec, primitive.navigation_type),
		XmRImmediate,
		(XtPointer) XmTAB_GROUP
	},
	{
		ExmNdrawCallback,
		ExmCdrawCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.draw_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNresizeCallback,
		ExmCresizeCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.resize_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNdefaultSizeCallback,
		ExmCdefaultSizeCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.defaultsize_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		XmNfocusCallback,
		XmNfocusCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.focusin_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		XmNlosingFocusCallback,
		XmNlosingFocusCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.focusout_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNenterCallback,
		ExmCenterCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.enter_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNleaveCallback,
		ExmCleaveCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.leave_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNredisplay,
		ExmCredisplay,
		XtRBool,
		sizeof (Bool),
		XtOffsetOf( ExmBaseRec, base.dummy),
		XmRImmediate,
		(XtPointer) TRUE
	},
	{
		ExmNbuttonDownCallback,
		ExmCbuttonDownCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.down_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNbuttonUpCallback,
		ExmCbuttonUpCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.up_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNmotionCallback,
		ExmCmotionCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.motion_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNcutCallback,
		ExmCcutCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.cut_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNcopyCallback,
		ExmCcopyCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.copy_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
		ExmNpasteCallback,
		ExmCpasteCallback,
		XtRCallback,
		sizeof(XtPointer),
		XtOffsetOf( ExmBaseRec, base.paste_callbacks),
		XtRCallback,
		(XtPointer) NULL
	},
	{
                ExmNdrawingArea,
                ExmCdrawingArea,
                XtRPointer,
                sizeof(XtPointer),
                XtOffsetOf( ExmBaseRec, base.drawingArea),
                XtRPointer,
                (XtPointer) NULL
        },
};


static XmSyntheticResource syn_resources[] =
{
	{
		XmNmarginWidth,
		sizeof (Dimension),
		XtOffsetOf( ExmBaseRec, base.margin_width),
		XmeFromHorizontalPixels,
		XmeToHorizontalPixels
	},
	{
		XmNmarginHeight,
		sizeof (Dimension),
		XtOffsetOf( ExmBaseRec, base.margin_height),
		XmeFromVerticalPixels,
		XmeToVerticalPixels
	},
	{
		ExmNdrawingArea,
		sizeof (XtPointer),
		XtOffsetOf( ExmBaseRec, base.drawingArea),
		GetDrawingArea,
		NULL
	},
};


static XmPrimitiveClassExtRec primClassExtRec =
{
	NULL,
	NULLQUARK,
	XmPrimitiveClassExtVersion,
	sizeof(XmPrimitiveClassExtRec),
	NULL,
	WidgetDisplayRect,
	NULL,
};


externaldef (exmbaseclassrec) ExmBaseClassRec exmBaseClassRec =
{
	{                     // core_class:
                              // superclass
		(WidgetClass)&xmPrimitiveClassRec,
		"ExmBase",     // class_name
                              // widget_size
		sizeof(ExmBaseRec),
                              // class_initialize
		ClassInitialize,
                              // class_part_initialize
		ClassPartInitialize,
		FALSE,        // class_inited
		Initialize,   // initialize
		NULL,         // initialize_hook
		Realize,      // realize
		actions,      // actions
		sizeof(actions)/sizeof(actions[0]), // num_actions
		resources,    // resources
                              // num_resources
		XtNumber(resources),
		NULLQUARK,    // xrm_class
		TRUE,         // compress_motion
                              // compress_exposure
		XtExposeCompressMaximal,
		TRUE,         // compress_enterleave
		FALSE,        // visible_interest
		Destroy,      // destroy
		Resize,       // resize
		Redisplay,    // expose
		SetValues,    // set_values
		NULL,         // set_values_hook
                              // set_values_almost
		XtInheritSetValuesAlmost,
		NULL,         // get_values_hook
		NULL,         // accept_focus
		XtVersion,    // version
		NULL,         // callback_private
                              // tm_table
		"",
                              // query_geometry
				QueryGeometry,
			NULL, // display_accelerator
			NULL, // extension
	},
	{                     // primitive_class:
                              // border_highlight
		XmInheritBorderHighlight,
                              // border_unhighlight
		XmInheritBorderUnhighlight,
                              // translations
		defaultTranslations,
		NULL,         // arm_and_activate
		syn_resources,// syn_resources
                              // num_syn_resources
		XtNumber(syn_resources),
                              // extension
		(XtPointer)&primClassExtRec,
	},
	{                     // base_class:
                              // default_render_table_type
		XmLABEL_RENDER_TABLE,
		DrawVisual,   // draw_visual
		DrawShadow,   // draw_shadow
		CreateGC,     // create_gc
		DestroyGC,    // destroy_gc
		SelectGC,     // select_gc
                              // calc_visual_size
		CalcVisualSize,
                              // calc_widget_size
		CalcWidgetSize,
		Reconfigure,  // reconfigure
		NULL,         // extension
	}
};


externaldef( exmbasewidgetclass) WidgetClass exmBaseWidgetClass =
(WidgetClass) &exmBaseClassRec;


static XmConst XmContainerItemTraitRec logCIT =
{
	0,                    /* version */
	ContItemSetValues,
	ContItemGetValues,
};


static XmConst XmCareVisualTraitRec logCVT =
{
	0,                    /* version */
	HandleRedraw,
};


// Initialize log widget class
static void ClassInitialize( void )
{
}


// Initialize class part of this widget

static void ClassPartInitialize (WidgetClass widgetClass)
{
	ExmBaseWidgetClass wc = (ExmBaseWidgetClass)widgetClass;
	ExmBaseWidgetClass sc = (ExmBaseWidgetClass) wc->core_class.superclass;

	if (wc->base_class.draw_visual == ExmInheritDrawVisual)
		wc->base_class.draw_visual = sc->base_class.draw_visual;
	if (wc->base_class.draw_shadow == ExmInheritDrawShadow)
		wc->base_class.draw_shadow = sc->base_class.draw_shadow;
	if (wc->base_class.create_gc == ExmInheritCreateGC)
		wc->base_class.create_gc = sc->base_class.create_gc;
	if (wc->base_class.destroy_gc == ExmInheritDestroyGC)
		wc->base_class.destroy_gc = sc->base_class.destroy_gc;
	if (wc->base_class.select_gc == ExmInheritSelectGC)
		wc->base_class.select_gc = sc->base_class.select_gc;
	if (wc->base_class.calc_visual_size == ExmInheritCalcVisualSize)
		wc->base_class.calc_visual_size = sc->base_class.calc_visual_size;
	if (wc->base_class.calc_widget_size == ExmInheritCalcWidgetSize)
		wc->base_class.calc_widget_size = sc->base_class.calc_widget_size;
	if (wc->base_class.reconfigure == ExmInheritReconfigure)
		wc->base_class.reconfigure = sc->base_class.reconfigure;

	XmeTraitSet((XtPointer) wc, XmQTcontainerItem, (XtPointer) &logCIT);
	XmeTraitSet((XtPointer) wc, XmQTcareParentVisual, (XtPointer) &logCVT);
}


//  Now, it's time to initialize my widget:

static void Initialize( Widget request_w,
Widget new_w,
ArgList ,
Cardinal *)
{
ExmBaseWidgetClass wc = (ExmBaseWidgetClass)XtClass(new_w);
ExmBaseWidget rw = (ExmBaseWidget)request_w;
ExmBaseWidget nw = (ExmBaseWidget)new_w;

	nw->base.render_table = XmRenderTableCopy(nw->base.render_table, NULL, 0);

	if (wc->base_class.create_gc)
		(*(wc->base_class.create_gc))((Widget)nw);

	if (rw->core.width == 0)
	{
		nw->base.need_to_compute_width = True;
	}
	else
	{
		nw->base.need_to_compute_width = False;
		nw->base.pref_width = rw->core.width;
		nw->core.width = rw->core.width;
	}

	if (rw->core.height == 0)
		nw->base.need_to_compute_height = True;
	else
	{
		nw->base.need_to_compute_height = False;
		nw->base.pref_height = rw->core.height;
		nw->core.height = rw->core.height;
	}

	nw->base.saved_foreground = XmUNSPECIFIED_PIXEL ;

	if (wc->base_class.reconfigure)
		(*(wc->base_class.reconfigure))(exmBaseWidgetClass, new_w, NULL);
}


static void Destroy (Widget w)
{
ExmBaseWidgetClass wc = (ExmBaseWidgetClass) XtClass(w);
ExmBaseWidget sw= (ExmBaseWidget)w;

	if (wc->base_class.destroy_gc)
		(*(wc->base_class.destroy_gc))(w);

	if (sw->base.render_table != NULL)
		XmRenderTableFree (sw->base.render_table);
}


static void Realize(Widget w, XtValueMask *p_valueMask,
XSetWindowAttributes *attributes )
{
//	Mask valueMask = *p_valueMask;

	xmPrimitiveClassRec.core_class.realize(w, p_valueMask, attributes);

	if (XtClass(w) == exmBaseWidgetClass)
	{
		Mask adjustMask;
		XSetWindowAttributes xswa;

		adjustMask = CWDontPropagate;
		xswa.do_not_propagate_mask = NoEventMask;
		XChangeWindowAttributes(XtDisplay(w), XtWindow(w), adjustMask, &xswa);
	}
}

// This widget has been resized

static void Resize (Widget w)
{
	ExmBaseWidgetClass wc = (ExmBaseWidgetClass)XtClass(w);
	ExmBaseWidget sw = (ExmBaseWidget)w;
	Dimension  mw, mh;
	Dimension  window_decoration_thickness;
	Dimension  total_target_widget_width, total_target_widget_height;

	if (wc->base_class.calc_visual_size)
		(*(wc->base_class.calc_visual_size))((Widget)sw);

	window_decoration_thickness = sw->primitive.highlight_thickness  +
	sw->primitive.shadow_thickness;

	mw = window_decoration_thickness + sw->base.margin_width;
	total_target_widget_width = (2 * mw) + sw->base.visual.width;

// Ok, figure out what can be displayed here.

	if (sw->core.width >= total_target_widget_width)
	{
		sw->base.visual.x = mw;
		sw->base.visual.width = sw->core.width - (2 * mw);
	} else if (sw->core.width > ((2 * window_decoration_thickness) +
	sw->base.visual.width))
	{
		sw->base.visual.x = (sw->core.width - sw->base.visual.width)/2;
	}
	else if (sw->core.width > 2 * window_decoration_thickness)
	{
		sw->base.visual.x = window_decoration_thickness;
		sw->base.visual.width = sw->core.width -
		(2 * window_decoration_thickness);
	}
	else
	{
		sw->base.visual.width = 0;
	}

	mh = window_decoration_thickness + sw->base.margin_height;
	total_target_widget_height = (2 * mh) + sw->base.visual.height;

	if (sw->core.height >= total_target_widget_height)
	{
		sw->base.visual.y = mh;
		sw->base.visual.height = sw->core.height - (2 * mh);
	} else if (sw->core.height > ((2 * window_decoration_thickness)
	+ sw->base.visual.height))
	{
		sw->base.visual.y = (sw->core.height - sw->base.visual.height)/2;
	}
	else if (sw->core.height > 2 * window_decoration_thickness)
	{
		sw->base.visual.y = window_decoration_thickness;
		sw->base.visual.height = sw->core.height -
		(2 * window_decoration_thickness);
	}
	else
	{
		sw->base.visual.height = 0;
	}

ExmBaseDrawInfo cbs;

	cbs.x=sw->base.visual.x;
	cbs.y=sw->base.visual.y;
	cbs.width=sw->base.visual.width;
	cbs.height=sw->base.visual.height;
        XtCallCallbackList (w, sw->base.resize_callbacks, (XtPointer) &cbs);
}


//  We must redraw this widget.

static void Redisplay ( Widget w, XEvent *event, Region region )
{
	ExmBaseWidgetClass wc = (ExmBaseWidgetClass)XtClass(w);

// First, draw the visual part
	if (wc->base_class.draw_visual)
		(*wc->base_class.draw_visual) (w);

// Now, draw the shadow

	if (wc->base_class.draw_shadow)
		(*wc->base_class.draw_shadow) (w);

// Call core's expose method, which knows how to draw the border
// highlight

	(*(xmPrimitiveClassRec.core_class.expose))(w, event, region);
}


// Change resources
static Boolean SetValues ( Widget old_w, Widget request_w, Widget new_w,
ArgList args, Cardinal *nargs)
{
ExmBaseWidgetClass wc = (ExmBaseWidgetClass)XtClass(new_w);
ExmBaseWidget cw = (ExmBaseWidget)old_w;
ExmBaseWidget rw = (ExmBaseWidget)request_w;
ExmBaseWidget nw = (ExmBaseWidget)new_w;
Boolean redisplayFlag = False;
Cardinal n;

// If keyboard focus is being taken or given, redisplay

	if (XtIsSensitive(new_w) != XtIsSensitive(old_w))
		redisplayFlag = True;

// If main colors change, recreate graphic contexts.

	if (nw->primitive.foreground != cw->primitive.foreground ||
		nw->core.background_pixel != cw->core.background_pixel)
	{
		if (wc->base_class.destroy_gc)
			(*(wc->base_class.destroy_gc))((Widget)cw);
		if (wc->base_class.create_gc)
			(*(wc->base_class.create_gc))((Widget)nw);
		redisplayFlag = True;
	}

// Render table changed, according to convention, it must be copied

	if (nw->base.render_table != cw->base.render_table)
	{
		nw->base.render_table = XmRenderTableCopy(nw->base.render_table,
		NULL, 0);
		XmRenderTableFree (cw->base.render_table);
		cw->base.render_table = (XmRenderTable) NULL;
		redisplayFlag = True;
	}

// See if default width/height must be calculated

	if (rw->core.width == 0)
	{
		nw->core.width = 0;
		nw->base.need_to_compute_width = True;
	}
	else if (rw->core.width != cw->core.width)
	{
		nw->core.width = rw->core.width;
		nw->base.pref_width = rw->core.width;
		nw->base.need_to_compute_width = False;
	}

	if (rw->core.height == 0)
	{
		nw->core.height = 0;
		nw->base.need_to_compute_height = True;
	}
	else if (rw->core.height != cw->core.height)
	{
		nw->core.height = rw->core.height;
		nw->base.pref_height = rw->core.height;
		nw->base.need_to_compute_height = False;
	}

	nw->base.need_to_reconfigure = False;
	if (nw->core.width != cw->core.width ||
		nw->core.height != cw->core.height ||
		nw->base.margin_width != cw->base.margin_width ||
		nw->base.margin_height != cw->base.margin_height ||
		nw->primitive.shadow_thickness
				!= cw->primitive.shadow_thickness ||
		nw->primitive.highlight_thickness
				!= cw->primitive.highlight_thickness )
		Reconfigure (exmBaseWidgetClass, new_w, old_w);

	for (n=0; n <*nargs; n++)
		if (strcmp(args[n].name, ExmNredisplay) == 0 &&
			!redisplayFlag && XtWindow(new_w))
		{
		XEvent xev;

			xev.xexpose.type=Expose;
			xev.xexpose.serial=0;
			xev.xexpose.send_event=FALSE;
			xev.xexpose.display=XtDisplay(new_w);
			xev.xexpose.window=XtWindow(new_w);
			xev.xexpose.x=nw->base.visual.x;
			xev.xexpose.y=nw->base.visual.y;
			xev.xexpose.width=nw->base.visual.width;
			xev.xexpose.height=nw->base.visual.height;
			xev.xexpose.count=0;
			XtDispatchEvent(&xev);
		}
	return (redisplayFlag);
}


// Is this geometry change OK?

static XtGeometryResult QueryGeometry ( Widget widget,
XtWidgetGeometry *parent_request,
XtWidgetGeometry *child_reply
)
{
	ExmBaseWidget sw = (ExmBaseWidget) widget;

	if (!XtIsRealized(widget))
	{
		child_reply->width  = XtWidth(widget);
		child_reply->height = XtHeight(widget);
	}
	else
	{
		child_reply->width  = sw->base.pref_width;
		child_reply->height = sw->base.pref_height;
	}

	return XmeReplyToQueryGeometry(widget, parent_request, child_reply);
}


// Ok, time to redisplay us

static void DrawVisual ( Widget w )
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallCallbackList (w, sw->base.draw_callbacks, (XtPointer) NULL);
}

static void GetDrawingArea(Widget w, int, XtArgVal *val)
{
ExmBaseWidgetClass wc = (ExmBaseWidgetClass)XtClass(w);
ExmBaseWidget sw = (ExmBaseWidget)w;

	sw->base.drawingArea= &sw->base.drawingAreaStruct;
	*val = (XtArgVal)sw->base.drawingArea;
	sw->base.drawingAreaStruct.x=sw->base.visual.x;
	sw->base.drawingAreaStruct.y=sw->base.visual.y;
	sw->base.drawingAreaStruct.width=sw->base.visual.width;
	sw->base.drawingAreaStruct.height=sw->base.visual.height;
	sw->base.drawingAreaStruct.gc=wc->base_class.select_gc(w);
	sw->base.drawingAreaStruct.render_table=sw->base.render_table;
	sw->base.drawingAreaStruct.layout_direction=sw->primitive.layout_direction;
}

// Draw standard Motif shadow around this widget.

static void DrawShadow ( Widget w )
{
	ExmBaseWidget sw = (ExmBaseWidget)w;

// Draw only if there's room

	if (sw->core.width  > (2 * sw->primitive.highlight_thickness) &&
		sw->core.height > (2 * sw->primitive.highlight_thickness) &&
	sw->primitive.shadow_thickness > 0)
	XmeDrawShadows (XtDisplay (sw), XtWindow (sw),
	sw->primitive.top_shadow_GC,
	sw->primitive.bottom_shadow_GC,
	sw->primitive.highlight_thickness,
	sw->primitive.highlight_thickness,
	sw->core.width - (2 * sw->primitive.highlight_thickness),
	sw->core.height - (2 * sw->primitive.highlight_thickness),
	sw->primitive.shadow_thickness,
	XmSHADOW_ETCHED_OUT);
}


// Create default graphic contexts

static void CreateGC ( Widget w )
{
	ExmBaseWidget sw = (ExmBaseWidget)w;
	XGCValues   values;
	XtGCMask    valueMask;
	Arg         args[2];
	Pixmap      insensitiveStippleBitmap;


// Create GC when we get input focus

	valueMask = GCForeground | GCBackground | GCGraphicsExposures;
	values.foreground = sw->primitive.foreground;
	values.background = sw->core.background_pixel;
	values.graphics_exposures = False;
	sw->base.normal_gc = XtGetGC ((Widget)sw, valueMask, &values);

// Create GC for when we don't have input focus

	valueMask |= GCFillStyle | GCStipple;
	values.fill_style = FillStippled;

// Motif default bitmap:

	XtSetArg(args[0], XmNinsensitiveStippleBitmap, &insensitiveStippleBitmap);
	XtGetValues(XmGetXmScreen(XtScreen(w)), args, 1);
	values.stipple = insensitiveStippleBitmap;

	sw->base.insensitive_gc = XtGetGC((Widget)sw, valueMask, &values);
}


// We should destroy all our GCs now
static void DestroyGC ( Widget w )
{
	ExmBaseWidget sw = (ExmBaseWidget)w;

	XtReleaseGC ((Widget)sw, sw->base.normal_gc);
	XtReleaseGC ((Widget)sw, sw->base.insensitive_gc);
}


// Return whatever GC should be used now:

static GC SelectGC ( Widget w )
{
	ExmBaseWidget sw = (ExmBaseWidget)w;
	GC drawGC;

	drawGC = XtIsSensitive(w)  ? sw->base.normal_gc
	: sw->base.insensitive_gc;
	return (drawGC);
}


// Return default size for my contents

static void CalcVisualSize ( Widget w )
{
	ExmBaseWidget sw = (ExmBaseWidget)w;

	sw->base.visual.width = INITIAL_WIDTH;
	sw->base.visual.height = INITIAL_HEIGHT;
}


// Calculate current size the widget should have now based upon our contents

static void CalcWidgetSize( Widget w )
{
ExmBaseWidgetClass wc = (ExmBaseWidgetClass)XtClass(w);
ExmBaseWidget sw = (ExmBaseWidget)w;

	if (wc->base_class.calc_visual_size)
		(*(wc->base_class.calc_visual_size))((Widget)sw);

ExmBaseDrawInfo cbs;

	if (sw->base.need_to_compute_width || sw->base.need_to_compute_height)
		XtCallCallbackList(w, sw->base.defaultsize_callbacks,
			(XtPointer) &cbs);

	if (sw->base.need_to_compute_width == True)
		sw->core.width=cbs.width +
			(2 * (sw->base.margin_width +
			sw->primitive.shadow_thickness +
			sw->primitive.highlight_thickness));
	else
		sw->core.width = sw->base.pref_width;

	if (sw->base.need_to_compute_height == True)
		sw->core.height=cbs.height +
			(2 * (sw->base.margin_height +
			sw->primitive.shadow_thickness +
			sw->primitive.highlight_thickness));
	else
		sw->core.height = sw->base.pref_height;
}

// Return the geometry of this widget's contents

static Boolean  WidgetDisplayRect( Widget       w, XRectangle  *displayrect )
{
	ExmBaseWidget  my_widget = (ExmBaseWidget) w;

	if ((my_widget->base.visual.width > 0) &&
		(my_widget->base.visual.height > 0))
	{
		displayrect->x =       my_widget->base.visual.x;
		displayrect->y =       my_widget->base.visual.y;
		displayrect->width =   my_widget->base.visual.width;
		displayrect->height =  my_widget->base.visual.height;
		return True;  /* Yes, this widget contains something displayable. */
	}
	else
	{
		return False;
	}
}


static void Reconfigure ( WidgetClass clname, Widget new_w, Widget old_w )
{
	ExmBaseWidgetClass wc = (ExmBaseWidgetClass)clname;
	ExmBaseWidget nw = (ExmBaseWidget)new_w;
	ExmBaseWidget cw = (ExmBaseWidget)old_w;

	if (!ExmIsBase((Widget)nw))
		return;

	if (clname == XtClass(nw))
	{
		if (wc->base_class.calc_widget_size)
			(*(wc->base_class.calc_widget_size))((Widget)nw);

		nw->base.pref_width  = nw->core.width;
		nw->base.pref_height = nw->core.height;

		if (cw == NULL ||
			(nw->core.width  == cw->core.width &&
		nw->core.height == cw->core.height)
		)
		{
			if (wc->core_class.resize)
				(*(wc->core_class.resize))((Widget)nw);
		}
	}
	else
		nw->base.need_to_reconfigure = True;
}


static void ContItemSetValues(Widget w, XmContainerItemData contItemData)
{
	ExmBaseWidget sw = (ExmBaseWidget)w;

	if (contItemData->valueMask & ContItemVisualEmphasis)
	{
		if (contItemData->visual_emphasis == XmSELECTED)
		{
			if (sw->base.saved_foreground == XmUNSPECIFIED_PIXEL)
				sw->base.saved_foreground = sw->primitive.foreground ;

			SetSelectedVisual  (w) ;

		}
		else
		{
			XtVaSetValues(w, XmNforeground, sw->base.saved_foreground, NULL);
			sw->base.saved_foreground = XmUNSPECIFIED_PIXEL ;
		}

	}
}


static void
DefaultFont ( Widget w, int, XrmValue *value )
{
ExmBaseWidgetClass wc = (ExmBaseWidgetClass)XtClass(w);
static XmRenderTable  f1;

	f1 = XmeGetDefaultRenderTable (w,
			wc->base_class.default_render_table_type);

	value->addr = (XPointer)&f1;
	value->size = sizeof(f1);
}


static void ContItemGetValues(Widget w, XmContainerItemData contItemData)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	contItemData->view_type = XmLARGE_ICON;

	if (contItemData->valueMask & ContItemVisualEmphasis)
	{
		if (sw->base.saved_foreground == XmUNSPECIFIED_PIXEL)
			contItemData->visual_emphasis = XmNOT_SELECTED;
		else
			contItemData->visual_emphasis = XmSELECTED;
	}

	if (contItemData->valueMask & ContItemIconWidth)
	{
		contItemData->icon_width = sw->core.width - sw->core.x;
	}

	if (contItemData->valueMask & ContItemDetailCount)
	{
		contItemData->detail_count = 0;
	}

}


static void SetSelectedVisual ( Widget wid)
{
	XmContainerDataRec container_data ;
	XmContainerTrait container_trait ;
	Pixel select_color = XmUNSPECIFIED_PIXEL;
	ExmBaseWidget sw = (ExmBaseWidget)wid;

	container_trait = (XmContainerTrait)
	XmeTraitGet((XtPointer)
	XtClass(XtParent(wid)),
	XmQTcontainer) ;

	if (container_trait)
	{
		container_data.valueMask = ContSelectColor ;
		container_trait->getValues(XtParent(wid), &container_data);

		if (container_data.valueMask & ContSelectColor)
		{

/* if the Container uses reverse ground, convert that
               to using black pixel */
			if (container_data.select_color == XmREVERSED_GROUND_COLORS)
				select_color = BlackPixelOfScreen(XtScreen(wid));
			else
				select_color = container_data.select_color;
		}
	}

	if ((select_color != XmUNSPECIFIED_PIXEL) &&
		(sw->base.saved_foreground != XmUNSPECIFIED_PIXEL))
	XtVaSetValues(wid, XmNforeground, select_color, NULL) ;

}


static Boolean HandleRedraw ( Widget kid, Widget cur_parent,
Widget new_parent,
Mask visual_flag)
{
	Boolean redraw = False;
	XmCareVisualTrait care_visual ;

	if (visual_flag & VisualSelectColor)
	{

		SetSelectedVisual (kid) ;

	}

	care_visual = (XmCareVisualTrait)
	XmeTraitGet(xmPrimitiveWidgetClass, XmQTcareParentVisual) ;

	redraw |= care_visual->redraw(kid, cur_parent, new_parent, visual_flag) ;

	return redraw ;
}

static void ExmBaseEnter (Widget w, XEvent *event, String *params,
		Cardinal *num_params)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallActionProc (w, "PrimitiveEnter", event, params, *num_params);
	XtCallCallbackList (w, sw->base.enter_callbacks, event);
}

static void ExmBaseLeave (Widget w, XEvent *event, String *params,
		Cardinal *num_params)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallActionProc (w, "PrimitiveLeave", event, params, *num_params);
	XtCallCallbackList (w, sw->base.leave_callbacks, event);
}

static void ExmBaseFocusIn (Widget w, XEvent *event, String *params,
		Cardinal *num_params)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallActionProc (w, "PrimitiveFocusIn", event, params, *num_params);

	if (event->xfocus.detail == 0)	// Someone explain this one to me
	{
	XmAnyCallbackStruct ptr;

		ptr.reason=XmCR_FOCUS;
		ptr.event= event;
		XtCallCallbackList (w, sw->base.focusin_callbacks, &ptr);
	}
}

static void ExmBaseFocusOut (Widget w, XEvent *event, String *params,
		Cardinal *num_params)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallActionProc (w, "PrimitiveFocusOut", event, params, *num_params);

	if (event->xfocus.detail == 0)	// Someone explain this one to me
	{
	XmAnyCallbackStruct ptr;

		ptr.reason=XmCR_LOSING_FOCUS;
		ptr.event= event;
		XtCallCallbackList (w, sw->base.focusout_callbacks, &ptr);
	}
}

static void ExmBaseButtonDown (Widget w, XEvent *event, String *, Cardinal *)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallCallbackList (w, sw->base.down_callbacks, event);
}

static void ExmBaseButtonUp (Widget w, XEvent *event, String *, Cardinal *)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallCallbackList (w, sw->base.up_callbacks, event);
}

static void ExmBaseMotion (Widget w, XEvent *event, String *, Cardinal *)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallCallbackList (w, sw->base.motion_callbacks, event);
}

static void ExmBaseCut (Widget w, XEvent *event, String *,
		Cardinal *)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallCallbackList (w, sw->base.cut_callbacks, event);
}

static void ExmBaseCopy (Widget w, XEvent *event, String *,
		Cardinal *)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallCallbackList (w, sw->base.copy_callbacks, event);
}

static void ExmBasePaste (Widget w, XEvent *event, String *,
		Cardinal *)
{
ExmBaseWidget sw = (ExmBaseWidget)w;

	XtCallCallbackList (w, sw->base.paste_callbacks, event);
}

// Convenience creation function, for consistency's sake

Widget ExmCreateBase ( Widget parent, char *name, Arg *arglist,
Cardinal argCount )
{
	return (XtCreateWidget (name, exmBaseWidgetClass, parent, arglist, argCount));
}
