// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"openserverform.h"
#include	"channel.h"

static const char rcsid[]="$Id: openserverform.C,v 1.3 1999/04/09 03:02:54 mrsam Exp $";


OpenServerForm::OpenServerForm() : CFormWidget("open_form"),
	m_form("form"),
	m_list_scroll("list_scroll"),
	m_connamelabel("connamelabel"),
	m_hostlabel("hostlabel"),
	m_portlabel("portlabel"),
	m_nicklabel("nicklabel"),
	m_altnicklabel("altnicklabel"),
	m_passwdlabel("passwdlabel"),
	m_namelabel("namelabel"),
	m_list("list"),
	m_connameedit("connameedit"),
	m_hostedit("hostedit"),
	m_portedit("portedit"),
	m_nickedit("nickedit"),
	m_altnickedit("altnickedit"),
	m_passwdedit("passwdedit"),
	m_nameedit("nameedit"),
	m_ok("ok"),
	m_cancel("cancel"),
	m_sep1("sep1"),
	m_channel(NULL),
	m_channel_ptr((void (Channel::*)(AFXBOOL))NULL)
{
	m_ok=this;
	m_cancel=this;
	m_ok= &Ok;
	m_cancel= &Cancel;
	IsDialog(TRUE);
}

OpenServerForm::~OpenServerForm()
{
}

void OpenServerForm::Create(Channel *p)
{
	CFormWidget::Create(p);
	DialogModal();

	m_list_scroll.Create(this);
	m_list.Create(&m_list_scroll);
	m_form.Create(this);

	m_form.Attach(NULL, CWidgetToForm, CWidgetToForm, NULL);
	m_list_scroll.Attach(CWidgetToForm, m_form, CWidgetToForm, NULL);
	m_list_scroll.AttachOpposite(NULL, NULL, NULL, m_form);

	// Separator & Ok/Cancel buttons

	m_sep1.Create(this, m_sep1.horizontal);
	m_ok.Create(this);
	m_cancel.Create(this);

	m_ok.Attach(CWidgetToForm, NULL, m_sep1, NULL);
	m_cancel.Attach(NULL, CWidgetToForm, m_sep1, NULL);

	m_sep1.Attach(CWidgetToForm, CWidgetToForm, m_form, NULL);

	m_connamelabel.Create(&m_form);
	m_hostlabel.Create(&m_form);
	m_portlabel.Create(&m_form);
	m_nicklabel.Create(&m_form);
	m_altnicklabel.Create(&m_form);
	m_passwdlabel.Create(&m_form);
	m_namelabel.Create(&m_form);
	m_connameedit.Create(&m_form);
	m_hostedit.Create(&m_form);
	m_portedit.Create(&m_form);
	m_nickedit.Create(&m_form);
	m_altnickedit.Create(&m_form);
	m_passwdedit.Create(&m_form);
	m_nameedit.Create(&m_form);

	m_connameedit.Attach(NULL, CWidgetToForm, CWidgetToForm, NULL);
	m_hostedit.Attach(NULL, CWidgetToForm, m_connameedit, NULL);
	m_portedit.Attach(NULL, CWidgetToForm, m_hostedit, NULL);
	m_nickedit.Attach(NULL, CWidgetToForm, m_portedit, NULL);
	m_altnickedit.Attach(NULL, CWidgetToForm, m_nickedit, NULL);
	m_passwdedit.Attach(NULL, CWidgetToForm, m_altnickedit, NULL);
	m_nameedit.Attach(NULL, CWidgetToForm, m_passwdedit, NULL);

	m_hostedit.AttachOpposite(m_connameedit, NULL, NULL, NULL);
	m_portedit.AttachOpposite(m_connameedit, NULL, NULL, NULL);
	m_nickedit.AttachOpposite(m_connameedit, NULL, NULL, NULL);
	m_altnickedit.AttachOpposite(m_connameedit, NULL, NULL, NULL);
	m_passwdedit.AttachOpposite(m_connameedit, NULL, NULL, NULL);
	m_nameedit.AttachOpposite(m_connameedit, NULL, NULL, NULL);

	m_connamelabel.Attach(NULL, m_connameedit, NULL, NULL);
	m_hostlabel.Attach(NULL, m_hostedit, NULL, NULL);
	m_portlabel.Attach(NULL, m_portedit, NULL, NULL);
	m_nicklabel.Attach(NULL, m_nickedit, NULL, NULL);
	m_altnicklabel.Attach(NULL, m_altnickedit, NULL, NULL);
	m_passwdlabel.Attach(NULL, m_passwdedit, NULL, NULL);
	m_namelabel.Attach(NULL, m_nameedit, NULL, NULL);

	m_connamelabel.AttachOpposite(NULL, NULL, m_connameedit, m_connameedit);
	m_hostlabel.AttachOpposite(NULL, NULL, m_hostedit, m_hostedit);
	m_portlabel.AttachOpposite(NULL, NULL, m_portedit, m_portedit);
	m_nicklabel.AttachOpposite(NULL, NULL, m_nickedit, m_nickedit);
	m_altnicklabel.AttachOpposite(NULL, NULL, m_altnickedit, m_altnickedit);
	m_passwdlabel.AttachOpposite(NULL, NULL, m_passwdedit, m_passwdedit);
	m_namelabel.AttachOpposite(NULL, NULL, m_nameedit, m_nameedit);

	m_sep1.Manage();
	m_ok.Manage();
	m_cancel.Manage();

	m_connamelabel.Manage();
	m_hostlabel.Manage();
	m_portlabel.Manage();
	m_nicklabel.Manage();
	m_altnicklabel.Manage();
	m_passwdlabel.Manage();
	m_namelabel.Manage();
	m_connameedit.Manage();
	m_hostedit.Manage();
	m_portedit.Manage();
	m_nickedit.Manage();
	m_altnickedit.Manage();
	m_passwdedit.Manage();
	m_nameedit.Manage();
	m_form.Manage();
	m_list.Manage();
	m_list_scroll.Manage();
}

void OpenServerForm::Initialize(CString host,
			CString port,
			CString nick,
			CString altnick,
			CString	passwd,
			CString name)
{
	m_hostedit.Value(host);
	m_portedit.Value(port);
	m_nickedit.Value(nick);
	m_altnickedit.Value(altnick);
	m_passwdedit.Value(passwd);
	m_nameedit.Value(name);
}

void OpenServerForm::operator=(Channel *p)
{
	m_channel=p;
	m_list=p;
	m_list.Click( &Channel::OpenServerListClick );
	m_list.DoubleClick(&Channel::OpenServerListDoubleClick);
}

void OpenServerForm::Ok()
{
	if (m_channel && m_channel_ptr)	(m_channel->*m_channel_ptr)(TRUE);
}

void OpenServerForm::Cancel()
{
	if (m_channel && m_channel_ptr)	(m_channel->*m_channel_ptr)(FALSE);
}
