// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"nickchangeform.h"
#include	"channel.h"

NickChangeForm::NickChangeForm(): CFormWidget("nick_change"),
	m_nick_form("nick_form"),
	m_nick_label("nick_label"),
	m_nick_edit("nick_edit"),
	m_okcancel_form("okcancel_form"),
	m_sep1("sep1"),
	m_ok("ok"),
	m_cancel("cancel"),
	m_channel(0)
{
	IsDialog(TRUE);
	m_ok=this;
	m_cancel=this;
	m_ok= &Ok;
	m_cancel= &Cancel;
	m_nick_edit=this;
	m_nick_edit=&Ok;
}

NickChangeForm::~NickChangeForm()
{
}

void NickChangeForm::Create(Channel *c)
{
	m_channel=c;
	CFormWidget::Create(c);
	DialogModal();
	m_nick_form.Create(this);
	m_okcancel_form.Create(this);
	m_nick_form.Attach(CWidgetToForm, CWidgetToForm, CWidgetToForm,
		m_okcancel_form);
	m_okcancel_form.Attach(CWidgetToForm, CWidgetToForm, NULL,
		CWidgetToForm);
	m_nick_label.Create(&m_nick_form);
	m_nick_edit.Create(&m_nick_form);
	m_nick_label.Attach(CWidgetToForm, NULL, CWidgetToForm, CWidgetToForm);
	m_nick_edit.Attach(m_nick_label,
		CWidgetToForm, CWidgetToForm, CWidgetToForm);

	m_sep1.Create(&m_okcancel_form);
	m_sep1.Attach(CWidgetToForm, CWidgetToForm, CWidgetToForm, NULL);
	m_ok.Create(&m_okcancel_form);
	m_ok.Attach(CWidgetToForm, NULL, m_sep1, CWidgetToForm);
	m_cancel.Create(&m_okcancel_form);
	m_cancel.Attach(NULL, CWidgetToForm, m_sep1, CWidgetToForm);

	m_ok.Manage();
	m_cancel.Manage();
	m_sep1.Manage();
	m_okcancel_form.Manage();
	m_nick_label.Manage();
	m_nick_edit.Manage();
	m_nick_form.Manage();
}

void NickChangeForm::Ok()
{
CString	s=m_nick_edit.Value();

	if (s.GetLength() == 0)	return;

	m_channel->Command("/NICK " + s, NULL);
	Destroy();
}

void NickChangeForm::Cancel()
{
	Destroy();
}
