// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"appshell.h"
#include	"main.h"
#include	"cplay.h"
#include	"afxdebug.h"
#include	"smirc.h"

static const char rcsid[]="$Id: main2.C,v 1.5 1999/04/12 04:39:47 mrsam Exp $";

CMain::CMain()
{
}

CMain::~CMain()	{}

void	CMain::Create(int &argc, char **argv, CString AppClass)
{
#if	HAVE_SOUND
	if (!m_play && !(m_play.Init(new CPlay)))
		AfxThrowMemoryException();
#endif
	CApplicationWidget::Create(argc, argv, AppClass);
}

AppShell *CMain::NewShell()
{
AppShell *pfirst=new AppShell(NAME);

	if (!pfirst)	AfxThrowMemoryException();

	try
	{
		pfirst->Create(this);

		pfirst->Realize();
		pfirst->m_channel.SetFocus();

		if (m_channels.GetCount() == 1)
		{
//			XSync(XtDisplay(wid()), FALSE);
			pfirst->m_channel.OpenConnectionFormOpen();
		}
	}
	catch (...)
	{
		delete pfirst;
		throw;
	}
	return (pfirst);
}

AppShell *CMain::NewChannel(AppShell *server, CString channel_name)
{
AppShell *pfirst=new AppShell(NAME);

	if (!pfirst)	AfxThrowMemoryException();

	try
	{
		pfirst->Create(server, channel_name);
		pfirst->Realize();
		pfirst->m_channel.SetFocus();
	}
	catch (...)
	{
		delete pfirst;
		throw;
	}
	return (pfirst);
}
