// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	logwidget_h
#define	logwidget_h

static const char logwidget_h_rcsid[]="$Id: logwidget.h,v 1.4 1999/04/09 03:02:54 mrsam Exp $";


/////////////////////////////////////////////////////////////////////////
//
// The channel log window widget

#include	"widget/widgetbasetext.h"
#include	"widget/widgetxms.h"

class CLogWindowWidget;

// A physical line

class CLogLine {
	CXmString	m_line;		// The line itself
	size_t		m_height;	// Line's height
public:
	POSITION	m_linepos;	// Position in the m_linelist
	AFXBOOL		m_newp;		// Flag:: new paragraph

	void		Contents(const CXmString &xms, size_t s)
			{
				m_line=xms;
				m_height=s;
			}
	const CXmString	&Contents()	const { return (m_line); }
	size_t		Height()	const { return (m_height); }
	CLogLine() : m_newp(FALSE)	{}
	~CLogLine()			{}
	CLogLine *	NextLine(CLogWindowWidget &);
	CLogLine *	PrevLine(CLogWindowWidget &);
} ;

//  A 'position' is represented thusly:

class	CLogPos {

	CLogLine	*m_line;
	unsigned	m_linepos;		// UNUSED for now

public:
	CLogPos():m_line(NULL), m_linepos(0)	{}
	~CLogPos()				{}
	void		Line(CLogLine *);
	CLogLine	*Line();
	CLogLine *	NextLine(CLogWindowWidget &);
	} ;

// The widget:

class CLogWindowWidget : public CBaseTextWidget {

	CList<CLogLine, const CLogLine &> m_lines;	// Our lines
	int	m_bufsize;		// Size of buffer.
	int	m_rows_approx;		// Approx # of rows.
	int	m_cols_approx;		// Approx # of cols.
	void	DrawText(POSITION, size_t,
			unsigned, unsigned, unsigned, unsigned,
			GC, XmRenderTable, unsigned char, size_t, size_t);
	void	OnDefaultSize(unsigned &, unsigned &);

	CXmStringRenditions	m_renditions;
	CXmStringMetrics	m_metrics;
	CXmStringMetrics *GetMetrics(POSITION, size_t);

	CXmPixmap		m_pixmap;
	Pixmap	GetTempPixmap(unsigned width, unsigned height);
	void	OnDestroy();
public:
	CLogWindowWidget(const char *);
	~CLogWindowWidget();
	void	Create(CWidget *);

	size_t	TotalRows();

private:
	POSITION LastPos();
	POSITION FirstPos();
	size_t NextPos(POSITION &);
	size_t PrevPos(POSITION &);
	size_t Height(POSITION);

	void	OnBaseTextButtonDown(int, int, size_t, POSITION, int);
	void	OnBaseTextButtonUp(int, int, size_t, POSITION, int);
	void	OnBaseTextMotion(int, size_t, POSITION, int);
	void	OnCut();
	void	OnCopy();
	size_t	FindColumn(POSITION, int, size_t &);

public:
	void	ReInit()
		{
			m_lines.RemoveAll();
			CBaseTextWidget::ReInit();
		}
	void	SetSize(size_t n)
		{
			m_bufsize=n;
		}
	void	Append(CXmString &, AFXBOOL doWrap=TRUE);	// Append to buffer
	void	TopRow(int n) { TopRow( (size_t)n); }
					// This is so we can be redirected
					// from CScrollBarWidgetRedirect
	void	TopRow(size_t n)
		{
		POSITION p=NULL;
		size_t	l=m_lines.GetCount();

			if (l)	--l;
			if (n > l)
				n=l;
			if (n < m_lines.GetCount())
				p=m_lines.FindIndex(n);
			CBaseTextWidget::TopRow(n, p);
		}

	friend	class CLogPos;
	friend	class CLogLine;
} ;
#endif
