// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"logfiledialog.h"
#include	"channel.h"
#include	"smirc.h"

extern CString homedir;

CLogFileDialog::CLogFileDialog(const char *s) : CFormWidget(s), m_fr(NULL)
{
	m_fr=this;
	m_fr.Ok( &OnOk );
	m_fr.Cancel( &OnCancel );
}

CLogFileDialog::~CLogFileDialog()
{
}

void CLogFileDialog::Create(CWidget *parent)
{
	CFormWidget::Create(parent);
	m_fr.Create(this);
	m_fr.Attach(CWidgetToForm, CWidgetToForm, CWidgetToForm, CWidgetToForm);
	m_fr.Chdir(homedir + '/' + HOMECONFIGDIR);
	m_fr.Manage();
}

void CLogFileDialog::Filename(CString s)
{
	m_fr.Filename(s);
}

CString CLogFileDialog::Filename()
{
	return (m_fr.m_filename);
}

void CLogFileDialog::OnOk()
{
	if (m_channel)	m_channel->LogFileOpenOk();
}

void CLogFileDialog::OnCancel()
{
	if (m_channel)	m_channel->LogFileOpenCancel();
}

