// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"ctcp.h"

static const char rcsid[]="$Id: ctcp.C,v 1.3 1999/04/09 03:02:54 mrsam Exp $";


#define	M_QUOTE	'\020'
#define	X_DELIM '\001'
#define	X_QUOTE '\134'

static void dequote(const char *psrc, size_t pleft, CString &dest,
	char quote_char)
{
char *	p=dest.GetBuffer(pleft);
size_t	cnt=0;

	while (pleft)
	{
		if ((char)*psrc == (char)quote_char && pleft > 1)
		{
			--pleft;
			switch (*++psrc)	{
			case '0':
				*p++=0;
				break;
			default:
				if ( (char)*psrc == quote_char)
					*p++ = quote_char;
				else
					*p++ = (*psrc) & 31;
				break;
			}
		}
		else	*p++ = *psrc;
		++psrc;
		--pleft;
		++cnt;
	}
	dest.ReleaseBuffer(cnt);
}

void Cctcp::Decode(CString string, CString source, CString dest, AFXBOOL isprivate)
{
	dequote(string, string.GetLength(), m_midstring, M_QUOTE);

const char *	buf=m_midstring;
size_t	i, j=m_midstring.GetLength();

	while (j)
	{
		if (*buf == X_DELIM)
			for (i=1; i<j; i++)
				if (buf[i] == X_DELIM)
					break;

		if (*buf == X_DELIM && i < j)
		{
			dequote(buf+1, i-1, m_command, X_QUOTE);

		int	k=m_command.Find(' ');

			if (k < 0)
				m_value="";
			else
			{
			size_t	cnt=m_command.GetLength()-k-1;
			char *	p=m_value.GetBuffer(cnt);

				if (cnt)
					memcpy(p, (const char *)m_command+k+1, cnt);
				m_value.ReleaseBuffer(cnt);
				(void)m_command.GetBuffer(-1);
				m_command.ReleaseBuffer(k);
			}
			++i;

		}
		else	// Not a CTCP command
		{
			m_command= CString();	// NULL command
			for (i=1; i<j; i++)
				if (buf[i] == X_DELIM)
					break;

		char *	p=m_value.GetBuffer(i);

			memcpy(p, buf, i);
			m_value.ReleaseBuffer(i);
		}
		buf += i;
		j -= i;

	Cctcp_token token;

		token.m_command=m_command;
		token.m_value=m_value;
		token.m_source=source;
		token.m_dest=dest;
		token.m_private=isprivate;
		m_tokens.AddTail(token);
	}
}

CString Cctcp::Encode()
{
char *bufp=NULL;
size_t bufl=0;
int	pass;
POSITION p;

	for (pass=0; pass<2; pass++)
	{
		if (pass)	bufp=m_command.GetBuffer(bufl);
		bufl=0;

		for (p=m_tokens.GetHeadPosition(); p; )
		{
		Cctcp_token &token=m_tokens.GetNext(p);
		AFXBOOL	quote_xdelim=FALSE;

			if (token.IsExtendedCommand())
			{
			size_t	cmdlen=token.m_command.GetLength();
			size_t	vallen=token.m_value.GetLength();
			char *	p=m_value.GetBuffer(cmdlen + vallen + 1);

				memcpy(p, token.m_command, cmdlen);
				p += cmdlen;
				if (vallen)
				{
					*p++=' ';
					memcpy(p, token.m_value, vallen);
					++vallen;
				}
				m_value.ReleaseBuffer(cmdlen + vallen);
				quote_xdelim=TRUE;
			}
			else
				m_value=token.m_value;

		const char *	p=m_value;
		size_t	cnt=m_value.GetLength();

			if (quote_xdelim)
			{
				if (pass)	*bufp++ = X_DELIM;
				++bufl;
			}

			while (cnt)
			{
				switch (*p)	{
				case X_DELIM:
					if (pass)
					{
						*bufp++ = X_QUOTE;
						*bufp++ = 'a';
					}
					bufl += 2;
					break;
				case '\0':
					if (pass)
					{
						*bufp++ = X_QUOTE;
						*bufp++ = '0';
					}
					bufl += 2;
					break;
				case '\n':
				case '\r':
					if (pass)
					{
						*bufp++ = X_QUOTE;
						*bufp++ = 64 | *p;
					}
					bufl += 2;
					break;
				case X_QUOTE:
					if (quote_xdelim)
					{
						if (pass)
						{
							*bufp++ = X_QUOTE;
							*bufp++ = X_QUOTE;
						}
						bufl += 2;
						break;
					}
					// FALLTHRU
				default:
					if (pass)	*bufp++ = *p;
					++bufl;
				}
				++p;
				--cnt;
			}

			if (quote_xdelim)
			{
				if (pass)	*bufp++ = X_DELIM;
				++bufl;
			}
		}
		if (pass)	m_command.ReleaseBuffer(bufl);
	}
	return (m_command);
}

