// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"cplay.h"
#include	"channel.h"
#include	"afxtempl.h"
#if	HAVE_ESOUND
#include	<esd.h>
#endif

static const char rcsid[]="$Id: cplay.C,v 1.4 1999/07/23 04:41:53 mrsam Exp $";

CPlay::CPlay()
{
	m_timer=this;
	m_inputfd1=this;
}

CPlay::~CPlay()
{
	Stop();
}

int CPlay::Play(const char *filename, Channel *ch)
{
	if (m_fd >= 0)	return (0);	// Still playing some previous sound.

	if (m_sndfile.OpenRead(filename))
	{
		ch->LogStrMessage("PLAYOPENERROR", filename,
					m_sndfile.LibSndError());
		return (-1);
	}

#if	HAVE_ESOUND
	m_fd=esd_play_stream(
			ESD_BITS16 |
			( m_sndfile.NumChannels() == 2 ? ESD_STEREO:ESD_MONO) |
			ESD_STREAM | ESD_PLAY,
			m_sndfile.SampleRate(), 0, 0);

	if (m_fd >= 0)
	{
		m_inputfd1.fd(m_fd);
		m_inputfd1.Write( &CPlay::esdplay );
		return (0);
	}
#endif

	if (Open())
	{
		m_sndfile.Close();
		return (-1);
	}

	m_inputfd1.fd(m_fd);
	if (setformat(COssSound::cosss16bit) ||
		setchannels(m_sndfile.NumChannels()))
	{
		ch->LogStrMessage("PLAYOPENERROR", filename,
					m_sndfile.LibSndError());
		Stop();
		return (-1);
	}

unsigned sample_rate=m_sndfile.SampleRate();
unsigned play_sample_rate=setsamplerate(sample_rate);
unsigned c= sample_rate < play_sample_rate
		? play_sample_rate - sample_rate
		: sample_rate - play_sample_rate;

	// If we have an outright failure, or if the final sampling rate
	// is off more than by 10%, we refuse to play it.

	if (play_sample_rate == 0 || c > sample_rate / 10)
	{
	CStringArray m_args;
	char	buf[80];

		m_args.SetSize(2);
		m_args[0]=filename;
		sprintf(buf, "%u", sample_rate);
		m_args[1]=buf;
		ch->LogStrMessage("PLAYSAMPLEERROR", m_args);
		Stop();
		return (-1);
	}

#if 0
	{
	CStringArray m_args;
	char	buf[80];

		m_args.SetSize(3);
		m_args[0]=filename;
		sprintf(buf, "%u", (unsigned)m_sndfile.NumChannels());
		m_args[1]=buf;
		sprintf(buf, "%u", sample_rate);
		m_args[2]=buf;
		ch->LogStrMessage("PLAYING", m_args);
	}
#endif

int fragments, fragstotal, fragsize, dummy;

	if (ofragments(fragments, fragstotal, fragsize, dummy))
	{
		Stop();
		return (-1);
	}

	if ( fragsize % (2 * m_sndfile.NumChannels()))
	{
		Stop();
		return (-1);
	}
	m_buf.SetSize( fragsize / 2);
	if ((m_count=m_sndfile.Read16(m_buf.GetData(), m_buf.GetSize())) == 0)
	{
		Stop();
		return (-1);
	}
	startplay();
	return (0);
}

void CPlay::Stop()
{
	m_timer.Cancel();
	Close();
	m_inputfd1.fd(-1);
	m_sndfile.Close();
}

void CPlay::startplay()
{
unsigned long ms;

	while ((ms=omorems()) == 0)
	{
		if (write(m_buf.GetData(), m_count))
		{
			Stop();
			return;
		}
		if ((m_count=m_sndfile.Read16(m_buf.GetData(), m_buf.GetSize())) == 0)
		{
		int dummy;

			flush();
			if (ofragments(dummy, dummy, dummy, m_lastbytes))
				Stop();
			else
			{
				--m_lastbytes;
				close();
			}
			return;
		}
	}
	m_timer.Arm_ms(&CPlay::startplay, ms);
}

void CPlay::close()
{
int	dummy, bytes;

	if (ofragments(dummy, dummy, dummy, bytes))
	{
		Stop();
		return;
	}

	if (bytes == m_lastbytes)
		Stop();
	else
	{

// Byte count can only be reliably updated after a full fragment
// transition, so delay for that long.

		m_lastbytes=bytes;
		m_timer.Arm_ms(&CPlay::close, 
			(samplesperfrag() * 1000 + m_frequency-1)
				/ m_frequency);
	}
}

#if	HAVE_ESOUND

CString	CPlay::esdplay()
{
	if ((m_count=m_sndfile.Read16((SND16BIT *)
		esdbuf.GetBuffer(32768), 32768 / sizeof(SND16BIT))) == 0)
	{
		esdbuf.ReleaseBuffer(0);
		m_timer.Arm_ms(&CPlay::close,
			m_count / m_sndfile.NumChannels() * 1000 /
			m_sndfile.SampleRate());
		esdbuf="";
		return (esdbuf);
	}
	esdbuf.ReleaseBuffer(m_count*sizeof(SND16BIT));
	return (esdbuf);
}

#endif
