// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"cosssound.h"
#include	<stdio.h>
#include	<sys/soundcard.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/ioctl.h>
#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#if	HAVE_FCNTL_H
#include	<fcntl.h>
#endif

COssSound::COssSound() : m_fd(-1), m_frequency(0), m_format(cosss8bit),
	m_channels(1)
{
}

COssSound::~COssSound()
{
	Close();
}


void COssSound::Close()
{
	m_frequency=0;
	m_format=cosss8bit;
	m_channels=1;
	if (m_fd >= 0)
	{
		reset();
		close(m_fd);
		m_fd= -1;
	}
}

int COssSound::Open()
{
	Close();
	if ((m_fd=open("/dev/dsp", O_NDELAY|O_WRONLY)) < 0)	return (-1);
	return (0);
}

int COssSound::setformat(enum sample_format f)
{
int	sformat;

	switch (f)	{
	case cosss8bit:
		sformat=AFMT_S8;
		break;
	case cosss16bit:
#ifdef	WORDS_BIGENDIAN
		sformat=AFMT_S16_BE;
#else
		sformat=AFMT_S16_LE;
#endif
		break;
	default:
		return (-1);
	}
	if (m_fd < 0 || ioctl(m_fd, SNDCTL_DSP_SETFMT, &sformat) == -1)
		return (-1);
	m_format=f;
	return (0);
}

int COssSound::setchannels(int n)
{
	if (m_fd < 0 || ioctl(m_fd, SNDCTL_DSP_CHANNELS, &n) == -1)
		return (-1);
	m_channels=n;
	return (0);
}

unsigned COssSound::setsamplerate(unsigned s)
{
int	n=s;

	if (m_fd < 0 || ioctl(m_fd, SNDCTL_DSP_SPEED, &n) == -1)
		return (0);
	m_frequency=n;
	return (n);
}

int COssSound::samplesperfrag()
{
int frag_size;

	if (m_fd < 0 || ioctl(m_fd, SNDCTL_DSP_GETBLKSIZE, &frag_size) == -1)
		return (0);
	frag_size /= m_channels;
	switch (m_format)	{
	case cosss16bit:
		frag_size /= 2;
		break;
	default:
		break;
	}
	return (frag_size);
}

int COssSound::ifragments(int &fragments, int &fragstotal, int &fragsize,
	int &bytes)
{
audio_buf_info info;

	if (m_fd < 0 || ioctl(m_fd, SNDCTL_DSP_GETISPACE, &info) == -1)
		return (-1);
	fragments=info.fragments;
	fragstotal=info.fragstotal;
	fragsize=info.fragsize;
	bytes=info.bytes;
	return (0);
}

int COssSound::ofragments(int &fragments, int &fragstotal, int &fragsize,
	int &bytes)
{
audio_buf_info info;

	if (m_fd < 0 || ioctl(m_fd, SNDCTL_DSP_GETOSPACE, &info) == -1)
		return (-1);
	fragments=info.fragments;
	fragstotal=info.fragstotal;
	fragsize=info.fragsize;
	bytes=info.bytes;
	return (0);
}

int COssSound::icount(int &bytes, int &blocks)
{
count_info info;

	if (m_fd < 0 || ioctl(m_fd, SNDCTL_DSP_GETIPTR, &info) == -1)
		return (-1);
	bytes=info.bytes;
	blocks=info.blocks;
	return (0);
}

int COssSound::ocount(int &bytes, int &blocks)
{
count_info info;

	if (m_fd < 0 || ioctl(m_fd, SNDCTL_DSP_GETOPTR, &info) == -1)
		return (-1);
	bytes=info.bytes;
	blocks=info.blocks;
	return (0);
}

unsigned long COssSound::omorems()
{
int fragments, fragstotal, fragsize, bytes;

	if (ofragments(fragments, fragstotal, fragsize, bytes) < 0)
		return (0);

	if (fragments)	return (0);

	// Calculate # of bytes to be played before a full fragment is free.

	bytes = fragsize - bytes+1;	// Just in case.

	// Calculate number of samples

	switch (m_format)	{
	case cosss16bit:
		bytes= (bytes+1)/2;	// two bytes per sample
		break;
	default:
		break;
	}

	bytes = (bytes + m_channels - 1) / m_channels;
		// Number of stereo samples.

	// There should be bytes/m_frequency*1000 milliseconds before another
	// fragment.

	return ( (bytes * 1000 + m_frequency - 1) / m_frequency );
}

int COssSound::write(const SND16BIT *vp, unsigned nbytes)
{
const char *p=(const char *)vp;
int	n;

	nbytes *= 2;
	while (nbytes)
	{
		if (m_fd < 0 || (n= ::write(m_fd, p, nbytes)) <= 0)
			return (-1);
		nbytes -= n;
		p += n;
	}
	return (0);
}

void COssSound::reset()
{
	if (m_fd >= 0)
		ioctl(m_fd, SNDCTL_DSP_RESET, 0);
}

void COssSound::flush()
{
	if (m_fd >= 0)
		ioctl(m_fd, SNDCTL_DSP_POST, 0);
}
