// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	clibsndfile_h
#define	clibsndfile_h

#include	"sndfile.h"
#include	"config.h"
#include	"afxtempl.h"

#if SIZEOF_INT == 2
typedef	int	SND16BIT;
#else
#if SIZEOF_SHORT == 2
typedef short	SND16BIT;
#else
#error Neither int nor short is 16 bits.
#endif
#endif

class CLibSndFile {
	SNDFILE *m_sndfile;
	SF_INFO m_info;
	unsigned long m_readleft;
public:

	CLibSndFile();
	virtual ~CLibSndFile();
	int OpenRead(const char *);
	int OpenWrite(const char *, const SF_INFO * =0);
			// NOT IMPLEMENTED
	int Seek(off_t, int);
	void Close();
	size_t NumSamples()	{ return (m_info.samples); }
	size_t NumChannels()	{ return (m_info.channels); }
	unsigned SampleRate()	{ return (m_info.samplerate); }
	size_t ReadShort(short *, size_t);
	size_t WriteShort(short *, size_t);
			// NOT IMPLEMENTED

	size_t ReadInt(int *, size_t);
	size_t WriteInt(int *, size_t);
			// NOT IMPLEMENTED

	size_t Read16(SND16BIT *p, size_t n)
		{
#if SIZEOF_INT == 2
			return (ReadInt(p, n));
#else
#if SIZEOF_SHORT == 2
			return (ReadShort(p, n));
#endif
#endif
		}
	size_t Write16(SND16BIT *, size_t);
			// NOT IMPLEMENTED

static CString	LibSndError();
} ;
#endif
