// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	channelinfoform_h
#define	channelinfoform_h

static const char channelinfoform_h_rcsid[]="$Id$";

#include	"widget/widget.h"
#include	"widget/widgettext.h"
#include	"widget/widgetprim.h"
#include	"widget/widgetapp.h"
#include	"widget/widgetrowcol.h"
#include	"widget/widgetscroll.h"
#include	"widget/widgetlist.h"
#include	"widget/widgetredirect.h"

class Channel;
class ChannelInfoForm;

class ChannelInfoForm : public CFormWidget {
	CFormWidget	m_topic_form;
	CLabelWidget	m_topic_label;
	CTextWidget	m_topic_edit;

	CSeparatorWidget	m_sep1;
	CRowColumnWidget	m_channel_modes;
	CToggleButtonWidget	m_modei, m_modem, m_moden, m_modep,
				m_modes, m_modet;

static CToggleButtonWidget ChannelInfoForm::*mode_ptrs[];
static char mode_names[];

	CSeparatorWidget	m_sep2;

	CFormWidget	m_ban_form;
	CLabelWidget	m_ban_label;
	CScrollWindowWidget	m_ban_scroll;
	CListWidget	m_ban_list;
	CActivateRedirect<CPushButtonWidget, ChannelInfoForm>
			m_remove_ban;
	CActivateRedirect<CPushButtonWidget, ChannelInfoForm>
			m_add_ban;
	CTextWidget	m_add_ban_text;

	CFormWidget	m_recent_departures_form;
	CLabelWidget	m_recent_departures;
	CScrollWindowWidget	m_recent_departures_scroll;
	CListWidget	m_recent_departures_list;
	CRowColumnWidget	m_recent_ban_list;
	CActivateRedirect<CPushButtonWidget, ChannelInfoForm>
				m_ban0, m_ban1, m_ban2, m_ban3, m_ban4;

	CSeparatorWidget	m_sep3;
	CActivateRedirect<CPushButtonWidget, ChannelInfoForm>
				m_ok, m_cancel;
	Channel		*m_channel;

	CString		m_current_modes, m_current_topic;
	CMap<CString, CString, AFXBOOL, AFXBOOL>	m_current_bans;

public:
	ChannelInfoForm();
	~ChannelInfoForm();
	void Create(Channel *, CString, CString, CStringList &);
	void BanList(CString);
	void EndBanList();
private:
	void RemoveBan();
	void AddBan();
	void AddBan0();
	void AddBan1();
	void AddBan2();
	void AddBan3();
	void AddBan4();
	void AddBanCommon(char);
	void Ok();
	void Cancel();
	} ;
#endif
