// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"channelinfoform.h"
#include	"channel.h"
#include	"smirc.h"
#include	"widget/widgetxms.h"

CToggleButtonWidget ChannelInfoForm::* ChannelInfoForm::mode_ptrs[] = {
	&ChannelInfoForm::m_modei,
	&ChannelInfoForm::m_modem,
	&ChannelInfoForm::m_moden,
	&ChannelInfoForm::m_modep,
	&ChannelInfoForm::m_modes,
	&ChannelInfoForm::m_modet
	} ;

char ChannelInfoForm::mode_names[]="imnpst";

ChannelInfoForm::ChannelInfoForm() : CFormWidget("channel_info"),
	m_topic_form("topic_form"),
	m_topic_label("topic_label"),
	m_topic_edit("topic_edit"),
	m_sep1("sep1"),
	m_channel_modes("channel_modes"),
	m_modei("modei"), m_modem("modem"), m_moden("moden"),
		m_modep("modep"), m_modes("modes"),
		m_modet("modet"),
	m_sep2("sep2"),
	m_ban_form("ban_form"),
	m_ban_label("ban_label"),
	m_ban_scroll("ban_scroll"),
	m_ban_list("ban_list"),
	m_remove_ban("remove_ban"),
	m_add_ban("add_ban"),
	m_add_ban_text("add_ban_text"),
	m_recent_departures_form("recent_departures_form"),
	m_recent_departures("recent_departures"),
	m_recent_departures_scroll("recent_departures_scroll"),
	m_recent_departures_list("recent_departures_list"),
	m_recent_ban_list("recent_ban_list"),
	m_ban0("ban0"),
	m_ban1("ban1"),
	m_ban2("ban2"),
	m_ban3("ban3"),
	m_ban4("ban4"),
	m_sep3("sep3"),
	m_ok("ok"),
	m_cancel("cancel"),
	m_channel(0)
{
	IsDialog(TRUE);
	m_modei.IsGadget(TRUE);
	m_modem.IsGadget(TRUE);
	m_moden.IsGadget(TRUE);
	m_modep.IsGadget(TRUE);
	m_modes.IsGadget(TRUE);
	m_modet.IsGadget(TRUE);

	m_remove_ban=this;
	m_add_ban=this;
	m_ban0=this;
	m_ban1=this;
	m_ban2=this;
	m_ban3=this;
	m_ban4=this;
	m_ok=this;
	m_cancel=this;
	m_remove_ban= &RemoveBan;
	m_add_ban= &AddBan;
	m_ban0= &AddBan0;
	m_ban1= &AddBan1;
	m_ban2= &AddBan2;
	m_ban3= &AddBan3;
	m_ban4= &AddBan4;
	m_ok= &Ok;
	m_cancel= &Cancel;
}

ChannelInfoForm::~ChannelInfoForm()
{
}

void ChannelInfoForm::Create(Channel *p, CString current_modes,
	CString current_topic,
	CStringList &recent_departures)
{
CArray<CXmString, const CXmString &> m_xmsa;
size_t i;
CString key;
POSITION pos;

	m_current_modes=current_modes;
	m_current_topic=current_topic;
	if ( !(const char *)m_current_modes )
		m_current_modes = "";
	if ( !(const char *)m_current_topic )
		m_current_topic = "";

	m_current_bans.RemoveAll();
	CFormWidget::Create(p);
	DialogModal();
	m_channel=p;
	m_topic_form.Create(this);
	m_topic_form.Attach(CWidgetToForm, CWidgetToForm,
		CWidgetToForm, NULL);

	m_topic_label.Create(&m_topic_form);
	m_topic_edit.Create(&m_topic_form);

	m_topic_label.Attach(CWidgetToForm, m_topic_edit,
				CWidgetToForm, CWidgetToForm);
	m_topic_edit.Attach(NULL, CWidgetToForm, CWidgetToForm, CWidgetToForm);
	m_topic_edit.Value(current_topic);
	m_topic_edit.Manage();
	m_topic_label.Manage();
	m_topic_form.Manage();

	m_sep1.Create(this);
	m_sep1.Attach(CWidgetToForm, CWidgetToForm, m_topic_form, NULL);
	m_sep1.Manage();

	m_channel_modes.Create(this);
	m_channel_modes.Attach(CWidgetToForm, CWidgetToForm, m_sep1,
				NULL);

	for (i=0; i<sizeof(mode_ptrs)/sizeof(mode_ptrs[0]); i++)
	{
		(this->* (mode_ptrs[i])).Create(&m_channel_modes);
		(this->* (mode_ptrs[i])).Set(
			current_modes.Find(mode_names[i]) >= 0);
		(this->* (mode_ptrs[i])).Manage();
	}
	m_channel_modes.Manage();
	m_sep2.Create(this);
	m_sep2.Attach(CWidgetToForm, CWidgetToForm, m_channel_modes, NULL);
	m_sep2.Manage();

	m_ban_form.Create(this);
	m_ban_form.Attach(CWidgetToForm, CWidgetToForm, m_sep2, NULL);
		m_ban_label.Create(&m_ban_form);
		m_ban_label.Attach(CWidgetToForm, NULL, CWidgetToForm, NULL);
		m_ban_scroll.Create(&m_ban_form);
		m_ban_scroll.Attach(CWidgetToForm, NULL, m_ban_label, NULL);

		m_ban_list.Create(&m_ban_scroll);

		m_remove_ban.Create(&m_ban_form);
		m_remove_ban.Attach(CWidgetToForm, NULL, m_ban_scroll, NULL);

		m_add_ban.Create(&m_ban_form);
		m_add_ban.Attach(m_ban_scroll, NULL, m_ban_label, NULL);
		m_add_ban_text.Create(&m_ban_form);
		m_add_ban_text.Attach(m_add_ban, NULL, m_ban_label, NULL);

		m_recent_departures_form.Create(&m_ban_form);
		m_recent_departures_form.Attach(m_add_ban, NULL,
						m_add_ban_text, NULL);

		m_recent_departures.Create(&m_recent_departures_form);
		m_recent_departures.Attach(CWidgetToForm, NULL,
						CWidgetToForm, NULL);
		m_recent_departures_scroll.Create(&m_recent_departures_form);
		m_recent_departures_scroll.Attach(CWidgetToForm, NULL,
						m_recent_departures,
						CWidgetToForm);
		m_recent_departures_list.Create(&m_recent_departures_scroll);

		m_xmsa.SetSize(recent_departures.GetCount());
		for (i=0, pos=recent_departures.GetTailPosition(); pos; i++)
			m_xmsa[i]=recent_departures.GetPrev(pos);

		m_recent_departures_list.AddItems(m_xmsa.GetData(), i, 0);
		m_xmsa.SetSize(0);

		m_recent_ban_list.Create(&m_recent_departures_form);
		m_recent_ban_list.Attach(m_recent_departures_scroll, NULL,
				m_recent_departures, CWidgetToForm);
		m_ban0.Create(&m_recent_ban_list);
		m_ban1.Create(&m_recent_ban_list);
		m_ban2.Create(&m_recent_ban_list);
		m_ban3.Create(&m_recent_ban_list);
		m_ban4.Create(&m_recent_ban_list);

		m_ban_label.Manage();
		m_ban_list.Manage();
		m_ban_scroll.Manage();
		m_remove_ban.Manage();
		m_add_ban.Manage();
		m_add_ban_text.Manage();
		m_recent_departures.Manage();
		m_recent_departures_list.Manage();
		m_recent_departures_scroll.Manage();
		m_ban0.Manage();
		m_ban1.Manage();
		m_ban2.Manage();
		m_ban3.Manage();
		m_ban4.Manage();
		m_recent_ban_list.Manage();
		m_recent_departures_form.Manage();
		m_ban_list.Manage();

	m_ban_form.Manage();
	m_sep3.Create(this);
	m_sep3.Attach(CWidgetToForm, CWidgetToForm, m_ban_form, NULL);
	m_sep3.Manage();
	m_ok.Create(this);
	m_ok.Attach(CWidgetToForm, NULL, m_sep3, NULL);
	m_ok.Manage();
	m_cancel.Create(this);
	m_cancel.Attach(NULL, CWidgetToForm, m_sep3, NULL);
	m_cancel.Manage();
	m_channel->AddWriteQueue("MODE " + m_channel->ChannelName()
				+ " +b");
}

void ChannelInfoForm::BanList(CString banmask)
{
	if (banmask.GetLength() == 0)	return;
	m_current_bans[banmask]=TRUE;
}

void ChannelInfoForm::EndBanList()
{
POSITION pos;
CString nick;
AFXBOOL dummy;
size_t i;
CArray<CXmString, const CXmString &> xmsa;

	RemoveCursor();
	xmsa.SetSize(m_current_bans.GetCount());

	for (pos=m_current_bans.GetStartPositionSorted(), i=0; pos; i++)
	{
		m_current_bans.GetNextAssocSorted(pos, nick, dummy);
		xmsa[i]=nick;
	}
	m_ban_list.RemoveAll();
	m_ban_list.AddItems(xmsa.GetData(), i, 0);
}

void ChannelInfoForm::RemoveBan()
{
CArray<size_t, size_t> selected_array;
size_t	*p, i;

	selected_array.SetSize(m_ban_list.NumSelected());
	p=m_ban_list.GetSelected();
	i=selected_array.GetSize();
	while (i)
	{
		--i;
		selected_array[i]=p[i]-1;
	}
	i=selected_array.GetSize();
	while (i)
	{
		--i;
		m_ban_list.DeleteItem(selected_array[i]);
	}
}

void ChannelInfoForm::AddBan()
{
CXmString	xms;
CString	banmask=m_add_ban_text.Value();
int i=0,j=0;

	if ((i=banmask.Find('!')) < 0 || (j=banmask.Find('@')) < 0 || i>j)
	{
		XBell(*this, 100);
		return;
	}

	xms=banmask;
	m_ban_list.AddItem(xms, 0);
	XtManageChild(XtNameToWidget(m_ban_scroll.wid(), "VertScrollBar"));
	m_add_ban_text.Value("");
}

void ChannelInfoForm::AddBan0()
{
	AddBanCommon('0');
}

void ChannelInfoForm::AddBan1()
{
	AddBanCommon('1');
}

void ChannelInfoForm::AddBan2()
{
	AddBanCommon('2');
}

void ChannelInfoForm::AddBan3()
{
	AddBanCommon('3');
}

void ChannelInfoForm::AddBan4()
{
	AddBanCommon('4');
}

void ChannelInfoForm::AddBanCommon(char level)
{
CArray<size_t, size_t> selected_array;
CStringArray selected_strings;
size_t	*p, i, j;
int	k;
CXmString xms;
CString	nick, user, host;

	selected_array.SetSize(m_recent_departures_list.NumSelected());
	p=m_recent_departures_list.GetSelected();
	i=selected_array.GetSize();
	for (j=0; j<i; j++) selected_array[j]=p[j];
	selected_strings.SetSize(i);
	for (j=0; j<i; j++)
	{
		xms=m_recent_departures_list.GetItem(selected_array[j]-1);
		selected_strings[j]=xms;
	}
	for (j=0; j<i; j++)
	{
		nick=selected_strings[j];
		user="";
		host="";
		k=nick.Find('!');
		if (k >= 0)
		{
			user=nick.Mid(k+1);
			nick=nick.Left(k);
		}
		k=user.Find('@');
		if (k >= 0)
		{
			host=user.Mid(k+1);
			user=user.Left(k);
		}
		xms=Channel::CalculateBan(level, nick, user, host);
		m_ban_list.AddItem(xms, 0);
	}
}

void ChannelInfoForm::Ok()
{
CString	mode_channel_name;
CString	new_topic;
CString	new_modes;
size_t	i, j;
CMap<CString, CString, AFXBOOL, AFXBOOL> new_ban;
CXmString xms;
POSITION pos;
CString	nick;
AFXBOOL	dummy;

	mode_channel_name="MODE " + m_channel->ChannelName();

	// If topic changed, issue TOPIC command

	new_topic=m_topic_edit.Value();
	if ( !(const char *)new_topic)
		new_topic="";
	if (new_topic != m_current_topic)
		m_channel->AddWriteQueue(
			"TOPIC " + m_channel->ChannelName() +
			" :" + new_topic);

	// Calculate new channel modes

	new_modes="";
	for (i=0; i<sizeof(mode_ptrs)/sizeof(mode_ptrs[0]); i++)
	{
		if ( (this->* (mode_ptrs[i])).IsSet())
			new_modes += mode_names[i];
	}

	// Remove channel modes no longer selected

	for (i=0; i<sizeof(mode_ptrs)/sizeof(mode_ptrs[0]); i++)
		if (m_current_modes.Find(mode_names[i]) >= 0 &&
			new_modes.Find(mode_names[i]) < 0)
		m_channel->AddWriteQueue(
			mode_channel_name +
			" -" + mode_names[i]);

	// Add new channel modes

	for (i=0; i<sizeof(mode_ptrs)/sizeof(mode_ptrs[0]); i++)
		if (m_current_modes.Find(mode_names[i]) < 0 &&
			new_modes.Find(mode_names[i]) >= 0)
		m_channel->AddWriteQueue(
			mode_channel_name +
			" +" + mode_names[i]);

	// Build a lookup table of bans

	j=m_ban_list.NumItems();
	for (i=0; i<j; i++)
	{
		xms=m_ban_list.GetItem(i);
		new_ban[ (CString)xms ]=TRUE;
	}

	// Remove deleted bans.

	for (pos=m_current_bans.GetStartPosition(); pos; )
	{
		m_current_bans.GetNextAssoc(pos, nick, dummy);
		if (new_ban.Lookup(nick, dummy))	continue;
		m_channel->AddWriteQueue(mode_channel_name + " -b " + nick);
	}

	// Add new bans

	for (pos=new_ban.GetStartPosition(); pos; )
	{
		new_ban.GetNextAssoc(pos, nick, dummy);
		if (m_current_bans.Lookup(nick, dummy))	continue;
		m_channel->AddWriteQueue(mode_channel_name + " +b " + nick);
	}
	UnManage();
}

void ChannelInfoForm::Cancel()
{
	UnManage();
}
