// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"config.h"
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<ctype.h>
#include	"mytime.h"
#include	<pwd.h>
#include	<stdlib.h>
#include	<iostream.h>
#include	<strstream.h>
#include	"widget/widget.h"
#include	"widget/widgetxms.h"
#include	"configautoplay.h"
#include	"channel.h"
#include	"memberlist.h"
#include	"channellisting.h"
#include	"channelinfoform.h"
#include	"main.h"
#include	"appshell.h"
#include	"smirc.h"
#include	"afxdebug.h"

static const char rcsid[]="$Id: channelReply.C,v 1.13 1999/04/12 04:39:47 mrsam Exp $";

extern CString	username;
extern ConfigAutoPlay autoplay;

/////////////////////////////////////////////////////////////////////////////
//
// Handle replies from server

void Channel::ReplyPING()
{
	m_args.SetSize(0);
	LogStrMessage("PINGPONG", m_args);
	AddWriteQueue("PONG " + m_myhost + " " +
		(m_replycmd.IsEmpty() ? "": (const char *)m_replycmd.GetHead()));
}

void Channel::ReplyNICK()
{
	GlobalReply( &GlobalReplyNICK );
}

void Channel::SourceToNickUser(CString source, CString &nick, CString &user)
{
int	i=source.Find('!');

	if (i < 0)
	{
		nick=source;
		user=source;
	}
	else
	{
		nick=source.Left(i);
		user=source.Mid(i+1);
	}
}

void Channel::GlobalReplyNICK()
{
CString	oldnick;
CString dummy;

	SourceToNickUser(m_replysource, oldnick, dummy);
	NickChange(oldnick, Pop());
}

// Process the reply to a JOIN command.  This is not as straightforward as it
// may seem, because:
//      A)  The JOIN reply may indicate multiple channels, and
//      B)  The JOIN reply comes back in response to our JOIN command, or when
//          someone else joins a channel we're on.  Therefore, the channel in
//          question may or may not already be created here.
//

void Channel::ReplyJOIN()
{
CString	nick, dummy;

	SourceToNickUser(m_replysource, nick, dummy);
	if (IrcLower(nick) == IrcLower(m_currentnick))
					// This is my join, see if we need
					// to create channels
	{
	CStringArray channels=CStringTok(m_replycmd.GetHead(), ",");
	size_t	l=channels.GetSize();
	size_t	i;

		for (i=0; i<l; i++)
		{
			if (channels[i].GetLength() == 0)	continue;
			if (!FindChannel(channels[i]))
			{
				m_server->m_shell->m_main->
					NewChannel(m_server->m_shell,
						channels[i]);
				// Issue a MODE command to get channel modes

				m_server->AddWriteQueue("MODE " +
					channels[i]);
			}
		}
	}

	GlobalReply( &GlobalReplyJOIN );
}

void Channel::GlobalReplyJOIN()
{
	if (!IsChannel())	return;

	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]="";

CString chstring(Pop());

CStringArray channels=CStringTok(chstring, ",");
int	i;
CString	my_channel_name(IrcLower(ChannelName()));

	for (i=0; i<channels.GetSize(); i++)
	{
		if (channels[i].GetLength() == 0)	continue;

		m_args[2]=IrcLower(channels[i]);

		if (m_args[2] == my_channel_name)
		{
			LogStrMessage("USERJOIN", m_args);
			m_members_list->AddMember(m_args[0]);
		}
	}
}

void Channel::ReplyPART()
{
	GlobalReply( &GlobalReplyPART );
}

void Channel::GlobalReplyPART()
{
	if (!IsChannel())	return;	// Only channel windows are interested
					// in this message.
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]="";

CString chstring(Pop());
CStringArray channels=CStringTok(chstring, ",");
CString channel_name(IrcLower(ChannelName()));

int	i;

	for (i=0; i<channels.GetSize(); i++)
		if (channels[i].GetLength() > 0)
		{
			m_args[2]=IrcLower(channels[i]);

			if (m_args[2] != channel_name)
				continue;

			if (IrcLower(m_args[0]) == IrcLower(m_currentnick))
				// This is me!
			{
				m_shell->Destroy();
				return;
			}

			LogStrMessage("USERPART", m_args);
			m_members_list->DeleteMember(m_args[0]);
			m_recent_departures.AddTail(
				m_args[0] + '!' + m_args[1]);
			if (m_recent_departures.GetCount() >
				CHANNEL_RECENTDEPARTURES_LISTSIZE)
				m_recent_departures.RemoveHead();
		}
}

void Channel::ReplyKICK()
{
	GlobalReply( &GlobalReplyKICK );
}

void Channel::GlobalReplyKICK()
{
CString chname(Pop());
CString kickeduid(Pop());
CString kickreason(Pop());

	m_args.SetSize(5);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]=chname;
	m_args[3]=kickeduid;
	m_args[4]=kickreason;

	chname=IrcLower(chname);
	kickeduid=IrcLower(kickeduid);

	if (!IsChannel())	// This is a server window.
	{
		if (kickeduid == IrcLower(m_currentnick))
			LogStrMessage("USERKICKME", m_args);
	}
	else if (IrcLower(ChannelName()) == chname)
	{
		if (kickeduid == IrcLower(m_currentnick))
		{
			m_shell->Destroy();	// I got kicked off
			return;
		}
		LogStrMessage("USERKICK", m_args);

		m_members_list->DeleteMember(kickeduid);
	}
}

void Channel::ReplyQUIT()
{
	GlobalReply( &GlobalReplyQUIT );
}

void Channel::GlobalReplyQUIT()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);

	m_args[2]=Pop();
	if (IsChannel() && !m_members_list->HasMember(m_args[0]))
		return;	// Not interested for channels where this one
			// is not a member

	LogStrMessage("USERQUIT", m_args);
	if (IsChannel())
		m_members_list->DeleteMember(m_args[0]);

	m_recent_departures.AddTail( m_args[0] + '!' + m_args[1]);
	if (m_recent_departures.GetCount() >
		CHANNEL_RECENTDEPARTURES_LISTSIZE)
		m_recent_departures.RemoveHead();
}

// When a PRIVMSG or a NOTICE is received, put in on the m_cmds queue
// of the server channel.  Then, start CTCP processing by calling
// ProcessCTCPReply().

void Channel::ReplyPRIVMSG()
{
CString	dest(Pop());
CString	cmd(Pop());

	m_cmds.Decode(cmd, m_replysource, dest, TRUE);
	ProcessCTCPReply();
}

void Channel::ReplyNOTICE()
{
CString	dest(Pop());
CString	cmd(Pop());

	m_cmds.Decode(cmd, m_replysource, dest, FALSE);
	ProcessCTCPReply();
}

//////////////////////////////////////////////////////////////////
//
// Process messages: either text, or CTCP commands received.

void Channel::ProcessCTCPReply()
{
	if (m_cmds.m_tokens.IsEmpty())	return;	// Aren't anymore
	m_cmdevent.Arm( &ProcessCTCPReply );	// For the next one

Cctcp_token token(m_cmds.m_tokens.RemoveHead());
CString	nick, dummy;
void	(Channel::*func)();

	m_replysource=token.m_source;
	SourceToNickUser(token.m_source, nick, dummy);

	{
	AFXBOOL	dummy;

		if (m_ignoremap.Lookup(IrcLower(nick), dummy))
			return;	// Ignore all messages from this bozo
	}

	if (!IsChannel())
	{
// Dispatch to a channel, if appropriate.
// Note: if we have a private window open to a nickname, all NOTICEs and
// PRIVMSGs from that nick will go to that window!

	AFXBOOL	dispatch_to_me=FALSE;

		m_args=CStringTok(token.m_dest, ",");

	size_t i, l=m_args.GetSize();
	Channel	*ch;

		for (i=0; i<l; i++)
		{
			ch=FindChannel(m_args[i]);
			if (ch)
			{
				ch->m_cmds.m_tokens.AddTail(token);
				ch->m_cmdevent.Arm( &ProcessCTCPReply );
				// Set the flag for processing
			}
			else
			{
#if 0
				if (IrcLower( m_args[i] ) == IrcLower(m_currentnick))
	// During registration, we don't have a valid nick
#endif
					dispatch_to_me=TRUE;
					// YOU TALKIN' TO ME???
			}
		}
		if (!dispatch_to_me)	return;

		ch=FindChannel(nick);	// Do we have a private channel to this
					// nick?
		if (ch)
		{
			ch->m_cmds.m_tokens.AddTail(token);
			ch->m_cmdevent.Arm( &ProcessCTCPReply );
			return;
		}

		// Here's a PRIVMSG that's addressed to me.
		// Open a private window under the following situations:
		//      A)  This is a PRIVATE message
		//      B)  This is a CTCP ACTION command.

		if (token.m_private && (!token.IsExtendedCommand() ||
			token.m_command == "ACTION"))
		{
		AppShell *appsh;

			appsh=m_server->m_shell->m_main->NewChannel(
				m_server->m_shell, nick);

			appsh->m_channel.m_cmds.m_tokens.AddTail(token);
			appsh->m_channel.m_cmdevent.Arm( &ProcessCTCPReply );
			return;
		}

		// All CTCP commands sent to this nick directly, in other
		// situations, are handled by trying to dispatch it to
		// a window where the sender is present as well.

		if (token.IsExtendedCommand())
		{
		POSITION        p;
		CString	chname;
		AppShell *appsh;

			p=m_chans.GetStartPosition();

			while (p)
			{
				m_chans.GetNextAssoc(p, chname, appsh);

			Channel         *chp=&appsh->m_channel;

				if (!chp->wid())
					continue;       // Artifact

				if (chp->m_members_list->HasMember(nick))
				{
					chp->m_cmds.m_tokens.AddTail(token);
					chp->m_cmdevent.Arm(&ProcessCTCPReply);
					return;
				}
			}
		}
	}

	m_args.SetSize(3);

	SourceToNickUser(token.m_source, m_args[0], m_args[1]);

	if (!token.IsExtendedCommand())	// This is a plain, garden variety,
					// message.
	{
	// Format message, finally.

		m_args[2]=token.m_value;
		LogStrMessage((token.m_private ? "PRIVMSG":"NOTICE"),
			m_args);
		return;
	}

	// Do we have a built-in handler for this CTCP message???

	if (rpltab.Lookup( (token.m_private ? "CTCP " : "CTCPACK ")
				 + token.m_command, func))
	{
		m_replysource=token.m_source;
		m_replycmd.RemoveAll();
		m_replycmd.AddTail(token.m_value);
		(this ->* func)();
		return;
	}

// Ok, an unknown CTCP message/acknowledgement

	m_args.SetSize(4);	
	m_args[2]=token.m_command;

	// 'Quote' CTCP data argument as follows:
	//
	// ASCII 0x00 - 0x1F becomes a backslash + 0x40-0x60
	// ASCII 0x7D becomes a backslash + 0x3F
	// ASCII \ becomes \\ .

const char *cp=token.m_value;
int	i,l=token.m_value.GetLength(),n=l;

	for (i=l; i; --i)
	{
	register unsigned char c= *cp++;

		if (c < ' ' || c == 0x7F || c == '\\')
			++n;
	}

	if (l == n)	// Nothing needs to be quoted
		m_args[3]=token.m_value;
	else
	{
	char *p=m_args[3].GetBuffer(n);

		cp=token.m_value;
		for (i=l; i; --i)
		{
		register unsigned char c= *cp++;

			if (c < ' ')
			{
				c += 0x40;
				*p++='\\';
			}
			else if (c == 127)
			{
				c=0x3F;
				*p++='\\';
			}
			else if (c == '\\')
				*p++='\\';
			*p++=c;
		}
		m_args[3].ReleaseBuffer(n);
	}

	LogStrMessage(token.m_private ? "CTCPCMD":"CTCPCMDACK",m_args);

	if (token.m_private)
	{
		// If a bot has registered a command, do NOT return
		// an error message

	POSITION	p;
	AFXBOOL	dummy;

		for (p=m_bots.GetHeadPosition(); p; )
		{
		CBot	&ptr=m_bots.GetNext(p);

			if (ptr.m_ctcpcmds.Ptr() &&
				ptr.m_ctcpcmds.Ptr()->Lookup(
					token.m_command, dummy))
				return;
		}

	CStringArray a;
	CXmString	xm(GetStrMessage("CTCPUNKNOWNERRMSG", a));

		FormatErrmsg("CTCP " + token.m_command, (CString)xm);
	}
}

// Kill message

void Channel::ReplyKILL()
{
	m_args.SetSize(2);
	m_args[0]=Pop();
	m_args[1]=Pop();
	LogStrMessage("KILL", m_args);
}

// Topic change

void Channel::ReplyTOPIC()
{
CString	user;
Channel	*ch;

	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], user);
	m_args[1]=Pop();
	m_args[2]=Pop();

	if ((ch=FindChannel(m_args[1])) != NULL)
	{
		ch->m_currenttopic=m_args[2];
		ch->SetTitle();
		ch->LogStrMessage("TOPIC", m_args);
	}
}

// Generic numeric reply

void Channel::GlobalReplyNumeric()
{
	GlobalReply(&ReplyNumeric);
}

void Channel::ReplyNumeric()
{
// Undernet IRC servers are broken, with respect to RFC1459,
// section 2.4, which requires a target for a numeric reply.
// Detect that, and fix it.

	if (m_replycmd.GetCount() == 1)
		m_replycmd.AddHead("");

CString	dest(Pop()); // Ditch destination

	if (IrcLower(dest) != IrcLower(m_currentnick))	// User sent raw NICK
		RegisterNick(dest);

POSITION	p;
size_t		i=0;

	m_args.SetSize(m_replycmd.GetCount());

	for (p=m_replycmd.GetHeadPosition(); p; )
		m_args[i++]=m_replycmd.GetNext(p);

	dest= "RPL"+m_reply;

int	n=atoi((const char *)m_reply);
	if ((n == 367 || n == 368) && m_channel_info.Ptr() &&
		m_channel_info->wid())
		if (n == 367)
			m_channel_info->BanList(m_args[1]);
		else
			m_channel_info->EndBanList();
	
	QueueBot(dest, m_args);

AFXBOOL	dummy;

	if (m_suppressmap.Lookup(dest, dummy))
		return;

CXmString xm(GetStrMessage(dest, m_args));

	// 400 and 500 replies are pre-cooked.  The last argument
	// is set to @3, everything else is piled into @2, the error
	// code is in @1

	if ( ((CString)xm).GetLength() == 0 &&
		(m_reply[0] == '4' || m_reply[0] == '5'))
	{
		m_args.SetSize(3);

	POSITION p=m_replycmd.GetTailPosition();

		m_args[2]="";
		if (p)
			m_args[2]=m_replycmd.GetPrev(p);
		m_args[1]="";
		while (p)
			m_args[1] = m_replycmd.GetPrev(p) + ' ' + m_args[1];
		if (m_args[1].GetLength() > 0)
			m_args[1] += "- ";
		m_args[0]=m_reply;
		dest="RPLERROR";
		xm=GetStrMessage(dest, m_args);
	}

	if ( ((CString)xm).GetLength() > 0)
				// Found in the resource file
	{
		LogMessage(xm);
		if (autoplay.LookupAutoPlay(dest, dest))
			CmdPLAY(dest);	// AUTOPLAY
		return;
	}

	// Oh well, compose a default reply.

	m_args.SetSize(2);

	m_args[0]=m_reply;
	m_args[1]="";

	while (!m_replycmd.IsEmpty())
	{
		if (m_args[1].GetLength() > 0)
			m_args[1] += " ";
		m_args[1] += m_replycmd.RemoveHead();
	}
	LogStrMessage("RPLDEFAULT", m_args);
}

//
// Intercept numeric replies which should go to the same window as the target
// nickname (and a copy to the server window).
//
void Channel::ReplyForNick()
{
	GlobalReply(&GlobalReplyForNick);
}

void Channel::GlobalReplyForNick()
{
	if (IsChannel())
	{
	POSITION p=m_replycmd.GetHeadPosition();

		if (p)	m_replycmd.GetNext(p);	// Skip destination
		if (p)
		{
			if (!m_members_list->HasMember(m_replycmd.GetNext(p)))
				return;
		}
	}
	ReplyNumeric();
}

//
// Intercept a RPL_WHOISUSER to do bans
//

void Channel::Reply311()
{
POSITION p=m_replycmd.GetHeadPosition();
CString	nick, user, host;

	if (p)	m_replycmd.GetNext(p);	// Skip destination
	if (p)	nick=m_replycmd.GetNext(p);
	if (p)	user=m_replycmd.GetNext(p);
	if (p)	host=m_replycmd.GetNext(p);	// nick

	nick=IrcLower(nick);

CString	arg;

	if (!m_server->m_whoismap.Lookup(nick, arg))
	{
		ReplyForNick();
		return;
	}

	m_server->m_whoismap.RemoveKey(nick);

int	i=arg.Find(' ');

	if (i < 0)	AfxThrowInternalException();

CString	channel=arg.Left(i);

	arg=arg.Mid(i);
	arg.TrimLeft();

CString	level=arg.Left(1);
	arg=arg.Mid(1);
	arg.TrimLeft();

CString banmask=CalculateBan(*(const char *)level, nick,user,host);

	if (arg.GetLength() > 0)	arg=" :"+arg;

	AddWriteQueue("MODE " + channel + " +b " + banmask);
	AddWriteQueue("KICK " + channel + ' ' + nick + arg);
}

CString Channel::CalculateBan(char level,
	CString nick, CString user, CString host)
{
CString	domain;
struct	in_addr	addr;
int	i;

	addr.s_addr=inet_addr(host);

	if (addr.s_addr != INADDR_NONE)	// IP address was the domain part
	{
		host=inet_ntoa(addr);	// Takes care of archaic a.b.c, and a.b
					// formats of addressing
		i=host.ReverseFind('.');
		domain=host.Left(i+1) + '*';
	}
	else
	{
		i=host.Find('.');
		if (i < 0 || host.Mid(i+1).Find('.') < 0)
			i=0;
		else
			++i;

		domain= "*."+host.Mid(i);	// At least two top level words
	}

CString	banmask;

	banmask= nick + "!" + user + '@' + host;	// Default ban mask

	switch (level)	{
	case '1':
		banmask= "*!" + user + '@' + host;
		break;
	case '2':
		banmask= "*!*@" + host;
		break;
	case '3':
		banmask= "*!" + user + '@' + domain;
		break;
	case '4':
		banmask= "*!*@" + domain;
		break;
	}
	return (banmask);
}

//
// Intercept a RPL_CHANNELMODEIS to set channel modes
//

void Channel::Reply324()
{
POSITION p=m_replycmd.GetHeadPosition();
CString	channel;

	if (p)	m_replycmd.GetNext(p);	// Skip destination
	if (p)	channel=m_replycmd.GetNext(p);	// Mode
	if (p)
	{
	CString	mode(m_replycmd.GetNext(p));	// The mode
	Channel	*ch=FindChannel(channel);

		if (ch)
		{
		const char *	p=mode;

			if (*p == '+')
				switch (p[1])	{
				case 'p':
				case 's':
				case 'i':
				case 't':
				case 'n':
				case 'm':
				case 'l':
					ch->ProcessMode(mode);
					break;
				}
		}
	}

	ReplyNumeric();
}

// Intercept a RPL_TOPIC, after joining the channel, this tells us the
// channel topic.

void Channel::Reply332()
{
	if (m_replycmd.GetCount() > 1)
	{
	POSITION p=m_replycmd.GetHeadPosition();

		(void)m_replycmd.GetNext(p);	// Skip destination

	Channel *ch=FindChannel(m_replycmd.GetNext(p));

		// If we have the channel open, change the channel title

		if (ch)
		{
			ch->m_currenttopic= p ? m_replycmd.GetNext(p)
						: CString("");
			ch->SetTitle();
		}
	}
	ReplyNumeric();
}

// We rely on a 353 message in order to help us build the initial list of
// users on the channel

void Channel::Reply353()
{
POSITION p=m_replycmd.GetHeadPosition();
CString	s;

	if (p)
	{
		(void)m_replycmd.GetNext(p);	// Skip destination
		if (p)
		{
			s=m_replycmd.GetNext(p);

			if ((s == "=" || s == "*" ||
				s == "@") && p)
				s=m_replycmd.GetNext(p);

			if (IsChannelName(s))
			{
			Channel	*ch;

				if ((ch=FindChannel(s)) != NULL)
				{
					m_args=CStringTok(m_replycmd.GetNext(p),
								" ");
				size_t i, l=m_args.GetSize();

					for (i=0; i<l; i++)
						ch->m_members_list->AddMember(
							m_args[i] );
					// Show 353 in channel window, for bots
					ch->m_replycmd=m_replycmd;
					ch->m_reply=m_reply;
					ch->ReplyNumeric();
				}
			}
		}
	}
	ReplyNumeric();
}

void Channel::GlobalReplyNumericChannel()
{
POSITION p=m_replycmd.GetHeadPosition();
CString	s;

	if (p)
	{
		(void)m_replycmd.GetNext(p);	// Skip destination
		if (p)
		{
			s=m_replycmd.GetNext(p);

			if (IsChannelName(s))
			{
			Channel	*ch;

				if ((ch=FindChannel(s)) != NULL)
				{
					ch->m_replycmd=m_replycmd;
					ch->m_reply=m_reply;
					ch->ReplyNumeric();
				}
			}
		}
	}
	ReplyNumeric();
}

// If typo was made in nick part of /ban, watch for 401 errors to clear the
// map

void Channel::Reply401()
{
POSITION p=m_replycmd.GetHeadPosition();
CString	nick;

	if (p)	m_replycmd.GetNext(p);	// Skip destination
	if (p)	nick=m_replycmd.GetNext(p);
	nick=IrcLower(nick);
	m_server->m_whoismap.RemoveKey(nick);
	ReplyNumeric();
}

////////////////////////////////////////////////////////////////////
//
// Process CTCP messages

void Channel::Reply_CTCP_ACTION()
{
	m_args.SetSize(3);
	
CString dummy;

	SourceToNickUser(m_replysource, m_args[0], dummy);
	m_args[1]=IsChannel() ? ChannelName():CString("");
	m_args[2]=Pop();
	LogStrMessage("CTCPACTION", m_args);
}

void Channel::Reply_CTCP_PING()	// Someone's pinging us
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]="PING";
	SendCTCP(TRUE, m_args[0], "PING "+Pop());
	LogStrMessage("CTCPCMD", m_args);
}

void Channel::Reply_CTCPACK_PING()	// Someone echoed our ping
{
char	buf[40];
ostrstream o(buf, sizeof(buf));

	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);

time_t	t;

	time(&t);

	o << (t - atol(Pop())) << '\0';

	m_args[2]=o.str();
	LogStrMessage("CTCPPING", m_args);
}

void Channel::Reply_CTCP_FINGER()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]= ::username;

CXmString xm(GetStrMessage("MYFINGER", m_args));

	SendCTCP(TRUE, m_args[0], "FINGER :"+(CString)xm);
	m_args[2]="FINGER";
	LogStrMessage("CTCPCMD", m_args);
}

void Channel::Reply_CTCPACK_FINGER()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]=Pop();
	LogStrMessage("CTCPFINGER", m_args);
}

void Channel::Reply_CTCP_VERSION()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]="VERSION";

	SendCTCP(TRUE, m_args[0], "VERSION " + VersionString() );
	LogStrMessage("CTCPCMD", m_args);
}

void Channel::Reply_CTCPACK_VERSION()
{
	m_args=CStringSplit( Pop(), ':' );
	m_args.SetSize(5);
	m_args[4]=m_args[2];
	m_args[3]=m_args[1];
	m_args[2]=m_args[0];
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	LogStrMessage("CTCPVERSION", m_args);
}

void Channel::Reply_CTCP_SOURCE()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]="SOURCE";

	SendCTCP(TRUE, m_args[0], "SOURCE");	// Not yet supported
	LogStrMessage("CTCPCMD", m_args);
}

void Channel::Reply_CTCPACK_SOURCE()
{
	m_args=CStringSplit( Pop(), ':' );
	if (m_args.GetSize() <= 1)
	{
		m_args.SetSize(2);
		SourceToNickUser(m_replysource, m_args[0], m_args[1]);
		LogStrMessage("CTCPSOURCEEND", m_args);
		return;
	}

	m_args.SetSize(5);
	m_args[4]=m_args[2];
	m_args[3]=m_args[1];
	m_args[2]=m_args[0];
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	LogStrMessage("CTCPSOURCE", m_args);
}

void Channel::Reply_CTCP_USERINFO()
{
	m_args.SetSize(2);
	m_args[0]=m_server->m_user;

CXmString xm(GetStrMessage("MYUSERINFO", m_args));
CString	userinfo(xm);

	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]="USERINFO";

	SendCTCP(TRUE, m_args[0], "USERINFO :"+userinfo);
	LogStrMessage("CTCPCMD", m_args);
}

void Channel::Reply_CTCPACK_USERINFO()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]=Pop();
	LogStrMessage("CTCPUSERINFO", m_args);
}

void Channel::Reply_CTCP_CLIENTINFO()
{
CString	clientinfo;

	m_args.SetSize(0);

	clientinfo=Pop();
	if (*(const char *)clientinfo == ':')
		clientinfo=clientinfo.Mid(1);

	if (clientinfo.GetLength() == 0)
	{
	CXmString xm(GetStrMessage("MYCLIENTINFO", m_args));

		clientinfo=xm;
	}
	else
	{
	CString cmd(clientinfo);

		cmd.MakeUpper();
		m_args.SetSize(1);
		m_args[0]=cmd;
	CXmString xm(GetStrMessage("MYCLIENTINFO_" + cmd, m_args));

		clientinfo=xm;
		if (clientinfo.GetLength() == 0)
		{
			xm=GetStrMessage("MYCLIENTINFO_UNKNOWN", m_args);
			FormatErrmsg("CLIENTINFO "+cmd, (CString)xm);
			LogStrMessage("CTCPCMD", m_args);
			return;
		}
	}

	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]="CLIENTINFO";

	SendCTCP(TRUE, m_args[0], "CLIENTINFO :"+clientinfo);
	LogStrMessage("CTCPCMD", m_args);
}

void Channel::Reply_CTCPACK_CLIENTINFO()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]=Pop();
	LogStrMessage("CTCPCLIENTINFO", m_args);
}

void Channel::Reply_CTCP_ERRMSG()
{
	m_args.SetSize(0);
CXmString xm(GetStrMessage("MYCTCPERRMSG", m_args));

	FormatErrmsg( Pop(), (CString)xm);
}


void Channel::FormatErrmsg(CString cmd, CString msg)
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	SendCTCP(TRUE, m_args[0], "ERRMSG  "+cmd+" :"+msg);
}

void Channel::Reply_CTCPACK_ERRMSG()
{
	m_args.SetSize(4);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);

CString	s(Pop());
int	i=s.Find(':');

	if (i < 0)	i=s.GetLength();

	m_args[2]=s.Left(i);
	m_args[3]=s.Mid(i+1);
	m_args[2].TrimLeft();
	m_args[3].TrimLeft();
	LogStrMessage("CTCPERRMSG", m_args);
}

void Channel::Reply_CTCP_TIME()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);

time_t	t;

	time(&t);

CString	s(ctime(&t));

	m_args[2]="TIME";

	SendCTCP(TRUE, m_args[0], "TIME :"+s.Left(s.GetLength()-1));
	LogStrMessage("CTCPCMD", m_args);
}

void Channel::Reply_CTCPACK_TIME()
{
	m_args.SetSize(3);
	SourceToNickUser(m_replysource, m_args[0], m_args[1]);
	m_args[2]=Pop();
	LogStrMessage("CTCPTIME", m_args);
}

////////////////////////////////////////////////////////////////////
//
// Process /MODE changes

void Channel::ReplyMODE()
{
CString	source, user;
CString target(Pop());
CString modechg(Pop());

	SourceToNickUser(m_replysource, source, user);
	if (!IsChannelName(target))	// Mode changes on a nick
	{
		m_args.SetSize(4);
		m_args[0]=source;
		m_args[1]=user;
		m_args[2]=target;
		m_args[3]=modechg;
		LogStrMessage("NICKMODECHG", m_args);
		if (IrcLower(target) == IrcLower(m_currentnick))
			ProcessMode(modechg);
		return;
	}

CString channel=target;
Channel *ch=FindChannel(channel);

	if (!ch)	return;

const char *	p=modechg;
char	plusminus='+';

	while (*p)
	{
		target="";
		switch (*p)	{
		case '+':
		case '-':
			plusminus= *p++;
			continue;
		case 'l':
			if (plusminus != '+')
				break;
			// FALLTHRU
		case 'o':
		case 'v':
		case 'k':
		case 'b':
			target=Pop();
			break;
		}

		m_args.SetSize(5);
		m_args[0]=source;
		m_args[1]=user;
		m_args[2]=channel;
		m_args[3]=CString("") + plusminus + *p;
		m_args[4]=target;
		ch->LogStrMessage("CHANNELMODECHG", m_args);

		// Update member listings for @ or +

		switch (*p)	{
		case 'o':
			ch->m_members_list->AddMember(
				(plusminus == '+' ? "@":"") + target );
			break;
		case 'v':
			ch->m_members_list->AddMember(
				(plusminus == '+' ? "+":"") + target );
			break;
		}

		switch (*p)	{
		case 'p':
		case 's':
		case 'i':
		case 't':
		case 'n':
		case 'm':
		case 'l':
			ch->ProcessMode(m_args[3]);
			break;
		}
		p++;
	}
}

////////////////////////////////////////////////////////////////////
//
// Process /LIST replies

void Channel::Reply321()
{
	if (!m_channel_list)
	{
		if ((m_channel_list.Init(new ChannelListing)) == NULL)
			AfxThrowMemoryException();
		m_channel_list->operator=(m_shell->m_main);
	}
	else
		m_channel_list->Destroy();

	m_channel_list->Create(this, m_curhost);
	m_args.SetSize(0);
	m_channel_list->TempTitle();
	m_channel_list->Realize();
}

void Channel::Reply322()
{
	Pop();	// Destination

CString	channel(Pop());
CString	members(Pop());
CString	topic(Pop());

int	nmembers=atol(members);
	m_channel_list->Add(channel, nmembers, topic);
}

void Channel::Reply323()
{
	ReplyNumeric();
	m_channel_list->Finish();
}
