// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"config.h"
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<pwd.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<iostream.h>
#include	<strstream.h>
#include	<fstream.h>
#include	<ctype.h>
#include	<string.h>
#include	<stdlib.h>
#include	<netdb.h>
#if	HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<errno.h>
#include	"mytime.h"
#include	"widget/widget.h"
#include	"channel.h"
#include	"channellog.h"
#include	"appshell.h"
#include	"nickchangeform.h"
#include	"smirc.h"
#include	"afxdebug.h"
#include	"bot.h"
#include	"botlist.h"

#if	HAS_GETHOSTNAME
#else
extern "C" int gethostname(const char *, size_t);
#endif

static const char rcsid[]="$Id: channelIO.C,v 1.13 1999/07/23 04:41:53 mrsam Exp $";

// Initiate a connection to the server.

void Channel::Connect()
{
struct	sockaddr_in	sin;
char	buf[40];
ostrstream o(buf, sizeof(buf));

	FloodReset();
	if (m_port.GetLength() == 0)
		m_port=DEFAULT_PORT;
	if (m_connecthost.GetLength() == 0)
	{
		LogStrMessage("BADHOST");
		return;
	}

	// Pick connecting port randomly.

CUIntArray portlo, porthi;	// Init lo-hi port list
unsigned long nports=0;		// Total # of ports
int	i;

	{
	CStringArray portranges=CStringSplit(m_port, ',');

		portlo.SetSize(portranges.GetSize());
		porthi.SetSize(portranges.GetSize());

	CString	lo, hi;

		for (i=0; i<portranges.GetSize(); i++)
		{
			lo=hi=portranges[i];

		int	j=lo.Find('-');

			if (j >= 0)
			{
				hi=lo.Mid(j+1);
				lo=lo.Left(j);
			}
			portlo[i]=atol(lo);
			porthi[i]=atol(hi);
			if (portlo[i] == 0 || porthi[i] < portlo[i] ||
				porthi[i] > 65535)
			{
				LogStrMessage("BADPORT");
				return;
			}
			nports += porthi[i] - portlo[i] + 1;
		}
	}

	if (nports == 0)
	{
		LogStrMessage("BADPORT");
		return;
	}

	// Now, pick a port randomly

unsigned long	p=rand() % nports;

	for (i=0; p >= porthi[i] - portlo[i] + 1;
		p -= porthi[i] - portlo[i] + 1, i++)
		;
	p += portlo[i];

	sin.sin_family=AF_INET;
	sin.sin_port=htons(p);
	sin.sin_addr.s_addr=inet_addr(m_connecthost);

	if (sin.sin_addr.s_addr == INADDR_NONE)
	{
		LogStrMessage("LOOKINGUP", m_connecthost);
		log->Update();	// gethostbyname blocks

	struct	hostent	*hostent=gethostbyname(m_connecthost);

		if (hostent == NULL)
		{
			LogStrMessage("NOSUCHHOST", m_connecthost);
			return;
		}
		memcpy(&sin.sin_addr,hostent->h_addr_list[0],
			sizeof(sin.sin_addr));
	}

	if (m_socket.fd() >= 0)
	{
		quit();
	}

	m_whoismap.RemoveAll();	// Clear out the WHOIS map

int	n=socket(AF_INET, SOCK_STREAM, 0);

	if (n < 0)
	{
		LogErrno();
		return;
	}
	
	m_connected=FALSE;
	m_connecting=FALSE;
	m_registered=FALSE;
	m_selfdestruct=FALSE;
	m_quitsent=FALSE;
	m_socket.fd(n);

	// Use non-blocking mode on socket.

	if (fcntl(n, F_SETFL, O_NONBLOCK) == -1)
	{
		LogErrno();
		return;
	}
	if (connect(n, (const sockaddr *)&sin, sizeof(sin)) == -1
		&& errno != EAGAIN && errno != EINPROGRESS)
	{
		LogErrno();
		return;
	}

	m_socket.Read( &ReadSocket );

	m_args.SetSize(2);
	m_args[0]=inet_ntoa(sin.sin_addr);

	o << p << '\0';

	m_args[1]=o.str();

	LogStrMessage("CONNECTING", m_args);
	m_connecting=TRUE;
	m_writeQueue.RemoveAll();

	if (gethostname(m_myhost.GetBuffer(128), 128) < 0)
	{
		m_myhost.ReleaseBuffer(0);
		LogErrno();
		return;
	}

	m_myhost.ReleaseBuffer(-1);
	m_currentnick=ConfigNickName();

	// Prepare registration commands, which will be written when the
	// connection completes.

	if (m_password.GetLength() > 0)
		AddWriteQueue ( "PASS " + m_password);
	AddWriteQueue ( "NICK " + m_currentnick);
	AddWriteQueue ( (CString)"USER " + UnixUserId() + " "
		+ m_myhost + " " + m_connecthost + " :" + UserName() );
}


void Channel::FloodReset()
{
	m_flood_timestamps.SetSize(m_flood_messages);
	m_flood_t_cnt=0;
	m_flood_t_head=0;
	m_flood_t_tail=0;
}

// Try to write something to the socket.

CString Channel::WriteSocket()
{
	if (m_writeQueue.IsEmpty())
	{
		if (m_connecting)
		{
		// We just succesfully wrote the "USER" command, this means
		// the connection is complete

			m_connected=TRUE;
			m_connecting=FALSE;
			m_curhost=m_connecthost;
			LogStrMessage("CONNCOMPLETE");
		}
		return ("");
	}

time_t	t;

	time(&t);
	if (m_flood_t_cnt == m_flood_messages)
	{
		if ( (time_t)(t - m_flood_timestamps[m_flood_t_tail])
			<= (time_t)m_flood_seconds)
		{
			m_flood_timeout.Arm( &FloodTimeout, m_flood_delay );
			return ("");
		}
		if (++m_flood_t_tail >= m_flood_messages)
			m_flood_t_tail=0;
		--m_flood_t_cnt;
	}

	m_flood_timestamps[m_flood_t_head]=t;
	if (++m_flood_t_head >= m_flood_messages)
		m_flood_t_head=0;
	++m_flood_t_cnt;

CString	s(m_writeQueue.RemoveHead());

	IFDEBUG("write", LogMessage(s, LOG_DEFAULT); )

	return (s + CRLF);
}

void Channel::FloodTimeout()
{
	if (m_server->m_socket.fd() < 0)	return;
	m_server->m_socket.Write( &WriteSocket );
}

// Add something to the write queue.

void Channel::AddWriteQueue(CString s, AFXBOOL priority)
{
	if (m_server->m_socket.fd() < 0)	return;

	if (m_server->m_writeQueue.IsEmpty())
		m_server->m_socket.Write( &WriteSocket );
				// Restart writing process.

	if (priority)
		m_server->m_writeQueue.AddHead(s);
	else
		m_server->m_writeQueue.AddTail(s);
}

// Process line read from the socket.

void Channel::ReadSocket(CString line)
{
	IFDEBUG("read",
		{
		static ofstream debugfile;

			if (!debugfile.is_open())
				debugfile.open("smirc.in");
			if (line.GetLength() > 1)
				debugfile << (const char *) line << flush;
		} )

	if (line.GetLength() == 0)	// Socket closed.
	{
		if (!wid())	// About to go away anyway
		{
			quitnotitle();
			return;
		}

		if (errno || m_connecting)
			LogErrno();	// ... Due to an error.
		else	// Normal termination.
		{
			LogStrMessage(
				m_quitsent ? "TERMINATED":
				"DISCONNECTED", m_curhost);
			quit();
		}

		if (m_selfdestruct)
		{
			// We are supposed to destroy ourselves.

			m_selfdestruct=FALSE;
			if (m_shell)
				m_shell->Destroy();
		}
		return;
	}

	if (!wid())	return;	// We're about to die

	line.Chop();

CString	orig_line(line);
const char *	p;

	m_replysource="";
	p=line;
	if (*p == ':')
	{
	int	i=line.Find(' ');

		if (i < 0)	i=line.GetLength();

		m_replysource=line.Mid(1, i-1);
		line=line.Mid(i);
	}

	SplitReply(line);

	if (m_replycmd.GetCount() == 0)	return;	// Empty line.

	// Execute the command.

void	(Channel::*func)();

	m_reply=m_replycmd.RemoveHead();
	if (!m_registered)
	{
		switch (m_reply[0])	{
		case '0':
		case '1':
		case '2':
			m_registered=TRUE;
			m_args.SetSize(0);
			LogStrMessage("READY", m_args);
			RegisterNick(m_currentnick);
			FloodReset();	// We shoot out a bunchastuff
					// when connecting.
		}
	}

	if (rpltab.Lookup(m_reply, func))
	{
		(this ->* func)();
		return;
	}


//
//  If we got a 433 before getting registered, try an alternate nickname
//

	if (m_reply == "433" && !m_registered && m_altnick.GetLength() > 0)
	{
	CString	mynick=IrcLower(m_currentnick);
	CString nick1=IrcLower(m_nick);
	CString nick2=IrcLower(m_altnick);

		if (mynick == nick1 && mynick != nick2)
		{
			m_currentnick=m_altnick;
			AddWriteQueue("NICK " + m_currentnick);
			return;
		}
		else
		{
			if (!m_nick_change.Ptr() && !m_nick_change.Init(
					new NickChangeForm))
				AfxThrowMemoryException();

			if (m_nick_change->wid())
			{
				if (XtIsManaged(m_nick_change->wid()))
					return;	// Already opened
				m_nick_change->Destroy();
			}

			BusyCursor();
			try
			{
				m_nick_change->Create(this);
				m_nick_change->Manage();
				RemoveCursor();
			}
			catch (...)
			{
				RemoveCursor();
				throw;
			}
		}
	}

	if (m_reply.GetLength() == 3 &&
		isdigit(m_reply[0]) &&
		isdigit(m_reply[1]) &&
		isdigit(m_reply[2]))
	{
		ReplyNumeric();
		return;
	}
	LogStrMessage("UNKNOWN", orig_line);
}

void Channel::SplitReply(CString line)
{
const char *p, *q;

	p=line;
	m_replycmd.RemoveAll();
	while (*p)
	{
		if (isspace(*p))
		{
			++p;
			continue;
		}

		if (*p == ':')
		{
			m_replycmd.AddTail(p+1);
			break;
		}
		for (q=p; *q; ++q)
			if (isspace(*q))
				break;
		m_replycmd.AddTail(CString(p, q-p));
		p=q;
	}
}

void Channel::prepbotmsg(CBot *bot)
{
char	buf[40];
ostrstream o(buf, sizeof(buf));

	m_args[0]=bot->m_name;
	o << bot->m_pid << '\0';
	m_args[1]=o.str();
}

void Channel::EndBot(CBot *bot)
{
	m_args.SetSize(2);
	prepbotmsg(bot);
	if (m_bot_list.Ptr())
		m_bot_list->BotRemoved(bot);
	m_bots.RemoveAt(bot->m_pos);
	LogStrMessage("BOTEND", m_args);
}

// Bot's stdout output is processed as a command entered in the buffer.

void Channel::BotOutput(CBot *bot, CString line)
{
	if (line.GetLength() == 0)	// Bot's done, but wait until
					// everything is flushed out.
	{
		bot->CloseStdout();
		if (bot->BothClosed())
			EndBot(bot);
		return;
	}
	line.Chop();
	Command(line, bot);
}

// Bot's standard error is just shown in the window.

void Channel::BotErr(CBot *bot, CString line)
{
	if (line.GetLength() == 0)	// Bot's done, but wait until
					// everything is flushed out.
	{
		bot->CloseStderr();
		if (bot->BothClosed())
			EndBot(bot);
		return;
	}
	line.Chop();
	m_args.SetSize(3);
	prepbotmsg(bot);
	m_args[2]=line;
	LogStrMessage("BOTSTDERR", m_args);
}

void Channel::QueueBot(CString cmd, const CStringArray &args)
{
int	i;
POSITION p;
CString	buf;

	for (i=0; i<args.GetSize(); i++)
	{
		buf=args[i];
	size_t	l=buf.GetLength();
	char *	p=buf.GetBuffer(l);
		while (l)
		{
			if (*p < ' ')	*p=' ';
			p++;
			--l;
		}
		buf.ReleaseBuffer(buf.GetLength());
		cmd += '\t';
		cmd += buf;
	}
	cmd += '\n';

	for (p=m_bots.GetHeadPosition(); p; )
		m_bots.GetNext(p).AddWrite(cmd);
}

// Helper class so we don't have to write pages of cleanup code...

class CPipeFd {
public:
	int m_fds[2];
	CPipeFd()	{ m_fds[0]= -1; m_fds[1]= -1; }
	~CPipeFd();
} ;

CPipeFd::~CPipeFd()
{
	if (m_fds[0] >= 0)	close(m_fds[0]);
	if (m_fds[1] >= 0)	close(m_fds[1]);
}

void Channel::CmdRUN(CString runcmd)
{
CString origcmd(runcmd);
CString cmdargs;
const char *p=runcmd;
size_t	i, j;

	for (i=0; p[i]; i++)
		if (isspace(p[i]))	break;
	for (j=i; p[j]; j++)
		if (!isspace(p[j]))	break;
	cmdargs=runcmd.Mid(j);
	runcmd=runcmd.Left(i);
	if (runcmd.GetLength() && StartBot(runcmd, cmdargs))	return;
	m_args.SetSize(1);
	m_args[0]=origcmd;
	LogStrMessage("BOTNOTFOUND", m_args);
}

// See if we can start a new bot going...

AFXBOOL Channel::StartBot(CString cmd, CString args)
{
CString	botdir, botfilename;

	botfilename=cmd+".bot";
	botdir=CONFIGDIR1;
	if (access(botdir + '/' + botfilename, X_OK))
	{
		botdir=CONFIGDIR2;
		if (access(botdir + '/' + botfilename, X_OK))
		{
			botdir=HOMECONFIGDIR;
			if (access(botdir + '/' + botfilename, X_OK))
				return (FALSE);
		}
	}
	DoStartBot(botdir, botfilename, args);
	return (TRUE);
}

void Channel::DoStartBot(const char *botdir, const char *botfilename,
			const char *args)
{
const char *	arg1="CHANNEL", *arg2=0, *arg3=0;

	if (IsChannel())
	{
		arg2=ChannelName();
		arg3=m_currentnick;
	}
	else
	{
		arg1="SERVER";
		arg2="";
		arg3="";
		if (m_connected)
		{
			arg2= m_curhost;
			arg3= m_port;
		}
	}

// Create a new CBot structure in the list itself.

CBot	*bot;
CBot	new_bot;
POSITION	p=m_bots.AddTail( new_bot );

	bot= &m_bots.GetAt(p);
	bot->m_pos=p;
	bot->m_pid=0;

	try
	{
	CPipeFd	fd0, fd1, fd2;

		bot->m_name=botfilename;
		bot->Create(this);
		if (pipe(fd0.m_fds) < 0 || pipe(fd1.m_fds) < 0 ||
			pipe(fd2.m_fds) < 0)
		{
			LogErrnoMsg(errno);
			delete bot;
			return;
		}

		if ((bot->m_pid=fork()) < 0)
		{
			LogErrnoMsg(errno);
			delete bot;
			return;
		}
		if (bot->m_pid == 0)
		{
			try
			{
				CApplicationWidget::Forked();
				CXmInputBase::Forked();
				close(0);
				close(1);
				close(2);
				if (dup(fd0.m_fds[0]) != 0
					|| dup(fd1.m_fds[1]) != 1
					|| dup(fd2.m_fds[1]) != 2)
				{
					_exit(100);
				}
				close(fd0.m_fds[0]);
				close(fd0.m_fds[1]);
				close(fd1.m_fds[0]);
				close(fd1.m_fds[1]);
				close(fd2.m_fds[0]);
				close(fd2.m_fds[1]);
				if (chdir(botdir) < 0)
					_exit(100);
#ifdef	USESHELL
			const char *p=getenv("SHELL");
				if (!p)	p="/bin/sh";

				execl(p, p, botfilename, arg1, arg2, arg3,
					args, (const char *)0);
#else
				execl( botfilename, botfilename,
					arg1, arg2, arg3, args,
					(const char *)0);
#endif
				_exit(100);
			}
			catch (...)
			{
				_exit(100);
			}
		}

		bot->m_fd0->fd( fd0.m_fds[1] );
		close(fd0.m_fds[0]);
		fd0.m_fds[0]= -1;
		fd0.m_fds[1]= -1;

		bot->m_fd1->fd( fd1.m_fds[0] );
		close(fd1.m_fds[1]);
		fd1.m_fds[0]= -1;
		fd1.m_fds[1]= -1;

		bot->m_fd2->fd( fd2.m_fds[0] );
		close(fd2.m_fds[1]);
		fd2.m_fds[0]= -1;
		fd2.m_fds[1]= -1;
		bot->Start();
		if (m_bot_list.Ptr())
			m_bot_list->BotAdded(bot);
	}
	catch (...)
	{
		m_bots.RemoveAt(bot->m_pos);
		if (bot->m_pid && m_bot_list.Ptr())
			m_bot_list->BotRemoved(bot);
		delete bot;
	}

	m_args.SetSize(2);
	prepbotmsg(bot);
	LogStrMessage("BOTSTART", m_args);
}

// Bot TIMER command

void Channel::TimerBot(CBot *b, CString s)
{
	b->SetTimer(atoi(s));
}

// Menu command to open the bot list window.

void Channel::BotListOpen()
{
	if (m_bot_list.Ptr())
	{
		delete m_bot_list.Ptr();
		m_bot_list.Init(NULL);
	}

	if ( !m_bot_list.Init(new CBotListForm))
		AfxThrowMemoryException();

	if (!m_bot_list->wid())
	{
		try
		{
			BusyCursor();
			m_bot_list->Create(this);

			if (IsChannel())
			{
				m_args.SetSize(1);
				m_args[0]=ChannelName();
				m_bot_list->Title(
					GetStrMessage("channelBotList",
						m_args));
			}
			else
			{
				m_args.SetSize(0);
				m_bot_list->Title(
					GetStrMessage("serverBotList",
						m_args));
			}
			m_bot_list->Manage();
			RemoveCursor();
		}
		catch (...)
		{
			delete m_bot_list.Ptr();
			m_bot_list.Init(NULL);
			try
			{
				RemoveCursor();
			}
			catch (...)
			{
				throw;
			}
			throw;
		}
	}
}
