// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"config.h"
#include	<Xm/Xm.h>
#include	<Xm/Text.h>
#include	<iostream.h>
#include	<strstream.h>
#include	<ctype.h>
#include	<string.h>
#include	<stdlib.h>
#include	<errno.h>
#if	HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#include	"mytime.h"
#include	"widget/widget.h"
#include	"channel.h"
#include	"main.h"
#include	"logwidget.h"
#include	"appshell.h"
#include	"smirc.h"
#include	"afxdebug.h"

static const char rcsid[]="$Id: channelCmd.C,v 1.11 1999/06/14 02:12:09 mrsam Exp $";


/////////////////////////////////////////////////////////////////////////////
//
// Handle user commands

// SERVER - parse arguments, then call Connect()

void Channel::CmdSERVER(CString s)
{
	m_server->ServerCmdSERVER(s);	// This is a server command
}

void Channel::ServerCmdSERVER(CString s)
{
CString	host, port;
size_t	i, l;
int	j;

	m_args=CStringTok(s, ' ', TRUE);

	l=m_args.GetSize();
	if (l == 0)
	{
		OpenConnectionFormOpen();	// Connect dialog
		return;
	}
	for (i=0; i<l; i++)
	{
		if ((j=m_args[i].Find('=')) < 0)
		{
			if (host.GetLength() == 0)
			{
				host=m_args[i];
				m_password="";
			}
			else if (port.GetLength() == 0)
				port=m_args[i];
			continue;
		}
		s=m_args[i].Left(j);
		s.MakeUpper();

		if (s == "NICK")
			m_nick=m_args[i].Mid(j+1);
		if (s == "ALTNICK")
			m_altnick=m_args[i].Mid(j+1);
		if (s == "PASSWORD")
			m_password=m_args[i].Mid(j+1);
		if (s == "USER")
			m_user=m_args[i].Mid(j+1);
	}

	if (host.GetLength() && !port.GetLength())
		port=DEFAULT_PORT;

	if (host.GetLength())
		m_connecthost=host;

	if (port.GetLength())
		m_port=port;

	Connect();
}

// QUIT command - send QUIT command to server.

void Channel::CmdQUIT(CString s)
{
	m_server->ServerCmdQUIT(s);
}

void Channel::ServerCmdQUIT(CString s)
{
	if (s.GetLength() > 0)
		s= ':' + s;

	// If we are here again, just forcibly quit.

	if (!m_quitsent && IsConnected())
	{
		AddWriteQueue("QUIT " + s);
		m_quitsent=TRUE;
	}
	else
	{
		quit();
		LogStrMessage("TERMINATED", m_curhost);
	}

	m_selfdestruct=FALSE;
}

void Channel::CmdNICK(CString s)	// Nick change command
{
	AddWriteQueue("NICK " + s);
}

void Channel::CmdWHOIS(CString s)
{
	AddWriteQueue("WHOIS " + s);
}

void Channel::CmdWHO(CString s)	// Nick change command
{
	AddWriteQueue("WHO " + s);
}

void Channel::CmdJOIN(CString s)	// Join command
{
	AddWriteQueue("JOIN " + s);
}

void Channel::CmdPARTMenu()
{
	CmdPART("");
}

CString Channel::Pop()
{
	if (m_replycmd.IsEmpty())
		return ("");
	return (m_replycmd.RemoveHead());
}

void Channel::badcmd()
{
	LogStrMessage("BADCMD", m_command);
}

void Channel::CmdPART(CString s)	// Part command
{
CString	channel;

	channel=CmdGetChannel(s);

	if (channel.GetLength() == 0)
	{
		badcmd();
		return;
	}

	AddWriteQueue("PART " + channel);
}

// Many commands take a channel argument, which defaults to the window's channel
// extract the channel name from the command line, or default it.

CString Channel::CmdGetChannel(CString &commandline)
{
CString	channel;
int	i;

	commandline.TrimLeft();
	i=commandline.Find(' ');
	if (i < 0)	i=commandline.GetLength();
	channel=commandline.Left(i);
	if (IsChannelName(channel))	// Yup, channel name was specified
		commandline=commandline.Mid(i+1);
	else
	{
		channel="";
		if (IsChannel() && !IsPrivateChannel())
			channel=ChannelName();
	}
	return (channel);
}

void Channel::CmdKICK(CString s)	// Kick command
{
CString	channel=CmdGetChannel(s);

	if (channel.GetLength() == 0)
	{
		badcmd();
		return;
	}

	s.TrimLeft();

int	i=s.Find(' ');
	if (i < 0)
		i=s.GetLength();

CString	nick(s.Left(i));

	s=s.Mid(i);
	s.TrimLeft();
	if (s.GetLength() > 0)	s= " :" + s;

	AddWriteQueue("KICK " + channel + ' ' + nick + s);
}

void Channel::CmdIGNORE(CString s)	// IGNORE command
{
	s.TrimLeft();
	s.TrimRight();
	if (!IsChannel() || IsPrivateChannel())
	{
		badcmd();
		return;
	}

	if (s.GetLength() == 0)
	{
		// Show all nicks being ignored

	POSITION	p;
	CString	nick;
	AFXBOOL dummy;

		for (p=m_ignoremap.GetStartPositionSorted(); p; )
		{
			m_ignoremap.GetNextAssocSorted(p, nick, dummy);
			LogStrMessage("IGNORE", nick);
		}
		LogStrMessage("ENDIGNORE");
		return;
	}

CString	ls(IrcLower(s));

	m_ignoremap[ls]=TRUE;
	LogStrMessage("IGNORE", s);
}

void Channel::CmdUNIGNORE(CString s)	// IGNORE command
{
	s.TrimLeft();
	s.TrimRight();
	if (!IsChannel() || IsPrivateChannel() || s.GetLength() == 0)
	{
		badcmd();
		return;
	}

CString	ls(IrcLower(s));

	m_ignoremap.RemoveKey(ls);
	LogStrMessage("UNIGNORE", s);
}

void Channel::CmdBAN(CString s)		// Ban user
{
CString	channel=CmdGetChannel(s);

	if (channel.GetLength() == 0)
	{
		badcmd();
		return;
	}

	s.TrimLeft();

int	i=s.Find(' ');

	if (i < 0)	i=s.GetLength();

CString	nick=s.Left(i);

	s=s.Mid(i);
	s.TrimLeft();

CString	banlevel="0";

	if (isdigit(*(const char *)s))
	{
		banlevel=s.Left(1);
		s=s.Mid(1);
		s.TrimLeft();
	}

	nick=IrcLower(nick);

	m_server->m_whoismap[nick]=channel + ' ' + banlevel + ' ' + s;
	try
	{
		CmdWHOIS(nick);
	}
	catch(...)
	{
		m_server->m_whoismap.RemoveKey(nick);
		throw;
	}
}

void Channel::CmdNAMES(CString s)	// NAMES command
{
	AddWriteQueue("NAMES " + s);
}

void Channel::CmdINVITE(CString s)	// INVITE command
{
int	i;
CString	nick, channel;

	s.TrimLeft();
	i=s.Find(' ');
	nick=s.Left(i);
	s=s.Mid(i);
	s.TrimLeft();
	if (s.GetLength() > 0)
		channel=s;
	else if (!IsChannel() || IsPrivateChannel())
	{
		badcmd();
		return;
	}
	else	channel=ChannelName();

	AddWriteQueue("INVITE " + nick + ' ' + channel);
}

void Channel::CmdAWAY(CString s)	// AWAY command
{
	s.TrimLeft();
	s.TrimRight();
	if (s.GetLength() > 0)	s= " :" + s;

	AddWriteQueue("AWAY"+s);
}

void Channel::CmdALLMSG(CString s)
{
POSITION	iter;
CString		dummy;

	for (iter=m_server->m_chans.GetStartPosition(); iter; )
	{
	AppShell *appsh;
	Channel	*ch;

		m_server->m_chans.GetNextAssoc(iter, dummy, appsh);
		if (!appsh)	AfxThrowInternalException();

		ch= &appsh->m_channel;
		if (ch->wid())
			ch->CmdPRIVMSG(ch->ChannelName() + ' ' + s);
	}
}

void Channel::CmdALLME(CString s)
{
POSITION	iter;
CString		dummy;

	for (iter=m_server->m_chans.GetStartPosition(); iter; )
	{
	AppShell *appsh;
	Channel	*ch;

		m_server->m_chans.GetNextAssoc(iter, dummy, appsh);
		if (!appsh)	AfxThrowInternalException();

		ch= &appsh->m_channel;
		if (ch->wid())
			ch->CmdCTCPACTION(s);
	}
}

void Channel::CmdNOTICE(CString s)
{
	NoticePrivmsgCommon("NOTICE", s);
}

void Channel::CmdPRIVMSG(CString s)
{
	NoticePrivmsgCommon("PRIVMSG", s);
}

void Channel::NoticePrivmsgCommon(CString token, CString s)
{
int	i;
CString	msg;

	if ((i=s.Find(' ')) >= 0)
	{
		msg=s.Mid(i+1);
		s=s.Left(i);
	}

	m_args.SetSize(3);
	m_args[0]=m_currentnick;
	m_args[1]=s;
	m_args[2]=msg;

	// Here's how we format things:
	//
	// NOTICE - MYNOTICE
	// PRIVMSG on a channel, or in a private window - MYMESSAGE
	// PRIVMSG to a nick - MYPRIVMSG

CString	msgtype;

	msgtype="MY"+token;

	if (token == "PRIVMSG" && IsChannel())
		if (m_args[1] == ChannelName())
			msgtype="MYMESSAGE";

	LogStrMessage(msgtype, m_args);
	AddWriteQueue(token + ' ' + s + " :" + msg);
}

void Channel::CmdCTCP(CString s)
{
	CmdCTCP_Common(FALSE, s);
}

void Channel::CmdCTCPACK(CString s)
{
	CmdCTCP_Common(TRUE, s);
}

void Channel::CmdCTCP_Common(AFXBOOL isReply, CString s)
{
int	i;

	m_args.SetSize(4);
	if ((i=s.Find(' ')) < 0)
	{
		badcmd();
		return;
	}
	m_args[0]=m_currentnick;
	m_args[1]=s.Left(i);
	s=s.Mid(i);
	s.TrimLeft();
	if ((i=s.Find(' ')) < 0)
		i=s.GetLength();
	m_args[2]=s.Left(i);
	m_args[3]=s.Mid(i+1);

	SendCTCP(isReply, m_args[1], s);
	LogStrMessage("MYCTCP", m_args);
}

void Channel::SendCTCP(AFXBOOL isReply, CString nick, CString cmd)
{
	if (isReply && m_server->m_writeQueue.GetCount() >= m_flood_stop)
		return;	// Drop CTCP acknowledgements if we're getting
			// backed up.

int i=cmd.Find(' ');

	if (i < 0)	i=cmd.GetLength();

Cctcp	ctcp_cmd;

	{
	Cctcp_token ctcp_token;

		ctcp_token.m_command=cmd.Left(i);
		ctcp_token.m_value=cmd.Mid(i+1);
		ctcp_cmd.m_tokens.AddTail(ctcp_token);
	}

	AddWriteQueue((isReply ? "NOTICE ":"PRIVMSG ") + nick
			+ " :" + ctcp_cmd.Encode());
}

void Channel::CmdCTCPACTION(CString s)
{
	if (!IsChannel())
	{
		badcmd();
		return;
	}

	m_args.SetSize(3);
	m_args[0]=m_currentnick;
	m_args[1]=ChannelName();
	m_args[2]=s;
	SendCTCP( FALSE,
		ChannelName(), "ACTION " + s);
	LogStrMessage("CTCPACTION", m_args);
}

void Channel::CmdCTCPPING(CString s)
{
char	buf[40];
ostrstream o(buf, sizeof(buf));

	if (s.GetLength() == 0)
	{
		badcmd();
		return;
	}

time_t	t;

	time(&t);

	o << t << '\0';

	m_args.SetSize(4);
	m_args[0]=m_currentnick;
	m_args[1]=s;
	m_args[2]="PING";
	m_args[3]="";

	SendCTCP(FALSE, m_args[1], CString("PING ") + o.str());
	LogStrMessage("MYCTCP", m_args);
}

void Channel::CmdCTCPFINGER(CString s)
{
	if (s.GetLength() == 0)
	{
		badcmd();
		return;
	}

	m_args.SetSize(4);
	m_args[0]=m_currentnick;
	m_args[1]=s;
	m_args[2]="FINGER";
	m_args[3]="";
	SendCTCP(FALSE, m_args[1], m_args[2]);
	LogStrMessage("MYCTCP", m_args);
}

void Channel::CmdCTCPVERSION(CString s)
{
	if (s.GetLength() == 0)
	{
		badcmd();
		return;
	}

	m_args.SetSize(4);
	m_args[0]=m_currentnick;
	m_args[1]=s;
	m_args[2]="VERSION";
	m_args[3]="";
	SendCTCP(FALSE, m_args[1], m_args[2]);
	LogStrMessage("MYCTCP", m_args);
}

void Channel::CmdCTCPSOURCE(CString s)
{
	if (s.GetLength() == 0)
	{
		badcmd();
		return;
	}

	m_args.SetSize(4);
	m_args[0]=m_currentnick;
	m_args[1]=s;
	m_args[2]="SOURCE";
	m_args[3]="";
	SendCTCP(FALSE, m_args[1], m_args[2]);
	LogStrMessage("MYCTCP", m_args);
}

void Channel::CmdCTCPUSERINFO(CString s)
{
	if (s.GetLength() == 0)
	{
		badcmd();
		return;
	}

	m_args.SetSize(4);
	m_args[0]=m_currentnick;
	m_args[1]=s;
	m_args[2]="USERINFO";
	m_args[3]="";
	SendCTCP(FALSE, m_args[1], m_args[2]);
	LogStrMessage("MYCTCP", m_args);
}

void Channel::CmdCTCPCLIENTINFO(CString s)
{
	if (s.GetLength() == 0)
	{
		badcmd();
		return;
	}

int	i=s.Find(' ');

	if (i < 0)	i=s.GetLength();

	m_args.SetSize(4);
	m_args[0]=m_currentnick;
	m_args[1]=s.Left(i);
	m_args[2]="CLIENTINFO";
	m_args[3]=s.Mid(i+1);
	SendCTCP(FALSE, m_args[1], m_args[2] + " :" + m_args[3]);
	LogStrMessage("MYCTCP", m_args);
}

void Channel::CmdTOPIC(CString s)
{
CString	channel=CmdGetChannel(s);

	if (channel.GetLength() == 0)
	{
		badcmd();
		return;
	}

	s.TrimLeft();
	if (s.GetLength() > 0)	s = " :"+s;
	AddWriteQueue("TOPIC " + channel + s);
}

void Channel::CmdCTCPTIME(CString s)
{
	if (s.GetLength() == 0)
	{
		badcmd();
		return;
	}

	m_args.SetSize(4);
	m_args[0]=m_currentnick;
	m_args[1]=s;
	m_args[2]="TIME";
	m_args[3]="";
	SendCTCP(FALSE, m_args[1], m_args[2]);
	LogStrMessage("MYCTCP", m_args);
}

void Channel::CmdMODE(CString s)	// MODE command
{
	// Shortcut: if command is issued without a channel/nick name, prepend
	// ours

	switch (*(const char *)s)	{
	case '+':
	case '-':
		if (IsChannel())
			s=ChannelName() + ' ' + s;
		else
			s=m_currentnick + ' ' + s;
		break;
	}

	AddWriteQueue("MODE " + s);
}

void Channel::CmdRAW(CString s)	// RAW server command
{
	m_args.SetSize(1);
	m_args[0]=s;
	LogStrMessage("RAW", m_args);
	AddWriteQueue(s);
}

void Channel::List()
{
	CmdLIST("");
}

void Channel::CmdLIST(CString s) // List command
{
	AddWriteQueue("LIST " + s);
}

/////////////////////////////////////////////////////////////////////

void Channel::EditCut()
{
Widget	w=XmGetFocusWidget(wid());

	if (ExmIsBase(w))
		XtCallActionProc (w, "ExmBaseCut", NULL, NULL, 0);
	else if (XmIsText(w))
		XmTextCut(w, 0);
}

void Channel::EditCopy()
{
Widget	w=XmGetFocusWidget(wid());

	if (ExmIsBase(w))
		XtCallActionProc (w, "ExmBaseCopy", NULL, NULL, 0);
	else if (XmIsText(w))
		XmTextCopy(w, 0);
}

void Channel::EditPaste()
{
Widget	w=XmGetFocusWidget(wid());

	if (ExmIsBase(w))
		XtCallActionProc (w, "ExmBasePaste", NULL, NULL, 0);
	else if (XmIsText(w))
		XmTextPaste(w);
}

void Channel::CmdLOGOPEN(CString s)	// Open log file.
{
	if (s.GetLength() == 0)
		LogFileDefault(s);

int	fd=open( s, O_WRONLY | O_APPEND | O_CREAT, 0666);

	if (fd < 0)
	{
		LogErrnoMsg(errno);
		return;
	}

	LogStrMessage("LOGSTART");
int	old_fd=m_logfile.fd();
	m_logfile.fd(fd);
	if (old_fd >= 0)
		close(old_fd);
	LogFileTimestamp();
}

void Channel::CmdLOGCLOSE(CString)	// Close log file.
{
int	old_fd=m_logfile.fd();

	m_logfile.fd(-1);
	if (old_fd >= 0)
	{
		close(old_fd);
		LogStrMessage("LOGEND");
	}
}

void Channel::CmdSV(CString)	// Show version
{
	if (!IsChannel())
	{
		badcmd();
		return;
	}
	m_args.SetSize(2);
	m_args[0]=m_currentnick;
	m_args[1]=VersionString();

char *	p=m_args[1].GetBuffer();	// For output, replace : with /

	for (; *p; p++)
		if (*p == ':')	*p='/';
	m_args[1].ReleaseBuffer();

CXmString	xm(GetStrMessage("SHOWVERMSG", m_args));

	LogStrMessage("SHOWVER", m_args);
	SendCTCP( FALSE,
		ChannelName(), "ACTION " + (CString)xm);
}

void Channel::CmdMESSAGE(CString s)	// Show messages
{
	m_args=CStringTok(s, " ");
	if (m_args.GetSize() == 0)	// Show the list first
	{
	POSITION	pos;
	AFXBOOL	dummy;

		m_args.SetSize(1);
		for (pos=m_suppressmap.GetStartPositionSorted(); pos; )
		{
			m_suppressmap.GetNextAssocSorted(pos,m_args[0], dummy);
			LogStrMessage("SUPPRESSED", m_args);
		}
		m_args.SetSize(0);
		LogStrMessage("ENDSUPPRESSED");
		return;
	}

	m_args[0].MakeUpper();
	if (m_args.GetSize() > 1 &&
		(m_args[1].MakeUpper(), m_args[1]) == "ON")
	{
		m_suppressmap.RemoveKey(m_args[0]);
		m_args.SetSize(1);
		LogStrMessage("SUPPRESSOFF", m_args);
	}
	else
	{
		m_suppressmap[m_args[0]]=TRUE;
		m_args.SetSize(1);
		LogStrMessage("SUPPRESSON", m_args);
	}
}

void Channel::CmdFLOOD(CString flood)	// Set flood parameters
{
char	buf[20];
CStringArray	flood_args=CStringTok(flood, " ");
unsigned	params[4], i;

	params[0]=m_flood_messages;
	params[1]=m_flood_seconds;
	params[2]=m_flood_delay;
	params[3]=m_flood_stop;

	flood_args.SetSize(4);
	for (i=0; i<4; i++)
	{
	const char *	p=flood_args[i];
	unsigned v=0;

		if (p)
			v=atoi(p);
		if (v)	params[i]=v;
	}

	if (params[0] == 0)	params[0]=1;
	if (params[0] > 99)	params[0]=99;
	if (params[1] < 5)	params[1]=5;
	if (params[1] > 99)	params[1]=99;
	if (params[2] < 2)	params[2]=2;
	if (params[2] > 19)	params[2]=19;
	if (params[3] < 10)	params[3]=10;
	if (params[3] > 99)	params[3]=99;

	m_flood_messages=params[0];
	m_flood_seconds=params[1];
	m_flood_delay=params[2];
	m_flood_stop=params[3];
	FloodReset();
	m_args.SetSize(4);
	for (i=0; i<4; i++)
	{
	ostrstream	o(buf, sizeof(buf));

		o << params[i] << '\0';
		m_args[i]=buf;
	}

	LogStrMessage("FLOOD", m_args);
}

void Channel::CmdWINDOW(CString cmd)	// Window command.
{
	cmd.MakeLower();

CStringArray	args=CStringTok(cmd, " ");

	args.SetSize(2);

	if ( (const char *)args[1] == 0)
		args[1]="";

	if (args[0] == "iconify")
		m_shell->Iconify();
	else if (args[0] == "deiconify")
		m_shell->DeIconify();
	else if (args[0] == "autoiconify")
	{
	unsigned	n=atoi(args[1]);

		if (n < 5)	n=5;	// Stupid user
		m_shell->AutoIconify(n);
		LogStrMessage( (n ? "AUTOICONIFY":"NOAUTOICONIFY"),
				args[1]);
	}
	else if (args[0] == "autoclose")
	{
	unsigned	n=atoi(args[1]);

		if (n < 5)	n=5;	// Stupid user
		m_shell->AutoClose(n);
		LogStrMessage( (n ? "AUTOCLOSE":"NOAUTOCLOSE"),
				args[1]);
	}
	else if (args[0] == "autodeiconify")
	{
	int	n=atoi(args[1]);

		m_shell->AutoDeIconify(atoi(args[1]));
		LogStrMessage( n ? "AUTODEICONIFY":"NOAUTODEICONIFY");
	}
}
