// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	channel_h
#define	channel_h

static const char channel_h_rcsid[]="$Id: channel.h,v 1.15 1999/04/12 04:39:47 mrsam Exp $";

#include	"afx.h"
#include	"afxtempl.h"
#include	"widget/widget.h"
#include	"widget/widgetprim.h"
#include	"widget/widgetlist.h"
#include	"widget/widgetpane.h"
#include	"widget/widgetscroll.h"
#include	"widget/widgetlineinput.h"
#include	"widget/widgettimer.h"
#include	"cmdline.h"
#include	"ctcp.h"
#include	"bot.h"
#include	"mytime.h"

class	Channel;
class	CXmString;
class	AppShell;
class	ChannelListing;
class	OpenServerForm;
class	ChannelMemberList;
class	Config;
class	ChannelMenu;
class	ChannelEditForm;
class	CLogWindowWidget;
class	ChannelLogWidget;
class	CLinksList;
class	CHelpSetupForm;
class	CLogFileDialog;
class	CBotListForm;
class	ChannelInfoForm;
class	NickChangeForm;

inline AFXBOOL IsChannelName(CString s)
{
const char *	p=s;

	return (*p == '#' || *p == '&');
}

// Per RFC1459, {}| are lowercase equivalents of []\ chars

CString	IrcLower(CString);

/////////////////////////////////////////////////////////////////////////
//
// The channel widget.  This is where things get interesting.

class	Channel : public CFormWidget {

static CMap<CString, CString, void (Channel::*)(CString),
				void (Channel::*)(CString) > cmdtab, globcmdtab;
static CMap<CString, CString, void (Channel::*)(), void (Channel::*)() > rpltab;

	CAfxAutoObj<ChannelMenu>	m_menu;

	// This is my main work area:

	CPanedWindowWidget	pane;	// Pane for the log & members widgets

	CFormWidget		log_pane;
	CAfxAutoObj<ChannelLogWidget> log;
	CScrollBarWidgetRedirect<CLogWindowWidget>
				log_scroll;

	CScrollWindowWidget	members_scroll;
	CListWidget		members;
	CSeparatorWidget	sep1;
	Cmdline			cmdline;	// Command line

	CAfxAutoObj<ChannelMemberList>	m_members_list;
						// List of channel members

	Cctcp			m_cmds;		// Pending CTCP commands/notices
	CEvent<Channel>		m_cmdevent;	// Event handler for m_cmds

	CAfxAutoObj<Config>	m_config;	// Configuration file

	// These are my dialogs

	CAfxAutoObj<OpenServerForm> m_openform;
	CAfxAutoObj<ChannelEditForm>	m_join_form, m_names_form, m_help_form;
	CAfxAutoObj<CLinksList>		m_links;	// The links list
	CAfxAutoObj<CLogFileDialog>	m_logfile_dialog;	// File requester
	CAfxAutoObj<CBotListForm>	m_bot_list;
	CAfxAutoObj<ChannelInfoForm>	m_channel_info;
	CAfxAutoObj<NickChangeForm>	m_nick_change;

	CXmInput<Channel>	m_logfile;
							// Log file
	time_t			m_logfile_time;

	CString	m_curhost, m_port, m_nick, m_altnick, m_password, m_user;
public:
	CString m_connecthost;
private:
				// Connection parameters
	CString m_myhost;	// And this is me.

	CString	m_command;	// Current command, uppercased
	CString	m_reply;	// Current reply
public:
	CXmLineInput<class Channel, CXmInput<class Channel> > m_socket;
				// The socket. (Appshell needs access)
private:

	AFXBOOL	m_connected;	// If TRUE, socket succesfully connected.
	AFXBOOL	m_connecting;	// If TRUE, connection is in progress.
public: // Needed by AppShell
	CString	m_currentnick;	// Current nickname in use
	CString m_currenttopic;	// Current channel topic
	CString m_currentmode;	// Current mode
private:
	AFXBOOL	m_registered;	// If TRUE, the server appeared to register us
	void	ProcessMode(CString);
	void	SetTitle();
public:
	Channel	*m_server;	// Points to myself if this is a server channel,
				// if not, points to the server channel.
	AppShell *m_shell;	// My shell widget
				// If this is a server window, here are
				// all the channels I'm on
	CMap<CString, CString, AppShell *, AppShell *> m_chans;
	Channel		*FindChannel(CString);
	CList<CBot, const CBot &> m_bots;	// Currently running bots.
	CStringList	m_recent_departures;	// Recent departures from
						// this channel.
#define CHANNEL_RECENTDEPARTURES_LISTSIZE	10
private:
	CAfxAutoObj<ChannelListing> m_channel_list;
						// When we're displaying
						// output of LIST command.

	AFXBOOL	m_selfdestruct;
				// If TRUE, we self destruct after socket is
				// closed...
	AFXBOOL	m_quitsent;	// If TRUE, QUIT was already sent.

	// Flood control parameters

	unsigned m_flood_messages, m_flood_seconds, m_flood_delay,
		m_flood_stop;

	CArray<time_t, time_t>	m_flood_timestamps; // Times of last n msgs
	size_t	m_flood_t_cnt;	// How many timestamps we have
	size_t	m_flood_t_head;	// Head
	size_t	m_flood_t_tail;	// Tail
	CXmTimeout<Channel>	m_flood_timeout; // Timeout event
	void	FloodReset();
	void	FloodTimeout();

	void	OnDestroy();

	CString	UserName();	// Return m_user, or default
	CString	ConfigNickName(); // Return m_nick, or default
				// Public because AppShell needs it

public:	// Needed by AppShell
	AFXBOOL	IsChannel();	// Convenient macro: true if this is actually
				// a channel.
	AFXBOOL	IsPrivateChannel()	// True if this is a private channel
		{
			return (IsChannel() && !IsChannelName(ChannelName()));
		}
	CString	ChannelName();	// Convenient macro
private:
	void	RegisterNick(CString);	// Using a new nickname now.
	CString UnixUserId();	// What's my userid?
public:
	Channel(const char *name);
	~Channel();

	void Create(AppShell *parent);
private:
	static void installmap();
public:
	void Command(CString, CBot *);

	void LogErrno();
	void LogErrnoMsg(int);
	void LogFileString(CString);
	void LogFileTimestamp();
	void LogMessage(CString, const char *);
	void LogMessage(CXmString &);
	void LogStrMessage(CString);
	void LogStrMessage(CString, CString);
	void LogStrMessage(CString, CString, CString);
	void LogStrMessage(CString, const CStringArray &);
	CXmString GetStrMessage(CString, const CStringArray &);
	void SetFocus();

	void EditCut(), EditCopy(), EditPaste();

	void Connect();
	void quit();
	void quitnotitle();
	void Exit();
	AFXBOOL IsConnected();
private:
	void NickChange(CString, CString);
	void ReadSocket(CString line);
	CString WriteSocket();
public:
	void	AddWriteQueue(CString, AFXBOOL=FALSE);
private:

	void SplitReply(CString line);
	CStringList m_writeQueue;	// Current queue awaiting to be written
	CStringList m_replycmd;		// Current reply command
	CString	m_replysource;		// Current reply source
	CStringArray m_args;		// Convenient array.

	CMap<CString, CString, CString, CString>	m_whoismap;
		// Bans are implemented by doing a WHOIS first.  This map
		// keeps track of all nicks that are being WHOISed for a ban.
		// The key is the nickname, in lowercase.  The argument
		// is "#channel<space>mode"

	CMap<CString, CString, AFXBOOL, AFXBOOL>	m_ignoremap;
		// List of NICKs we are ignoring.

	CMap<CString, CString, AFXBOOL, AFXBOOL>	m_suppressmap;
		// List of messages we will not show.

	// Commands

	CString Pop();
	void badcmd();

	void CmdRUN(CString);
	void CmdSERVER(CString);
	void CmdPLAY(CString);
	void CmdAUTOPLAY(CString);
	void ServerCmdSERVER(CString);
	void CmdQUIT(CString);
	void ServerCmdQUIT(CString);
	void CmdNICK(CString);
	void CmdWHO(CString);
	void CmdJOIN(CString);
	void CmdMODE(CString);
	void CmdNOTICE(CString);
	void CmdPRIVMSG(CString);
	void CmdCTCP(CString);
	void CmdCTCPACK(CString);
	void CmdCTCPACTION(CString);
	void CmdTOPIC(CString);
	void CmdRAW(CString);
	void CmdLIST(CString);
	void CmdINVITE(CString);
	void CmdAWAY(CString);
	void CmdLINKS(CString);
	void CmdSV(CString);
	void CmdALLME(CString);
	void CmdALLMSG(CString);
	void CmdMESSAGE(CString);
	void List();
	CString	CmdGetChannel(CString &);

	CString	VersionString();

public:
	void CmdWHOIS(CString);
	void CmdCTCPPING(CString);
	void CmdCTCPFINGER(CString);
	void CmdCTCPVERSION(CString);
	void CmdCTCPSOURCE(CString);
	void CmdCTCPUSERINFO(CString);
	void CmdCTCPCLIENTINFO(CString);
	void CmdCTCPTIME(CString);
	void CmdKICK(CString);
	void CmdBAN(CString);
	void CmdIGNORE(CString);
	void CmdUNIGNORE(CString);
	void CmdLOGOPEN(CString);
	void CmdLOGCLOSE(CString);
	void CmdFLOOD(CString);
	void CmdCLEAR(CString);
	void CmdWINDOW(CString);
private:
	void CmdCTCP_Common(AFXBOOL, CString);
	void SendCTCP(AFXBOOL, CString, CString);
	void NoticePrivmsgCommon(CString, CString);

public:	// Needed by AppShell
	void CmdPART(CString);
private:
	void CmdPARTMenu();
	void CmdNAMES(CString);

	// Replies

	void ReplyPING();
	void ReplyNICK();
	void GlobalReplyNumeric();
	void GlobalReplyNumericChannel();
	void ReplyNumeric();
	void ReplyForNick();
	void GlobalReplyForNick();
	void Reply311();
	void Reply321();
	void Reply322();
	void Reply323();
	void Reply324();
	void Reply332();
	void Reply353();
	void Reply364();
	void Reply365();
	void Reply401();
	void ReplyJOIN();
	void ReplyPART();
	void ReplyKICK();
	void ReplyQUIT();
	void ReplyNOTICE();
	void ReplyPRIVMSG();
	void Reply_CTCP_ACTION();
	void ReplyTOPIC();
	void ReplyKILL();
	void Reply_CTCP_PING();
	void Reply_CTCPACK_PING();
	void ReplyMODE();

	void Reply_CTCP_FINGER();
	void Reply_CTCP_VERSION();
	void Reply_CTCP_SOURCE();
	void Reply_CTCP_USERINFO();
	void Reply_CTCP_CLIENTINFO();
	void Reply_CTCP_TIME();
	void Reply_CTCP_ERRMSG();
	void Reply_CTCPACK_FINGER();
	void Reply_CTCPACK_VERSION();
	void Reply_CTCPACK_SOURCE();
	void Reply_CTCPACK_USERINFO();
	void Reply_CTCPACK_CLIENTINFO();
	void Reply_CTCPACK_TIME();
	void Reply_CTCPACK_ERRMSG();

	void GlobalReply( void (Channel::*)() );
	void GlobalReplyNICK();
	void GlobalReplyJOIN();
	void GlobalReplyPART();
	void GlobalReplyKICK();
	void GlobalReplyQUIT();
	void ProcessCTCPReply();

	void FormatErrmsg(CString cmd, CString msg);

static	void SourceToNickUser(CString, CString &, CString &);
public:
static	CString CalculateBan(char, CString, CString, CString);
	// Callbacks

	void OpenConnectionFormOpen();
private:
	void OpenNewServer();
	void Links();
	void OpenConnectionFormClose(AFXBOOL);
public:
	void OpenServerListClick(int, int *, XmString *, int);
	void OpenServerListDoubleClick(int n, int *, XmString *, int);
private:
	void JoinFormOpen();
	void NamesFormOpen();
	void JoinFormClose(AFXBOOL);
	void NamesFormClose(AFXBOOL);
	void HelpFormOpen();
	void HelpFormClose(AFXBOOL);
	void HelpContents();

	void LogFileOpen();
	void BotListOpen();

	void ChannelInfoOpen();
public:
	void LogFileOpenOk();
	void LogFileOpenCancel();
private:
	void LogFileClose();
	void LogFileDefault(CString &);
public:
	void BotOutput(CBot *, CString);
	void BotErr(CBot *, CString);

	void QueueBot(CString, const CStringArray &);
	AFXBOOL StartBot(CString, CString);
	void DoStartBot(const char *, const char *, const char *);

	void prepbotmsg(CBot *);
	void EndBot(CBot *);
	void TimerBot(CBot *, CString);
} ;

///////////////////////////////////////////////////////////////////////
//
// Various renditions for the log window:

#define	LOG_DEFAULT	"default"	// Normal conversation/output
#define	LOG_STATUS	"status"	// Server status: connect/disconnect
#define	LOG_ERROR	"error"		// Errors

#endif
