// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	"bot.h"
#include	"channel.h"
#include	"afxdebug.h"
#include	<iostream.h>

CBot::CBot() : m_pos(0), m_pid(0), m_xoff(FALSE), m_channel(0)
{
}

CBot::CBot(const CBot &c) : m_pos(0), m_pid(0), m_xoff(FALSE),
				m_channel(c.m_channel)
{
}

// Cleanup whatever we have open.

CBot::~CBot()
{
int	fd;

	if (m_fd0.Ptr())
	{
		fd=m_fd0->fd();
		if (fd >= 0)
		{
			m_fd0->fd(-1);
			close(fd);
		}
	}

	if (m_fd1.Ptr())
	{
		fd=m_fd1->fd();
		if (fd >= 0)
		{
			m_fd1->fd(-1);
			close(fd);
		}
	}

	if (m_fd2.Ptr())
	{
		fd=m_fd2->fd();
		if (fd >= 0)
		{
			m_fd2->fd(-1);
			close(fd);
		}
	}
}

// Allocate objects to handle I/O to bot process.

void	CBot::Create(Channel *ch)
{
	m_channel=ch;

	if (!m_ctcpcmds.Ptr() && !m_ctcpcmds.Init(
		new CMap<CString, CString, AFXBOOL, AFXBOOL>))
		AfxThrowMemoryException();

	if (!m_fd0.Ptr() && !m_fd0.Init(new CXmInput<CBot>))
		AfxThrowMemoryException();

	if (!m_fd1.Ptr() &&
		!m_fd1.Init(new CXmLineInput< CBot, CXmInput<CBot> >))
		AfxThrowMemoryException();

	if (!m_fd2.Ptr() &&
		!m_fd2.Init(new CXmLineInput< CBot, CXmInput<CBot> >))
		AfxThrowMemoryException();
}

// After the bot has been started, initialize I/O (must be separate from
// Create(), since we must first create the child process)

void CBot::Start()
{
	if (!m_fd0.Ptr() || !m_fd1.Ptr() || !m_fd2.Ptr())	return;
	*m_fd0.Ptr() = this;
	*m_fd1.Ptr() = this;
	*m_fd2.Ptr() = this;

	m_fd1.Ptr()->Read( &CBot::ReadStdout );
	m_fd2.Ptr()->Read( &CBot::ReadStderr );
}

// Just feed the output to the channel object.

void	CBot::ReadStdout(CString line)
{
TRACE_FUNCTION("CBot::ReadStdout");
	if (m_channel)	m_channel->BotOutput(this, line);
}

void	CBot::ReadStderr(CString line)
{
TRACE_FUNCTION("CBot::ReadStderr");
	if (m_channel)	m_channel->BotErr(this, line);
}

void	CBot::CloseStdout()
{
	if (!m_fd1.Ptr())	return;

int	fd=m_fd1.Ptr()->fd();

	m_fd1.Ptr()->fd(-1);
	if (fd >= 0)	close(fd);
}

void	CBot::CloseStderr()
{
	if (!m_fd2.Ptr())	return;

int	fd=m_fd2.Ptr()->fd();

	m_fd2.Ptr()->fd(-1);
	if (fd >= 0)	close(fd);
}

// We don't track process IDs, and don't wait for server bots to die.
// We ignore SIGCLD, and just wait for BOTH stdout and stderr to close.
// We wait for both of them to close to make sure that everything is
// processed.

AFXBOOL	CBot::BothClosed()
{
	return ( (!m_fd1.Ptr() || m_fd1.Ptr()->fd() < 0) &&
		(!m_fd2.Ptr() || m_fd2.Ptr()->fd() < 0) );
}

void		CBot::AddWrite(CString line)
{
TRACE_FUNCTION("CBot::AddWrite");
	if (m_xoff)	return;	// Transmission is off

	if (m_wqueue.IsEmpty())
		m_fd0.Ptr()->Write( &CBot::WriteBot );
	m_wqueue.AddTail(line);
}

CString		CBot::WriteBot()
{
TRACE_FUNCTION("CBot::WriteBot");
	if (m_wqueue.IsEmpty())	return ("");
	return (m_wqueue.RemoveHead());
}

void CBot::SetTimer(unsigned long nsecs)
{
TRACE_FUNCTION("CBot::SetTimer");
	m_timer=this;
	if (!nsecs)
	{
		m_timer.Cancel();
		AddWrite( "_CANCEL");
		return;
	}
	m_timer.Arm( &CBot::Timer, nsecs );
}

void CBot::Timer()
{
TRACE_FUNCTION("CBot::Timer");
	AddWrite("_TIMEOUT\n");
}
