// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#include	<string.h>
#include	<stdio.h>
#if HAVE_CONFIG_H
#include	"config.h"
#endif
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"afx.h"

static const char rcsid[]="$Id: exception.C,v 1.5 1999/04/06 06:38:08 mrsam Exp $";

// Various exception classes

const char * CException::GetErrorMessage()
{
	return ("ERROR: Program exception.");
}

int CException::GetErrorNumber()
{
	return (0);
}

void CException::ReportError()
{
const char * p=GetErrorMessage();

	write(2, p, strlen(p)*sizeof(*p));
	if (m_module || m_line)
	{
		write(2, " (", 2);
		if (m_module)
		{
			write(2, "file ", 5);
			write(2, m_module, strlen(m_module)*sizeof(*m_module));
			if (m_line)
				write(2, ", ", 2);
		}
		if (m_line)
		{
		char	buf[40];

			sprintf(buf, "%d", m_line);
			write(2, "line ", 5);
			write(2, buf, strlen(buf));
		}
		write(2, ")", 1);
	}
	write(2, "\n", 1);
}

static CSimpleException out_of_memory("ERROR: Out of memory.");
static CSimpleException internal("ERROR: Internal error detected.");

void AfxThrowMemoryException()
{
	out_of_memory.Throw();
}

void Afx_ThrowInternalException(const char *module, int line)
{
	internal.m_module=module;
	internal.m_line=line;
	internal.Throw();
}

