// DSTART 
// SmIRC - an X11R6/Motif 2.0 IRC client for Linux 
//  
// Current version is 0.70 
//  
// Copyright 1997-1999, Double Precision, Inc. 
//  
// This program is distributed under the terms of the GNU General Public 
// License. See COPYING for additional information. 
//  
// DEND 
#ifndef	afxdebug_h
#define	afxdebug_h

static const char afxdebug_h_rcsid[]="$Id: afxdebug.h,v 1.4 1999/05/03 12:17:25 mrsam Exp $";

#ifdef	DEBUG

#include	"afxtempl.h"
#include	<iostream.h>

class	AfxDebug	{
	CStringArray	m_debugmodes;
public:
	void	Init(CString modes)
		{
			m_debugmodes=CStringTok(modes, ",");
		}
	AFXBOOL	HasMode(CString m)
		{
		size_t l=m_debugmodes.GetSize();
		size_t i;

			for (i=0; i<l; i++)
				if (m == m_debugmodes[i])
					return (TRUE);
			return (FALSE);
		}
} ;

extern AfxDebug afxdebug;	// Must declare in your main

#define IFDEBUG(name, action) if (afxdebug.HasMode(name)) { action }
#else
#define IFDEBUG(name, action)
#endif

#define TRACE(x)	IFDEBUG("trace", cout << __FILE__ << '(' \
				<< __LINE__ << "): " << x << endl; )

#ifdef	DEBUG
class	AfxDebugFunction {
	const char *m_name;
public:
	AfxDebugFunction(const char *name) : m_name(name)
		{
			IFDEBUG("func", cout << "Entering " << m_name << endl;)
		}
	~AfxDebugFunction()
		{
			IFDEBUG("func", cout << "Exiting " << m_name<< endl;)
		}
} ;

#define	TRACE_FUNCTION(name) AfxDebugFunction debug_function(name);
#else
#define	TRACE_FUNCTION(name)
#endif

#endif
