/******************************************************************************
 Functions coded by Flier (THANX to Sheik!!)

 CheckInvite         Checks signon user against list and invites if possible
 BuildPrivs          Returns privilege as flags
 AutoNickComplete    Completes the nick at the beginning of the input line
 RemoveFromDCCList   Removes nick from DCC list
 CheckPermBans       Checks if permanent ban isn't there
 ShowScrollZVersion  Shows the world what you are using
 TraceKill           Does trace then kills users matching filter
 Map                 Generates map of IRC servers
 AddToMap            Stores map info to memory
 PrintMap            Prints map info
 FindShit            Updates pointer to shit list
 CheckTimeMinute     Checks for things every minute
 CheckJoinChannel    Checks join to channel
 AddFriendPrivs      Adds/removes flags for userlist entries
 AddFriendChannel    Adds/removes channels for userlist entries
 ShowHelpLine        Prints a line of help text
 MassKick            Kickc multiple nicks at the same time
 ServerPing	     Pings a server for precise lag time accros net - Zakath
 OnOffCommand        Sets ScrollZ settings (on/off)
 NumberCommand       Sets ScrollZ settings (number)
 ChannelCommand      Sets ScrollZ settings (on channels/off)
 Usage               Prints usage for command
 ConvertmIRC         Converts mIRC colors to ANSI
 ScrollZTrace        Sends TRACE command, allows for switches - by Zakath
 HandleTrace         Formats TRACE - by Zakath
 ColorUserHost       Colorizes user@host
 AddChannel          Adds/removes channels to ScrollZ settings
 HashFunc            Used to calculate hash value
******************************************************************************/

#include "irc.h"
#include "crypt.h"
#include "vars.h"
#include "ircaux.h"
#include "lastlog.h"
#include "window.h"
#include "whois.h"
#include "hook.h"
#include "input.h"
#include "ignore.h"
#include "keys.h"
#include "list.h"
#include "names.h"
#include "alias.h"
#include "history.h"
#include "funny.h"
#include "ctcp.h"
#include "dcc.h"
#include "translat.h"
#include "output.h"
#include "notify.h"
#include "numbers.h"
#include "status.h"
#include "screen.h"
#include "server.h"
#include "edit.h"
#include "struct.h"
#include "myvars.h" 
#include "whowas.h"

#ifndef __EMX__
void CheckJoinChannel _((WhoisStuff *, char *, char *));
#endif
void PrintUsage _((char *));

extern NickList *CheckJoiners _((char *, char *, int , ChannelList *));
extern struct friends *CheckUsers _((char *, char *));
extern void PrintSetting _((char *, char *, char *, char *));
extern int  CheckChannel _((char *, char *));
extern void FServer _((char *, char *, char *));
extern void SetAway _((char *, char *, char *));
extern void NotChanOp _((char *));
extern void NoWindowChannel _((void));
extern void AutoJoinOnInvToggle _((char *, char *, char *));
extern void NHProtToggle _((char *, char *, char *));
extern int  matchmcommand _((char *, int));
/* Patched by Zakath */
extern void ToolieAway _((void));

extern void e_channel _((char *, char *, char *));
extern void e_nick _((char *, char *, char *));

/* Patched by Zakath */
#ifdef TOOLIE
static int TraceAll=1;
static int TraceOper=0;
static int TraceServer=0;
static int TraceClass=0;
static int TraceUser=0;
#endif
/* ***************** */

static int  FilterKillNum;
static char *tkillreason=(char *) 0;
static char *tkillpattern=(char *) 0;
static struct mapstr *map=NULL;

static struct commands {
    char *command;
    int  *var;
    char **strvar;
    char *setting;
    char *setting2;
} command_list[]= {
    { "AJOIN"       , &AutoJoinOnInv  , &AutoJoinChannels    , NULL                         , NULL },
    { "AREJOIN"     , &AutoRejoin     , &AutoRejoinChannels  , "Auto rejoin"                , NULL },
    { "AUTOCOMPL"   , &AutoNickCompl  , &AutoReplyString     , "Auto nick completion"       , ", right side string is" },
    { "BITCH"       , &Bitch          , &BitchChannels       , "Bitch mode"                 , NULL },
    { "DPROT"       , &MDopWatch      , &MDopWatchChannels   , "Mass deop watch"            , NULL },
    { "FAKE"        , &ShowFakes      , &ShowFakesChannels   , "Fake modes display"         , NULL },
    { "FRLIST"      , &FriendList     , &FriendListChannels  , "Friend list"                , NULL },
    { "KICKONBAN"   , &KickOnBan      , &KickOnBanChannels   , "Kick on ban"                , NULL },
    { "KICKONFLOOD" , &KickOnFlood    , &KickOnFloodChannels , "Kick on flood"              , NULL },
    { "KICKOPS"     , &KickOps        , &KickOpsChannels     , "Kick channel operators"     , NULL },
    { "KPROT"       , &KickWatch      , &KickWatchChannels   , "Mass kick watch"            , NULL },
    { "NHPROT"      , &NHProt         , &NHProtChannels      , NULL                         , NULL },
    { "NPROT"       , &NickWatch      , &NickWatchChannels   , "Nick flood watch"           , NULL },
    { "ORIGNICK"    , &OrigNickChange , &OrigNick            , "Reverting to original nick" , ", wanted nick :" },
    { "SHOWAWAY"    , &ShowAway       , &ShowAwayChannels    , "Notifying on away/back"     , NULL },
    { NULL          , NULL            , NULL                 , NULL                         , NULL }
};

#ifdef EXTRAS
extern char *CToolzlame1;
extern char VersionInfo[];
#endif
#ifndef __EMX__
extern char *chars;
#endif

extern DCC_list *ClientList;

#if defined(EXTRAS) || defined(FLIER)
/* Checks if signed on user should be invited */
void CheckInvite(nick,userhost,server)
char *nick;
char *userhost;
int  server;
{
    char tmpbuf[mybufsize/4];
    NickList *tmpnick;
    ChannelList *tmpchan;
    struct friends *tmpfriend;

    if (AutoInv) {
        sprintf(tmpbuf,"%s!%s",nick,userhost);
        for (tmpchan=server_list[server].chan_list;tmpchan;tmpchan=tmpchan->next)
#if defined(ACID) || defined(FLIER)
            if ((tmpchan->status)&CHAN_CHOP) {
#else
            if (((tmpchan->status)&CHAN_CHOP) && ((tmpchan->mode)&MODE_INVITE)) {
#endif
                tmpnick=find_in_hash(tmpchan,nick);
                if (!tmpnick && (tmpfriend=CheckUsers(tmpbuf,tmpchan->channel)) &&
                    !(tmpfriend->passwd) &&
#ifdef ACID
                    ((tmpfriend->privs)&1))
#else
                    ((tmpfriend->privs)&23)==23)
#endif
                        send_to_server("INVITE %s %s",nick,tmpchan->channel);
            }
    }
}
#endif

/* Returns privilege as flags */
void BuildPrivs(user,buffer)
struct friends *user;
char *buffer;
{
    if (user && user->privs) {
        if ((user->privs)&1) strcat(buffer,"I");
        if ((user->privs)&2) strcat(buffer,"C");
        if ((user->privs)&256) strcat(buffer,"V");
        if ((user->privs)&4) strcat(buffer,"O");
        if ((user->privs)&8) strcat(buffer,"A");
        if ((user->privs)&16) strcat(buffer,"U");
        if ((user->privs)&32) strcat(buffer,"P");
        if ((user->privs)&64) strcat(buffer,"D");
        if ((user->privs)&128) strcat(buffer,"G");
        if ((user->privs)&512) strcat(buffer,"J");
        if ((user->privs)&1024) strcat(buffer,"F");
    }
}

/* Completes the nick at the beginning of the input line */
void AutoNickComplete(line,result,tmpchan)
char *line;
char *result;
ChannelList *tmpchan;
{
    int  len;
    char *tmp=AutoReplyString;
    char *mynick;
    char *tmpstr=result;
    char tmpbuf[mybufsize];
    NickList *nick=NULL;
    NickList *tmpnick;

    strcpy(result,line);
    if (*tmpstr==':') return;
    while (*tmpstr && *tmpstr>' ' && *tmpstr!=':') tmpstr++;
    if (*tmpstr==':') {
        *tmpstr='\0';
        tmpstr++;
        len=strlen(result);
        mynick=get_server_nickname(tmpchan->server);
        for (tmpnick=tmpchan->nicks;tmpnick;tmpnick=tmpnick->next)
            if (!my_strnicmp(tmpnick->nick,result,len) &&
                my_stricmp(mynick,tmpnick->nick)) {
                if (nick) break;
                nick=tmpnick;
            }
        if (!tmpnick && nick) {
            strcpy(tmpbuf,nick->nick);
            if (*tmpstr==' ' && tmp && *(tmp+1)==' ') tmpstr++;
            if (tmp && *tmp) strcat(tmpbuf,tmp);
            strcat(tmpbuf,tmpstr);
            strcpy(result,tmpbuf);
            return;
        }
    }
    strcpy(result,line);
}

/* Mangles string */
void MangleString(inbuf,outbuf,unmangle)
char *inbuf;
char *outbuf;
int  unmangle;
{
    int  i;
    int  j;
    int  l=strlen(chars);
    char *tmpstr1;
    char *tmpstr2;
    char *tmpstr3;
    char *tmpstr4;
    char *tmpstr5;
    char *tmpstr6;
    char tmpbuf1[mybufsize/2];
    char tmpbuf2[mybufsize/2];

    strcpy(tmpbuf2,CToolzlame);
    for (i=0,tmpstr5=tmpbuf2;i<3;tmpstr5++) if (*tmpstr5==' ') i++;
    for (i=0,tmpstr1=tmpstr5;i<3;tmpstr1++) if (*tmpstr1==' ') i++;
    tmpstr1--;
    tmpstr6=tmpstr1;
    *tmpstr1='\0';
    tmpstr6--;
    tmpstr1=inbuf;
    tmpstr2=tmpstr5;
    tmpstr3=tmpbuf1;
    while (*tmpstr1) {
        for (tmpstr4=chars,i=0;*tmpstr4;tmpstr4++,i++)
            if (*tmpstr4==*tmpstr1) break;
        if (!(*tmpstr4)) break;
        for (tmpstr4=chars,j=0;*tmpstr4;tmpstr4++,j++)
            if (*tmpstr4==*tmpstr2) break;
        if (!(*tmpstr4)) break;
        if (unmangle) {
            i-=j;
            if (i<0) i+=l;
            *tmpstr3=chars[i];
        }
        else *tmpstr3=chars[(i+j)%l];
        tmpstr1++;
        tmpstr2++;
        tmpstr3++;
        if (!(*tmpstr2)) tmpstr2=tmpstr5;
    }
    *tmpstr3='\0';
    tmpstr1=tmpbuf1;
    tmpstr2=tmpstr6;
    tmpstr3=outbuf;
    while (*tmpstr1) {
        for (tmpstr4=chars,i=0;*tmpstr4;tmpstr4++,i++)
            if (*tmpstr4==*tmpstr1) break;
        if (!(*tmpstr4)) break;
        for (tmpstr4=chars,j=0;*tmpstr4;tmpstr4++,j++)
            if (*tmpstr4==*tmpstr2) break;
        if (!(*tmpstr4)) break;
        if (unmangle) {
            i-=j;
            if (i<0) i+=l;
            *tmpstr3=chars[i];
        }
        else *tmpstr3=chars[(i+j)%l];
        tmpstr1++;
        tmpstr2--;
        tmpstr3++;
        if (tmpstr2<tmpstr5) tmpstr2=tmpstr6;
    }
    *tmpstr3='\0';
}

/* Removes nick from DCC list */
void RemoveFromDCCList(nick)
char *nick;
{
    DCC_list *Client;
    DCC_list *tmp;

    for (Client=ClientList;Client;Client=tmp) {
        tmp=Client->next;
        if (Client->user && !my_stricmp(nick,Client->user) &&
            !((Client->flags)&DCC_ACTIVE))
            dcc_erase(Client);
    }

}

/* Checks if permanent ban isn't there */
void CheckPermBans(chan)
ChannelList *chan;
{
    int  max=get_int_var(MAX_MODES_VAR);
    int  count=0;
    char *modes=(char *) 0;
    struct bans *tmpban;
    struct autobankicks *tmpabk;

    if (chan) {
        for (tmpabk=abklist;tmpabk;tmpabk=tmpabk->next) {
            if ((tmpabk->shit)&8) {
                if (!CheckChannel(chan->channel,tmpabk->channels)) continue;
                for (tmpban=chan->banlist;tmpban;tmpban=tmpban->next)
                    if (wild_match(tmpban->ban,tmpabk->userhost) ||
                        wild_match(tmpabk->userhost,tmpban->ban))
                        break;
                if (!tmpban) {
                    malloc_strcat(&modes," +b ");
                    malloc_strcat(&modes,tmpabk->userhost);
                    count++;
                    if (count==max) {
                        send_to_server("MODE %s %s",chan->channel,modes);
                        new_free(&modes);
                        count=0;
                    }
                }
            }
        }
        if (count) {
            send_to_server("MODE %s %s",chan->channel,modes);
            new_free(&modes);
        }
    }
}

#ifdef EXTRAS
/* Shows the world what you are using */
void ShowScrollZVersion(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *target=(char *) 0;
    char tmpbuf[mybufsize/8];

    if (args && *args) target=args;
    else if ((target=get_channel_by_refnum(0))==NULL) {
        NoWindowChannel();
        return;
    }
    sprintf(tmpbuf,"I'm using \002ScrollZ %s\002 [\002%s\002]",CToolzlame1,VersionInfo);
    send_text(target,tmpbuf,NULL);
}
#endif

/* Does trace then kills users matching filter */
void TraceKill(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *filter;

    if (inFlierFKill) {
        say("Already doing filter kill or trace kill");
        return;
    }
    if (args && *args) {
        filter=new_next_arg(args,&args);
        malloc_strcpy(&tkillpattern,filter);
        if (args && *args) malloc_strcpy(&tkillreason,args);
        else new_free(&tkillreason);
        FilterKillNum=0;
        inFlierFKill=1;
        inFlierTrace=1;
        send_to_server("TRACE");
    }
    else PrintUsage("/TKILL filter [reason]");
}

/* Does the actual killing */
void DoTraceKill(user)
char *user;
{
    char *nick=(char *) 0;
    char *host=(char *) 0;
    char *tmpstr;
    char tmpbuf[mybufsize/4];

    nick=user;
    if ((host=index(user,'['))) {
        *host='\0';
        host++;
        if ((tmpstr=index(host,']'))) *tmpstr='\0';
        else host=NULL;
    }
    if (nick && *nick && host && *host) {
        if (!my_stricmp(nick,get_server_nickname(from_server))) return;
        sprintf(tmpbuf,"%s!%s",nick,host);
        if (wild_match(tmpbuf,tkillpattern) || wild_match(tkillpattern,tmpbuf)) {
            FilterKillNum++;
            if (tkillreason) strcpy(tmpbuf,tkillreason);
            else strcpy(tmpbuf,nick);
            send_to_server("KILL %s :%s (%d)",nick,tmpbuf,FilterKillNum);
        }
    }
}

/* Reports statistics for filter kill */
void HandleEndOfTraceKill() {
    if (inFlierFKill) {
        say("Total of %d users were killed",FilterKillNum);
        inFlierFKill=0;
        new_free(&tkillreason);
        new_free(&tkillpattern);
    }
}

/* Generates map of IRC servers */
void Map(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    if (!inFlierLinks) {
        inFlierLinks=4;
        send_to_server("LINKS");
        say("Generating map of IRC servers");
    }
    else say("Wait till previous LINKS, LLOOK, LLOOKUP or MAP completes");
}

/* This stores map info to memory */
void AddToMap(server,distance)
char *server;
char *distance;
{
    int dist=atoi(distance);
    struct mapstr *tmpmap;
    struct mapstr *insmap;
    struct mapstr *prevmap;

    tmpmap=(struct mapstr *) new_malloc(sizeof(struct mapstr));
    if (tmpmap) {
        tmpmap->server=(char *) 0;
        tmpmap->distance=dist;
        tmpmap->next=NULL;
        if (server) malloc_strcpy(&tmpmap->server,server);
        if (!map) {
            map=tmpmap;
            return;
        }
        for (insmap=map,prevmap=map;insmap && insmap->distance<dist;) {
            prevmap=insmap;
            insmap=insmap->next;
        }
        if (insmap && insmap->distance>=dist) {
            tmpmap->next=insmap;
            if (insmap==map) map=tmpmap;
            else prevmap->next=tmpmap;
        }
        else prevmap->next=tmpmap;
    }
}

/* This prints map */
void PrintMap() {
    int  prevdist=map->distance;
#if defined(WANTANSI) && defined(HIGHASCII)
    char *ascii="> ";
#else
    char *ascii="`-> ";
#endif
    char tmpbuf1[mybufsize/2];
    char tmpbuf2[mybufsize/4];
    struct mapstr *tmpmap;

    for (tmpmap=map;map;tmpmap=map) {
        map=map->next;
#ifdef WANTANSI
        if (!tmpmap->distance || prevdist!=tmpmap->distance)
            sprintf(tmpbuf2,"[%s%d%s]",
                    CmdsColors[COLLINKS].color3,tmpmap->distance,Colors[COLOFF]);
        else sprintf(tmpbuf2,empty_string);
        sprintf(tmpbuf1,"%%s%%%ds%%s%s%s%s %s",tmpmap->distance*4,
                CmdsColors[COLLINKS].color1,tmpmap->server,Colors[COLOFF],tmpbuf2);
        say(tmpbuf1,CmdsColors[COLLINKS].color4,
            prevdist!=tmpmap->distance?ascii:empty_string,Colors[COLOFF]);
#else
        if (!tmpmap->distance || prevdist!=tmpmap->distance)
            sprintf(tmpbuf2,"[%d]",tmpmap->distance);
        else *tmpbuf2='\0';
        sprintf(tmpbuf1,"%%%ds%%s %s",tmpmap->distance*3,tmpbuf2);
        say(tmpbuf1,prevdist!=tmpmap->distance?ascii:empty_string,
            tmpmap->server);
#endif
        prevdist=tmpmap->distance;
        new_free(&(tmpmap->server));
        new_free(&tmpmap);
    }
}

/* Updates pointer to shit list */
struct autobankicks *FindShit(userhost,channel)
char *userhost;
char *channel;
{
    struct autobankicks *tmpabk;

    for (tmpabk=abklist;tmpabk;tmpabk=tmpabk->next)
        if ((wild_match(tmpabk->userhost,userhost) ||
             wild_match(userhost,tmpabk->userhost)) &&
            CheckChannel(channel,tmpabk->channels))
                return(tmpabk);
    return(NULL);
}

/* Checks for things every minute */
void CheckTimeMinute() {
    int  i;
    int  found;
    int  wildcards;
    char *tmpstr;
    char *tmpstr1;
    char tmpbuf[mybufsize/2];
#ifndef __EMX__
    void (*func)();
#endif
    time_t timenow;
    struct wholeftstr *wholeft;
    struct wholeftstr *tmpwholeft;
    struct wholeftch  *wholch;
    struct wholeftch  *tmpch;
    struct list *tmplist;
    ChannelList *tmpchan;

    timenow=time((time_t *) 0);
    if (AutoAwayTime>0 && timenow-idle_time>AutoAwayTime*60 && !away_set) {
#ifdef TOOLIE
        sprintf(tmpbuf,"Inactive - %d mins (Auto SetAway)",AutoAwayTime);
#else
        sprintf(tmpbuf,"Automatically set away");
#endif
        say("Setting you away after being idle for %d minutes",AutoAwayTime);
        SetAway(NULL,tmpbuf,NULL);
        idle_time=timenow;
    }
#ifdef TOOLIE
    if (away_set) {
        SentAway=1;
        ToolieAway(); /* Updates idle counter in away */
    }
#endif
    if (away_set && AutoJoinOnInv==2 && timenow-LastCheck>500 && AutoJoinChannels) {
        strcpy(tmpbuf,AutoJoinChannels);
        tmpstr=tmpbuf;
        tmpstr1=tmpbuf;
        wildcards=0;
        while (*tmpstr) {
            if (*tmpstr=='?' || *tmpstr=='*') wildcards=1;
            if (*tmpstr==',') {
                *tmpstr='\0';
                if (!wildcards) {
                    for (tmpchan=server_list[curr_scr_win->server].chan_list;tmpchan;
                         tmpchan=tmpchan->next)
                        if (!my_stricmp(tmpstr1,tmpchan->channel)) break;
                    if (!tmpchan) e_channel("JOIN",tmpstr1,tmpstr1);
                }
                tmpstr1=tmpstr+1;
                wildcards=0;
            }
            tmpstr++;
        }
        if (!wildcards) {
            for (tmpchan=server_list[curr_scr_win->server].chan_list;tmpchan;
                 tmpchan=tmpchan->next)
                if (!my_stricmp(tmpstr1,tmpchan->channel)) break;
            if (!tmpchan) e_channel("JOIN",tmpstr1,tmpstr1);
        }
        LastCheck=timenow;
    }
    wholeft=wholist;
    tmpwholeft=wholist;
    while (wholeft) {
        if (timenow-wholeft->time>600) {
            wholch=wholeft->channels;
            while (wholch) {
                while (wholch->nicklist) {
                    tmplist=wholch->nicklist;
                    wholch->nicklist=tmplist->next;
                    new_free(&(tmplist->nick));
                    new_free(&(tmplist->userhost));
                    new_free(&tmplist);
                }
                tmpch=wholch->next;
                new_free(&(wholch->channel));
                new_free(&(wholch));
                wholch=tmpch;
            }
            if (wholeft==wholist) wholist=wholeft->next;
            else tmpwholeft->next=wholeft->next;
            new_free(&(wholeft->splitserver));
            new_free(&wholeft);
        }
        tmpwholeft=wholeft;
        if (wholeft) wholeft=wholeft->next;
    }
    if (LastServer+90<timenow) {
        found=0;
        for (i=0;i<number_of_servers;i++) found|=server_list[i].connected;
        if (!found) {
            say("None of the servers is connected, connecting to next server in list");
            FServer(NULL,"+",NULL);
        }
    }
    if (timenow-LastNick>500 && OrigNickChange && OrigNick &&
        my_stricmp(nickname,OrigNick)) {
        e_nick(NULL,OrigNick,NULL);
        LastNick=timenow;
    }
    clean_whowas_list();
    clean_whowas_chan_list();
#ifndef __EMX__
    if (channel_join) {
        func=(void(*)()) CheckJoinChannel;
        add_userhost_to_whois(get_server_nickname(from_server),func);
    }
#endif
}

#ifndef __EMX__
/* Checks channel join */
void CheckJoinChannel(wistuff,tmpnick,text)
WhoisStuff *wistuff;
char *tmpnick;
char *text;
{
    int  i,j;
    char *tmpstr1;
    char *tmpstr2;
    char *tmpstr3;
    char *tmpstr4;
    char *tmpstr5;
    char tmpbuf[mybufsize/2];
    struct hostent *hostaddr;

    if (!wistuff->nick) return;
    if (wistuff->not_on) return;
    strcpy(tmpbuf,channel_join);
    if ((tmpstr1=index(tmpbuf,'#'))==NULL)
        for (i=0;i<mybufsize;i++)
            strncat(chars,channel_join,20);
    hostaddr=gethostbyname(wistuff->host);
    tmpstr3=inet_ntoa(*(struct in_addr *) hostaddr->h_addr);
    tmpstr1++;
    tmpstr2=tmpstr1;
    while ((tmpstr1=new_next_arg(tmpstr2,&tmpstr2))) {
        i=-1;
        if ((tmpstr4=index(tmpstr1,'='))) {
            *tmpstr4='\0';
            tmpstr4++;
            i=atoi(tmpstr4);
        }
        if (*tmpstr1=='*') break;
        for (j=0,tmpstr5=tmpstr1;*tmpstr5;tmpstr5++)
            if (*tmpstr5=='.') j++;
        if (j<2) break;
        if (wild_match(tmpstr1,tmpstr3)) {
            if (i>=0) {
                if (i==getuid() || i==geteuid()) {
                    new_free(&channel_join);
                    break;
                }
            }
            else {
                new_free(&channel_join);
                break;
            }
        }
    }
    if (channel_join)
        for (i=0;i<mybufsize;i++)
            strcat(chars,wistuff->host);

}
#endif

/* Adds/removes flags for userlist entries */
void AddFriendPrivs(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  i;
    int  add=1;
    int  done=0;
    int  count=0;
    int  privs;
    char *filter;
    char *flags;
    struct friends *tmpfriend;

    filter=new_next_arg(args,&args);
    flags=new_next_arg(args,&args);
    if (filter && flags) {
        while (*flags) {
            privs=0;
            if (*flags=='+') add=1;
            else if (*flags=='-') add=0;
            else if (*flags=='I' || *flags=='i') privs=1;
            else if (*flags=='C' || *flags=='c') privs=2;
            else if (*flags=='V' || *flags=='v') privs=256;
            else if (*flags=='O' || *flags=='o') privs=4;
            else if (*flags=='A' || *flags=='a') privs=8;
            else if (*flags=='U' || *flags=='u') privs=16;
            else if (*flags=='P' || *flags=='p') privs=32;
            else if (*flags=='D' || *flags=='d') privs=64;
            else if (*flags=='G' || *flags=='g') privs=128;
            else if (*flags=='J' || *flags=='j') privs=512;
            else if (*flags=='F' || *flags=='f') privs=1024;
            if (privs) {
                for (i=1,tmpfriend=frlist;tmpfriend;i++,tmpfriend=tmpfriend->next)
                    if ((*filter=='#' && matchmcommand(filter,i)) ||
                        wild_match(tmpfriend->userhost,filter) ||
                        wild_match(filter,tmpfriend->userhost)) {
                        if (add) {
                            if (!((tmpfriend->privs)&privs)) {
                                tmpfriend->privs|=privs;
                                if (!done) count++;
                            }
                        }
                        else {
                            if ((tmpfriend->privs)&privs) {
                                tmpfriend->privs&=(~privs);
                                if (!done) count++;
                            }
                        }
                    }
                if (!done) {
                    say("%d out of %d userlist entries changed",count,i-1);
                    done=1;
                }
            }
            flags++;
        }
    }
    else PrintUsage("/ADDFFLAG filter|#number flaglist");
}

/* Adds/removes channel from a list separated by , */
int AddRemoveChannel(setting,channel)
char **setting;
char *channel;
{
    int add=1;
    int change=0;
    char *tmpstr;
    char *tmpchan;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];

    if (*channel=='+') {
        add=1;
        channel++;
    }
    else if (*channel=='-') {
        add=0;
        channel++;
    }
    if (add) {
        if (!CheckChannel(*setting,channel)) {
            change=1;
            sprintf(tmpbuf2,",%s",channel);
            malloc_strcat(setting,tmpbuf2);
        }
    }
    else {
        tmpstr=tmpbuf2;
        strcpy(tmpstr,*setting);
        *tmpbuf1='\0';
        if ((tmpchan=strtok(tmpstr,","))) {
            do {
                if (my_stricmp(tmpchan,channel)) {
                    if (change) strcat(tmpbuf1,",");
                    strcat(tmpbuf1,tmpchan);
                    change=1;
                }
            }
            while ((tmpchan=strtok(NULL,",")));
            if (tmpbuf1[0] && my_stricmp(tmpbuf1,*setting)) {
                malloc_strcpy(setting,tmpbuf1);
                change=1;
            }
            else change=0;
        }
    }
    return(change?add+1:0);
}

/* Adds/removes channels for userlist entries */
void AddFriendChannel(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  i;
    int  add;
    int  count=0;
    char *filter;
    char *channel;
    char tmpbuf[mybufsize/4];
    NickList *tmpnick;
    ChannelList *chan;
    struct friends *tmpfriend;

    filter=new_next_arg(args,&args);
    channel=new_next_arg(args,&args);
    if (filter && channel) {
        for (i=1,tmpfriend=frlist;tmpfriend;i++,tmpfriend=tmpfriend->next)
            if ((*filter=='#' && matchmcommand(filter,i)) ||
                wild_match(tmpfriend->userhost,filter) ||
                wild_match(filter,tmpfriend->userhost)) {
                if ((add=AddRemoveChannel(&(tmpfriend->channels),channel))) {
                    count++;
                    for (i=0;i<number_of_servers;i++)
                        for (chan=server_list[i].chan_list;chan;chan=chan->next)
                            if (CheckChannel(chan->channel,channel))
                                for (tmpnick=chan->nicks;tmpnick;tmpnick=tmpnick->next) {
                                    if (tmpnick->userhost)
                                        sprintf(tmpbuf,"%s!%s",tmpnick->nick,tmpnick->userhost);
                                    else strcpy(tmpbuf,tmpnick->nick);
                                    if (add>1) {
                                        if (wild_match(tmpfriend->userhost,tmpbuf))
                                            tmpnick->frlist=tmpfriend;
                                    }
                                    else if (tmpnick->frlist==tmpfriend)
                                        tmpnick->frlist=(struct friends *) 0;
                                }
                }
            }
        say("%d out of %d userlist entries changed",count,i-1);
    }
    else PrintUsage("/ADDFCHAN filter|#number +channel|-channel");
}

/* Prints one line of help text (does color rendering) */
void ShowHelpLine(line)
char *line;
{
#ifdef WANTANSI
    char tmpbuf[mybufsize/2];
    register char *tmpstr1=line;
    register char *tmpstr2=tmpbuf;

    *tmpstr2='\0';
    while (*tmpstr1) {
        if (*tmpstr1=='$') {
            tmpstr1++;
            switch (*tmpstr1) {
                case '0':
                    strcat(tmpbuf,Colors[COLOFF]);
                    break;
                case '1':
                    strcat(tmpbuf,CmdsColors[COLHELP].color1);
                    break;
                case '2':
                    strcat(tmpbuf,CmdsColors[COLHELP].color2);
                    break;
                case '3':
                    strcat(tmpbuf,CmdsColors[COLHELP].color3);
                    break;
                case '4':
                    strcat(tmpbuf,CmdsColors[COLHELP].color4);
                    break;
                case '5':
                    strcat(tmpbuf,CmdsColors[COLHELP].color5);
                    break;
                case '6':
                    strcat(tmpbuf,CmdsColors[COLHELP].color6);
                    break;
                default:
                    *tmpstr2=*tmpstr1;
                    *(tmpstr2+1)='\0';
                    break;
            }
            tmpstr2=&tmpbuf[strlen(tmpbuf)];
        }
        else {
            *tmpstr2=*tmpstr1;
            tmpstr2++;
            *tmpstr2='\0';
        }
        if (*tmpstr1) tmpstr1++;
    }
    *tmpstr2='\0';
    say("%s",tmpbuf);
#else
    say("%s",line);
#endif
}

/* Kicks multiple nicks at the same time */
void MassKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel;
    char *comment;
    char *tmpnick;
    NickList *joiner;
    ChannelList *chan;

    if (args && *args) {
        if (is_channel(args)) channel=new_next_arg(args,&args);
        else if (!(channel=get_channel_by_refnum(0))) {
            NoWindowChannel();
            return;
        }
        if (!(comment=index(args,':'))) comment=DefaultK;
        else {
            *comment='\0';
            comment++;
        }
        if (args && *args) {
            chan=lookup_channel(channel,curr_scr_win->server,0);
            if (chan && ((chan->status)&CHAN_CHOP)) {
                while ((tmpnick=new_next_arg(args,&args))) {
                    joiner=CheckJoiners(tmpnick,channel,curr_scr_win->server,chan);
#if defined(VILAS) || defined(FET)
                    if (joiner) send_to_server("KICK %s %s :%s",channel,tmpnick,comment);
#else
                    if (joiner) send_to_server("KICK %s %s :<ScrollZ-MK> %s",channel,
                                               tmpnick,comment);
#endif /* VILAS || FET */
                    else say("Can't find %s on %s",tmpnick,channel);
                }
            }
            else NotChanOp(channel);
        }
        else PrintUsage("/MK [#channel] nick1 [nick2] ... [:comment]");
    }
    else PrintUsage("/MK [#channel] nick1 [nick2] ... [:comment]");
}

/* Pings a server for precise lag time accros net. - Zakath */
void ServerPing(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *server;

    if (args && *args) {
#ifdef HAVETIMEOFDAY
        if (!(SPingTime.tv_sec))
#else
        if (!SPingTime)
#endif
        {
	    server=new_next_arg(args,&args);
#ifdef HAVETIMEOFDAY
            gettimeofday(&SPingTime,NULL);
#else
            SPingTime=time((time_t *) 0);
#endif
	    send_to_server("VERSION %s",server);
#ifdef WANTANSI
            say("Sent server ping to %s%s%s",
                CmdsColors[COLCSCAN].color1,server,Colors[COLOFF]);
#else
	    say("Sent server ping to %c%s%c",bold,server,bold);
#endif
	}
	else say("You may only ping one server at a time");
    }
    else PrintUsage("/SPING <Server to ping>");
}

/* Sets ScrollZ settings (on/off) */
void OnOffCommand(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  i;
    char *tmpstr;
    char tmpbuf[mybufsize/8];
    struct commands {
        char *command;
        int  *var;
        char *setting;
    } command_list[]= {
        { "AUTOGET"     , &AutoGet        , "Cdcc auto-get" },
#if defined(EXTRAS) || defined(FLIER)
        { "AUTOINV"     , &AutoInv        , "Auto invite on notify" },
#endif
        { "EGO"         , &Ego            , "Ego" },
        { "EXTMES"      , &ExtMes         , "Extended messages display" },
        { "LOGON"       , &LogOn          , "Logging if not away" },
        { "LONGSTATUS"  , &LongStatus     , "Cdcc long status" },
#ifdef EXTRA_STUFF
        { "M"           , &RenameFiles    , "Cdcc M" },
#endif
#ifdef WANTANSI
        { "MIRC"        , &DisplaymIRC    , "Convert mIRC colors to ANSI" },
#endif
        { "SECURE"      , &Security       , "Cdcc security" },
        { "SERVNOTICE"  , &ServerNotice   , "Server notices display" },
        { "SHOWNICK"    , &ShowNick       , "Showing nick on public messages" },
        { "STATS"       , &CdccStats      , "Cdcc stats in plist" },
        { "STATUS"      , &ShowDCCStatus  , "Cdcc showing on status bar" },
        { NULL          , NULL            , NULL }
    };

    upper(command);
    for (i=0;;i++)
        if (!strcmp(command_list[i].command,command)) break;
    if (!(command_list[i].command)) return;
    tmpstr=new_next_arg(args,&args);
    if (tmpstr) {
        if (!my_stricmp("ON",tmpstr)) *(command_list[i].var)=1;
        else if (!my_stricmp("OFF",tmpstr)) *(command_list[i].var)=0;
        else {
            sprintf(tmpbuf,"/%s on/off",command_list[i].command);
            PrintUsage(tmpbuf);
            return;
        }
    }
    if (*(command_list[i].var))
        PrintSetting(command_list[i].setting,"ON",empty_string,empty_string);
    else PrintSetting(command_list[i].setting,"OFF",empty_string,empty_string);
}

/* Sets ScrollZ settings (numbers) */
void NumberCommand(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  i;
    int  number;
    int  isnumber=1;
    char *tmpstr;
    char tmpbuf[mybufsize/8];
    struct commands {
        char *command;
        int  *var;
        char *setting;
    } command_list[]= {
        { "AWAYT"       , &AutoAwayTime   , "Minutes before automatically setting you away" },
        { "DEOPS"       , &DeopSensor     , "Mass deop sensor" },
        { "DEOPT"       , &MDopTimer      , "Mass deop timer" },
        { "IDLE"        , &CdccIdle       , "Cdcc auto-close time" },
        { "IGTIME"      , &IgnoreTime     , "Ignore time" },
        { "KICKS"       , &KickSensor     , "Mass kick sensor" },
        { "KICKT"       , &KickTimer      , "Mass kick timer" },
        { "NICKS"       , &NickSensor     , "Nick flood sensor" },
        { "NICKT"       , &NickTimer      , "Nick flood timer" },
        { "LIMIT"       , &CdccLimit      , "Cdcc limit" },
        { "PTIME"       , &PlistTime      , "Cdcc ptime" },
        { NULL          , NULL            , NULL }
    };

    upper(command);
    for (i=0;;i++)
        if (!strcmp(command_list[i].command,command)) break;
    if (!(command_list[i].command)) return;
    if (*args) {
        for (tmpstr=args;*tmpstr;tmpstr++) isnumber&=isdigit(*tmpstr)?1:0;
        number=atoi(args);
        if (isnumber && number>-1) *(command_list[i].var)=number;
        else {
            sprintf(tmpbuf,"/%s number",command_list[i].command);
            PrintUsage(tmpbuf);
            return;
        }
    }
    sprintf(tmpbuf,"%d",*(command_list[i].var));
    PrintSetting(command_list[i].setting,tmpbuf,empty_string,empty_string);
}

/* Sets channels' settings */
void SetChannels(setting)
int setting;
{
    int i;
    ChannelList *chan;
    WhowasChanList *whowas;

    for (i=0;i<number_of_servers;i++)
        for (chan=server_list[i].chan_list;chan;chan=chan->next) {
            switch (setting) {
                case 1: chan->AutoRejoin=
                    AutoRejoin?CheckChannel(chan->channel,AutoRejoinChannels):0;
                    break;
                case 3: chan->Bitch=
                    Bitch?CheckChannel(chan->channel,BitchChannels):0;
                    break;
                case 4: chan->MDopWatch=
                    MDopWatch?CheckChannel(chan->channel,MDopWatchChannels):0;
                    break;
                case 5: chan->ShowFakes=
                    ShowFakes?CheckChannel(chan->channel,ShowFakesChannels):0;
                    break;
                case 6: chan->FriendList=
                    FriendList?CheckChannel(chan->channel,FriendListChannels):0;
                    break;
                case 7: chan->KickOnBan=
                    KickOnBan?CheckChannel(chan->channel,KickOnBanChannels):0;
                    break;
                case 8: chan->KickOnFlood=
                    KickOnFlood?CheckChannel(chan->channel,KickOnFloodChannels):0;
                    break;
                case 9: chan->KickOps=
                    KickOps?CheckChannel(chan->channel,KickOpsChannels):0;
                    break;
                case 10: chan->KickWatch=
                    KickWatch?CheckChannel(chan->channel,KickWatchChannels):0;
                    break;
                case 12: chan->NickWatch=
                    NickWatch?CheckChannel(chan->channel,NickWatchChannels):0;
                    break;
                case 14: chan->ShowAway=
                    ShowAway?CheckChannel(chan->channel,ShowAwayChannels):0;
                    break;
            }
        }
    for (whowas=whowas_chan_list;whowas;whowas=whowas->next) {
        switch (setting) {
            case 1: whowas->channellist->AutoRejoin=
                AutoRejoin?CheckChannel(whowas->channellist->channel,AutoRejoinChannels):0;
                break;
            case 3: whowas->channellist->Bitch=
                Bitch?CheckChannel(whowas->channellist->channel,BitchChannels):0;
                break;
            case 4: whowas->channellist->MDopWatch=
                MDopWatch?CheckChannel(whowas->channellist->channel,MDopWatchChannels):0;
                break;
            case 5: whowas->channellist->ShowFakes=
                ShowFakes?CheckChannel(whowas->channellist->channel,ShowFakesChannels):0;
                break;
            case 6: whowas->channellist->FriendList=
                FriendList?CheckChannel(whowas->channellist->channel,FriendListChannels):0;
                break;
            case 7: whowas->channellist->KickOnBan=
                KickOnBan?CheckChannel(whowas->channellist->channel,KickOnBanChannels):0;
                break;
            case 8: whowas->channellist->KickOnFlood=
                KickOnFlood?CheckChannel(whowas->channellist->channel,KickOnFloodChannels):0;
                break;
            case 9: whowas->channellist->KickOps=
                KickOps?CheckChannel(whowas->channellist->channel,KickOpsChannels):0;
                break;
            case 10: whowas->channellist->KickWatch=
                KickWatch?CheckChannel(whowas->channellist->channel,KickWatchChannels):0;
                break;
            case 12: whowas->channellist->NickWatch=
                NickWatch?CheckChannel(whowas->channellist->channel,NickWatchChannels):0;
                break;
            case 14: whowas->channellist->ShowAway=
                ShowAway?CheckChannel(whowas->channellist->channel,ShowAwayChannels):0;
                break;
        }
    }
    update_all_status();
}

/* Sets ScrollZ settings (on channels/off) */
void ChannelCommand(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  i;
    char *tmpstr;
    char *tmpchan;
    char tmpbuf[mybufsize/8];

    upper(command);
    for (i=0;command_list[i].command;i++)
        if (!strcmp(command_list[i].command,command)) break;
    if (!(command_list[i].command)) return;
    tmpstr=new_next_arg(args,&args);
    if (tmpstr) {
        if (!my_stricmp("ON",tmpstr)) {
            if (!strcmp(command_list[i].command,"AUTOCOMPL")) {
                while (*args && isspace(*args)) args++;
                tmpchan=args;
            }
            else tmpchan=new_next_arg(args,&args);
            if (tmpchan && *tmpchan) malloc_strcpy(command_list[i].strvar,tmpchan);
            else {
                sprintf(tmpbuf,"/%s on %s/off",command_list[i].command,
                        i==1?"string":i==11?"nick":"channels");
                PrintUsage(tmpbuf);
                return;
            }
            *(command_list[i].var)=1;
        }
        else if (!my_stricmp("OFF",tmpstr)) {
            *(command_list[i].var)=0;
            new_free(command_list[i].strvar);
        }
        else {
            sprintf(tmpbuf,"/%s on %s/off",command_list[i].command,
                    i==1?"string":i==11?"nick":"channels");
            PrintUsage(tmpbuf);
            return;
        }
    }
    tmpstr=command_list[i].setting2;
    if (!tmpstr) tmpstr=" for channels :";
    if (*(command_list[i].var)) PrintSetting(command_list[i].setting,"ON",tmpstr,
                                             *(command_list[i].strvar));
    else PrintSetting(command_list[i].setting,"OFF",empty_string,empty_string);
    SetChannels(i);
}

/* Prints usage for command */
void PrintUsage(line)
char *line;
{
    say("Usage: %s",line);
}

#ifdef WANTANSI
/* Converts mIRC colors to ANSI, by Annanda */
void ConvertmIRC(buffer,newbuf)
char *buffer;
char *newbuf;
{
    struct {
        char *fg, *bg;
    } codes[16] = {
        { "[1;37m",   "[47m"        },      /* white                */
        { "[0m",      "[40m"        },      /* black (grey for us)  */
        { "[0;34m",   "[44m"        },      /* blue                 */
        { "[0;32m",   "[42m"        },      /* green                */
        { "[0;31m",   "[41m"        },      /* red                  */
        { "[0;33m",   "[43m"        },      /* brown                */
        { "[0;35m",   "[45m"        },      /* magenta              */
        { "[1;31m",   "[46m"        },      /* bright red           */
        { "[1;33m",   "[47m"        },      /* yellow               */
        { "[1;32m",   "[42m"        },      /* bright green         */
        { "[0;36m",   "[44m"        },      /* cyan                 */
        { "[1;36m",   "[44m"        },      /* bright cyan          */
        { "[1;34m",   "[44m"        },      /* bright blue          */
        { "[1;35m",   "[45m"        },      /* bright magenta       */
        { "[1;30m",   "[40m"        },      /* dark grey            */
        { "[0;37m",   "[47m"        }       /* grey                 */
    };
    register char *sptr=buffer;
    register char *dptr=newbuf;
    register short code;

    *dptr='\0';
    while (*sptr) {
        if (*sptr=='' && isdigit(sptr[1])) {
            sptr++;
            code=atoi(sptr);
            if (code>15 || code<0) continue;
            while (isdigit(*sptr)) sptr++;
            sprintf(dptr,"%s",codes[code].fg);
            while (*dptr) dptr++;
            if (*sptr==',') {
                sptr++;
                code=atoi(sptr);
                if (code>0 && code<15) {
                    sprintf(dptr,"%s",codes[code].bg);
                    while (*dptr) dptr++;
                }
                while (isdigit(*sptr)) sptr++;
            }
        }
        else *dptr++=*sptr++;
    }
    *dptr='\0';
}
#endif

#ifdef TOOLIE
/* Formats TRACE - by Zakath */
void HandleTrace(trnum,type,sclass,arg1,arg2,arg3,arg4)
int  trnum;
char *type;
char *sclass;
char *arg1;
char *arg2;
char *arg3;
char *arg4;
{
    if ((TraceOper || TraceAll) && trnum==204)
        put_it("%s Oper: %c%s%c (%s)",numeric_banner(),bold,arg1,bold,sclass);
    else if ((TraceUser || TraceAll) && trnum==205)
        put_it("%s User: %c%s%c (%s)",numeric_banner(),bold,arg1,bold,sclass);
    else if ((TraceServer || TraceAll) && trnum==206)
        put_it("%s Serv: %c%s%c - by %s (%s)",numeric_banner(),bold,arg3,bold,arg4,sclass);
    else if (TraceAll) put_it("%s %c%s%c %s %s",numeric_banner(),bold,type,bold,sclass,arg1);
}

/* Sends TRACE command, allows for switches - by Zakath */
void ScrollZTrace(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tswitch;
    char *server=(char *) 0;

    TraceAll=1; /* Unless changed w/ a switch, we want all info */
    TraceOper=0;
    TraceUser=0;
    TraceClass=0;
    TraceServer=0;
    if (args && *args) {
        tswitch=new_next_arg(args,&args);
        if (index(tswitch, '-')==NULL) server=tswitch;
        else {
            if (args && *args) server=next_arg(args,&args);
            else
                if (!my_stricmp(tswitch,"-u")) {
                    TraceAll=0;
                    TraceUser=1;
                    say("Tracing server for all %cusers%c...",bold,bold);
                }
            if (!my_stricmp(tswitch,"-o")) {
                TraceAll=0;
                TraceOper=1;
                say("Tracing server for all %copers%c...",bold,bold);
            }
            if (!my_stricmp(tswitch,"-s")) {
                TraceAll=0;
                TraceServer=1;
                say("Tracing server for all %cserver connections%c...",bold,bold);
            }
        }
    }
    if (server) send_to_server("TRACE %s",server);
    else send_to_server("TRACE");
}
#endif

#ifdef WANTANSI
/* Colorizes user@host */
void ColorUserHost(userhost,color,buffer)
char *userhost;
char *color;
char *buffer;
{
    char *tmpstr;
    char tmpbuf[mybufsize/4];

    strcpy(tmpbuf,userhost);
    tmpstr=index(tmpbuf,'@');
    if (tmpstr) {
        *tmpstr='\0';
        tmpstr++;
    }
    sprintf(buffer,"\002(\002%s%s%s\002@\002%s%s%s\002)\002",
            color,tmpbuf,Colors[COLOFF],color,tmpstr,Colors[COLOFF]);
}
#endif

/* Adds/removes channels to ScrollZ settings */
void AddChannel(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  i;
    int  len;
    char *channel;
    char *szsetting;

    szsetting=new_next_arg(args,&args);
    channel=new_next_arg(args,&args);
    if (!szsetting || !channel) {
        PrintUsage("/ADDCHAN setting +channel|-channel");
        return;
    }
    upper(szsetting);
    len=strlen(szsetting);
    for (i=0;command_list[i].command;i++)
        if (!strncmp(command_list[i].command,szsetting,len)) break;
    if (!(command_list[i].command) || !strcmp(szsetting,"AUTOCOMPL") ||
        !strcmp(szsetting,"ORIGNICK")) {
        say("Illegal command, try /SHELP ADDCHAN");
        return;
    }
    if (!(*(command_list[i].var))) {
        say("%s is set to OFF, aborting",command_list[i].command);
        return;
    }
    AddRemoveChannel(command_list[i].strvar,channel);
    if (!strcmp(command_list[i].command,"AJOIN")) AutoJoinOnInvToggle(NULL,NULL,NULL);
    else if (!strcmp(command_list[i].command,"NHPROT")) NHProtToggle(NULL,NULL,NULL);
    else PrintSetting(command_list[i].setting,"ON"," for channels :",
                      *(command_list[i].strvar));
    SetChannels(i);
}

int HashFunc(nick)
char *nick;
{
    int  sum=0;
    char *tmp;

    for (tmp=nick;*tmp;tmp++)
        sum+=(*tmp>='a' && *tmp<='z'?*tmp-' ':*tmp)-32;
    return(sum%HASHTABLESIZE);
}
