/******************************************************************************
 Functions coded by Flier (THANX to Sheik!!)

 PrintMessage        Prints received message
 HandleSplit         Handles net splits
 CheckJoin           Checks the joined person
 HandleJoin          Handles net joins
 ChannelJoin         This executes when you join a channel
 HandleInvite        Handles invite requests
 HandleKills         Handles operator kills
 HandleNickChange    Handles nick change
 HandleMyKick        Handles my kicks
 HandleKick          Handles kicks
 HandleTab           Handles tab key
 EndOfBans           Handles end of bans reply
 HandleNotice        Handles received notice
 HandleClosedConn    Handles closed connections from server
 HandleRename        Handles on the fly renaming of files
 HandleFlood         Handles flooding
 ModeLocked          Locks channel mode
 CheckLock           Checks if there is a need to lock mode back
 HandleEndOfWho      Handles end of who reply
 CTCPCloakingToggle  Toggles CTCP cloaking on/off
 Check4WordKick      Checks if wordkick should take place
 MassOp              Ops everyone on your current channel
 AddBan              This adds ban to ban list
 RemoveBan           This removes ban from ban list
 UnbanIt             Really unbans user
 TBan                Shows all bans and asks which one you wanna remove
 HandleFakes         Handles fakes
 ModeUnlocked        Unlocks channel mode
 ScatterKick         Kicks nick with funny message
 RandomScatterKick   Randomly picks funny message and kicks nick
 LastNoticeKick      Kicks nick with last notice
 NickStat            Prints some statistics about nick
 AddNotify           Adds user to notify list
 RemoveNotify        Removes user from notify list
 HandleNotifyOn      Handles notify
 HandleUserhost      Adds userhost info to notify list
 HandleNotifyOff     Handles notify off
 HandleNotifyOffUh   Handles notify userhost off
 ListNotify          Lists all users on notify list
 ClearBans           Clears my stuff in ChannelList (bans and modelock)
 HandleGotOps        Handles all things when you get ops
 MyQuit              This executes when you quit from IRC
 CountNicks          Counts number of nicks in line
 AddDelayOp          Adds user to delay op list
 ChangeNickDelay     Changes nick in delay op list
 AddDelayNotify      Adds nick to delay notify list
 AddServer           Adds given server to server list
 RemoveServer        Removes given server from server list
 ListServers         Lists all servers on server list
 IsBanned            Returns 1 if user is banned on channel, else 0
 PickSignOff         Randomly picks sign off message
 PickScatterKick     Randomly picks scatter kick
 ClearTab            Clears tabkey list
 HandleLinks         This handles links reply from server
 ListSplitedServers  Prints all servers missing from links info
 ShowKill            This will print out the sucker that last killed you
******************************************************************************/

#include "irc.h"
#include "crypt.h"
#include "vars.h"
#include "ircaux.h"
#include "lastlog.h"
#include "window.h"
#include "whois.h"
#include "hook.h"
#include "input.h"
#include "ignore.h"
#include "keys.h"
#include "names.h"
#include "alias.h"
#include "history.h"
#include "funny.h"
#include "ctcp.h"
#include "dcc.h"
#include "translat.h"
#include "output.h"
#include "notify.h"
#include "numbers.h"
#include "status.h"
#include "screen.h"
#include "server.h"
#include "edit.h"
#include "ircterm.h"
#include "list.h"
#include "struct.h"
#include "myvars.h"
#include "whowas.h"

typedef struct notify_stru
{
    struct  notify_stru     *next;
    char    *nick;
    char    *userhost;
    int     flag;
} NotifyList;

void   ListBansPage _((char *));
void   ListBansPrompt _((char *, char *));
void   HandleUserhost _((WhoisStuff *, char *, char *));
void   HandleGotOps _((char *, ChannelList *));
void   MyQuitPrompt _((char *, char *));
void   AddDelayOp _((char *, char *, int, int));
void   ChangeNickDelay _((char *, char *, int));
void   AddDelayNotify _((char *, int));
int    IsBanned _((char *, char *, int, ChannelList *));
char   *PickSignOff _((void));
#ifdef SCKICKS
char   *PickScatterKick _((int));
#endif
#ifdef TOOLIE
char   *ToolieSignoff _((void));
#endif

extern NickList *CheckJoiners _((char *, char *, int , ChannelList *));
extern struct words *CheckLine _((char *, char *));
extern void AwaySave _((char *, int));
extern void AddNick2List _((char *));
#ifndef WANTANSI
extern void UserDomain _((char *));
#endif
extern int  AddSplitter _((char *, char *, char *));
extern int  Check4Fake _((char *));
extern struct friends *CheckUsers _((char *, char *));
extern void Check4Join _((char *, char *));
extern int  CheckChannel _((char *, char *));
extern void NickNext _((void));
#ifdef EXTRAS
extern void FixName _((char *));
#endif
extern void ClearKey _((char *, char *, char *));
extern void Cdcc _((char *, char *, char *));
extern int  readln _((FILE *, char *));
extern void NextArg _((char *, char **, char *));
extern void PrintSetting _((char *, char *, char *, char *));
extern char *OpenCreateFile _((char *, int));
extern void PrintSynch _((ChannelList *));
extern void StripAnsi _((char *, char *, int));
extern int  matchmcommand _((char *, int));
extern int  GrabURL _((char *, char *, char *));
extern void Ignore _((char *, char *, char *));
extern void CheckPermBans _((ChannelList *));
#ifdef EXTRAS
void CheckLock _((char *, int, ChannelList *));
#endif
#if defined(EXTRAS) || defined(FLIER)
extern void CheckInvite _((char *, char *, int));
#endif
extern void NotChanOp _((char *));
extern void NoWindowChannel _((void));
extern void PrintUsage _((char *));
extern void ColorUserHost _((char *, char *, char *));
extern int  AddLast _((List *, List *));
extern NickList *find_in_hash _((ChannelList *, char *));

extern void e_channel _((char *, char *, char *));
extern void timercmd _((char *, char *, char *));
extern void me _((char *, char *, char *));
extern void waitcmd _((char *, char *, char *));
extern char *recreate_mode _((ChannelList *));

static struct bans *tmpbn;
static struct bans *tmpbanlist;
static int  listcount;

extern NotifyList *notify_list;
extern DCC_list *ClientList;

extern char *chars;
extern NickList *tabnickcompl;

/* Prints received message */
void PrintMessage(nick,userhost,msg,print)
char *nick;
char *userhost;
char *msg;
int  print;
{
    int  numurl=0;
    char *message;
    char *filepath=NULL;
    char tmpbuf1[mybufsize];
    char tmpbuf2[mybufsize];
    char tmpbuf3[mybufsize];
    char tmpbuf4[mybufsize];
#ifdef WANTANSI
    char *tmpstr;
#ifdef HIGHASCII
    char thing='';
#else
    char thing='*';
#endif

    if (URLCatch) {
        filepath=OpenCreateFile("ScrollZ.notepad",1);
        numurl=GrabURL(msg,tmpbuf4,filepath);
        message=tmpbuf4;
    }
    else message=msg;
    sprintf(tmpbuf1,"\002%c\002%s%s%s\002%c\002 %s%s%s",thing,
            CmdsColors[COLMSG].color1,nick,Colors[COLOFF],thing,
            CmdsColors[COLMSG].color3,message,Colors[COLOFF]);
    if (ExtMes && userhost) {
        ColorUserHost(userhost,CmdsColors[COLMSG].color2,tmpbuf2);
        sprintf(tmpbuf3,"  %s [%s%s%s]\002)\002",tmpbuf2,
                CmdsColors[COLMSG].color4,update_clock(GET_TIME),Colors[COLOFF]);
    }
    else *tmpbuf3='\0';
    if (print) put_it("%s%s",tmpbuf1,tmpbuf3);
    if (userhost) {
        strcpy(tmpbuf2,userhost);
        tmpstr=index(tmpbuf2,'@');
        if (tmpstr) {
            *tmpstr='\0';
            tmpstr++;
        }
    }
    else {
        *tmpbuf2='\0';
        tmpstr=tmpbuf2;
    }
    StripAnsi(message,tmpbuf3,1);
    sprintf(tmpbuf1,"\002*\002%s\002*\002 %s  \002(\002%s\002@\002%s [%s]\002)\002",
            nick,tmpbuf3,tmpbuf2,tmpstr,update_clock(GET_TIME));
    malloc_strcpy(&LastMessage,tmpbuf1);
    sprintf(tmpbuf1,"\002*\002%s\002*\002 %s  \002(\002%s\002@\002%s\002)\002",
            nick,tmpbuf3,tmpbuf2,tmpstr);
#else
    char reverse=22;

    if (URLCatch) {
        filepath=OpenCreateFile("ScrollZ.notepad",1);
        numurl=GrabURL(msg,tmpbuf4,filepath);
        message=tmpbuf4;
    }
    else message=msg;
    StripAnsi(message,tmpbuf3,1);
    if (!ExtMes || !userhost) sprintf(tmpbuf1,"%c[%s]%c %s",reverse,nick,reverse,tmpbuf3);
    else {
        strcpy(tmpbuf2,userhost);
        UserDomain(tmpbuf2);
        sprintf(tmpbuf1,"%c[%s!%s]%c %s",reverse,nick,tmpbuf2,reverse,tmpbuf3);
    }
    malloc_strcpy(&LastMessage,tmpbuf1);
    if (print) put_it("%s",tmpbuf1);
#endif
    if (away_set || LogOn) {
       AwaySave(tmpbuf1,SAVEMSG);
       AwayMsgNum++;
       update_all_status();
    }
    AddNick2List(nick);
    if (URLCatch && numurl)
        say("Added %d URL%s to NotePad (%c%s%c)",numurl,numurl==1?"":"s",bold,filepath,
            bold);
}

/* Handles net splits */
void HandleSplit(reason,nick,channel,netsplit)
char *reason;
char *nick;
char *channel;
int  *netsplit;
{
    *netsplit=0;
    if (!NHDisp) return;
    if (wild_match("*.* *.*",reason) && !Check4Fake(reason)) {
        if (AddSplitter(nick,channel,reason)) *netsplit=2;
        else *netsplit=1;
    }
}

/* Checks joined person */
NickList *CheckJoin(nick,userhost,channel,server,tmpchan)
char *nick;
char *userhost;
char *channel;
int  server;
ChannelList *tmpchan;
{
    int  privs;
    int  ischanop;
    char *comment;
    char *tmpignore;
    char tmpbuf[mybufsize/4];
    NickList *tmpjoiner;
    ChannelList *chan;
    struct autobankicks *tmpabk;

    if (tmpchan) chan=tmpchan;
    else chan=lookup_channel(channel,server,0);
    if (!chan) return(NULL);
    tmpjoiner=CheckJoiners(nick,channel,server,chan);
    if (tmpjoiner && tmpjoiner->frlist && !(tmpjoiner->frlist->passwd))
        privs=tmpjoiner->frlist->privs;
    else privs=0;
    ischanop=(chan->status)&CHAN_CHOP;
    sprintf(tmpbuf,"%s!%s",nick,userhost);
    if (!(privs&160) && ischanop && chan->KickOnBan &&
        IsBanned(tmpbuf,channel,server,chan))
#if defined(VILAS) || defined(FET)
        send_to_server("KICK %s %s :Banned",channel,nick);
#elif defined(TOOLIE)
        send_to_server("KICK %s %s :%s Banned <SZ-K>",channel,nick,ToolieA);
#else  /* TOOLIE */
        send_to_server("KICK %s %s :<ScrollZ-K> Banned",channel,nick);
#endif /* VILAS || FET */
    else if (ischanop && (tmpabk=tmpjoiner->shitlist)) {
        if ((tmpabk->shit)&2)
            send_to_server("MODE %s -o+b %s %s",channel,nick,tmpabk->userhost);
        if ((tmpabk->shit)&1) {
            if (tmpabk->reason[0]) comment=tmpabk->reason;
            else comment=DefaultABK;
#if defined(VILAS) || defined(FET)
            send_to_server("KICK %s %s :%s",channel,nick,comment);
#elif defined(TOOLIE)
            send_to_server("KICK %s %s :%s %s <SZ-ABK>",channel,nick,ToolieA,comment);
#else  /* TOOLIE */
            send_to_server("KICK %s %s :<ScrollZ-ABK> %s",channel,nick,comment);
#endif /* VILAS || FET */
        }
        if ((tmpabk->shit)&4) {
            tmpignore=index(tmpabk->userhost,'!');
            if (tmpignore) tmpignore++;
            else tmpignore=tmpabk->userhost;
            sprintf(tmpbuf,"%s ALL",tmpignore);
            Ignore(NULL,tmpbuf,tmpbuf);
        }
    }
    else {
        if (tmpjoiner && chan->FriendList) {
            if (privs&8) {
                if (AutoOpDelay) AddDelayOp(channel,nick,server,0);
                else if (ischanop) send_to_server("MODE %s +o %s",channel,nick);
            }
            else if (privs&256) AddDelayOp(channel,nick,server,1);
        }
    }
    return(tmpjoiner);
}

/* Handles net joins */
int HandleJoin(tmpnick,nick,userhost,channel)
NickList *tmpnick;
char *nick;
char *userhost;
char *channel;
{
    char *servername;
#ifdef WANTANSI
    char *colnick;
    char *tmpstr;
    char *server;
#endif
    char tmpbuf1[mybufsize/4];
#ifdef WANTANSI
    char tmpbuf2[mybufsize/4];
#endif

    servername=tmpbuf1;
    Check4Join(userhost,servername);
    if (!my_stricmp(servername,"000")) {
#ifdef WANTANSI
        if (tmpnick && tmpnick->shitlist && tmpnick->shitlist->shit)
            colnick=CmdsColors[COLJOIN].color6;
        else if (tmpnick && tmpnick->frlist && tmpnick->frlist->privs)
            colnick=CmdsColors[COLJOIN].color5;
        else colnick=CmdsColors[COLJOIN].color1;
        ColorUserHost(userhost,CmdsColors[COLJOIN].color2,tmpbuf1);
        say("%s%s%s %s has joined channel %s%s%s",
            colnick,nick,Colors[COLOFF],tmpbuf1,
            CmdsColors[COLJOIN].color3,channel,Colors[COLOFF]);
#else
        say("%s (%s) has joined channel %s",nick,userhost,channel);
#endif
        return(1);
    }
    else if (my_stricmp(servername,"111")) {
        if (NHDisp) {
            message_from((char *) 0,LOG_CURRENT);
#ifdef WANTANSI
            tmpstr=tmpbuf1;
            server=new_next_arg(tmpstr,&tmpstr);
            sprintf(tmpbuf2,"%sNetjoined%s at %s%s%s : ",
                    CmdsColors[COLNETSPLIT].color1,Colors[COLOFF],
                    CmdsColors[COLNETSPLIT].color2,update_clock(GET_TIME),Colors[COLOFF]);
            say("%s[%s%s%s %s<-%s %s%s%s]",tmpbuf2,
                CmdsColors[COLNETSPLIT].color3,tmpstr,Colors[COLOFF],
                CmdsColors[COLNETSPLIT].color6,Colors[COLOFF],
                CmdsColors[COLNETSPLIT].color3,server,Colors[COLOFF]);
#else
            say("%cNetjoined%c at %s : %s",bold,bold,update_clock(GET_TIME),servername);
#endif
        }
    }
    return(0);
}

/* This executes when you join a channel */
NickList *ChannelJoin(nick,channel,chan)
char *nick;
char *channel;
ChannelList *chan;
{
    int width;
    char tmpbuf1[mybufsize/8];
    char tmpbuf2[mybufsize/32];
    NickList *tmpjoiner;

    if (unban<2) unban=2;
    else unban++;
    inFlierWho++;
    tmpjoiner=CheckJoiners(nick,channel,from_server,chan);
    width=get_int_var(CHANNEL_NAME_WIDTH_VAR);
    if (width) sprintf(tmpbuf2,"%%s/%%.%ds",width);
    else strcpy(tmpbuf2,"%%s/%%s");
    sprintf(tmpbuf1,tmpbuf2,nick,channel);
    malloc_strcpy(&LastJoin,tmpbuf1);
    do_hook(JOIN_ME_LIST,"%s",channel);
    return(tmpjoiner);
}

/* Handles invite requests */
void HandleInvite(nick,userhost,channel)
char *nick;
char *userhost;
char *channel;
{
    int  isfake=0;
    char *tmpstr;
    char tmpbuf1[mybufsize/4];
#ifdef WANTANSI
    char tmpbuf2[mybufsize/4];
#endif
    struct friends *tmpfriend;

#ifdef WANTANSI
    ColorUserHost(userhost,CmdsColors[COLINVITE].color2,tmpbuf2);
#endif
    tmpstr=channel;
    for (tmpstr=channel;*tmpstr;tmpstr++) {
        if (!isprint(*tmpstr)) {
            isfake=1;
            break;
        }
    }
#ifdef WANTANSI
    sprintf(tmpbuf1,"%s%s%s %s invites you to channel %s%s%s",
            CmdsColors[COLINVITE].color1,nick,Colors[COLOFF],tmpbuf2,
            CmdsColors[COLINVITE].color3,channel,Colors[COLOFF]);
    if (isfake) {
        sprintf(tmpbuf2,"- %sfake%s",CmdsColors[COLINVITE].color4,Colors[COLOFF]);
        strcat(tmpbuf1,tmpbuf1);
    }
#else
    sprintf(tmpbuf1,"%s (%s) invites you to channel %s",nick,userhost,channel);
    if (isfake) strcat(tmpbuf1,"- fake");
#endif
    say("%s",tmpbuf1);
    if (away_set || LogOn) AwaySave(tmpbuf1,SAVEINVITE);
    sprintf(tmpbuf1,"%s!%s",nick,userhost);
    tmpfriend=CheckUsers(tmpbuf1,NULL);
    if ((AutoJoinOnInv && CheckChannel(channel,AutoJoinChannels)) ||
        (tmpfriend && ((tmpfriend->privs)&512))) {
        e_channel("JOIN",channel,NULL);
#ifdef WANTANSI
        say("Auto joining %s%s%s",CmdsColors[COLINVITE].color3,channel,Colors[COLOFF]);
#else
        say("Auto joining %s",channel);
#endif
    }
}

/* Handles operator kills */
void HandleKills(server,nick,userhost,reason)
int server;
char *nick;
char *userhost;
char *reason;
{
    char tmpbuf[mybufsize/2];

    new_free(&WhoKilled);
    sprintf(tmpbuf,"You have been killed by operator %s (%s) %s",nick,userhost,reason);
    malloc_strcpy(&WhoKilled,tmpbuf);
    if (away_set || LogOn) AwaySave(tmpbuf,SAVEKILL);
}

/* Handles nick change */
void HandleNickChange(oldnick,newnick,userhost,server)
char *oldnick;
char *newnick;
char *userhost;
int  server;
{
    int  privs=0;
    int  printed=0;
    char *mynick;
    char tmpbuf[mybufsize/2];
    time_t timenow;
    ChannelList *chan;
    NickList *tmp;

    mynick=get_server_nickname(server);
    timenow=time((time_t *) 0);
    if (!(!my_stricmp(oldnick,mynick) || !my_stricmp(newnick,mynick))) {
        for (chan=server_list[server].chan_list;chan;chan=chan->next) {
            if (chan->NickWatch) {
                if ((tmp=find_in_hash(chan,oldnick))) {
                    if (tmp->frlist) privs=tmp->frlist->privs;
                    else privs=0;
                    if (!(privs&160)) {
                        if (timenow-tmp->nickt>=NickTimer) {
                            tmp->curn=1;
                            tmp->nickp=0;
                            tmp->nickt=timenow;
                        }
                        else tmp->curn++;
                        tmp->nickc++;
                        if (!tmp->nickp && tmp->curn>=NickSensor && ((chan->status)&CHAN_CHOP)) {
#if defined(VILAS) || defined(FET)
                            send_to_server("KICK %s %s :Nick flood detected",chan->channel,oldnick);
#elif defined(TOOLIE)
                            send_to_server("KICK %s %s :%s Nick flood detected <SZ-MK>",chan->channel,oldnick,ToolieA);
#else  /* TOOLIE */
                            send_to_server("KICK %s %s :<ScrollZ-MK> Nick flood detected",chan->channel,oldnick);
#endif /* VILAS || FET */
#ifdef WANTANSI
                            if (!printed) {
                                say("%sNick flood%s detected by %s%s%s",
                                    CmdsColors[COLWARNING].color1,Colors[COLOFF],
                                    CmdsColors[COLWARNING].color2,newnick,Colors[COLOFF]);
                                printed=1;
                            }
#else  /* WANTANSI */
                            if (!printed) {
                                say("%cNick flood%c detected by %s",bold,bold,newnick);
                                printed=1;
                            }
#endif /* WANTANSI */
                            if (away_set || LogOn) {
                                sprintf(tmpbuf,"Nick flood detected by %s (%s)",newnick,userhost);
                                AwaySave(tmpbuf,SAVEMASS);
                            }
                            tmp->nickp=1;
                        }
                    }
                }
            }
        }
    }
    ChangeNickDelay(oldnick,newnick,server);
}

/* Adds comment to buffer */
void AddComment(buffer,comment)
char *buffer;
char *comment;
{
    char tmpbuf[mybufsize/2];

    if (comment && *comment) {
        sprintf(tmpbuf,"%s  (%s)",buffer,comment);
        strcpy(buffer,tmpbuf);
    }
}

/* Handles my kicks */
int HandleMyKick(mynick,nick,userhost,channel,comment,frkick)
char *mynick;
char *nick;
char *userhost;
char *channel;
char *comment;
int  *frkick;
{
    int rejoin=0;
    char tmpbuf[mybufsize/2];
    NickList *joiner;
    ChannelList *chan;

    chan=lookup_channel(channel,from_server,0);
    if (chan && chan->AutoRejoin) {
        sprintf(tmpbuf,"%s",chan->channel);
        if (chan->key) {
            strcat(tmpbuf," :");
            strcat(tmpbuf,chan->key);
        }
        e_channel("JOIN",tmpbuf,tmpbuf);
        rejoin=1;
    }
    if (away_set || LogOn) {
        sprintf(tmpbuf,"You have been kicked off channel %s by %s (%s)",
                channel,nick,userhost);
        AddComment(tmpbuf,comment);
        AwaySave(tmpbuf,SAVEKICK);
    }
    joiner=CheckJoiners(mynick,channel,from_server,chan);
    *frkick=(joiner && joiner->frlist)?joiner->frlist->privs:0;
    return(rejoin);
}

/* Handles kicks */
void HandleKick(nick,who,userhost,channel,comment,frkick)
char *nick;
char *who;
char *userhost;
char *channel;
char *comment;
int  *frkick;
{
    int  privs=0;
    int  tmplevel=0;
    char *userh;
    char *mynick;
    char tmpbuf[mybufsize/2];
    time_t timenow;
    NickList *joiner;
    ChannelList *chan;

    chan=lookup_channel(channel,from_server,0);
    joiner=CheckJoiners(who,channel,from_server,chan);
    if (chan) chan->kick++;
    timenow=time((time_t *) 0);
    if (joiner && joiner->userhost) {
        userh=joiner->userhost;
        if (joiner->frlist) tmplevel=joiner->frlist->privs;
        else tmplevel=0;
        mynick=get_server_nickname(from_server);
        joiner=CheckJoiners(nick,channel,from_server,chan);
        if (joiner) {
            if (joiner->curk==0) joiner->kickp=0;
            if (timenow-joiner->kickt>=KickTimer) {
                joiner->curk=1;
                joiner->kickp=0;
                joiner->kickt=timenow;
            }
            else joiner->curk++;
            joiner->kick++;
        }
        if (my_stricmp(nick,mynick) && my_stricmp(nick,who)) {
            if (joiner && joiner->userhost && chan) {
                if (chan->FriendList && joiner->frlist) privs=joiner->frlist->privs;
                else privs=0;
                if (!(privs&160)) {
                    if (joiner->curk>=KickSensor && joiner->curk<KickSensor*2) {
                        if (!(joiner->kickp) && chan->KickWatch) {
                            if ((chan->status)&CHAN_CHOP)
                                send_to_server("MODE %s -o %s",channel,nick);
#ifdef WANTANSI
                            say("%sMass kick%s detected on %s%s%s by %s%s%s",
                                CmdsColors[COLWARNING].color1,Colors[COLOFF],
                                CmdsColors[COLWARNING].color4,channel,Colors[COLOFF],
                                CmdsColors[COLWARNING].color2,nick,Colors[COLOFF]);
#else  /* WANTANSI */
                            say("%cMass kick%c detected on %s by %s",bold,bold,channel,
                                nick);
#endif /* WANTANSI */
                            if (away_set || LogOn) {
                                sprintf(tmpbuf,"Mass kick detected on %s by %s (%s)",
                                        channel,nick,userhost);
                                AwaySave(tmpbuf,SAVEMASS);
                            }
                        }
                        joiner->kickp=1;
                    }
                    if (joiner->curk>=KickSensor*2) {
                        if (joiner->kickp<2 && chan->KickWatch && chan->KickOnFlood) {
                            if ((chan->status)&CHAN_CHOP)
#if defined(VILAS) || defined(FET)
                                send_to_server("KICK %s %s :Kick flood detected",channel,nick);
#elif defined(TOOLIE)
                                send_to_server("KICK %s %s :%s Kick flood detected <SZ-MK>",channel,nick,ToolieA);
#else  /* TOOLIE */
                                send_to_server("KICK %s %s :<ScrollZ-MK> Kick flood detected",channel,nick);
#endif /* VILAS || FET */
#ifdef WANTANSI
                            say("%sKick flood%s detected on %s%s%s by %s%s%s",
                                CmdsColors[COLWARNING].color1,Colors[COLOFF],
                                CmdsColors[COLWARNING].color4,channel,Colors[COLOFF],
                                CmdsColors[COLWARNING].color2,nick,Colors[COLOFF]);
#else  /* WANTANSI */
                            say("%cKick flood%c detected on %s by %s",bold,bold,channel,
                                nick);
#endif /* WANTANSI */
                            if (away_set || LogOn) {
                                sprintf(tmpbuf,"Kick flood detected on %s by %s (%s)",
                                        channel,nick,userhost);
                                AwaySave(tmpbuf,SAVEMASS);
                            }
                        }
                        joiner->kickp=2;
                    }
                }
            }
            if (chan && chan->FriendList && (tmplevel&160)) {
                if ((chan->status)&CHAN_CHOP) {
                    if ((tmplevel&128) && !(privs&128))
                        send_to_server("MODE %s -o %s",channel,nick);
                    if ((tmplevel&1) && ((tmplevel&128) ||
                                         ((tmplevel&32) && !(privs&128))))
                        send_to_server("INVITE %s %s",who,channel);
                }
                if (away_set || LogOn) {
                    sprintf(tmpbuf,"%s (%s) has been kicked off channel %s by %s (%s)",
                            who,userh,channel,nick,userhost);
                    AddComment(tmpbuf,comment);
                    AwaySave(tmpbuf,SAVEPROT);
                }
            }
        }
    }
    *frkick=tmplevel;
}

/* Handles tab key */
void HandleTab() {
    int  len;
    char *tmpstr;
    char *nickstr;
    char *channel;
    char *cmdchars;
    char tmpbuf[mybufsize/8];
    static char *tabnick=NULL;
    Screen *curscr=current_screen;
    NickList *tmpnick;
    ChannelList *chan;

    tmpstr=&(curscr->input_buffer[curscr->buffer_min_pos]);
    if (*tmpstr && (!my_strnicmp(tmpstr,"/m ",3) || !my_strnicmp(tmpstr,"/msg ",5))) {
        while (*tmpstr && !isspace(*tmpstr)) tmpstr++;
        if (*tmpstr) {
            tmpstr++;
            if (*tmpstr && (channel=get_channel_by_refnum(0)))
                if ((chan=lookup_channel(channel,from_server,0))) {
                    if (tabnickcompl && tabnick) {
                        tmpnick=tabnickcompl->next;
                        len=strlen(tabnick);
                    }
                    else {
                        for (nickstr=tmpbuf;*tmpstr;) *nickstr++=*tmpstr++;
                        *nickstr=0;
                        len=strlen(tmpbuf);
                        tmpnick=chan->nicks;
                        malloc_strcpy(&tabnick,tmpbuf);
                    }
                    for (;tmpnick;tmpnick=tmpnick->next)
                        if (!my_strnicmp(tmpnick->nick,tabnick,len)) break;
                    if (!tmpnick) {
                        for (tmpnick=chan->nicks;tmpnick;tmpnick=tmpnick->next)
                            if (!my_strnicmp(tmpnick->nick,tabnick,len)) break;
                    }
                    if (tmpnick) {
                        input_clear_line(0,(char *) 0);
                        if (!(cmdchars=get_string_var(CMDCHARS_VAR))) cmdchars=DEFAULT_CMDCHARS;
                        input_add_character(*cmdchars,NULL);
                        input_add_character('m',NULL);
                        input_add_character(' ',NULL);
                        for (tmpstr=tmpnick->nick;tmpstr && *tmpstr;tmpstr++)
                            input_add_character(*tmpstr,NULL);
                        input_add_character(' ',NULL);
                        tabnickcompl=tmpnick;
                        return;
                    }
                }
        }
    }
    new_free(&tabnick);
    tabnickcompl=NULL;
    if (nickcur) {
        input_clear_line(0,(char *) 0);
        if (!(cmdchars=get_string_var(CMDCHARS_VAR))) cmdchars=DEFAULT_CMDCHARS;
        input_add_character(*cmdchars,NULL);
        input_add_character('m',NULL);
        input_add_character(' ',NULL);
        for (tmpstr=nickcur->nick;tmpstr && *tmpstr;tmpstr++)
            input_add_character(*tmpstr,NULL);
        input_add_character(' ',NULL);
        NickNext();
    }
}

/* Handles end of bans reply */
void EndOfBans(channel,server)
char *channel;
int  server;
{
    ChannelList *chan;

    if (unban>2) unban--;
    else unban=0;
    chan=lookup_channel(channel,server,0);
    if (!chan) return;
    if (!chan->gotbans) {
        chan->gotbans=1;
        if (chan->gotwho) PrintSynch(chan);
    }
}

/* Handles received notice */
void HandleNotice(nick,notice,userhost,print)
char *nick;
char *notice;
char *userhost;
int  print;
{
    char tmpbuf[mybufsize/2];

    if (print)
#ifdef WANTANSI
        sprintf(tmpbuf,"%s-%s",CmdsColors[COLNOTICE].color5,Colors[COLOFF]);
        put_it("%s%s%s%s%s %s%s%s",tmpbuf,
               CmdsColors[COLNOTICE].color1,nick,Colors[COLOFF],tmpbuf,
               CmdsColors[COLNOTICE].color3,notice,Colors[COLOFF]);
#else
        put_it("%c-%s-%c %s",bold,nick,bold,notice);
#endif
    sprintf(tmpbuf,"%c-%c%s%c-%c %s",bold,bold,nick,bold,bold,notice);
    malloc_strcpy(&LastNotice,tmpbuf);
    if (away_set || LogOn) AwaySave(LastNotice,SAVENOTICE);
}

/* Handles closed connections from server */
void HandleClosedConn(server,reason)
int server;
char *reason;
{
    if (away_set || LogOn) AwaySave(reason,SAVESERVER);
}

#ifdef EXTRA_STUFF
/* Handles on the fly renaming of files */
void HandleRename(dccstuff)
char **dccstuff;
{
    char tmpbuf[mybufsize/8];

    if (RenameFiles) {
        FixName(tmpbuf);
        new_free(dccstuff);
        malloc_strcpy(dccstuff,tmpbuf);
    }
}
#endif

/* Handles flooding */
void HandleFlood(nick,userhost,ignoretype)
char *nick;
char *userhost;
char *ignoretype;
{
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    NickList *joiner;
    struct friends *tmpfriend;

    if (!userhost) return;
    if (!(joiner=CheckJoiners(nick,NULL,from_server,NULL))) {
        sprintf(tmpbuf1,"%s!%s",nick,userhost);
        tmpfriend=CheckUsers(tmpbuf1,NULL);
    }
    else tmpfriend=joiner->frlist;
    if (!tmpfriend || !((tmpfriend->privs)&1024)) {
        if (FloodProt) {
            sprintf(tmpbuf1,"%s %s",userhost,ignoretype);
            sprintf(tmpbuf2,"%d",IgnoreTime);
            ignore(NULL,tmpbuf1,tmpbuf2);
            sprintf(tmpbuf1,"%d IGNORE %s NONE",IgnoreTime,userhost);
            timercmd("TIMER",tmpbuf1,NULL);
        }
#ifdef WANTANSI
        ColorUserHost(userhost,CmdsColors[COLWARNING].color3,tmpbuf2);
        sprintf(tmpbuf1,"%s%s flooding%s detected from %s%s%s %s",
                CmdsColors[COLWARNING].color1,ignoretype,Colors[COLOFF],
                CmdsColors[COLWARNING].color2,nick,Colors[COLOFF],tmpbuf2);
#else
        sprintf(tmpbuf1,"%c%s flooding%c detected from %s (%s)",
                bold,ignoretype,bold,nick,userhost);
#endif
        say("%s",tmpbuf1);
        if (away_set || LogOn) AwaySave(tmpbuf1,SAVEFLOOD);
    }
}

#ifdef EXTRAS
/* Locks channel mode */
void ModeLocked(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *mode=(char *) 0;
    char *tmpchannel=(char *) 0;
    char tmpbuf[mybufsize/4];
    ChannelList *chan;

    tmpchannel=new_next_arg(args,&args);
    mode=args;
    if (tmpchannel && mode && *tmpchannel && *mode) {
        if (!is_channel(tmpchannel)) sprintf(tmpbuf,"#%s",tmpchannel);
        else strcpy(tmpbuf,tmpchannel);
        chan=lookup_channel(tmpbuf,curr_scr_win->server,0);
        if (chan) {
            malloc_strcpy(&(chan->modelock),mode);
            CheckLock(chan->channel,curr_scr_win->server,chan);
            say("Mode %s is now locked for channel %s",mode,chan->channel);
        }
        else say("You are not on channel %s on this server",tmpbuf);
    }
    else PrintUsage("/MODELOCK [#]channel mode");
}

/* Checks if there is a need to put lock mode back */
void CheckLock(channel,server,tmpchan)
char *channel;
int  server;
ChannelList *tmpchan;
{
    int  plus;
    int  count;
    char *mode;
    char *lockmode;
    char *tmpmode;
    char *tmplmode;
    char *inmode;
    char tmpbuf1[mybufsize/8];
    char tmpbuf2[mybufsize/8];
    ChannelList *chan;

    if (!tmpchan) chan=lookup_channel(channel,server,0);
    else chan=tmpchan;
    *tmpbuf1='\0';
    plus=0;
    if (chan && chan->modelock) {
        mode=recreate_mode(chan);
        lockmode=chan->modelock;
        while (*lockmode) {
            if (*lockmode=='+') plus=1;
            else if (*lockmode=='-') plus=0;
            else {
                inmode=strchr(mode,*lockmode);
                if (!plus && inmode) {
                    if (*lockmode!='k') {
                        sprintf(tmpbuf2,"-%c",*lockmode);
                        strcat(tmpbuf1,tmpbuf2);
                    }
                    else ClearKey(NULL,channel,NULL);
                }
                if (plus && !inmode) {
                    if (*lockmode!='l') {
                        sprintf(tmpbuf2,"+%c",*lockmode);
                        strcat(tmpbuf1,tmpbuf2);
                    }
                    else {
                        tmpmode=lockmode;
                        while (*tmpmode && *tmpmode!=' ') tmpmode++;
                        if (*tmpmode==' ') tmpmode++;
                        sprintf(tmpbuf2,"+l %s",tmpmode);
                        strcat(tmpbuf1,tmpbuf2);
                    }
                }
                if (plus && *lockmode=='l' && inmode) {
                    tmpmode=mode;
                    count=1;
                    while (*tmpmode!='l') {
                        if (*tmpmode=='l' || *tmpmode=='k') count++;
                        tmpmode++;
                    }
                    tmpmode=mode;
                    while (count) {
                        while (*tmpmode!=' ') tmpmode++;
                        tmpmode++;
                        count--;
                    }
                    tmplmode=lockmode;
                    while (*tmplmode!=' ') tmplmode++;
                    if (*tmplmode==' ') tmplmode++;
                    inmode=tmplmode;
                    while (*tmplmode==*tmpmode) {
                        tmplmode++;
                        tmpmode++;
                    }
                    if (*tmplmode && *tmplmode!=*tmpmode) {
                        sprintf(tmpbuf2,"+l %s",inmode);
                        strcat(tmpbuf1,tmpbuf2);
                    }
                }
            }
            lockmode++;
            if (*lockmode==' ') break;
        }
        if (chan && ((chan->status)&CHAN_CHOP) && tmpbuf1[0])
            send_to_server("MODE %s %s",channel,tmpbuf1);
    }
}
#endif

/* Handles end of who reply */
void HandleEndOfWho(channel,server)
char *channel;
int  server;
{
    ChannelList *chan;

    chan=lookup_channel(channel,server,0);
    if (!chan) return;
    if (!chan->gotwho) {
        chan->gotwho=1;
        if (chan->gotbans) PrintSynch(chan);
    }
}

/* Toggles CTCP cloaking on/off */
void CTCPCloakingToggle(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    if (*args) {
        if (!my_stricmp(args,"ON")) CTCPCloaking=1;
        else if (!my_stricmp(args,"HIDE")) CTCPCloaking=2;
        else if (!my_stricmp(args,"OFF")) CTCPCloaking=0;
        else {
            PrintUsage("/CTCPCLOAK on/off/hide");
            return;
        }
    }
    if (CTCPCloaking==1) PrintSetting("CTCP cloaking","ON",empty_string,empty_string);
    else if (CTCPCloaking==2) PrintSetting("CTCP cloaking","HIDE",empty_string,empty_string);
    else PrintSetting("CTCP cloaking","OFF",empty_string,empty_string);
    update_all_status();
}

void Check4WordKick(line,joiner,privs,chan)
char *line;
NickList *joiner;
int  privs;
ChannelList *chan;
{
    struct words *tmpword;

    if (chan && ((chan->status)&CHAN_CHOP) && !(privs&1024) && joiner &&
        (chan->KickOps || !(joiner->chanop)) && (tmpword=CheckLine(chan->channel,line)))
#if defined(VILAS) || defined(FET)
        send_to_server("KICK %s %s :%s",chan->channel,joiner->nick,tmpword->reason);
#elif defined(TOOLIE)
        send_to_server("KICK %s %s :%s %s <SZ-WK>",chan->channel,joiner->nick,ToolieA,
                       tmpword->reason);
#else  /* TOOLIE */
        send_to_server("KICK %s %s :<ScrollZ-WK> %s",chan->channel,joiner->nick,
                       tmpword->reason);
#endif /* VILAS || FET */
}

/* Ops everyone on the current channel */
void MassOp(command,args,subargs)
char *command;
char *args;
{
    int  send=0;
    int  count=0;
    int  all=1;
    int  isfriend;
    int  max=get_int_var(MAX_MODES_VAR);
    char *tmpstr;
    char *channel;
    char *mynick=get_server_nickname(from_server);
    char tmpbuf1[mybufsize];
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
    NickList *tmp;
    ChannelList *chan;

    tmpstr=new_next_arg(args,&args);
    if (tmpstr && !my_stricmp(tmpstr,"-O")) {
        all=0;
        tmpstr=new_next_arg(args,&args);
    }
    if (tmpstr && is_channel(tmpstr)) channel=tmpstr;
    else if (!(channel=get_channel_by_refnum(0))) {
        NoWindowChannel();
        return;
    }
    chan=lookup_channel(channel,curr_scr_win->server,0);
    if (!chan) return;
    if ((chan->status)&CHAN_CHOP) {
        *tmpbuf1='\0';
        *tmpbuf2='\0';
        for (tmp=chan->nicks;tmp;tmp=tmp->next) {
            isfriend=tmp->frlist && ((tmp->frlist->privs)&4 || (tmp->frlist->privs)&8);
            if ((all || (!all && isfriend)) && !(tmp->chanop) &&
                my_stricmp(mynick,tmp->nick)) {
                strcat(tmpbuf2," +o ");
                strcat(tmpbuf2,tmp->nick);
                count++;
                send=1;
            }
            if (count==max) {
                sprintf(tmpbuf3,"MODE %s %s\r\n",channel,tmpbuf2);
                strcat(tmpbuf1,tmpbuf3);
                *tmpbuf2='\0';
                count=0;
            }
            if (strlen(tmpbuf1)>=IRCD_BUFFER_SIZE-150) {
                send_to_server("%s",tmpbuf1);
                *tmpbuf1='\0';
                send=0;
            }
        }
        if (count) {
            sprintf(tmpbuf3,"MODE %s %s\r\n",channel,tmpbuf2);
            strcat(tmpbuf1,tmpbuf3);
            send=1;
        }
        if (send) send_to_server("%s",tmpbuf1);
    }
    else NotChanOp(channel);
}

/* Compare function for list.c */
int AddFirst(element,toadd)
List *element;
List *toadd;
{
    return(1);
}

/* This adds ban to ban list */
void AddBan(ban,channel,server,nick,when,tmpchan)
char *ban;
char *channel;
int  server;
char *nick;
time_t when;
ChannelList *tmpchan;
{
    ChannelList *chan;
    struct bans *tmpban;

    if (channel && tmpchan) chan=tmpchan;
    else chan=lookup_channel(channel,server,0);
    if (chan) {
        tmpban=(struct bans *) list_lookup((List **) &(chan->banlist),ban,
                                           !USE_WILDCARDS,!REMOVE_FROM_LIST);
        if (tmpban) return;
        tmpban=(struct bans *) new_malloc(sizeof(struct bans));
        tmpban->ban=(char *) 0;
        tmpban->who=(char *) 0;
        malloc_strcpy(&(tmpban->ban),ban);
        if (nick) malloc_strcpy(&(tmpban->who),nick);
        tmpban->when=when;
        tmpban->next=NULL;
        add_to_list_ext((List **) &(chan->banlist),(List *) tmpban,
                        (int (*) _((List *, List *))) AddFirst);
    }
}

/* This removes ban from ban list */
void RemoveBan(ban,chan)
char *ban;
ChannelList *chan;
{
    struct bans *tmpban;

    if (!chan) return;
    tmpban=(struct bans *) list_lookup((List **) &chan->banlist,ban,!USE_WILDCARDS,
                                       REMOVE_FROM_LIST);
    if (tmpban) {
        new_free(&(tmpban->ban));
        new_free(&(tmpban->who));
        new_free(&tmpban);
    }
}

/* This really unbans user */
void UnbanIt(pattern,channel,server)
char *pattern;
char *channel;
int  server;
{
    int  count=0;
    int  max=get_int_var(MAX_MODES_VAR);
    char *banmodes=(char *) 0;
    ChannelList *chan;
    struct bans *tmpban;

    chan=lookup_channel(channel,server,0);
    if (!chan) return;
    for (tmpban=chan->banlist;tmpban;tmpban=tmpban->next) {
        if (wild_match(pattern,tmpban->ban) || wild_match(tmpban->ban,pattern)) {
            malloc_strcat(&banmodes," -b ");
            malloc_strcat(&banmodes,tmpban->ban);
            count++;
        }
        if (count==max) {
            send_to_server("MODE %s %s",channel,banmodes);
            new_free(&banmodes);
            count=0;
        }
    }
    if (count) {
        send_to_server("MODE %s %s",channel,banmodes);
        new_free(&banmodes);
    }
}

/* Shows all bans and asks which one you wanna remove */
void TBan(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel;
    char tmpbuf[mybufsize/4];
    ChannelList *chan;

    if (args && *args) {
        channel=new_next_arg(args,&args);
        if (is_channel(channel)) strcpy(tmpbuf,channel);
        else sprintf(tmpbuf,"#%s",channel);
        channel=tmpbuf;
    }
    else if (!(channel=get_channel_by_refnum(0))) {
        NoWindowChannel();
        return;
    }
    if (!(chan=lookup_channel(channel,from_server,0))) {
        say("You are not on channel %s",channel);
        return;
    }
    if (chan && ((chan->status)&CHAN_CHOP)) {
        tmpbanlist=chan->banlist;
        tmpbn=tmpbanlist;
        listcount=0;
        ListBansPage(chan->channel);
        return;
    }
    else NotChanOp(chan->channel);
}

/* Lists one page of bans list */
void ListBansPage(line)
char *line;
{
    int count=1;

    while (count<curr_scr_win->display_size && tmpbanlist) {
        count++;
        if (!listcount) say("Listing all bans on channel %s",line);
        listcount++;
        if (tmpbanlist->who && tmpbanlist->when)
            say("#%-2d %s set by %s on %.19s",listcount,tmpbanlist->ban,tmpbanlist->who,
                ctime(&tmpbanlist->when));
        else say("#%-2d %s",listcount,tmpbanlist->ban);
        tmpbanlist=tmpbanlist->next;
    }
    if (!tmpbanlist) {
        if (listcount) {
            say("Total of %d bans",listcount);
            add_wait_prompt("Press ENTER to quit or filter (-2,4,6-8,10- or *) : ",ListBansPrompt,line,WAIT_PROMPT_LINE);
        }
        else say("There are no bans on channel %s",line);
    }
    else if (count>=curr_scr_win->display_size) add_wait_prompt("Press ENTER to quit or filter (-2,4,6-8,10- or *) : ",ListBansPrompt,line,WAIT_PROMPT_LINE);
}

/* This waits for line input */
void ListBansPrompt(stuff,line)
char *stuff;
char *line;
{
    int  max=get_int_var(MAX_MODES_VAR);
    int  count=0;
    int  number=0;
    char *banmodes=(char *) 0;

    if (line && *line) {
        for (tmpbanlist=tmpbn;tmpbanlist;tmpbanlist=tmpbanlist->next) {
            count++;
            if (matchmcommand(line,count)) {
                malloc_strcat(&banmodes," -b ");
                malloc_strcat(&banmodes,tmpbanlist->ban);
                number++;
            }
            if (number==max) {
                send_to_server("MODE %s %s",stuff,banmodes);
                new_free(&banmodes);
                number=0;
            }
        }
        if (number) {
            send_to_server("MODE %s %s",stuff,banmodes);
            new_free(&banmodes);
        }
        return;
    }
    else if (tmpbanlist) ListBansPage(stuff);
}

/* Handles fake modes */
void HandleFakes(line,from,server)
char *line;
char *from;
int  server;
{
    char *tmpstr=(char *) 0;
    char *tmpnick=(char *) 0;
    char *tmpchan=(char *) 0;
    char *tmpwhat=(char *) 0;
    char *tmparg;
    char tmpbuf1[mybufsize/2];
#ifdef WANTANSI
    char tmpbuf2[mybufsize/2];
#endif
    ChannelList *chan;

    strcpy(tmpbuf1,line);
    tmparg=tmpbuf1;
    tmpstr=new_next_arg(tmparg,&tmparg);
    tmpstr=new_next_arg(tmparg,&tmparg);
    tmpstr=new_next_arg(tmparg,&tmparg);
    tmpstr=new_next_arg(tmparg,&tmparg);
    tmpnick=new_next_arg(tmparg,&tmparg);
    tmpstr=new_next_arg(tmparg,&tmparg);
    tmpchan=new_next_arg(tmparg,&tmparg);
    tmpwhat=tmpchan;
    while (*tmpwhat) tmpwhat++;
    tmpwhat++;
    tmparg=tmpwhat;
    while (*tmparg) tmparg++;
    tmparg--;
    *tmparg=0;
    for (chan=server_list[server].chan_list;chan;chan=chan->next)
        if (chan->ShowFakes && server==chan->server && !my_stricmp(tmpchan,chan->channel)) {
#ifdef WANTANSI
            sprintf(tmpbuf2,"%sFake%s %s%s%s %sMODE%s %s",
                    CmdsColors[COLMODE].color6,Colors[COLOFF],
                    CmdsColors[COLMODE].color1,tmpnick,Colors[COLOFF],
                    CmdsColors[COLMODE].color5,Colors[COLOFF],
                    CmdsColors[COLMODE].color3);
            sprintf(tmpbuf1,"%s%s%s \"%s%s%s\" from %s%s%s",
                    tmpbuf2,tmpchan,Colors[COLOFF],
                    CmdsColors[COLMODE].color4,tmpwhat,Colors[COLOFF],
                    CmdsColors[COLMODE].color2,from,Colors[COLOFF]);
#else
            sprintf(tmpbuf1,"%cFake%c %s MODE %s %s from %s",
                    bold,bold,tmpnick,tmpchan,tmpwhat,from);
#endif
            say("%s",tmpbuf1);
            if (away_set || LogOn) AwaySave(tmpbuf1,SAVEFAKE);
            return;
        }
}

#ifdef EXTRAS
/* Resets channel's lock mode */
void ModeUnlocked(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel;
    char tmpbuf[mybufsize/4];
    ChannelList *chan;

    if (args && *args) {
        channel=new_next_arg(args,&args);
        if (is_channel(channel)) strcpy(tmpbuf,channel);
        else sprintf(tmpbuf,"#%s",channel);
        channel=tmpbuf;
    }
    else if ((channel=get_channel_by_refnum(0))==NULL) {
        NoWindowChannel();
        return;
    }
    chan=lookup_channel(channel,curr_scr_win->server,0);
    if (!chan) {
        say("You're not on channel %s on this server",channel);
        return;
    }
    if (chan->modelock) {
        say("Mode lock %s has been removed for channel %s",chan->modelock,channel);
        new_free(&(chan->modelock));
    }
}
#endif

#ifdef SCKICKS
/* Kicks nick with funny message */
void ScatterKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  number=0;
    int  kicked=0;
    char *channel;
    char *tmpnick=(char *) 0;
    char *tmpkick=(char *) 0;
    char *tmpcommand=(char *) 0;
    char *tmpstr;
    char *tmpstr1;
    char *comment;
    char tmpbuf1[mybufsize/2];
    char tmpbuf2[mybufsize/2];
    char tmpbuf3[mybufsize/2];
    NickList *joiner;

    channel=get_channel_by_refnum(0);
    if (channel) {
        if (NumberOfScatterKicks) {
            tmpkick=new_next_arg(args,&args);
            tmpnick=new_next_arg(args,&args);
            if (tmpnick && tmpkick) {
                if (is_chanop(channel,get_server_nickname(from_server))) {
                    number=atoi(tmpkick);
                    if (number>0 && number<=NumberOfScatterKicks) {
                        number--;
                        strcpy(tmpbuf1,PickScatterKick(number));
                        tmpstr=tmpbuf1;
                        joiner=CheckJoiners(tmpnick,channel,from_server,NULL);
                        if (joiner) {
                            while (1) {
                                tmpcommand=new_next_arg(tmpstr,&tmpstr);
                                if (!tmpcommand) break;
                                *tmpbuf2='\0';
                                if (!my_stricmp("$M",tmpcommand)) {
                                    do {
                                        tmpstr1=new_next_arg(tmpstr,&tmpstr);
                                        if (!tmpstr1) break;
                                        if (*tmpstr1=='$' && *(tmpstr1+1)=='0') {
                                            tmpstr1++;
                                            tmpstr1++;
                                            if (!joiner) strcat(tmpbuf2,tmpnick);
                                            else strcat(tmpbuf2,joiner->nick);
                                            strcat(tmpbuf2,tmpstr1);
                                        }
                                        else if (!my_stricmp("$C",tmpstr1)) strcat(tmpbuf2,channel);
                                        else if (*tmpstr1=='$' && *(tmpstr1+1)=='N') {
                                            tmpstr1++;
                                            tmpstr1++;
                                            strcat(tmpbuf2,get_server_nickname(from_server));
                                            strcat(tmpbuf2,tmpstr1);
                                        }
                                        else if (*tmpstr1!=';') strcat(tmpbuf2,tmpstr1);
                                        strcat(tmpbuf2," ");
                                    } while (tmpstr1 && *tmpstr1!=';');
                                    if (!kicked) me(NULL,tmpbuf2,NULL);
                                    else {
                                        sprintf(tmpbuf3,"-CMD ME %s",tmpbuf2);
                                        waitcmd(NULL,tmpbuf3,NULL);
                                    }
                                }
                                if (!my_stricmp("$S",tmpcommand)) {
                                    do {
                                        tmpstr1=new_next_arg(tmpstr,&tmpstr);
                                        if (!tmpstr1) break;
                                        if (*tmpstr1=='$' && *(tmpstr1+1)=='0') {
                                            tmpstr1++;
                                            tmpstr1++;
                                            if (!joiner) strcat(tmpbuf2,tmpnick);
                                            else strcat(tmpbuf2,joiner->nick);
                                            strcat(tmpbuf2,tmpstr1);
                                        }
                                        else if (!my_stricmp("$C",tmpstr1)) strcat(tmpbuf2,channel);
                                        else if (*tmpstr1=='$' && *(tmpstr1+1)=='N') {
                                            tmpstr1++;
                                            tmpstr1++;
                                            strcat(tmpbuf2,get_server_nickname(from_server));
                                            strcat(tmpbuf2,tmpstr1);
                                        }
                                        else if (*tmpstr1!=';') strcat(tmpbuf2,tmpstr1);
                                        strcat(tmpbuf2," ");
                                    } while (tmpstr1 && *tmpstr1!=';');
                                    if (!kicked) send_text(channel,tmpbuf2,"PRIVMSG");
                                    else {
                                        sprintf(tmpbuf3,"-CMD MSG %s %s",channel,tmpbuf2);
                                        waitcmd(NULL,tmpbuf3,NULL);
                                    }
                                }
                                if (!my_stricmp("$K",tmpcommand)) {
                                    do {
                                        tmpstr1=new_next_arg(tmpstr,&tmpstr);
                                        if (!tmpstr1) break;
                                        if (*tmpstr1=='$' && *(tmpstr1+1)=='0') {
                                            tmpstr1++;
                                            tmpstr1++;
                                            if (!joiner) strcat(tmpbuf2,tmpnick);
                                            else strcat(tmpbuf2,joiner->nick);
                                            strcat(tmpbuf2,tmpstr1);
                                        }
                                        else if (!my_stricmp("$C",tmpstr1)) strcat(tmpbuf2,channel);
                                        else if (*tmpstr1=='$' && *(tmpstr1+1)=='N') {
                                            tmpstr1++;
                                            tmpstr1++;
                                            strcat(tmpbuf2,get_server_nickname(from_server));
                                            strcat(tmpbuf2,tmpstr1);
                                        }
                                        else if (*tmpstr1!=';') strcat(tmpbuf2,tmpstr1);
                                        strcat(tmpbuf2," ");
                                    } while (tmpstr1 && *tmpstr1!=';');
                                    while (tmpbuf2[strlen(tmpbuf2)-1]==' ') tmpbuf2[strlen(tmpbuf2)-1]=0;
                                    if (tmpbuf2[0]) comment=tmpbuf2;
                                    else comment=DefaultSK;
#if defined(VILAS) || defined(FET)
                                    send_to_server("KICK %s %s :%s",channel,
                                                   joiner->nick,comment);
#elif defined(TOOLIE)
                                    send_to_server("KICK %s %s :%s %s <SZ-SK>",channel,
                                                   joiner->nick,ToolieA,comment);
#else  /* TOOLIE */
                                    send_to_server("KICK %s %s :<ScrollZ-SK> %s",channel,
                                                   joiner->nick,comment);
#endif /* VILAS || FET */
                                    kicked=1;
                                }
                            }
                        }
                        else say("Can't find %s on %s",tmpnick,channel);
                    }
                    else {
                        sprintf(tmpbuf1,"/SK # nick (# is from 1 to %d)",NumberOfScatterKicks);
                        PrintUsage(tmpbuf1);
                    }
                }
                else NotChanOp(channel);
            }
            else {
                sprintf(tmpbuf1,"/SK # nick (# is from 1 to %d)",NumberOfScatterKicks);
                PrintUsage(tmpbuf1);
            }
        }
        else say("No scatter kicks defined");
    }
    else NoWindowChannel();
}

/* Randomly picks a funny message and kicks nick */
void RandomScatterKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  number=0;
    char *channel;
    char *tmpnick=(char *) 0;
    char tmpbuf[mybufsize/16];

    channel=get_channel_by_refnum(0);
    if (channel) {
        if (NumberOfScatterKicks) {
            tmpnick=new_next_arg(args,&args);
            if (tmpnick) {
                srand(time(0));
                number=rand()%NumberOfScatterKicks+1;
                sprintf(tmpbuf,"%d %s",number,tmpnick);
                ScatterKick(NULL,tmpbuf,NULL);
            }
            else PrintUsage("/RANSK nick");
        }
        else say("No scatter kicks defined");
    }
    else NoWindowChannel();
}
#endif

#ifdef EXTRAS
/* Kicks nick with last notice */
void LastNoticeKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel;
    char *tmpnick;
    NickList *joiner;
    ChannelList *chan;

    if (!(*args)) PrintUsage("/DIRLNK nick");
    else {
        channel=get_channel_by_refnum(0);
        if (channel) {
            chan=lookup_channel(channel,curr_scr_win->server,0);
            if (chan && ((chan->status)&CHAN_CHOP)) {
                tmpnick=new_next_arg(args,&args);
                joiner=CheckJoiners(tmpnick,channel,curr_scr_win->server,chan);
                if (joiner) {
#if defined(VILAS) || defined(FET)
                    if (LastNotice) send_to_server("KICK %s %s :%s",channel,tmpnick,LastNotice);
                    else send_to_server("KICK %s %s :%s",channel,tmpnick,DefaultK);
#elif defined(TOOLIE)
                    if (LastNotice) send_to_server("KICK %s %s :%s %s",channel,tmpnick,ToolieA,LastNotice);
                    else send_to_server("KICK %s %s :%s %s",channel,tmpnick,ToolieA,DefaultK);
#else  /* TOOLIE */
                    if (LastNotice) send_to_server("KICK %s %s :<ScrollZ-LNK> %s",channel,tmpnick,LastNotice);
                    else send_to_server("KICK %s %s :<ScrollZ-K> %s",channel,tmpnick,DefaultK);
#endif /* VILAS || FET */
                }
                else say("Can't find %s on %s.",tmpnick,channel);
            }
            else NotChanOp(channel);
        }
        else NoWindowChannel();
    }
}
#endif

/* Prints some statistics about nick */
void NickStat(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  found=0;
    char *tmpnick=(char *) 0;
    NickList *joiner;
    ChannelList *chan;

    if (*args) {
        tmpnick=new_next_arg(args,&args);
        for (chan=server_list[curr_scr_win->server].chan_list;chan;chan=chan->next) {
            joiner=find_in_hash(chan,tmpnick);
            if (joiner) {
                if (!found) {
                    say("Current statistics for %s is :",joiner->nick);
                    say("Channel               +o    -o    +b    -b   kicks  nicks   pub");
                    found=1;
                }
                say("%-19.19s %4d  %4d  %4d  %4d   %5d  %5d  %4d",
                    chan->channel,joiner->pluso,joiner->minuso,
                    joiner->plusb,joiner->minusb,joiner->kick,
                    joiner->nickc,joiner->publics);
            }
        }
        if (!found) say("%s not found on channels you are on",tmpnick);
    }
    else PrintUsage("/NWHOIS nick");
}

/* Adds nick to notify list */
void AddNotify(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick;

    if (*args) {
        while ((tmpnick=new_next_arg(args,&args)))
            notify(NULL,tmpnick,NULL);
    }
    else PrintUsage("/ADDN nick [nick ...]");
}

/* Removes nick from notify list */
void RemoveNotify(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick;
    char tmpbuf[mybufsize/4];

    if (*args) {
        *tmpbuf='\0';
        while ((tmpnick=new_next_arg(args,&args))) {
            strcat(tmpbuf," -");
            strcat(tmpbuf,tmpnick);
        }
        notify(NULL,tmpbuf,NULL);
    }
    else PrintUsage("/REMN nick [nick ...]");
}

/* Handles notify reply */
void HandleNotifyOn(nick,server)
char *nick;
int  server;
{
    AddDelayNotify(nick,server);
}

/* Handles userhost reply */
void HandleUserhost(wistuff,tmpnick,text)
WhoisStuff *wistuff;
char *tmpnick;
char *text;
{
    char tmpbuf1[mybufsize/4];
#ifdef WANTANSI
    char tmpbuf2[mybufsize/4];
#endif
    NotifyList *notify;
#ifdef WANTANSI
    char   *colnick;
#else
    time_t timenow;

    timenow=time((time_t *) 0);
#endif
    inFlierNotify--;
    if (inFlierNotify==1) inFlierNotify=0;
    if (!wistuff->nick) return;
    notify_mark(wistuff->nick,2+wistuff->not_on,0);
    if (wistuff->not_on) return;
    sprintf(tmpbuf1,"%s@%s",wistuff->user,wistuff->host);
#if defined(EXTRAS) || defined(FLIER)
    CheckInvite(wistuff->nick,tmpbuf1,parsing_server_index);
#endif
    notify=(NotifyList *) list_lookup((List **) &notify_list,wistuff->nick,
                                      !USE_WILDCARDS,!REMOVE_FROM_LIST);
    if (notify) {
        malloc_strcpy(&(notify->nick),wistuff->nick);
        malloc_strcpy(&(notify->userhost),tmpbuf1);
    }
    if (do_hook(NOTIFY_SIGNON_UH_LIST,"%s %s %s",wistuff->nick,wistuff->user,wistuff->host)) {
#ifdef WANTANSI
        sprintf(tmpbuf2,"%s!%s",wistuff->nick,tmpbuf1);
        if (CheckUsers(tmpbuf2,NULL)) colnick=CmdsColors[COLNOTIFY].color6;
        else colnick=CmdsColors[COLNOTIFY].color1;
        ColorUserHost(tmpbuf1,CmdsColors[COLNOTIFY].color2,tmpbuf2);
        sprintf(tmpbuf1,"Sign%sOn%s detected: %s%s%s %s ",
                CmdsColors[COLNOTIFY].color4,Colors[COLOFF],
                colnick,wistuff->nick,Colors[COLOFF],tmpbuf2);
        say("%s[%s%s%s]",tmpbuf1,
            CmdsColors[COLNOTIFY].color3,update_clock(GET_TIME),Colors[COLOFF]);
#else
        say("Signon by %s (%s) detected at %.16s",wistuff->nick,tmpbuf1,ctime(&timenow));
#endif
    }
}

/* Handles notify off reply */
void HandleNotifyOff(nick,timenow)
char *nick;
time_t timenow;
{
#ifdef WANTANSI
    say("Sign%sOff%s detected: %s%s%s [%s%s%s]",
        CmdsColors[COLNOTIFY].color4,Colors[COLOFF],
        CmdsColors[COLNOTIFY].color1,nick,Colors[COLOFF],
        CmdsColors[COLNOTIFY].color3,update_clock(GET_TIME),Colors[COLOFF]);
#else
    say("Signoff by %s detected at %.16s",nick,ctime(&timenow));
#endif
}

/* Handles notify userhost off reply */
void HandleNotifyOffUh(nick,userhost,timenow)
char *nick;
char *userhost;
time_t timenow;
{
#ifdef WANTANSI
    char *colnick;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    struct friends *tmpfriend;
#endif

#ifdef WANTANSI
    sprintf(tmpbuf1,"%s!%s",nick,userhost);
    if ((tmpfriend=CheckUsers(tmpbuf1,NULL))) colnick=CmdsColors[COLNOTIFY].color6;
    else colnick=CmdsColors[COLNOTIFY].color1;
    ColorUserHost(userhost,CmdsColors[COLNOTIFY].color2,tmpbuf2);
    sprintf(tmpbuf1,"Sign%sOff%s detected: %s%s%s %s",
            CmdsColors[COLNOTIFY].color4,Colors[COLOFF],
            colnick,nick,Colors[COLOFF],tmpbuf2);
    say("%s [%s%s%s]",tmpbuf1,
        CmdsColors[COLNOTIFY].color3,update_clock(GET_TIME),Colors[COLOFF]);
#else
    say("Signoff by %s (%s) detected at %.16s",nick,userhost,ctime(&timenow));
#endif
}

/* Lists all users on notify list */
void ListNotify(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  count=0;
    char *on=(char *) 0;
    char *noton=(char *) 0;
    char tmpbuf1[mybufsize/4];
#ifdef WANTANSI
    char tmpbuf2[mybufsize/4];
#endif
    NotifyList *notify;

    say("Listing all the people on your notify list");
    for (notify=notify_list;notify;notify=notify->next) {
        if (notify->flag && notify->flag!=2) {
            if (NotifyMode==2) {
                if (!count) strcpy(tmpbuf1,"\002(\002Present\002)\002 ");
                else strcpy(tmpbuf1,"          ");
#ifdef WANTANSI
                if (notify->userhost) {
                    ColorUserHost(notify->userhost,CmdsColors[COLNOTIFY].color2,tmpbuf2);
                    say("%s %s%-13s%s %s",tmpbuf1,
                        CmdsColors[COLNOTIFY].color5,notify->nick,Colors[COLOFF],tmpbuf2);
                }
                else say("%s %s%-13s%s",tmpbuf1,
                         CmdsColors[COLNOTIFY].color5,notify->nick,Colors[COLOFF]);
#else
                if (notify->userhost) say("%s %c%-13s%c [%s]",tmpbuf1,bold,notify->nick,
                                          bold,notify->userhost);
                else say("%s %c%-13s%c",tmpbuf1,bold,notify->nick,bold);
#endif
            }
            else {
                if (!on) malloc_strcpy(&on,"\002(\002Present\002)\002 ");
#ifdef WANTANSI
                sprintf(tmpbuf1," %s%s%s",CmdsColors[COLNOTIFY].color5,
                        notify->nick,Colors[COLOFF]);
#else
                sprintf(tmpbuf1," %s",notify->nick);
#endif
                malloc_strcat(&on,tmpbuf1);
            }
            count++;
        }
        else {
            if (!noton) malloc_strcpy(&noton,"\002(\002Absent \002)\002 ");
#ifdef WANTANSI
            sprintf(tmpbuf1," %s%s%s",CmdsColors[COLNOTIFY].color1,
                    notify->nick,Colors[COLOFF]);
#else
            sprintf(tmpbuf1," %s",notify->nick);
#endif
            malloc_strcat(&noton,tmpbuf1);
        }
    }
    if (on) {
        say("%s",on);
        new_free(&on);
    }
    if (noton) {
        say("%s",noton);
        new_free(&noton);
    }
}

/* Clears bans in ChannelList */
/* Also clears hash table */
void ClearBans(chan)
ChannelList *chan;
{
    int i;
    struct bans *tmpban;
    struct bans *tmpbant;
    struct hashstr *tmp;

    for (tmpbant=chan->banlist;tmpbant;) {
        tmpban=tmpbant;
        tmpbant=tmpbant->next;
        new_free(&(tmpban->ban));
        new_free(&(tmpban->who));
        new_free(&tmpban);
    }
    chan->banlist=(struct bans *) 0;
    for (i=0;i<HASHTABLESIZE;i++) {
        for (;chan->nickshash[i];) {
            tmp=chan->nickshash[i];
            chan->nickshash[i]=chan->nickshash[i]->next;
            new_free(&tmp);
        }
        chan->nickshash[i]=(struct hashstr *) 0;
    }
}

/* Handles all things when you get ops */
void HandleGotOps(mynick,chan)
char *mynick;
ChannelList *chan;
{
    int  count=0;
    int  countv=0;
    int  done;
    int  max=get_int_var(MAX_MODES_VAR);
    char *tmpmode=(char *) 0;
    char *tmpmodev=(char *) 0;
    char *reason;
    char tmpbuf[mybufsize/4];
    NickList *tmp;
    WhowasList *whowas;
    struct bans *tmpban;

    if (chan) {
        count=0;
        for (tmpban=chan->banlist;tmpban;tmpban=tmpban->next) {
            for (tmp=chan->nicks;tmp;tmp=tmp->next) {
                if (tmp->frlist && ((tmp->frlist->privs)&160) && ((tmp->frlist->privs)&16)) {
                    sprintf(tmpbuf,"%s!%s",tmp->nick,tmp->userhost);
                    if (wild_match(tmpban->ban,tmpbuf)) {
                        count++;
                        malloc_strcat(&tmpmode," -b ");
                        malloc_strcat(&tmpmode,tmpban->ban);
                        break;
                    }
                }
            }
            if (!tmp) {
                for (whowas=whowas_userlist_list;whowas;whowas=whowas->next) {
                    if (whowas->nicklist->frlist && ((whowas->nicklist->frlist->privs)&160)
                       && ((whowas->nicklist->frlist->privs)&16)) {
                        if (whowas->nicklist->userhost)
                            sprintf(tmpbuf,"%s!%s",whowas->nicklist->nick,whowas->nicklist->userhost);
                        else strcpy(tmpbuf,whowas->nicklist->nick);
                        if (wild_match(tmpban->ban,tmpbuf)) {
                            count++;
                            malloc_strcat(&tmpmode," -b ");
                            malloc_strcat(&tmpmode,tmpban->ban);
                        }
                        break;
                    }
                }
            }
            if (count==max) {
                count=0;
                send_to_server("MODE %s %s",chan->channel,tmpmode);
                new_free(&tmpmode);
            }
        }
        for (tmp=chan->nicks;tmp;tmp=tmp->next) {
            if (!(tmp->chanop))
                if (tmp->frlist && ((tmp->frlist->privs)&8) && ((tmp->frlist->privs)&4)
                    && !(tmp->frlist->passwd)) {
                    count++;
                    malloc_strcat(&tmpmode," +o ");
                    malloc_strcat(&tmpmode,tmp->nick);
                    if (count==max) {
                        count=0;
                        send_to_server("MODE %s %s",chan->channel,tmpmode);
                        new_free(&tmpmode);
                    }
                }
                else if (!(tmp->voice))
                    if (tmp->frlist && ((tmp->frlist->privs)&256)) {
                        countv++;
                        malloc_strcat(&tmpmodev," +v ");
                        malloc_strcat(&tmpmodev,tmp->nick);
                        if (countv==max) {
                            countv=0;
                            send_to_server("MODE %s %s",chan->channel,tmpmodev);
                            new_free(&tmpmodev);
                        }
                    }
        }
        if (count) {
            send_to_server("MODE %s %s",chan->channel,tmpmode);
            new_free(&tmpmode);
        }
        if (countv) {
            send_to_server("MODE %s %s",chan->channel,tmpmodev);
            new_free(&tmpmodev);
        }
        count=0;
        for (tmp=chan->nicks;tmp;tmp=tmp->next) {
            done=0;
            if (chan->Bitch && my_stricmp(tmp->nick,mynick) && tmp->chanop &&
                (!tmp->frlist || (tmp->frlist && !((tmp->frlist->privs)&12)))) {
                malloc_strcat(&tmpmode," -o ");
                malloc_strcat(&tmpmode,tmp->nick);
                count++;
                done=1;
            }
            if (tmp->shitlist && tmp->shitlist->shit) {
                reason=(char *) 0;
                if ((tmp->shitlist->shit)&16) {
                    if (!done && tmp->chanop) {
                        malloc_strcat(&tmpmode," -o ");
                        malloc_strcat(&tmpmode,tmp->nick);
                        count++;
                    }
                }
                if ((tmp->shitlist->shit)&1) {
                    if (tmp->shitlist->reason[0]) reason=tmp->shitlist->reason;
                    else reason=DefaultABK;
#if defined(VILAS) || defined(FET)
                    send_to_server("KICK %s %s :%s",chan->channel,tmp->nick,reason);
#elif defined(TOOLIE)
                    send_to_server("KICK %s %s :%s %s <SZ-ABK>",chan->channel,
                                   tmp->nick,ToolieA,reason);
#else  /* TOOLIE */
                    send_to_server("KICK %s %s :<ScrollZ-ABK> %s",chan->channel,
                                   tmp->nick,reason);
#endif /* VILAS || FET */
                }
                if ((tmp->shitlist->shit)&2)
                    send_to_server("MODE %s -o+b %s %s",chan->channel,
                                   tmp->nick,tmp->shitlist->userhost);

                if ((tmp->shitlist->shit)&4) {
                    sprintf(tmpbuf,"%s ALL",tmp->userhost);
                    Ignore(NULL,tmpbuf,tmpbuf);
                    break;
                }
            }
            if (count==max) {
                send_to_server("MODE %s %s",chan->channel,tmpmode);
                new_free(&tmpmode);
                count=0;
            }
        }
        if (count) {
            send_to_server("MODE %s %s",chan->channel,tmpmode);
            new_free(&tmpmode);
        }
        CheckPermBans(chan);
#ifdef EXTRAS
        CheckLock(chan->channel,from_server,chan);
#endif
    }
}

/* This executes when you quit from IRC */
void MyQuit(reason)
char *reason;
{
    if (ClientList) {
        if (get_int_var(BEEP_VAR)) term_beep();
#ifdef WANTANSI
        say("You have DCCs %sactive%s",CmdsColors[COLWARNING].color1,Colors[COLOFF]);
#else
        say("You have DCCs %cactive%c",bold,bold);
#endif
        Cdcc(NULL,NULL,NULL);
        add_wait_prompt("Press any key to continue, 'q' to quit from IRC",MyQuitPrompt,reason,WAIT_PROMPT_KEY);
    }
    else MyQuitPrompt(reason,"q");
}

/* Prompt when you quit if you have dccs pending */
void MyQuitPrompt(reason,line)
char *reason;
char *line;
{
    int max;
    int i;
    char *tmpstr=NULL;
    char *mynick;
#ifdef WANTANSI
    char *colnick;
    NickList *joiner;
#endif
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];

    if (reason) tmpstr=reason;
#ifdef TOOLIE
    else tmpstr=ToolieSignoff();
#else
    else if (NumberOfSignOffMsgs) tmpstr=PickSignOff();
#endif
    if (!tmpstr) {
        if (DefaultSignOff && *DefaultSignOff) tmpstr=DefaultSignOff;
        else tmpstr=(char *) "Leaving";
    }
    strcpy(tmpbuf2,tmpstr);
    if (line && (*line=='q' || *line=='Q')) {
        max=number_of_servers;
        for (i=0;i<max;i++)
            if (is_server_connected(i)) {
                from_server=i;
                strcpy(tmpbuf1,tmpbuf2);
#ifdef TOOLIE
                send_to_server("QUIT :%s %s",tmpbuf1,ToolieB);
#else
                send_to_server("QUIT :%s",tmpbuf1);
#endif
                strcpy(tmpbuf1,tmpbuf2);
                mynick=get_server_nickname(from_server);
#ifdef WANTANSI
                joiner=CheckJoiners(mynick,NULL,from_server,NULL);
                if (joiner && joiner->shitlist && joiner->shitlist->shit)
                    colnick=CmdsColors[COLLEAVE].color5;
                else if (joiner && joiner->frlist && joiner->frlist->privs)
                    colnick=CmdsColors[COLLEAVE].color4;
                else colnick=CmdsColors[COLLEAVE].color1;
#ifdef TOOLIE
                say("Signoff: %s%s%s (%s%s%s %s)",
                    colnick,mynick,Colors[COLOFF],
                    CmdsColors[COLLEAVE].color3,tmpbuf1,Colors[COLOFF],ToolieB);
#else
                say("Signoff: %s%s%s (%s%s%s)",
                    colnick,mynick,Colors[COLOFF],
                    CmdsColors[COLLEAVE].color3,tmpbuf1,Colors[COLOFF]);
#endif
#else
#ifdef TOOLIE
                say("Signoff: %s (%s %s)",mynick,tmpbuf1,ToolieB);
#else
                say("Signoff: %s (%s)",mynick,tmpbuf1);
#endif
#endif
            }
        irc_exit(IRCQuit);
    }
}

/* Counts number of nicks in string */
int CountNicks(nicks)
char *nicks;
{
    int  count=0;
    char *tmpstr;

    for (tmpstr=nicks;*tmpstr;) {
        while (*tmpstr && !isspace(*tmpstr)) tmpstr++;
        if (*tmpstr && isspace(*tmpstr)) {
            count++;
            while (*tmpstr && isspace(*tmpstr)) tmpstr++;
        }
    }
    return(count);
}

/* Adds nick to delay op list */
void AddDelayOp(channel,nick,server,vote)
char *channel;
char *nick;
int  server;
int  vote;
{
    int max=get_int_var(MAX_MODES_VAR);
    char tmpbuf[mybufsize/4];
    NickList *tmp;
    ChannelList *chan;
    struct delayop *tmpopdelay;

    chan=lookup_channel(channel,server,0);
    if (chan) {
        if ((tmp=find_in_hash(chan,nick))) {
            sprintf(tmpbuf,"%s ",nick);
            for (tmpopdelay=delayoplist;tmpopdelay;tmpopdelay=tmpopdelay->next)
                if (server==tmpopdelay->server && !my_stricmp(channel,tmpopdelay->channel)
                    && CountNicks(tmpopdelay->nick)<max) {
                    if (strstr(tmpopdelay->nick,tmpbuf)) return;
                    if (vote) malloc_strcat(&(tmpopdelay->nick),"#");
                    malloc_strcat(&(tmpopdelay->nick),tmpbuf);
                    return;
                }
            tmpopdelay=(struct delayop *) new_malloc(sizeof(struct delayop));
            if (tmpopdelay) {
                tmpopdelay->nick=(char *) 0;
                tmpopdelay->channel=(char *) 0;
                if (vote) malloc_strcpy(&(tmpopdelay->nick),"#");
                malloc_strcat(&(tmpopdelay->nick),tmpbuf);
                malloc_strcpy(&(tmpopdelay->channel),channel);
                tmpopdelay->server=server;
                tmpopdelay->time=time((time_t *) 0);
                tmpopdelay->next=NULL;
                add_to_list_ext((List **) &delayoplist,(List *) tmpopdelay,
                                (int (*) _((List *, List *))) AddLast);
            }
        }
    }
}

/* Changes nick in delay op list */
void ChangeNickDelay(oldnick,newnick,server)
char *oldnick;
char *newnick;
int  server;
{
    struct delayop *tmpopdelay;

    for (tmpopdelay=delayoplist;tmpopdelay;tmpopdelay=tmpopdelay->next)
        if (tmpopdelay->nick && tmpopdelay->channel && server==tmpopdelay->server &&
            !my_stricmp(tmpopdelay->nick,oldnick)) {
            malloc_strcpy(&(tmpopdelay->nick),newnick);
            return;
        }
}

/* Adds nick to delay notify list */
void AddDelayNotify(nick,server)
char *nick;
int  server;
{
    char tmpbuf[mybufsize/4];
    struct delaynotify *tmpnotifydelay=delaynotifylist;

    sprintf(tmpbuf,"%s",nick);
    for (;tmpnotifydelay;tmpnotifydelay=tmpnotifydelay->next) {
        if (!strcmp(tmpnotifydelay->nick,nick) ||
            strstr(tmpnotifydelay->nick,tmpbuf)) return;
        if (server==tmpnotifydelay->server && CountNicks(tmpnotifydelay->nick)<5) {
            malloc_strcat(&(tmpnotifydelay->nick)," ");
            malloc_strcat(&(tmpnotifydelay->nick),nick);
            return;
        }
    }
    tmpnotifydelay=(struct delaynotify *) new_malloc(sizeof(struct delaynotify));
    if (tmpnotifydelay) {
        tmpnotifydelay->nick=(char *) 0;
        tmpnotifydelay->server=server;
        tmpnotifydelay->time=time((time_t *) 0);
        malloc_strcpy(&(tmpnotifydelay->nick),nick);
        tmpnotifydelay->next=delaynotifylist;
        delaynotifylist=tmpnotifydelay;
    }
}

/* Adds given server to server list */
void AddServer(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int port=0;
    int old_server=0;
    char *tmp;
    char *server;

    server=new_next_arg(args,&args);
    if (!(server && *server)) {
        PrintUsage("/ADDS server[:port] or /ADDS server [port]");
        return;
    }
    if ((tmp=index(server,':'))!=(char *) 0) *tmp++='\0';
    else tmp=new_next_arg(args,&args);
    if (!(tmp && *tmp)) port=6667;
    else {
        if (!isdigit(*tmp)) port=6667;
        else {
            port=atoi(tmp);
            if (port<1024) port=6667;
        }
    }
    old_server=from_server;
    add_to_server_list(server,port,(char *) 0,(char *) 0,0);
    from_server=old_server;
    say("%s %d added to your server list",server,port);
}

/* Removes given server from server list */
void RemoveServer(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int port=0;
    int old_server=0;
    int servernum=0;
    char *tmp;
    char *server;

    server=new_next_arg(args,&args);
    if (!(server && *server)) {
        PrintUsage("/REMS server[:port] or /REMS server [port]");
        return;
    }
    if ((tmp=index(server,':'))!=(char *) 0) *tmp++ = '\0';
    else tmp=new_next_arg(args,&args);
    if (!(tmp && *tmp)) port=6667;
    else {
        if (!isdigit(*tmp)) port=6667;
        else {
            port=atoi(tmp);
            if (port<1024) port=6667;
        }
    }
    old_server=from_server;
    if ((servernum=find_in_server_list(server,port))==-1)
        say("Couldn't find %s %d",server,port);
    else {
        server=server_list[servernum].name;
        if (server_list[servernum].connected)
            say("%s %d is connected. Not removed !",server,port);
        else {
            say("%s %d removed from your server list",server,port);
            remove_from_server_list(servernum);
        }
    }
    from_server=old_server;
}

/* Lists servers on server list */
void ListServers(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  i;
    char *server;

    say("List of servers on your server list");
    for (i=0;i<number_of_servers;i++) {
        server=server_list[i].name;
        if (i!=from_server) say("#%-2d %s  %d",i,server,server_list[i].port);
        else say("#%-2d %c%s%c  %d",i,bold,server,bold,server_list[i].port);
    }
}

/* Returns 1 if user is banned on channel, else 0 */
int IsBanned(userhost,channel,server,tmpchan)
char *userhost;
char *channel;
int  server;
ChannelList *tmpchan;
{
    ChannelList *chan;
    struct bans *tmpban;

    if (tmpchan) chan=tmpchan;
    else chan=lookup_channel(channel,server,0);
    if (chan) {
        for (tmpban=chan->banlist;tmpban;tmpban=tmpban->next)
            if (wild_match(userhost,tmpban->ban) || wild_match(tmpban->ban,userhost))
                return(1);
    }
    return(0);
}

#ifdef TOOLIE
/* Random signoff generator */
char *ToolieSignoff()
{
    int num;

    srand(time(0));
    num=rand()%9;
    if ((num==0) || (num==6)) return("What do you have in your Toolie Box?");
    else if ((num==1) || (num==7)) return("It's got less backdoors than iNFiNiTY...");
    else if (num==2) return("Hope it makes ya feel warm & safe");
    else if ((num==3) || (num==8)) return("Complete with new Nerf Jackhammer (c)");
    else if ((num==4) || (num==9)) return("Accepteth No Substitutes");
    else if (num==5) return("Now available in fire engine red!");
    else return(NULL);
}
#endif

/* Randomly picks sign off message */
char *PickSignOff()
{
    int  number;
    int  count=0;
    char *pointer=(char *) 0;
    char *filepath;
    char tmpbuf1[mybufsize];
    char tmpbuf2[mybufsize/2];
    FILE *fp;

    if (!NumberOfSignOffMsgs) return(NULL);
    srand(time((time_t *) 0));
    number=rand()%NumberOfSignOffMsgs+1;
    filepath=OpenCreateFile("ScrollZ.addon",0);
    fp=fopen(filepath,"r");
    if (fp!=NULL) {
        while (readln(fp,tmpbuf1)) {
            pointer=tmpbuf1;
            NextArg(pointer,&pointer,tmpbuf2);
            if (!my_stricmp("SIOFF",tmpbuf2)) count++;
            if (count==number) break;
        }
        fclose(fp);
        while (isspace(*pointer)) pointer++;
        return(pointer);
    }
    return(NULL);
}

#ifdef SCKICKS
/* Randomly picks scatter kick comment */
char *PickScatterKick(number)
int number;
{
    int  count=0;
    char *pointer=(char *) 0;
    char *filepath;
    char tmpbuf1[mybufsize];
    char tmpbuf2[mybufsize/2];
    FILE *fp;

    if (!NumberOfScatterKicks) return(NULL);
    filepath=OpenCreateFile("ScrollZ.addon",0);
    fp=fopen(filepath,"r");
    if (fp!=NULL) {
        while (readln(fp,tmpbuf1)) {
            pointer=tmpbuf1;
            NextArg(pointer,&pointer,tmpbuf2);
            if (!my_stricmp("SKICK",tmpbuf2)) count++;
            if (count==number) break;
        }
        fclose(fp);
        while (isspace(*pointer)) pointer++;
        return(pointer);
    }
    return(NULL);
}
#endif

/* Clears tabkey list */
void ClearTab(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    struct nicks *nickstr;

    while (nicklist) {
        nickstr=nicklist;
        nicklist=nickstr->next;
        new_free(&(nickstr->nick));
        new_free(&nickstr);
    }
    nicklist=NULL;
    nickcur=NULL;
}

#ifdef EXTRAS
/* Stores links info internally */
void LLook(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    struct splitstr *tmpsplit;

    if (!inFlierLinks) {
        while (splitlist) {
            tmpsplit=splitlist;
            splitlist=splitlist->next;
            new_free(&(tmpsplit->servers));
            new_free(&tmpsplit);
        }
        inFlierLinks=1;
        send_to_server("LINKS");
        say("Gathering links info from server");
    }
    else say("Wait till previous LINKS, LLOOK, LLOOKUP or MAP completes");
}

/* Compares links info against one stored internally */
void LLookUp(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    struct splitstr *tmpsplit;

    if (splitlist) {
        if (!inFlierLinks) {
            while (splitlist1) {
                tmpsplit=splitlist1;
                splitlist1=splitlist1->next;
                new_free(&(tmpsplit->servers));
                new_free(&tmpsplit);
            }
            inFlierLinks=2;
            send_to_server("LINKS");
            say("Gathering links info from server");
        }
        else say("Wait till previous LINKS, LLOOK, LLOOKUP or MAP completes");
    }
    else say("Do /LLOOK first");
}

/* This handles links reply from server */
void HandleLinks(servers)
char *servers;
{
    int  found1,found2;
    char *tmpstr=(char *) 0;
    char tmpbuf[mybufsize/4];
    struct splitstr *tmp1,*tmp2,*tmpsplit;

    if (inFlierLinks) {
        tmp1=(struct splitstr *) new_malloc(sizeof(struct splitstr));
        tmp2=(struct splitstr *) new_malloc(sizeof(struct splitstr));
        if (tmp1 && tmp2) {
            tmpstr=servers;
            tmp1->next=tmp2;
            tmp2->next=NULL;
            tmp1->servers=NULL;
            tmp2->servers=NULL;
            NextArg(tmpstr,&tmpstr,tmpbuf);
            malloc_strcpy(&(tmp1->servers),tmpbuf);
            NextArg(tmpstr,&tmpstr,tmpbuf);
            malloc_strcat(&(tmp2->servers),tmpbuf);
            if (inFlierLinks==1) {
                found1=0;
                found2=0;
                tmpsplit=splitlist;
                while (tmpsplit) {
                    if (!my_stricmp(tmp1->servers,tmpsplit->servers)) found1=1;
                    if (!my_stricmp(tmp2->servers,tmpsplit->servers)) found2=1;
                    tmpsplit=tmpsplit->next;
                    if (found1 && found2) break;
                }
                if (found1 && !found2) {
                    new_free(&(tmp1->servers));
                    new_free(&tmp1);
                    tmp1=tmp2;
                    tmp2=NULL;
                }
                if (!found1 && found2) {
                    new_free(&(tmp2->servers));
                    new_free(&tmp2);
                    tmp1->next=NULL;
                }
                if (found1 && found2) {
                    new_free(&(tmp1->servers));
                    new_free(&tmp1);
                    new_free(&(tmp2->servers));
                    new_free(&tmp2);
                    return;
                }
                if (!splitlist) splitlist=tmp1;
                else {
                    tmpsplit=splitlist;
                    while (tmpsplit->next) tmpsplit=tmpsplit->next;
                    tmpsplit->next=tmp1;
                }
            }
            else {
                found1=0;
                found2=0;
                tmpsplit=splitlist1;
                while (tmpsplit) {
                    if (!my_stricmp(tmp1->servers,tmpsplit->servers)) found1=1;
                    if (!my_stricmp(tmp2->servers,tmpsplit->servers)) found2=1;
                    tmpsplit=tmpsplit->next;
                    if (found1 && found2) break;
                }
                if (found1 && !found2) {
                    new_free(&(tmp1->servers));
                    new_free(&tmp1);
                    tmp1=tmp2;
                    tmp2=NULL;
                }
                if (!found1 && found2) {
                    new_free(&(tmp2->servers));
                    new_free(&tmp2);
                    tmp1->next=NULL;
                }
                if (found1 && found2) {
                    new_free(&(tmp1->servers));
                    new_free(&tmp1);
                    new_free(&(tmp2->servers));
                    new_free(&tmp2);
                    return;
                }
                if (!splitlist1) splitlist1=tmp1;
                else {
                    tmpsplit=splitlist1;
                    while (tmpsplit->next) tmpsplit=tmpsplit->next;
                    tmpsplit->next=tmp1;
                }
            }
        }
    }
}

/* Prints all servers missing from links info */
void ListSplitedServers()
{
    int found;
    struct splitstr *tmp,*tmpsplit;

    say("Servers missing from links info");
    tmpsplit=splitlist;
    while (tmpsplit) {
        found=0;
        tmp=splitlist1;
        while (tmp && !found) {
            if (!my_stricmp(tmpsplit->servers,tmp->servers)) found=1;
            tmp=tmp->next;
        }
        if (!found) say("%s",tmpsplit->servers);
        tmpsplit=tmpsplit->next;
    }
    say("End of missing servers list");
}
#endif

/* This will show the sucker that last killed you */
void ShowKill(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    if (WhoKilled) say("%s",WhoKilled);
    else say("You haven't been killed so far");
}
