/*************************************************************************
 *  Various Functions   Coded  By  Sheik and Scrubbs                     *
 *  Goal: To Create a Toolz-like atmosphere, in C.                       *
 *                                                                       *
 *  ChanWallOp       msg all the ops on current channel - /wallmsg       *
 *  MegaDeop         mega deops the current channel - /mdop              *
 *  LameKick         Kicks all unopped people from current channel - /lk *
 *  DoDops           Deops a line of nicks, whatever the length          *
 *  NewUser          Lets you fake your UserName - /newuser              *
 *  ReconnectServer  Reconnects to Current Server - /reconnect           *
 *************************************************************************/

/******************************************************************************
 Functions coded by Flier (THANX to Sheik!!)
 The same goal as 12 lines up ! :))

 ReconnectOnKill      Reconnects you to server on kills
 Kick                 Kicks nick from channel
 BanType              Sets ban type (normal,hostname,screw)
 Ban                  Bans nick from channel
 BanKick              Kicks and bans user from channel
 Op                   Ops nick
 Dop                  Deops nick
 About                Tells you some info on ScrollZ
 Leave                Leave channel
 Invite               Invites nick to channel
 ModeClear            Does a -ntsilpmk on channel
 Chops                Shows all ops on current channel
 ChannelScan          Shows all nicks on current channel
 ListFriends          Lists all the friends on your friends list
 ListAutoBanKicks     Lists all the people on your auto (ban) kick list
 Topic                Shows or sets topic on channel
 FServer              Connects to specified server, else to default one
 Cycle                Leaves and joins channel
 CToolzSave           Saves ScrollZ.save file
 CheckUsers           Returns user's privileges or 0 if he/she is not registered
 CheckABKs            Returns user's shit-level or 0 if he/she is not on ABK list
 CheckJoiners         Returns pointer if it finds nick on your joinlist, else adds him to your joinlist
 DirLM                Redirects last message/notice you have received
 AddFriend            Adds user to your friends list
 AddAutoBanKick       Adds user to your auto (ban) kick list
 RemoveFriend         Removes user from your friends list
 RemoveAutoBanKick    Removes user from your auto (ban) kick list
 ShowBans             Shows bans on a channel
 Version              Does /CTCP nick VERSION
 Unban                Unbans user
 OnBans               Handles ban messages from server
 CdBan                Clears channel of bans
 NoIgnore             Unignores user
 Ignore               Ignores user
 SetAway              Marks you as being away
 SetBack              Marks you as not being away
 OnWho                Handles who reply from server
 Check4Ban            Checks if ban on you is detected
 AddWord              Adds word to your wordkick list
 RemoveWord           Removes word from your wordkick list
 ListWords            Lists all the words from your wordkick list
 CheckLine            Checks line for wordkick, 1 - if match found, 0 - otherwise
 AddNick2List         Adds nick to list of people who have messaged you
 NickNext             Sets nickcur to the next leaf on linked list nicks (when TAB pressed)
 AddSplitter          Adds splitter to appropriate server
 Check4Join           Checks if net has joined and returns server name if so
 WhoLeft              Tells you all the nicks that went away with the split
 FilterKick           Kicks all the people that match filter
 DoBans               Bans all the people that are shitlisted
 NewHost              Virtual Hosting, patched in by Zakath
******************************************************************************/

#include "irc.h"
#include "crypt.h"
#include "vars.h"
#include "ircaux.h"
#include "lastlog.h"
#include "window.h"
#include "whois.h"
#include "hook.h"
#include "input.h"
#include "ignore.h"
#include "keys.h"
#include "names.h"
#include "alias.h"
#include "history.h"
#include "funny.h"
#include "ctcp.h"
#include "dcc.h"
#include "translat.h"
#include "output.h"
#include "notify.h"
#include "numbers.h"
#include "status.h"
#include "screen.h"
#include "server.h"
#include "edit.h"
#include "list.h"
#include "struct.h"
#include "myvars.h"
#include "whowas.h"

typedef struct notify_stru
{
    struct  notify_stru     *next;
    char    *nick;
    char    *userhost;
    int     flag;
} NotifyList;

extern NotifyList *notify_list;
extern int CO;

NickList *CheckJoiners _((char *, char *, int , ChannelList *));
void DoDops _((char *, char *));
void ReconnectServer _((char *, char *, char *));
void AddFriend2List _((char *, char *, char *));
void AddBK2List _((char *, char *, char *));
void RemoveFriendFromList _((char *));
void RemoveAutoBanKickFromList _((char *));
void SetBack2 _((char *, char *));
void SetBackDelete _((char *, char *));
void ListFriendsPage _((char *));
void ListFriendsKey _((char *, char *));
void ListABKsPage _((char *));
void ListABKsKey _((char *, char *));
void AddNick2List _((char *));
struct words *CheckLine _((char *, char *));
void NotChanOp _((char *));
void NoWindowChannel _((void));
void BanNew _((WhoisStuff *, char *, char *));
void BanKickNew _((WhoisStuff *, char *, char *));
void AddFriendNew _((WhoisStuff *, char *, char *));
void AddBKNew _((WhoisStuff *, char *, char *));
void RemoveFriendNew _((WhoisStuff *, char *));
void RemoveAutoBanKickNew _((WhoisStuff *, char *));
void UnbanNew _((WhoisStuff *, char *, char *));
void IgnoreNew _((WhoisStuff *, char *, char *));
int  AddLast _((List *, List *));

extern struct friends *FindMatch _((char *, char *));
extern void ClearKey _((char *, char *, char *));
extern int  CheckChannel _((char *, char *));
extern void UnbanIt _((char *, char *, int));
extern void AddBan _((char *, char *, int, char *, time_t, ChannelList *));
extern void AwaySave _((char *, int));
extern void UserDomainList _((char *));
#ifdef WANTANSI
extern void SaveColors _((FILE *));
#endif
extern void PrintSetting _((char *, char *, char *, char *));
extern char *OpenCreateFile _((char *, int));
extern void CreateBan _((char *, char *, char *));
extern void StripAnsi _((char *, char *, int));
extern void BuildPrivs _((struct friends *, char *));
#ifdef WANTANSI
extern int  CountAnsi _((char *, int));
#endif
extern struct autobankicks *FindShit _((char *, char *));
extern void PlayBack _((char *, char *, char *));
extern void PrintUsage _((char *));
extern int  matchmcommand _((char *, int));
extern NickList *find_in_hash _((ChannelList *, char *));
extern void add_nick_to_hash _((ChannelList *, NickList *));
extern void remove_nick_from_hash _((ChannelList *, NickList *));

extern void e_channel _((char *, char *, char *));
extern void timercmd _((char *, char *, char *));
extern void away _((char *, char *, char *));
extern void describe _((char *, char *, char *));

static char *tmpbuflist=(char *) 0;
static int  listcount;
static int  countall;
static int  DontHold;
static struct friends *tmpfriendlist;
static struct autobankicks *tmpabklist;
/* Patched by Zakath */
static int  MegaType;
static char timereturn[mybufsize/16];
#ifdef TOOLIE
static char *toolieawaystr=(char *) 0;
static time_t ToolieAwayTime;
#endif

/* Kicks all unopped people from current channel */
void LameKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  count=0;
    char *channel;
    char *comment=(char *) 0;
    char tmpbuf1[mybufsize];
    char tmpbuf2[mybufsize/4];
    NickList *tmp;
    ChannelList *chan;

    if ((channel=get_channel_by_refnum(0))) {
        chan=lookup_channel(channel,curr_scr_win->server,0);
        if (chan && ((chan->status)&CHAN_CHOP)) {
            if (!chan) return;
            *tmpbuf1='\0';
            if (args && *args) comment=args;
            else comment=DefaultLK;
            for (tmp=chan->nicks;tmp;tmp=tmp->next)
                if (!tmp->chanop && !tmp->voice) {
#if defined(VILAS) || defined(FET)
                    sprintf(tmpbuf2,"KICK %s %s :%s\r\n",channel,tmp->nick,comment);
#elif defined(TOOLIE)
                    sprintf(tmpbuf2,"KICK %s %s :%s %s <SZ-LK>\r\n",channel,tmp->nick,
                            ToolieA,comment);
#else  /* TOOLIE */
                    sprintf(tmpbuf2,"KICK %s %s :<ScrollZ-LK> %s\r\n",channel,tmp->nick,
                            comment);
#endif /* VILAS || FET */
                    if (strlen(tmpbuf1)+strlen(tmpbuf2)>=IRCD_BUFFER_SIZE-150) {
                        send_to_server("%s",tmpbuf1);
                        *tmpbuf1='\0';
                        count=0;
                    }
                    count++;
                    strcat(tmpbuf1,tmpbuf2);
                }
            if (count) send_to_server("%s",tmpbuf1);
            say("Sent the server all the lamer kicks, sit back and watch !");
        }
        else NotChanOp(channel);
    }
    else NoWindowChannel();
}

/* Sends NOTICE to all ops of Current Channel!       */
void ChanWallOp(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  server=0;
    int  maxnicks=get_int_var(MAX_WALLOP_NICKS_VAR);
    int  opscount=0;
    int  totalcount=0;
    int  includecount=0;
    char *ptr;
    char *word;
    char *channel;
    char *fulllistptr;
    char tmpnick[100];
    char fulllist[mybufsize*2];
    char excludelist[mybufsize];
    char includelist[mybufsize];
    char currentlist[mybufsize];
    NickList *tmp;
    ChannelList *chan;

    /* set all strings to null */
    *fulllist='\0';
    *excludelist='\0';
    *includelist='\0';
    *currentlist='\0';
    if (!(args && *args)) {
        PrintUsage("/WALL [+nick] [-nick] message");
        return;
    }
    if (!(channel=get_channel_by_refnum(0))) {
        NoWindowChannel();
        return;
    }
    server=curr_scr_win->server;
    if ((chan=lookup_channel(channel,server,0))==NULL) return;
    /* work along line till we find a word that doesn't start with - or +  */
    while (args) {
        /* peek at the first char, before detaching */
        if ((*args!='-') && (*args!='+')) break; /* no special flags to parse out */
        word=next_arg(args,&args);
        if (!word || !*(word+1)) {
            say("Error: no message/nicks found");
            return;
        }
        else if (*word=='-') {
            *word++='\0';
            /* exclude list will be like " sheik  blah  lame " */
            strcat(excludelist," ");
            strcat(excludelist,word);
            strcat(excludelist," ");
        }
        else if (*word=='+') {
            *word++='\0';
            strcat(includelist," ");
            strcat(includelist,word);
            includecount++;
        }
    }
    /* strip all spaces in front of message */
    while (args && isspace(*args)) *args++='\0';
    if (!args || !(*args)) {
        say("Error: no message found");
        return;
    }
    upper(includelist);
    upper(excludelist);
    for (tmp=chan->nicks;tmp;tmp=tmp->next) {
        if (tmp->chanop) {
            /* create a string like  " sheik ", then strstr()
             * on the exclude list, does not allow wildcards
             * in the exclude list! EXPENSIVE!
             */
            sprintf(tmpnick," %s ",tmp->nick);
            if (strstr(excludelist,tmpnick)) continue;
            strcat(fulllist,tmpnick);
            opscount++;
        }
    }
    if (includecount) strcat(fulllist,includelist);
    fulllistptr=fulllist;
    for (ptr=new_next_arg(fulllistptr,&fulllistptr);ptr;
         ptr=new_next_arg(fulllistptr,&fulllistptr)) {
        if (*currentlist) strcat(currentlist,",");
        strcat(currentlist,ptr);
        totalcount++;
        if (totalcount>=maxnicks) {
            sprintf(buffer,"[\002S-WallOp\002/\002%s\002] %s",chan->channel,args);
            send_to_server("NOTICE %s :%s",currentlist,buffer);
            totalcount=0;
            *currentlist='\0';
        }
    }
    if (totalcount) {
        sprintf(buffer,"[\002S-WallOp\002/\002%s\002] %s",chan->channel,args);
        send_to_server("NOTICE %s :%s",currentlist,buffer);
    }
    if (*excludelist) say("Excluding %s from wallmsg",excludelist);
    if (includecount) say("Including %s to receive wallmsg",includelist);
    if (!opscount) say("There are no channel operators in %s",chan->channel);
}

/* Mega ops/deops channel */
void MegaMode(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  isfriend;
    int  all=1;
    char *channel;
    char *tmpstr;
    char *chops=(char *) 0;
    char *mynick=get_server_nickname(from_server);
    ChannelList *chan;
    NickList *tmp;

    tmpstr=new_next_arg(args,&args);
    if (tmpstr && !my_stricmp(tmpstr,"-O")) {
        all=0;
        tmpstr=new_next_arg(args,&args);
    }
    if (tmpstr && is_channel(tmpstr)) channel=tmpstr;
    else if (!(channel=get_channel_by_refnum(0))) {
        NoWindowChannel();
        return;
    }
    chan=lookup_channel(channel,curr_scr_win->server,0);
    if (!chan) return;
    if ((chan->status)&CHAN_CHOP) {
        for (tmp=chan->nicks;tmp;tmp=tmp->next) {
            isfriend=tmp->frlist && ((tmp->frlist->privs)&4 || (tmp->frlist->privs)&8);
            if (!(tmp->chanop)) continue;
            if ((all || (!all && (MegaType?!isfriend:isfriend))) &&
                 my_stricmp(tmp->nick,mynick)) {
                if (chops) malloc_strcat(&chops," ");
                malloc_strcat(&chops,tmp->nick);
            }
        }
        if (chops) {
            if (!all) say("%susers on %s",
                          MegaType?"Mass deopping l":"Mass re-opping ",channel);
            else say("Mass %sopping %s",MegaType?"de":"re-",channel);
            DoDops(chops,channel);
            new_free(&chops);
        }
        else {
            if (!all) say("There are no %susers on %s",
                          MegaType?"opped l":"opped ",channel);
            else say("There are no channel operators on %s",channel);
        }
    }
    else NotChanOp(channel);
}

/* MegaDeops current channel */
void MegaDeop(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    MegaType=1;
    MegaMode(command,args,subargs);
}

/* MegaReops all ops in current channel */
void MegaReop(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    MegaType=0;
    MegaMode(command,args,subargs);
}

/*  Deop a line of users */
void DoDops(chops,channel)
char *chops;
char *channel;
{
    int  send=0;
    int  count=0;
    int  max=get_int_var(MAX_MODES_VAR);
    char *tmp=(char *) 0;
    char *modetype;
    char tmpbuf1[mybufsize];
    char tmpbuf2[mybufsize/4];

    *tmpbuf1='\0';
    *tmpbuf2='\0';
    if (MegaType) modetype="-o";
    else modetype="+o";
    sprintf(tmpbuf2,"MODE %s ",channel);
    for (tmp=new_next_arg(chops,&chops);tmp;tmp=new_next_arg(chops,&chops)) {
        count++;
	strcat(tmpbuf2," ");
        strcat(tmpbuf2,modetype);
	strcat(tmpbuf2," ");
        strcat(tmpbuf2,tmp);
        send=1;
        if (count==max) {
            strcat(tmpbuf1,tmpbuf2);
            strcat(tmpbuf1,"\r\n");
            sprintf(tmpbuf2,"MODE %s ",channel);
            count=0;
        }
        if (strlen(tmpbuf1)>=IRCD_BUFFER_SIZE-150) {
            send_to_server("%s",tmpbuf1);
            *tmpbuf1='\0';
            send=0;
        }
    }
    if (count) {
        strcat(tmpbuf1,tmpbuf2);
        strcat(tmpbuf1,"\r\n");
        send=1;
    }
    if (send) send_to_server("%s",tmpbuf1);
}

/* Newuser, stolen from Hendrix, and fixed up */
void NewUser(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmp;

    if (!(tmp=new_next_arg(args,&args))) {
        PrintUsage("/NEWUSER username realname");
        PrintSetting("Current username",username,empty_string,empty_string);
        PrintSetting("Current realname",realname,empty_string,empty_string);
        return;
    }
    strmcpy(username,tmp,NAME_LEN);
    if (args && *args) strmcpy(realname,args,REALNAME_LEN);
    ReconnectServer(NULL,NULL,NULL);
}

/* Newhost, patched in by Zakath. Got from diff w/ no credits... */
void NewHost(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *newhname=(char *) 0;
#ifdef JIMMIE
    int  i;
    int  count=0;
    char *hname;
    char *tmpstr;
    char *chosenname=(char *) 0;
    char putbuf[mybufsize/4];
    char tmpbuf[mybufsize/4];
    char filename[mybufsize/4];
    FILE *fp;
    struct hostent *hostaddr;
    /* servers in struct splitstr holds hostname */
    struct splitstr *tmplist=NULL,*listnew;
    unsigned long ipnum;
#endif

    newhname=new_next_arg(args,&args);
#ifndef JIMMIE
    if (newhname) {
        malloc_strcpy(&VirtualHost,newhname);
        ReconnectServer(NULL,NULL,NULL);
    }
    else PrintUsage("/NEWHOST <Virtual Host>");
#else
    /* create temporary file */
    sprintf(filename,"/tmp/sztmp%ld",time((time_t *) 0)%100);
    /* run /sbin/ifconfig */
    sprintf(tmpbuf,"/sbin/ifconfig >%s",filename);
    system(tmpbuf);
    if ((fp=fopen(filename,"r"))==NULL) {
        say("Error, something went wrong");
        unlink(filename);
        return;
    }
    while (fgets(tmpbuf,mybufsize/4,fp))
        if ((tmpstr=strstr(tmpbuf,"inet addr"))) {
            tmpstr+=10;
            hname=new_next_arg(tmpstr,&tmpstr);
            if (!hname || !strcmp(hname,"127.0.0.1")) continue;
            /* find hostname for this IP */
            ipnum=inet_addr(hname);
            hostaddr=gethostbyaddr((char *) &ipnum,sizeof(ipnum),AF_INET);
            /* put it in list */
            if (hostaddr && (listnew=(struct splitstr *) new_malloc(sizeof(struct splitstr)))) {
                listnew->servers=(char *) 0;
                listnew->next=(struct splitstr *) 0;
                malloc_strcpy(&(listnew->servers),(char *) hostaddr->h_name);
                add_to_list_ext((List **) &tmplist,(List *) listnew,
                                (int (*) _((List *, List *))) AddLast);
            }
        }
    fclose(fp);
    if (tmplist) {
        *putbuf='\0';
        /* let's print all available hostnames */
        for (listnew=tmplist,i=1;listnew;i++) {
            tmplist=listnew;
            listnew=listnew->next;
            sprintf(tmpbuf,"%2d) %-35s",i,tmplist->servers);
            strcat(putbuf,tmpbuf);
            count++;
            if (count==2 || strlen(tmplist->servers)>35) {
                if (!newhname) say("%s",putbuf);
                count=0;
                *putbuf='\0';
            }
            if (newhname && *newhname=='#' && i==atoi(&newhname[1]))
                malloc_strcpy(&chosenname,tmplist->servers);
            else if (newhname && !chosenname) malloc_strcpy(&chosenname,newhname);
            new_free(&(tmplist->servers));
            new_free(&tmplist);
        }
        if (!newhname) {
            if (count) say("%s",putbuf);
            say("Use /NEWHOST #number to select hostname");
        }
    }
    else say("No valid hostnames found");
    if (chosenname) {
        malloc_strcpy(&VirtualHost,chosenname);
        ReconnectServer(NULL,NULL,NULL);
        new_free(&chosenname);
    }
    unlink(filename);
#endif
}

/* Reconnects you to server, storing all current info */
void ReconnectServer(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int port;
    int servernum=from_server;
    char tmpbuf[mybufsize/4];

    port=get_server_port(servernum);
    say("Reconnecting to server %s port %d...",get_server_name(servernum),port);
    sprintf(tmpbuf,"+%i %d",servernum,port);
    close_server(servernum,"reconnecting to server");
    clean_whois_queue();
    window_check_servers();
    server(NULL,tmpbuf,NULL);
}

/* Sheik's stuff :) */
/*char *digtoken(string,match)
char **string;
char *match;
{
    if (string && *string && **string) {
        while (**string && strchr(match,**string)) (*string)++;
        if (**string) { *//* got something */
            /*char *token=*string;
            if ((*string=strpbrk(*string,match))) {
                *(*string)++=(char)0;
                while(**string && strchr(match,**string)) (*string)++;
            }
            else *string = empty_string;*/ /* must be at the end */
            /*return(token);
        }
    }
    return((char *)0);
}*/

/* Reconnects you to server on kill */
void ReconnectOnKill(servernum)
int servernum;
{
    int flag=1;
    Window *tmp;
    Window *oldwindow;

    oldwindow=get_window_by_refnum(current_refnum());
    while ((tmp=traverse_all_windows(&flag))!=NULL)
        if (tmp->server==servernum) break;
    set_current_window(tmp);
    ReconnectServer(NULL,NULL,NULL);
    set_current_window(oldwindow);
}

/* Kicks nick from the current channel */
void Kick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel;
    char *tmpnick=(char *) 0;
    char *comment=(char *) 0;
    NickList *joiner;
    ChannelList *chan;

    channel=get_channel_by_refnum(0);
    if (channel) {
        if (args && *args) {
            chan=lookup_channel(channel,curr_scr_win->server,0);
            if (chan && ((chan->status)&CHAN_CHOP)) {
                tmpnick=new_next_arg(args,&args);
                if (args && *args) comment=args;
                else comment=DefaultK;
                joiner=CheckJoiners(tmpnick,channel,curr_scr_win->server,chan);
#if defined(VILAS) || defined(FET)
                if (joiner) send_to_server("KICK %s %s :%s",channel,tmpnick,comment);
#elif defined(TOOLIE)
                if (joiner) send_to_server("KICK %s %s :%s %s <SZ-K>",channel,tmpnick,
                                           ToolieA,comment);
#else  /* TOOLIE */
                if (joiner) send_to_server("KICK %s %s :<ScrollZ-K> %s",channel,tmpnick,
                                           comment);
#endif /* VILAS || FET */
                else say("Can't find %s on %s",tmpnick,channel);
            }
            else NotChanOp(channel);
        }
        else PrintUsage("/K nick [reason]");
    }
    else NoWindowChannel();
}

/* Changes default ban type */
void BanType(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmptype;
    char tmpbuf[mybufsize/4];

    if (*args) {
        tmptype=new_next_arg(args,&args);
        switch (tmptype[0]) {
            case 'N':
            case 'n':
                defban='N';
                break;
            case 'B':
            case 'b':
                defban='B';
                break;
            case 'E':
            case 'e':
                defban='E';
                break;
            case 'H':
            case 'h':
                defban='H';
                break;
            case 'S':
            case 's':
                defban='S';
                break;
            default:
                PrintUsage("/BANTYPE type (N, B, E, H, or S)");
                say("          N=Normal, B=Better, E=Elite, H=Host, S=Screw");
                break;
        }
    }
    strcpy(tmpbuf,"Ban type");
    switch (defban) {
        case 'N':
            PrintSetting(tmpbuf,"Normal",empty_string,empty_string);
            break;
        case 'B':
            PrintSetting(tmpbuf,"Better",empty_string,empty_string);
            break;
        case 'E':
            PrintSetting(tmpbuf,"Elite",empty_string,empty_string);
            break;
        case 'H':
            PrintSetting(tmpbuf,"Host",empty_string,empty_string);
            break;
        case 'S':
            PrintSetting(tmpbuf,"Screw",empty_string,empty_string);
            break;
    }
}

/* Bans nick on specified channel */
void BanIt(channel,nick,userhost,deop,chan)
char *channel;
char *nick;
char *userhost;
int  deop;
ChannelList *chan;
{
    ChannelList *tmpchan;
    char tmpbuf[mybufsize/4];

    if (channel && chan) tmpchan=chan;
    else tmpchan=lookup_channel(channel,curr_scr_win->server,0);
    CreateBan(nick,userhost,tmpbuf);
    if (tmpchan && ((tmpchan->status)&CHAN_CHOP)) {
        if (deop) send_to_server("MODE %s -o+b %s %s",channel,nick,tmpbuf);
        else send_to_server("MODE %s +b %s",channel,tmpbuf);
    }
    else NotChanOp(channel);
}

/* Bans nick on the current channel */
void Ban(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel = (char *) 0;
    char *tmpnick;
    void (*func)();
    NickList *joiner;
    ChannelList *chan;

    channel=get_channel_by_refnum(0);
    if (channel) {
        chan=lookup_channel(channel,curr_scr_win->server,0);
        if (!chan) return;
        if (*args) {
            if ((chan->status)&CHAN_CHOP) {
                while ((tmpnick=new_next_arg(args,&args))) {
                    if (strchr(tmpnick,'!') || strchr(tmpnick,'@') || strchr(tmpnick,'*') ||
                        strchr(tmpnick,'.') || strchr(tmpnick,'?')) {
                        send_to_server("MODE %s +b %s",channel,tmpnick);
                        continue;
                    }
                    joiner=CheckJoiners(tmpnick,chan->channel,from_server,chan);
                    if (joiner) BanIt(channel,joiner->nick,joiner->userhost,1,chan);
                    else {
                        joiner=CheckJoiners(tmpnick,NULL,from_server,NULL);
                        if (joiner) BanIt(channel,joiner->nick,joiner->userhost,0,NULL);
                        else {
                            func=(void(*)())BanNew;
                            inFlierWI++;
                            add_to_whois_queue(tmpnick,func,"%s",channel);
                        }
                    }
                }
            }
            else NotChanOp(channel);
        }
        else PrintUsage("/BAN nick");
    }
    else NoWindowChannel();
}

/* Bans user if he/she is not on joinlist */
void BanNew(wistuff, tmpnick, text)
WhoisStuff *wistuff;
char *tmpnick;
char *text;
{
    char tmpbuf[mybufsize/4];

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    sprintf(tmpbuf,"%s@%s",wistuff->user,wistuff->host);
    BanIt(text,wistuff->nick,tmpbuf,0,NULL);
}

/* Bans and kicks nick from the current channel */
/* Also handles ignore and timed ban */
void BanKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel=(char *) 0;
    char *comment=(char *) 0;
    char *tmpnick;
    char tmpbuf1[mybufsize/4];
#ifdef EXTRAS
    char tmpbuf2[mybufsize/4];
#endif
    void (*func)();
    NickList *joiner;
    ChannelList *chan;

    channel=get_channel_by_refnum(0);
    if (channel) {
        chan=lookup_channel(channel,curr_scr_win->server,0);
        if (!chan) return;
        if (*args && args) {
            if ((chan->status)&CHAN_CHOP) {
                tmpnick=new_next_arg(args,&args);
                if (args && *args) comment=args;
                else {
                    if (!my_stricmp(command,"BK")) comment=DefaultBK;
#ifdef EXTRAS
                    else if (!my_stricmp(command,"BKI")) comment=DefaultBKI;
                    else comment=DefaultBKT;
#endif
                }
                joiner=CheckJoiners(tmpnick,channel,from_server,chan);
                if (joiner) {
                    BanIt(channel,joiner->nick,joiner->userhost,1,chan);
#if defined(VILAS) || defined(FET)
                    send_to_server("KICK %s %s :%s",channel,joiner->nick,comment);
#elif defined(TOOLIE)
                    send_to_server("KICK %s %s :%s %s <SZ-%s>",channel,joiner->nick,
                                   ToolieA,comment,command);
#else  /* TOOLIE */
                    send_to_server("KICK %s %s :<ScrollZ-%s> %s",channel,joiner->nick,
                                   command,comment);
#endif /* VILAS || FET */
                }
                else {
                    joiner=CheckJoiners(tmpnick,NULL,from_server,NULL);
                    if (joiner) BanIt(channel,joiner->nick,joiner->userhost,0,NULL);
                    else {
                        func=(void(*)())BanKickNew;
                        inFlierWI++;
                        add_to_whois_queue(tmpnick,func,"%s %s",command,channel);
                    }
                }
#ifdef EXTRAS
                if (joiner) {
                    if (index(command,'I')) {
                        send_text(joiner->nick,"You're now being ignored","NOTICE");
                        sprintf(tmpbuf1,"%s ALL",joiner->userhost);
                        sprintf(tmpbuf2,"%d",IgnoreTime);
                        ignore(NULL,tmpbuf1,tmpbuf2);
                        sprintf(tmpbuf1,"%d IGNORE %s NONE",IgnoreTime,joiner->userhost);
                        timercmd("TIMER",tmpbuf1,NULL);
                    }
                    else if (index(command,'T')) {
                        CreateBan(joiner->nick,joiner->userhost,tmpbuf2);
                        sprintf(tmpbuf1,"6 MODE %s -b %s",channel,tmpbuf2);
                        timercmd("TIMER",tmpbuf1,NULL);
                    }
                }
#endif
            }
            else NotChanOp(channel);
        }
        else {
            sprintf(tmpbuf1,"/%s nick [reason]",command);
            PrintUsage(tmpbuf1);
        }
    }
    else NoWindowChannel();
}

/* Bans & kicks user if he/she is not on joinlist */
void BanKickNew(wistuff, tmpnick, text)
WhoisStuff *wistuff;
char *tmpnick;
char *text;
{
    char *command;
    char *channel;
    char tmpbuf1[mybufsize/4];
#ifdef EXTRAS
    char tmpbuf2[mybufsize/4];
#endif

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    command=new_next_arg(text,&text);
    channel=new_next_arg(text,&text);
    if (!command || !channel) return;
    sprintf(tmpbuf1,"%s@%s",wistuff->user,wistuff->host);
    BanIt(channel,wistuff->nick,tmpbuf1,0,NULL);
#ifdef EXTRAS
    if (index(command,'I')) {
        strcat(tmpbuf1," ALL");
        sprintf(tmpbuf2,"%d",IgnoreTime);
        ignore(NULL,tmpbuf1,tmpbuf2);
        sprintf(tmpbuf1,"%d IGNORE %s@%s NONE",IgnoreTime,wistuff->user,wistuff->host);
        timercmd("TIMER",tmpbuf1,NULL);
    }
    else if (index(command,'T')) {
        CreateBan(wistuff->nick,tmpbuf1,tmpbuf2);
        sprintf(tmpbuf1,"6 MODE %s -b %s",channel,tmpbuf2);
        timercmd("TIMER",tmpbuf1,NULL);
    }
#endif
}

/* Ops nick on the current channel */
void Op(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  op=!my_stricmp(command,"OP")?1:0;
    int  count=0;
    int  usage=0;
    int  max=get_int_var(MAX_MODES_VAR);
    char *tmpnick;
    char *channel=(char *) 0;
    char *oplist=(char *) 0;
    char tmpbuf[mybufsize/4];
    register NickList *tmp;
    ChannelList *chan;

    if (args && *args) {
        if (is_channel(args)) channel=new_next_arg(args,&args);
        else if (!(channel=get_channel_by_refnum(0))) {
            NoWindowChannel();
            return;
        }
        chan=lookup_channel(channel,curr_scr_win->server,0);
        if (!chan) return;
        if (*args) {
            if ((chan->status)&CHAN_CHOP) {
                while ((tmpnick=new_next_arg(args,&args))) {
                    tmp=find_in_hash(chan,tmpnick);
                    if (tmp) {
                        if (op) malloc_strcat(&oplist," +o ");
                        else malloc_strcat(&oplist," -o ");
                        malloc_strcat(&oplist,tmpnick);
                        count++;
                    }
                    else say("Can't find %s on %s",tmpnick,channel);
                    if (count==max) {
                        send_to_server("MODE %s %s",channel,oplist);
                        new_free(&oplist);
                        count=0;
                    }
                }
                if (count) {
                    send_to_server("MODE %s %s",channel,oplist);
                    new_free(&oplist);
                }
            }
            else NotChanOp(channel);
        }
        else usage=1;
    }
    else usage=1;
    if (usage) {
        sprintf(tmpbuf,"/%s nicks",op?"OP":"DOP");
        PrintUsage(tmpbuf);
    }
}

/* Invites nick to your current channel */
void Invite(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick;
    char *tmpchannel=(char *) 0;
    char tmpbuf[mybufsize/4];

    if (*args) {
        tmpnick=new_next_arg(args,&args);
        if (args && *args) {
            tmpchannel=new_next_arg(args,&args);
            if (!is_channel(tmpchannel)) sprintf(tmpbuf,"#%s",tmpchannel);
            else strcpy(tmpbuf,tmpchannel);
            tmpchannel=tmpbuf;
        }
        else if ((tmpchannel=get_channel_by_refnum(0))==NULL) {
            NoWindowChannel();
            return;
        }
        if (is_chanop(tmpchannel,get_server_nickname(from_server)))
            send_to_server("INVITE %s %s",tmpnick,tmpchannel);
        else NotChanOp(tmpchannel);
    }
    else PrintUsage("/INV nick [[#]channel]");
}

/* Leaves current or specified channel */
void Leave(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *comment=(char *) 0;
    char *tmpchannel=(char *) 0;

    if (args && is_channel(args)) tmpchannel=new_next_arg(args,&args);
    else if (args && *args=='*') {
        tmpchannel=new_next_arg(args,&args);
        tmpchannel=get_channel_by_refnum(0);
    }
    comment=args;
    if (!tmpchannel && (tmpchannel=get_channel_by_refnum(0))==NULL) {
        NoWindowChannel();
        return;
    }
    if (comment && *comment) send_to_server("PART %s :%s",tmpchannel,comment);
    else send_to_server("PART %s",tmpchannel);
}

/* Does a -ntislmpk on your current channel */
void ModeClear(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel=(char *) 0;

    channel=get_channel_by_refnum(0);
    if (channel) {
        if (is_chanop(channel,get_server_nickname(from_server))) {
            send_to_server("MODE %s -ntislmp",channel);
            ClearKey(NULL,channel,NULL);
        }
        else NotChanOp(channel);
    }
    else NoWindowChannel();
}

/* Prints out all nicks on your current or specified channel */
void ChannelScan(command,args,subargs)
char *command;
char *args;
char *subargs;
{
#ifdef NEWCSCAN
    int  count=0;
    int  width=0;
    int  len=0;
#else
    int  buflen;
    int  szlen;
#endif
    int  gotchannel=0;
    int  shitted;
    int  reverse=2;
    int  friendok;
    int  hierarchy; /* 1-shitted, 2-normal, 3-voted, 4-ops, 5-friends */
    char *channel=(char *) 0;
    char *users=(char *) 0;
#ifdef WANTANSI
    char *colorstr=(char *) 0;
#endif
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
#ifndef NEWCSCAN
    char tmpbuf3[mybufsize/4];
#endif
#ifdef WANTANSI
    char tmpbuf4[mybufsize/4];
#endif
    NickList *tmp;
    ChannelList *chan;

    channel=new_next_arg(args,&args);
    if (channel) {
        gotchannel=1;
        if (!my_stricmp(channel,"-H")) {
            reverse=0;
            gotchannel=0;
        }
        else if (!my_stricmp(channel,"-R")) {
            reverse=1;
            gotchannel=0;
        }
        if (!gotchannel && (channel=new_next_arg(args,&args))) gotchannel=1;
        if (gotchannel) {
            if (is_channel(channel)) strcpy(tmpbuf1,channel);
            else sprintf(tmpbuf1,"#%s",channel);
            channel=tmpbuf1;
        }
        else channel=(char *) 0;
    }
    if (!channel && (channel=get_channel_by_refnum(0))==NULL) {
        NoWindowChannel();
        return;
    }
    hierarchy=reverse?5:1;
    chan=lookup_channel(channel,curr_scr_win->server,0);
    if (!chan) return;
#ifdef WANTANSI
#ifndef NEWCSCAN
    szlen=strlen(CToolzstr)-CountAnsi(CToolzstr,-1);
    sprintf(tmpbuf3,"%%%ds",szlen);
#endif /* NEWCSCAN */
    sprintf(tmpbuf1,"%s Users on %s%s%s :",CToolzstr,
            CmdsColors[COLCSCAN].color1,chan->channel,Colors[COLOFF]);
#else /* WANTANSI */
    sprintf(tmpbuf1,"%s Users on %s :",CToolzstr,chan->channel);
#ifndef NEWCSCAN
    szlen=strlen(CToolzstr);
    sprintf(tmpbuf3,"%%%ds",szlen);
#endif /* NEWCSCAN */
#endif /* WANTANSI */

#ifdef NEWCSCAN
    put_it("%s",tmpbuf1);
#else
    buflen=strlen(tmpbuf1);
    malloc_strcpy(&users,tmpbuf1);
#endif /* NEWCSCAN */

#ifdef NEWCSCAN
    for (tmp=chan->nicks;tmp;tmp=tmp->next)
        if(strlen(tmp->nick)>len) len=strlen(tmp->nick);
    if (len<=9) len=9;
#ifdef WANTANSI
    width=(CO-(strlen(CToolzstr)-CountAnsi(CToolzstr,-1)+7))/(len+2);
#else
    width=(CO-(strlen(CToolzstr)+7))/(len+2);
#endif /* WANTANSI */
    sprintf(tmpbuf1,"%%-%ds",len);
#endif /* NEWCSCAN */

    tmp=chan->nicks;
    for (;;) {
        if (!tmp) {
            if (reverse==2) break;
            else if (reverse) {
                hierarchy--;
                if (hierarchy<1) break;
            }
            else {
                hierarchy++;
                if (hierarchy>5) break;
            }
            tmp=chan->nicks;
        }
        shitted=tmp->shitlist?tmp->shitlist->shit:0;
        friendok=(!shitted && tmp->frlist)?tmp->frlist->privs:0;
        if (reverse!=2) {
            switch (hierarchy) {
            case 1: /* shitlisted */
                if (shitted)
#ifdef WANTANSI
                    colorstr=CmdsColors[COLCSCAN].color6;
#else
                ;
#endif
                else {
                    tmp=tmp->next;
                    continue;
                }
                break;
            case 2: /* normal */
                if (!(tmp->voice) && !(tmp->chanop) && !friendok && !shitted)
#ifdef WANTANSI
                    colorstr=CmdsColors[COLCSCAN].color5;
#else
                ;
#endif
                else {
                    tmp=tmp->next;
                    continue;
                }
                break;
            case 3: /* voted */
                if (tmp->voice && !(tmp->chanop) && !friendok && !shitted)
#ifdef WANTANSI
                    colorstr=CmdsColors[COLCSCAN].color4;
#else
                ;
#endif
                else {
                    tmp=tmp->next;
                    continue;
                }
                break;
            case 4: /* ops */
                if (tmp->chanop && !friendok && !shitted)
#ifdef WANTANSI
                    colorstr=CmdsColors[COLCSCAN].color3;
#else
                ;
#endif
                else {
                    tmp=tmp->next;
                    continue;
                }
                break;
            case 5: /* friends */
                if (friendok)
#ifdef WANTANSI
                    colorstr=CmdsColors[COLCSCAN].color2;
#else
                ;
#endif
                else {
                    tmp=tmp->next;
                    continue;
                }
                break;
            }
        }

#ifdef WANTANSI
        else {
            if (shitted) colorstr=CmdsColors[COLCSCAN].color6;
            else if (friendok) colorstr=CmdsColors[COLCSCAN].color2;
            else if (tmp->chanop) colorstr=CmdsColors[COLCSCAN].color3;
            else if (tmp->voice) colorstr=CmdsColors[COLCSCAN].color4;
            else colorstr=CmdsColors[COLCSCAN].color5;
        }
#endif /* WANTANSI */

        if (users) malloc_strcat(&users," ");

#ifdef NEWCSCAN
        else malloc_strcat(&users,"  ");
#endif /* NEWCSCAN */

#ifdef WANTANSI
        if (tmp->chanop) {
            sprintf(tmpbuf4,"%s@%s",CmdsColors[COLNICK].color4,Colors[COLOFF]);
            malloc_strcat(&users,tmpbuf4);
#ifndef NEWCSCAN
            buflen+=strlen(tmpbuf4)+1;
#endif /* NEWCSCAN */
        }
        else if (tmp->voice) {
            sprintf(tmpbuf4,"%s+%s",CmdsColors[COLNICK].color5,Colors[COLOFF]);
            malloc_strcat(&users,tmpbuf4);
#ifndef NEWCSCAN
            buflen+=strlen(tmpbuf4)+1;
#endif /* NEWCSCAN */
        }
#else  /* WANTANSI */
        if (tmp->chanop) malloc_strcat(&users,"@");
        else if (tmp->voice) malloc_strcat(&users,"+");
#ifndef NEWCSCAN
        buflen+=2;
#endif /* NEWCSCAN */
#endif /* WANTANSI */

#ifdef NEWCSCAN
        else malloc_strcat(&users," ");
#endif /* NEWCSCAN */

#ifdef WANTANSI
        malloc_strcat(&users,colorstr);
#ifndef NEWCSCAN
        buflen+=strlen(colorstr);
#endif /* NEWCSCAN */
#endif /* WANTANSI */

#ifndef NEWCSCAN
        malloc_strcat(&users,tmp->nick);
        buflen+=strlen(tmp->nick);
#else
        sprintf(tmpbuf2,tmpbuf1,tmp->nick);
        malloc_strcat(&users,tmpbuf2);
#endif /* NEWCSCAN */

#ifdef WANTANSI
        malloc_strcat(&users,Colors[COLOFF]);
#ifndef NEWCSCAN
        buflen+=4;
#endif /* NEWCSCAN */
#endif /* WANTANSI */

#ifndef NEWCSCAN
        if (buflen>=1800) {
            put_it("%s",users);
            buflen=0;
            sprintf(tmpbuf2,tmpbuf3," ");
            malloc_strcpy(&users,tmpbuf2);
        }
#else
        count++;
        if ((count%width)==0) {
            say("%s",users);
            count=0;
            new_free(&users);
        }
#endif /* NEWCSCAN */
        tmp=tmp->next;
    }
#ifndef NEWCSCAN
    if (users && buflen) put_it("%s",users);
#else
    if (count) say("%s",users);
#endif
    new_free(&users);
}

/* Lists all the friends you have on your friends list */
void ListFriends(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    DontHold=0;
    if (args && *args) malloc_strcpy(&tmpbuflist,args);
    else malloc_strcpy(&tmpbuflist,"*");
    tmpfriendlist=frlist;
    countall=0;
    listcount=0;
    say("No.  %-38s Access      P Channels","User");
    ListFriendsPage(tmpbuflist);
}

/* Lists one page of friends list */
void ListFriendsPage(line)
char *line;
{
    int  count=3;
#ifdef WANTANSI
    char *tmpstr;
    int  i;
#endif
    char tmpbuf1[mybufsize/4];
#ifdef WANTANSI
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
#endif

    while (count<curr_scr_win->display_size && tmpfriendlist!=NULL) {
        countall++;
        if ((*line=='#' && CheckChannel(line,tmpfriendlist->channels)) ||
            wild_match(line,tmpfriendlist->userhost) ||
            wild_match(tmpfriendlist->userhost,line)) {
            listcount++;
            count++;
            *tmpbuf1='\0';
            BuildPrivs(tmpfriendlist,tmpbuf1);
#ifdef WANTANSI
            sprintf(tmpbuf2,"%s%-11s%s",
                    CmdsColors[COLSETTING].color2,tmpbuf1,Colors[COLOFF]);
            strcpy(tmpbuf1,tmpfriendlist->userhost);
            i=strlen(tmpbuf1);
            if ((tmpstr=index(tmpbuf1,'@'))) {
                *tmpstr='\0';
                tmpstr++;
                sprintf(tmpbuf3,"%s%s%s\002@\002%s%s%s",
                        CmdsColors[COLSETTING].color4,tmpbuf1,Colors[COLOFF],
                        CmdsColors[COLSETTING].color4,tmpstr,Colors[COLOFF]);
                strcpy(tmpbuf1,tmpbuf3);
            }
            else
                sprintf(tmpbuf1,"%s%s%s",
                        CmdsColors[COLSETTING].color4,tmpfriendlist->userhost,Colors[COLOFF]);
            for (;i<38;i++) strcat(tmpbuf1," ");
            sprintf(tmpbuf3,"#%-3d %s %s %s",tmpfriendlist->number,tmpbuf1,tmpbuf2,
                    tmpfriendlist->passwd?"Y":"N");
            say("%s %s%s%s",tmpbuf3,
                CmdsColors[COLSETTING].color5,tmpfriendlist->channels,Colors[COLOFF]);
#else
            say("#%-2d %-38s %-11s %s %s",countall,tmpfriendlist->userhost,
                tmpbuf1,tmpfriendlist->passwd?"Y":"N",tmpfriendlist->channels);
#endif
        }
        tmpfriendlist=tmpfriendlist->next;
    }
    if (!tmpfriendlist) ListFriendsKey(line,"E");
    else if (DontHold) ListFriendsPage(line);
    else if (count>=curr_scr_win->display_size) add_wait_prompt("Press any key to continue, 'c' for continuous, 'q' to quit",ListFriendsKey,line,WAIT_PROMPT_KEY);
}

/* This waits for key press */
void ListFriendsKey(stuff,line)
char *stuff;
char *line;
{
    if (line && (*line=='q' || *line=='Q' || *line=='E')) {
        if (*line=='E') say("%d out of %d entries matched your filter",listcount,
                            countall);
        return;
    }
    else {
        if (line && (*line=='c' || *line=='C')) DontHold=1;
        ListFriendsPage(stuff);
    }
}

/* Lists all the people you have on your auto (ban) kick list */
void ListAutoBanKicks(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    DontHold=0;
    if (args && *args) malloc_strcpy(&tmpbuflist,args);
    else malloc_strcpy(&tmpbuflist,"*");
    tmpabklist=abklist;
    listcount=0;
    countall=0;
    say("The following people match %s on shit list :",tmpbuflist);
    ListABKsPage(tmpbuflist);
}

/* This lists one page of auto (ban) kicks list */
void ListABKsPage(line)
char *line;
{
    int  count=2;
#ifdef WANTANSI
    char *tmpstr;
#endif
    char tmpbuf1[mybufsize/4];
#ifdef WANTANSI
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
#endif

    while (count<curr_scr_win->display_size && tmpabklist) {
        countall++;
        if ((*line=='#' && CheckChannel(line,tmpabklist->channels)) ||
            wild_match(line,tmpabklist->userhost) ||
            wild_match(tmpabklist->userhost,line)) {
            listcount++;
            count++;
            count++;
            *tmpbuf1='\0';
            if ((tmpabklist->shit)&1) strcat(tmpbuf1,"K");
            if ((tmpabklist->shit)&2) strcat(tmpbuf1,"B");
            if ((tmpabklist->shit)&4) strcat(tmpbuf1,"I");
            if ((tmpabklist->shit)&8) strcat(tmpbuf1,"P");
            if ((tmpabklist->shit)&16) strcat(tmpbuf1,"D");
#ifdef WANTANSI
            strcpy(tmpbuf2,tmpabklist->userhost);
            if ((tmpstr=index(tmpbuf2,'@'))) {
                *tmpstr='\0';
                tmpstr++;
                sprintf(tmpbuf3,"%s%s%s\002@\002%s%s%s",
                        CmdsColors[COLSETTING].color4,tmpbuf2,Colors[COLOFF],
                        CmdsColors[COLSETTING].color4,tmpstr,Colors[COLOFF]);
            }
            else
                sprintf(tmpbuf3,"%s%s%s",
                        CmdsColors[COLSETTING].color4,tmpabklist->userhost,Colors[COLOFF]);
            say("#%-2d %s%-3s%s %s",countall,
                CmdsColors[COLSETTING].color2,tmpbuf1,Colors[COLOFF],tmpbuf3);
            say("    on channels %s%s%s : %s%s%s",
                CmdsColors[COLSETTING].color5,tmpabklist->channels,
                Colors[COLOFF],CmdsColors[COLSETTING].color3,
                tmpabklist->reason,Colors[COLOFF]);
#else
            say("#%-2d %-3s  %-45s",countall,tmpbuf1,tmpabklist->userhost);
            say("    on channels %s : %s",tmpabklist->channels,tmpabklist->reason);
#endif
        }
        tmpabklist=tmpabklist->next;
    }
    if (!tmpabklist) ListABKsKey(NULL,"E");
    else if (DontHold) ListABKsPage(line);
    else if (count>=curr_scr_win->display_size) add_wait_prompt("Press any key to continue, 'c' for continuous, 'q' to quit",ListABKsKey,line,WAIT_PROMPT_KEY);
}

/* This waits for key press */
void ListABKsKey(stuff,line)
char *stuff;
char *line;
{
    if (line && (*line=='q' || *line=='Q' || *line=='E')) {
        if (*line=='E') say("%d out of %d entries matched your filter",listcount,
                            countall);
        return;
    }
    else {
        if (line && (*line=='c' || *line=='C')) DontHold=1;
        ListABKsPage(stuff);
    }
}

/* Shows or sets topic for current or specified channel */
void Topic(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel;
    char *tmparg;
    ChannelList *chan;

    channel=get_channel_by_refnum(0);
    if (!(args && *args)) {
        if (channel && (chan=lookup_channel(channel,from_server,0))) {
            say("Topic for %s: %s",chan->channel,chan->topicstr);
            if (chan->topicwho) say("%s",chan->topicwho);
        }
        else NoWindowChannel();
    }
    else {
        if (!is_channel(args)) {
            if (channel) {
                if ((chan=lookup_channel(channel,from_server,0))) {
                    if (((chan->mode)&MODE_TOPIC) && ((chan->status)&CHAN_CHOP))
                        send_to_server("TOPIC %s :%s",channel,args);
                    else if ((chan->mode)&MODE_TOPIC) NotChanOp(channel);
                    else send_to_server("TOPIC %s :%s",channel,args);
                }
            }
            else NoWindowChannel();
        }
        else {
            tmparg=new_next_arg(args,&args);
            if ((chan=lookup_channel(tmparg,from_server,0))) {
                if (((chan->mode)&MODE_TOPIC) && ((chan->status)&CHAN_CHOP))
                    send_to_server("TOPIC %s :%s",chan->channel,args);
                else if ((chan->mode)&MODE_TOPIC) NotChanOp(chan->channel);
                else send_to_server("TOPIC %s :%s",chan->channel,args);
            }
            else say("You are not on channel %s",tmparg);
        }
    }
}

/* Connects to default or specified server */
void FServer(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    if (args && *args) server(NULL,args,NULL);
    else if (my_stricmp(DefaultServer,"NONE")) server(NULL,DefaultServer,NULL);
    else say("No default server specified");
}

/* Leaves and joins current or specified channel */
void Cycle(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpchannel=(char *) 0;
    char tmpbuf[mybufsize/4];
    ChannelList *chan;

    if (args && *args) {
        tmpchannel=new_next_arg(args,&args);
        if (!is_channel(tmpchannel)) sprintf(tmpbuf,"#%s",tmpchannel);
        else strcpy(tmpbuf,tmpchannel);
        tmpchannel=tmpbuf;
    }
    else if ((tmpchannel=get_channel_by_refnum(0))==NULL) {
        NoWindowChannel();
        return;
    }
    if ((chan=lookup_channel(tmpchannel,from_server,0))) {
        strcpy(tmpbuf,tmpchannel);
        if (chan->key) {
            strcat(tmpbuf," :");
            strcat(tmpbuf,chan->key);
        }
        send_to_server("PART %s",tmpchannel);
        e_channel("JOIN",tmpbuf,tmpbuf);
    }
}

/* Saves friends into ScrollZ.save file */
void CToolzSave(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  ulistcount;
    int  slistcount;
    int  nlistcount;
    int  wlistcount;
    char *filepath;
    char *filebak;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    FILE *usfile;
    NotifyList *notify;
    struct words *tmpword;
    struct friends *tmpfriend;
    struct autobankicks *tmpabk;

    filebak=OpenCreateFile("ScrollZ.bak",1);
    filepath=OpenCreateFile("ScrollZ.save",0);
    remove(filebak);
    if (filepath) rename(filepath,filebak);
    filepath=OpenCreateFile("ScrollZ.save",1);
    if ((usfile=fopen(filepath,"w"))==NULL) {
        say("Can't open file ScrollZ.save for writing !");
        return;
    }
    say("Saving all ScrollZ related stuff into ScrollZ.save");
    fprintf(usfile,"#\n");
    fprintf(usfile,"# This is ScrollZ by Flier + Cdcc from Sheik & Flier save file\n");
    fprintf(usfile,"#\n");
    fprintf(usfile,"#\n");
    fprintf(usfile,"# Friends list\n");
    fprintf(usfile,"# ADDF   Nick!User@Host    Privileges    Channels\n");
    fprintf(usfile,"# where privileges can be : ALL or INVITE, CHOPS, OP, AUTOOP, UNBAN, PROT, GOD, VOTE or CDCC\n");
    fprintf(usfile,"#        ALL=2047   INVITE=1   CHOPS=2   OP=4   AUTOOP=8   UNBAN=16   PROT=32\n");
    fprintf(usfile,"#                   CDCC=64    GOD=128   VOTE=256   JOIN=512   FLOOD=1024\n");
    fprintf(usfile,"# channels is a list of channels separated by ','  like #sex*,#test,#chan\n");
    fprintf(usfile,"#\n");
    for (tmpfriend=frlist,ulistcount=0;tmpfriend;tmpfriend=tmpfriend->next) {
        fprintf(usfile,"ADDF  %-40s   %4d   %20s",tmpfriend->userhost,tmpfriend->privs,
                tmpfriend->channels);
        if (tmpfriend->passwd) fprintf(usfile," %s",tmpfriend->passwd);
        fprintf(usfile,"\n");
        ulistcount++;
    }
    fprintf(usfile,"#\n");
    fprintf(usfile,"# Shit list\n");
    fprintf(usfile,"# ADDBK   Nick!User@Host    Shit-level    Channels    Comment\n");
    fprintf(usfile,"# where shit-level can be : KICK, BAN, IGNORE, PERMBAN or DEOP\n");
    fprintf(usfile,"#         KICK=1   BAN=2   IGNORE=4   PERMBAN=8   DEOP=16\n");
    fprintf(usfile,"# channels is a list of channels separated by ','  like #sex*,#test,#chan\n");
    fprintf(usfile,"#\n");
    for (tmpabk=abklist,slistcount=0;tmpabk;tmpabk=tmpabk->next) {
        fprintf(usfile,"ADDBK %-40s   %4d   %20s   %s\n",tmpabk->userhost,tmpabk->shit,
                tmpabk->channels,tmpabk->reason);
        slistcount++;
    }
    fprintf(usfile,"#\n");
    fprintf(usfile,"# Notify list\n");
    fprintf(usfile,"# ADDN   Nick1   Nick2   Nick3   Nick4   Nick5\n");
    fprintf(usfile,"#\n");
    nlistcount=0;
    *tmpbuf2='\0';
    for (notify=notify_list;notify;notify=notify->next) {
        sprintf(tmpbuf1,"%-10s",notify->nick);
        strcat(tmpbuf2,tmpbuf1);
        nlistcount++;
        if ((nlistcount%5)==0) {
            fprintf(usfile,"ADDN  %s\n",tmpbuf2);
            *tmpbuf2='\0';
        }
    }
    if (nlistcount && (nlistcount%5)) fprintf(usfile,"ADDN  %s\n",tmpbuf2);
    fprintf(usfile,"#\n");
    fprintf(usfile,"# Word kick list\n");
    fprintf(usfile,"# ADDW   channels word comment\n");
    fprintf(usfile,"#\n");
    for (tmpword=wordlist,wlistcount=0;tmpword;tmpword=tmpword->next) {
        fprintf(usfile,"ADDW %15s %20s %s\n",
                tmpword->channels,tmpword->word,tmpword->reason);
        wlistcount++;
    }
    say("Saved %d fl, %d sl, %d nl and %d wk entries",ulistcount,slistcount,nlistcount,
        wlistcount);
    fprintf(usfile,"#\n");
    fprintf(usfile,"# Various user definable settings\n");
    fprintf(usfile,"#\n");
    fprintf(usfile,"EXTMES          ");
    if (ExtMes) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"NHPROT          ");
    if (NHProt) fprintf(usfile,"ON %s ",NHProtChannels);
    else fprintf(usfile,"OFF ");
    if (NHDisp==0) fprintf(usfile,"QUIET\n");
    if (NHDisp==1) fprintf(usfile,"MEDIUM\n");
    if (NHDisp==2) fprintf(usfile,"FULL\n");
    fprintf(usfile,"BANTYPE         ");
    if (defban=='N') fprintf(usfile,"NORMAL\n");
    else if (defban=='B') fprintf(usfile,"BETTER\n");
    else if (defban=='E') fprintf(usfile,"ELITE\n");
    else if (defban=='H') fprintf(usfile,"HOST\n");
    else if (defban=='S') fprintf(usfile,"SCREW\n");
    fprintf(usfile,"AUTOAWTIME      %d\n",AutoAwayTime);
    fprintf(usfile,"IGNORETIME      %d\n",IgnoreTime);
    fprintf(usfile,"SHITIGNORETIME  %d\n",ShitIgnoreTime);
    fprintf(usfile,"MDOPWATCH       ");
    if (MDopWatch) fprintf(usfile,"ON %s\n",MDopWatchChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"KICKWATCH       ");
    if (KickWatch) fprintf(usfile,"ON %s\n",KickWatchChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"NICKWATCH       ");
    if (NickWatch) fprintf(usfile,"ON %s\n",NickWatchChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"AUTOREJOIN      ");
    if (AutoRejoin) fprintf(usfile,"ON %s\n",AutoRejoinChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"AUTOJOININV     ");
    if (AutoJoinOnInv==2) fprintf(usfile,"AUTO %s\n",AutoJoinChannels);
    else if (AutoJoinOnInv) fprintf(usfile,"ON %s\n",AutoJoinChannels);
    else fprintf(usfile,"OFF\n");
#if defined(EXTRAS) || defined(FLIER)
    fprintf(usfile,"AUTOINV         ");
    if (AutoInv) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
#endif
    fprintf(usfile,"FLOODPROT       ");
    if (FloodProt>1) fprintf(usfile,"MAX %d %d\n",FloodMessages,FloodSeconds);
    else if (FloodProt) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"SERVNOTICE      ");
    if (ServerNotice) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"CTCPCLOAKING    ");
    if (CTCPCloaking==1) fprintf(usfile,"ON\n");
    else if (CTCPCloaking==2) fprintf(usfile,"HIDE\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"SHOWFAKES       ");
    if (ShowFakes) fprintf(usfile,"ON %s\n",ShowFakesChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"SHOWAWAY        ");
    if (ShowAway) fprintf(usfile,"ON %s\n",ShowAwayChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"KICKOPS         ");
    if (KickOps) fprintf(usfile,"ON %s\n",KickOpsChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"KICKONFLOOD     ");
    if (KickOnFlood) fprintf(usfile,"ON %s\n",KickOnFloodChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"SHOWNICK        ");
    if (ShowNick) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"KICKONBAN       ");
    if (KickOnBan) fprintf(usfile,"ON %s\n",KickOnBanChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"BITCHMODE       ");
    if (Bitch) fprintf(usfile,"ON %s\n",BitchChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"FRIENDLIST      ");
    if (FriendList) fprintf(usfile,"ON %s\n",FriendListChannels);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"DEOPSENSOR      %d\n",DeopSensor);
    fprintf(usfile,"KICKSENSOR      %d\n",KickSensor);
    fprintf(usfile,"NICKSENSOR      %d\n",NickSensor);
    fprintf(usfile,"DEOPTIMER       %d\n",MDopTimer);
    fprintf(usfile,"KICKTIMER       %d\n",KickTimer);
    fprintf(usfile,"NICKTIMER       %d\n",NickTimer);
    fprintf(usfile,"DEFSERVER       %s\n",DefaultServer);
    fprintf(usfile,"DEFSIGNOFF      %s\n",DefaultSignOff);
    fprintf(usfile,"DEFSETAWAY      %s\n",DefaultSetAway);
    fprintf(usfile,"DEFSETBACK      %s\n",DefaultSetBack);
    fprintf(usfile,"DEFUSERINFO     %s\n",DefaultUserinfo);
    fprintf(usfile,"DEFFINGER       %s\n",DefaultFinger);
    fprintf(usfile,"DEFK            %s\n",DefaultK);
    fprintf(usfile,"DEFBK           %s\n",DefaultBK);
    fprintf(usfile,"DEFBKI          %s\n",DefaultBKI);
    fprintf(usfile,"DEFBKT          %s\n",DefaultBKT);
    fprintf(usfile,"DEFFK           %s\n",DefaultFK);
    fprintf(usfile,"DEFLK           %s\n",DefaultLK);
    fprintf(usfile,"DEFABK          %s\n",DefaultABK);
    fprintf(usfile,"DEFSK           %s\n",DefaultSK);
    fprintf(usfile,"AUTOOPTIME      %d\n",AutoOpDelay);
    fprintf(usfile,"SHOWWALLOP      ");
    if (ShowWallop) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    if (AutoReplyBuffer) fprintf(usfile,"AUTOREPLY       %s\n",AutoReplyBuffer);
    fprintf(usfile,"ORIGNICK        ");
    if (OrigNickChange) fprintf(usfile,"ON %s\n",OrigNick);
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"NOTIFYMODE      ");
    if (NotifyMode==2) fprintf(usfile,"Verbose\n");
    else fprintf(usfile,"Brief\n");
    fprintf(usfile,"URLCATCHER      ");
    if (URLCatch==2) fprintf(usfile,"AUTO\n");
    else if (URLCatch) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"EGO             ");
    if (Ego) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"AUTOCOMPLETION  ");
    if (AutoNickCompl) fprintf(usfile,"ON %s\n",AutoReplyString);
    else fprintf(usfile,"OFF\n");
#ifdef WANTANSI
    fprintf(usfile,"MIRCCOLORS      ");
    if (DisplaymIRC) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
#endif
    if (PermUserMode) fprintf(usfile,"USERMODE        %s\n",PermUserMode);
    fprintf(usfile,"#\n");
    fprintf(usfile,"# ScrollZ.away defines\n");
    fprintf(usfile,"# AWAYSAVE      type\n");
    fprintf(usfile,"# where type can be : ALL or MSG, NOTICE, MASS, COLL, CDCC, DCC, PROT, HACK, SRVMODE\n");
    fprintf(usfile,"#                     CTCP, FLOOD, INVITE, KILL, KICK, SERVER or FAKE\n");
    fprintf(usfile,"#        ALL=262143   MSG=1   NOTICE=2   MASS=4    COLL=8    CDCC=16    DCC=32    PROT=64    HACK=128\n");
    fprintf(usfile,"#                     SRVMODE=256   CTCP=512   FLOOD=1024  INVITE=2048  KILL=4096  KICK=8192  SERVER=16384\n");
    fprintf(usfile,"#                     FAKE=32768   AREPLY=65536   CHAT=131072\n");
    fprintf(usfile,"#\n");
    fprintf(usfile,"AWAYSAVE        %d\n",AwaySaveSet);
    fprintf(usfile,"#\n");
    fprintf(usfile,"# Cdcc related settings\n");
    fprintf(usfile,"#\n");
    fprintf(usfile,"CDCC LIMIT      %d\n",CdccLimit);
    fprintf(usfile,"CDCC IDLE       %d\n",CdccIdle);
    fprintf(usfile,"CDCC AUTOGET    ");
    if (AutoGet) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"CDCC SECURE     ");
    if (Security) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    if (CdccChannels) fprintf(usfile,"CDCC CHANNELS   %s\n",CdccChannels);
    fprintf(usfile,"CDCC PTIME      %d\n",PlistTime);
    fprintf(usfile,"CDCC LONGSTATUS ");
    if (LongStatus) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"CDCC STATUS     ");
    if (ShowDCCStatus) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    fprintf(usfile,"CDCC STATS      ");
    if (CdccStats) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
    if (CdccUlDir) fprintf(usfile,"CDCC ULDIR      %s\n",CdccUlDir);
    if (CdccDlDir) fprintf(usfile,"CDCC DLDIR      %s\n",CdccDlDir);
#ifdef EXTRA_STUFF
    fprintf(usfile,"CDCC E          %s\n",EString);
    fprintf(usfile,"CDCC M          ");
    if (RenameFiles) fprintf(usfile,"ON\n");
    else fprintf(usfile,"OFF\n");
#endif
#ifdef WANTANSI
    SaveColors(usfile);
#endif
    fclose(usfile);
    say("ScrollZ.save succesfully saved !");
}

/* Returns friend's privilege (if it finds him/her on your friends list, else 0 */
struct friends *CheckUsers(userhost,channels)
char *userhost;
char *channels;
{
    struct friends *tmpfriend;

    if (!userhost) return(0);
    tmpfriend=frlist;
    if (!channels) {
        for (;tmpfriend;tmpfriend=tmpfriend->next)
            if (wild_match(tmpfriend->userhost,userhost) ||
                wild_match(userhost,tmpfriend->userhost))
                return(tmpfriend);
    }
    else {
        for (;tmpfriend;tmpfriend=tmpfriend->next)
            if ((wild_match(tmpfriend->userhost,userhost) ||
                 wild_match(userhost,tmpfriend->userhost))
                && CheckChannel(channels,tmpfriend->channels))
                return(tmpfriend);
    }
    return(NULL);
}

/* Returns autobankicker's shit-level (if it finds him/her on your abks list, else 0 */
struct autobankicks *CheckABKs(userhost,channel)
char *userhost;
char *channel;
{
    struct autobankicks *tmpabk;

    tmpabk=abklist;
    if (!channel) {
        while (tmpabk) {
            if (wild_match(tmpabk->userhost,userhost) ||
                wild_match(userhost,tmpabk->userhost))
                break;
            tmpabk=tmpabk->next;
        }
    }
    else {
        while (tmpabk) {
            if ((wild_match(tmpabk->userhost,userhost) ||
                 wild_match(userhost,tmpabk->userhost))
                && CheckChannel(channel,tmpabk->channels)) break;
            tmpabk=tmpabk->next;
        }
    }
    return(tmpabk);
}

/* Finds nick on given channel and server or just server if no channel */
NickList *CheckJoiners(nick,channel,server,tmpchan)
char *nick;
char *channel;
int  server;
ChannelList *tmpchan;
{
    NickList *tmp=NULL;
    register ChannelList *chan;

    if (channel) {
        if (tmpchan) chan=tmpchan;
        else chan=lookup_channel(channel,server,0);
        if (chan) tmp=find_in_hash(chan,nick);
        return(tmp);
    }
    else {
        for (chan=server_list[server].chan_list;chan;chan=chan->next) {
            tmp=find_in_hash(chan,nick);
            if (tmp) return(tmp);
        }
    }
    return((NickList *) 0);
}

/* Redirects last message/notice to current or specified channel */
void DirLM(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  msg=1;
    char *tmparg;
    char *message=LastMessage;
    char *channel=(char *) 0;

    if (!my_stricmp(command,"DIRLN")) {
        message=LastNotice;
        msg=0;
    }
    if (message) {
        if (!(*args)) {
            channel=get_channel_by_refnum(0);
            if (channel) send_text(channel,message,"PRIVMSG");
            else NoWindowChannel();
        }
        else {
            tmparg=new_next_arg(args,&args);
            send_text(tmparg,message,"PRIVMSG");
            AddNick2List(tmparg);
        }
    }
    else say("You haven't received any %s so far",msg?"message":"notice");
}

/* Adds friend to your friends list with specified privileges */
void AddFriend(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick=(char *) 0;
    char *tmpchan=(char *) 0;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
    void (*func)();
    NickList *joiner;

    tmpnick=new_next_arg(args,&args);
    tmpchan=new_next_arg(args,&args);
    if (!(args && *args)) {
        PrintUsage("/ADDF nick/filter channels privileges [password]");
        return;
    }
    sprintf(tmpbuf1,"%s %s",tmpchan,args);
    if (strchr(tmpnick,'!') || strchr(tmpnick,'@') || strchr(tmpnick,'*') ||
        strchr(tmpnick,'.') || strchr(tmpnick,'?'))
        AddFriend2List(NULL,tmpnick,tmpbuf1);
    else {
        joiner=CheckJoiners(tmpnick,NULL,from_server,NULL);
        if (joiner && joiner->userhost) {
            strcpy(tmpbuf2,joiner->userhost);
            UserDomainList(tmpbuf2);
            sprintf(tmpbuf3,"*!%s",tmpbuf2);
            AddFriend2List(joiner->nick,tmpbuf3,tmpbuf1);
        }
        else {
            func=(void(*)())AddFriendNew;
            inFlierWI++;
            add_to_whois_queue(tmpnick,func,"%s",tmpbuf1);
        }
    }
}

/* Adds friend to your friends list if he/she is not on joinlist */
void AddFriendNew(wistuff, tmpnick, text)
WhoisStuff *wistuff;
char *tmpnick;
char *text;
{
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    sprintf(tmpbuf1,"%s@%s",wistuff->user,wistuff->host);
    UserDomainList(tmpbuf1);
    sprintf(tmpbuf2,"*!%s",tmpbuf1);
    AddFriend2List(wistuff->nick,tmpbuf2,text);
}

/* Returns the integer from specified privileges */
int CheckPrivs(privs,buffer)
char *privs;
char *buffer;
{
    int  i=0;
    char *tmpprivs=(char *) 0;

    *buffer='\0';
    tmpprivs=privs;
    if (tmpprivs && *tmpprivs && !my_stricmp(tmpprivs,"ALL")) {
        i=1663;
        strcpy(buffer,"INVITE CHOPS OP UNBAN CDCC");
        return(i);
    }
    for (;tmpprivs && *tmpprivs;tmpprivs++) {
        switch (*tmpprivs) {
            case 'i':
            case 'I':
                if (i&1) break;
                i|=1;
                strcat(buffer,"INVITE ");
                break;
            case 'c':
            case 'C':
                if (i&2) break;
                i|=2;
                strcat(buffer,"CHOPS ");
                break;
            case 'o':
            case 'O':
                if (i&4) break;
                i|=4;
                strcat(buffer,"OP ");
                break;
            case 'a':
            case 'A':
                i|=8;
                break;
            case 'u':
            case 'U':
                if (i&16) break;
                i|=16;
                strcat(buffer,"UNBAN ");
                break;
            case 'p':
            case 'P':
                i|=32;
                break;
            case 'd':
            case 'D':
                if (i&64) break;
                i|=64;
                strcat(buffer,"CDCC ");
                break;
            case 'g':
            case 'G':
                i|=128;
                break;
            case 'v':
            case 'V':
                i|=256;
                break;
            case 'j':
            case 'J':
                i|=512;
                break;
            case 'f':
            case 'F':
                i|=1024;
                break;
        }
    }
    return(i);
}

/* This really adds him/her to your friends list */
void AddFriend2List(nick,userhost,buffer)
char *nick;
char *userhost;
char *buffer;
{
    int  i=0;
    int  number=1;
    char *tmpstr=(char *) 0;
    char *chanlist=(char *) 0;
    char *privs=(char *) 0;
    char *passwd=(char *) 0;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    NickList *tmp;
    ChannelList *tmpchan;
    struct friends *tmpfriend;
    struct friends *tmpfriend1;

    tmpstr=buffer;
    chanlist=new_next_arg(tmpstr,&tmpstr);
    privs=new_next_arg(tmpstr,&tmpstr);
    passwd=new_next_arg(tmpstr,&tmpstr);
    i=CheckPrivs(privs,tmpbuf2);
    if (i) {
        if (CheckUsers(userhost,chanlist)) {
            for (tmpfriend=frlist;tmpfriend;tmpfriend=tmpfriend->next)
                if ((wild_match(tmpfriend->userhost,userhost) ||
                     wild_match(userhost,tmpfriend->userhost))
                    && CheckChannel(chanlist,tmpfriend->channels)) break;
        }
        else {
            tmpfriend=(struct friends *) new_malloc(sizeof(struct friends));
            tmpfriend->userhost=(char *) 0;
            tmpfriend->channels=(char *) 0;
            tmpfriend->passwd=(char *) 0;
            tmpfriend->next=NULL;
            for (tmpfriend1=frlist;tmpfriend1 && tmpfriend1->next;tmpfriend1=tmpfriend1->next)
                number++;
            if (tmpfriend1) {
                tmpfriend1->next=tmpfriend;
                number++;
            }
            else frlist=tmpfriend;
            tmpfriend->number=number;
        }
        for (tmpchan=server_list[curr_scr_win->server].chan_list;tmpchan;
             tmpchan=tmpchan->next)
            if (CheckChannel(tmpchan->channel,chanlist)) {
                for (tmp=tmpchan->nicks;tmp;tmp=tmp->next) {
                    if (tmp->userhost) sprintf(tmpbuf1,"%s!%s",tmp->nick,tmp->userhost);
                    else strcpy(tmpbuf1,tmp->nick);
                    if (wild_match(userhost,tmpbuf1)) tmp->frlist=tmpfriend;
                }
            }
        malloc_strcpy(&(tmpfriend->userhost),userhost);
        malloc_strcpy(&(tmpfriend->channels),chanlist);
        if (passwd && *passwd) malloc_strcpy(&(tmpfriend->passwd),passwd);
        else new_free(&(tmpfriend->passwd));
        tmpfriend->privs=i;
        synch_whowas_adduser(tmpfriend);
        sprintf(tmpbuf1,"Auto-op:%s  Vote:%s  Prot:%s  God:%s  No flood check:%s",
                (i&8)?"Y":"N",(i&256)?"Y":"N",(i&32)?"Y":"N",(i&128)?"Y":"N",
                (i&1024)?"Y":"N");
        if (nick) {
            send_to_server("NOTICE %s :You have been added to my friends list with",nick);
            send_to_server("NOTICE %s :CTCP access of : %s",nick,tmpbuf2);
            send_to_server("NOTICE %s :Commands are valid on channel(s) : %s",nick,chanlist);
            send_to_server("NOTICE %s :%s",nick,tmpbuf1);
            if (i&512) send_to_server("NOTICE %s :I will join channels you invite me to",nick);
            if (tmpfriend->passwd)
                send_to_server("NOTICE %s :Your password is : %s",nick,tmpfriend->passwd);
        }
#ifdef WANTANSI
        say("Added %s%s%s to your friends list",
            CmdsColors[COLSETTING].color4,userhost,Colors[COLOFF]);
        say("with CTCP access of : %s%s%s",
            CmdsColors[COLSETTING].color2,tmpbuf2,Colors[COLOFF]);
        say("on channels %s%s%s",
            CmdsColors[COLSETTING].color5,chanlist,Colors[COLOFF]);
        sprintf(tmpbuf1,"Auto-op:%s%s%s  Vote:%s%s%s  Prot:%s%s%s",
                CmdsColors[COLSETTING].color2,(i&8)?"Y":"N",Colors[COLOFF],
                CmdsColors[COLSETTING].color2,(i&256)?"Y":"N",Colors[COLOFF],
                CmdsColors[COLSETTING].color2,(i&32)?"Y":"N",Colors[COLOFF]);
        say("%s  God:%s%s%s  No flood check:%s%s%s",tmpbuf1,
            CmdsColors[COLSETTING].color2,(i&128)?"Y":"N",Colors[COLOFF],
            CmdsColors[COLSETTING].color2,(i&1024)?"Y":"N",Colors[COLOFF]);
        if (i&512) say("You will join channels %s%s%s invites you to",
                       CmdsColors[COLSETTING].color4,userhost,Colors[COLOFF]);
#else
        say("Added %s to your friends list",userhost);
        say("with CTCP access of : %s",tmpbuf2);
        say("on channels %s",chanlist);
        say("%s",tmpbuf1);
        if (i&512) say("You will join channels %s invites you to",userhost);
#endif
        if (tmpfriend->passwd)
            say("Password is set to : %s",tmpfriend->passwd);
    }
    else PrintUsage("/ADDF nick/filter channels privileges [password]");
}

/* Adds someone on your auto-ban-kick list */
void AddAutoBanKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick=(char *) 0;
    char *tmpchan=(char *) 0;
    char *tmpshit=(char *) 0;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
    void (*func)();
    NickList *joiner;

    tmpnick=new_next_arg(args,&args);
    tmpchan=new_next_arg(args,&args);
    tmpshit=new_next_arg(args,&args);
    if (!(tmpnick && tmpshit && tmpchan)) {
        PrintUsage("/ADDBK nick/filter channels shit-level [comment]");
        return;
    }
    sprintf(tmpbuf1,"%s %s",tmpchan,args);
    if (strchr(tmpnick,'!') || strchr(tmpnick,'@') || strchr(tmpnick,'*') ||
        strchr(tmpnick,'.') || strchr(tmpnick,'?'))
        AddBK2List(tmpnick,tmpshit,tmpbuf1);
    else {
        joiner=CheckJoiners(tmpnick,NULL,from_server,NULL);
        if (joiner && joiner->userhost) {
            strcpy(tmpbuf2,joiner->userhost);
            UserDomainList(tmpbuf2);
            sprintf(tmpbuf3,"*!%s",tmpbuf2);
            AddBK2List(tmpbuf3,tmpshit,tmpbuf1);
        }
        else {
            func=(void(*)())AddBKNew;
            inFlierWI++;
            sprintf(tmpbuf1,"%s %s %s",tmpshit,tmpchan,args);
            add_to_whois_queue(tmpnick,func,"%s",tmpbuf1);
        }
    }
}

/* This adds him/her on auto (ban) kick list if he/she is not on your joinlist */
void AddBKNew(wistuff, tmpnick, text)
WhoisStuff *wistuff;
char *tmpnick;
char *text;
{
    char *tmpshit=(char *) 0;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    tmpshit=new_next_arg(text,&text);
    sprintf(tmpbuf1,"%s@%s",wistuff->user,wistuff->host);
    UserDomainList(tmpbuf1);
    sprintf(tmpbuf2,"*!%s",tmpbuf1);
    AddBK2List(tmpbuf2,tmpshit,text);
}

/* Returns integer from specified shit level */
int CheckShit(shit,buffer)
char *shit;
char *buffer;
{
    int i=0;
    char *tmpshit=(char *) 0;

    *buffer='\0';
    for (tmpshit=new_next_arg(shit,&shit);tmpshit && *tmpshit;tmpshit++) {
        switch (*tmpshit) {
            case 'k':
            case 'K':
                i|=1;
                strcat(buffer,"KICK ");
                break;
            case 'b':
            case 'B':
                i|=2;
                strcat(buffer,"BAN ");
                break;
            case 'i':
            case 'I':
                i|=4;
                strcat(buffer,"IGNORE ");
                break;
            case 'p':
            case 'P':
                i|=8;
                strcat(buffer,"PERMBAN ");
                break;
            case 'd':
            case 'D':
                i|=16;
                strcat(buffer,"DEOP ");
                break;
        }
    }
    return(i);
}

/* This really adds user to shitlist */
void AddBK2List(userhost,shit,reason)
char *userhost;
char *shit;
char *reason;
{
    int i=0;
    char *tmpchan=(char *) 0;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    NickList *tmp;
    ChannelList *chan;
    struct autobankicks *tmpabk;

    tmpchan=new_next_arg(reason,&reason);
    i=CheckShit(shit,tmpbuf2);
    if (i) {
        if (!(tmpabk=CheckABKs(userhost,tmpchan))) {
            tmpabk=(struct autobankicks *) new_malloc(sizeof(struct autobankicks));
            tmpabk->userhost=(char *) 0;
            tmpabk->channels=(char *) 0;
            tmpabk->reason=(char *) 0;
            tmpabk->next=NULL;
            add_to_list_ext((List **) &abklist,(List *) tmpabk,
                            (int (*) _((List *, List *))) AddLast);
        }
        for (chan=server_list[curr_scr_win->server].chan_list;chan;chan=chan->next)
            if (CheckChannel(chan->channel,tmpchan)) {
                for (tmp=chan->nicks;tmp;tmp=tmp->next) {
                    if (tmp->userhost) sprintf(tmpbuf1,"%s!%s",tmp->nick,tmp->userhost);
                    else strcpy(tmpbuf1,tmp->nick);
                    if (wild_match(userhost,tmpbuf1)) tmp->shitlist=tmpabk;
                }
            }
        malloc_strcpy(&(tmpabk->userhost),userhost);
        malloc_strcpy(&(tmpabk->reason),reason);
        malloc_strcpy(&(tmpabk->channels),tmpchan);
        tmpabk->shit=i;
        synch_whowas_addshit(tmpabk);
#ifdef WANTANSI
        say("Added %s%s%s to your shit list",
            CmdsColors[COLSETTING].color4,userhost,Colors[COLOFF]);
        say("with shit type %s%s%son channels %s%s%s",
            CmdsColors[COLSETTING].color2,tmpbuf2,Colors[COLOFF],
            CmdsColors[COLSETTING].color5,tmpchan,Colors[COLOFF]);
#else
        say("Added %s to your shit list",userhost);
        say("with shit type %son channels %s",tmpbuf2,tmpchan);
#endif
    }
    else PrintUsage("/ADDBK nick/filter channels shit-level [comment]");
}

/* Show bans on current or specified channel */
void ShowBans(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  count=0;
    char *channel=(char *) 0;
    char tmpbuf[mybufsize/4];
    ChannelList *chan;
    struct bans *tmpban;

    if (args && *args) {
        channel=new_next_arg(args,&args);
        if (!is_channel(channel)) sprintf(tmpbuf,"#%s",channel);
        else strcpy(tmpbuf,channel);
        channel=tmpbuf;
    }
    else if ((channel=get_channel_by_refnum(0))==NULL) {
        NoWindowChannel();
        return;
    }
    chan=lookup_channel(channel,from_server,0);
    if (chan) {
        for (tmpban=chan->banlist;tmpban;tmpban=tmpban->next) {
            if (tmpban->who && tmpban->when)
                say("%s %s by %s on %.19s",chan->channel,tmpban->ban,tmpban->who,
                    ctime(&(tmpban->when)));
            else say("%s %s",chan->channel,tmpban->ban);
            count++;
        }
        if (!count) say("There are no bans on channel %s",channel);
    }
    else {
        unban=1;
        send_to_server("MODE %s b",channel);
    }
}

/* Removes friend from your friends list */
void RemoveFriend(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick=(char *) 0;
    char tmpbuf[mybufsize/4];
    void (*func)();
    NickList *joiner;

    if (!(*args)) PrintUsage("/REMF nick/filter");
    else {
        tmpnick=new_next_arg(args,&args);
        if (*tmpnick=='#'       || strchr(tmpnick,'!') || strchr(tmpnick,'@') ||
            strchr(tmpnick,'*') || strchr(tmpnick,'.') || strchr(tmpnick,'?'))
            RemoveFriendFromList(tmpnick);
        else {
            joiner=CheckJoiners(tmpnick,NULL,from_server,NULL);
            if (joiner && joiner->userhost) {
                sprintf(tmpbuf,"%s!%s",joiner->nick,joiner->userhost);
                RemoveFriendFromList(tmpbuf);
                return;
            }
            func=(void(*)())RemoveFriendNew;
            inFlierWI++;
            add_userhost_to_whois(tmpnick,func);
        }
    }
}

/* Removes friend from your friends list if he/she is not on joinlist */
void RemoveFriendNew(wistuff, tmpnick)
WhoisStuff *wistuff;
char *tmpnick;
{
    char tmpbuf[mybufsize/4];

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    sprintf(tmpbuf,"%s!%s@%s",wistuff->nick,wistuff->user,wistuff->host);
    RemoveFriendFromList(tmpbuf);
}

/* This really removes him/her from your friends list */
void RemoveFriendFromList(userhost)
char *userhost;
{
    int  found=0;
    int  filter;
    int  count=0;
    char tmpbuf[mybufsize/4];
    struct friends *tmpfriend;
    struct friends *tmpfriend1;
    struct friends *tmpfriend2;
    NickList *tmp;
    ChannelList *tmpchan;

    filter=*userhost=='#';
    tmpfriend2=frlist;
    tmpfriend=frlist;
    while (tmpfriend2) {
        count++;
        if ((filter && matchmcommand(&userhost[1],count)) ||
            wild_match(tmpfriend2->userhost,userhost) ||
            wild_match(userhost,tmpfriend2->userhost)) {
#ifdef WANTANSI
            say("%s%s%s removed from your friends list",
                CmdsColors[COLSETTING].color4,tmpfriend2->userhost,Colors[COLOFF]);
#else
            say("%s removed from your friends list",tmpfriend2->userhost);
#endif
            found=1;
            if (tmpfriend2==frlist) frlist=tmpfriend2->next;
            else tmpfriend->next=tmpfriend2->next;
            tmpfriend1=tmpfriend2;
            tmpfriend2=tmpfriend2->next;
            for (tmpchan=server_list[curr_scr_win->server].chan_list;tmpchan;
                 tmpchan=tmpchan->next)
                if (CheckChannel(tmpchan->channel,tmpfriend1->channels)) {
                    for (tmp=tmpchan->nicks;tmp;tmp=tmp->next) {
                        if (tmp->userhost) sprintf(tmpbuf,"%s!%s",tmp->nick,tmp->userhost);
                        else strcpy(tmpbuf,tmp->nick);
                        if (wild_match(tmpfriend1->userhost,tmpbuf)) tmp->frlist=NULL;
                    }
                }
            synch_whowas_unuser(tmpfriend1);
            new_free(&(tmpfriend1->userhost));
            new_free(&(tmpfriend1->channels));
            new_free(&tmpfriend1);
        }
        else {
            tmpfriend=tmpfriend2;
            tmpfriend2=tmpfriend2->next;
        }
    }
    if (!found) say("No friend list entries matched %s",userhost);
    else {
        for (tmpfriend=frlist,count=1;tmpfriend;tmpfriend=tmpfriend->next)
            tmpfriend->number=count++;
    }
}

/* Removes user from your auto (ban) kick list */
void RemoveAutoBanKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick=(char *) 0;
    char tmpbuf[mybufsize/4];
    void (*func)();
    NickList *joiner;

    if (!(*args)) PrintUsage("/REMBK nick/filter");
    else {
        tmpnick=new_next_arg(args,&args);
        if (*tmpnick=='#'       || strchr(tmpnick,'!') || strchr(tmpnick,'@') ||
            strchr(tmpnick,'*') || strchr(tmpnick,'.') || strchr(tmpnick,'?'))
            RemoveAutoBanKickFromList(tmpnick);
        else {
            joiner=CheckJoiners(tmpnick,NULL,from_server,NULL);
            if (joiner && joiner->userhost) {
                sprintf(tmpbuf,"%s!%s",joiner->nick,joiner->userhost);
                RemoveAutoBanKickFromList(tmpbuf);
                return;
            }
            func=(void(*)())RemoveAutoBanKickNew;
            inFlierWI++;
            add_userhost_to_whois(tmpnick,func);
        }
    }
}

/* Removes user from your auto (ban) kick list if he/she is not on joinlist */
void RemoveAutoBanKickNew(wistuff, tmpnick)
WhoisStuff *wistuff;
char *tmpnick;
{
    char tmpbuf[mybufsize/4];

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    sprintf(tmpbuf,"%s!%s@%s",wistuff->nick,wistuff->user,wistuff->host);
    RemoveAutoBanKickFromList(tmpbuf);
}

/* This really removes him/her from your auto (ban) kick list */
void RemoveAutoBanKickFromList(userhost)
char *userhost;
{
    int found=0;
    int count=0;
    int filter;
    char tmpbuf[mybufsize/4];
    struct autobankicks *tmpabk;
    struct autobankicks *tmpabk1;
    struct autobankicks *tmpabk2;
    ChannelList *tmpchan;
    NickList    *tmp;

    filter=*userhost=='#';
    tmpabk2=abklist;
    tmpabk=abklist;
    while (tmpabk2) {
        count++;
        if ((filter && matchmcommand(&userhost[1],count)) ||
            wild_match(tmpabk2->userhost,userhost) ||
            wild_match(userhost,tmpabk2->userhost)) {
#ifdef WANTANSI
            say("%s%s%s removed from your shit list",
                CmdsColors[COLSETTING].color4,tmpabk2->userhost,Colors[COLOFF]);
#else
            say("%s removed from your shit list",tmpabk2->userhost);
#endif
            found=1;
            if (tmpabk2==abklist) abklist=tmpabk2->next;
            else tmpabk->next=tmpabk2->next;
            tmpabk1=tmpabk2;
            tmpabk2=tmpabk2->next;
            for (tmpchan=server_list[curr_scr_win->server].chan_list;tmpchan;
                 tmpchan=tmpchan->next)
                if (CheckChannel(tmpchan->channel,tmpabk1->channels)) {
                    for (tmp=tmpchan->nicks;tmp;tmp=tmp->next) {
                        if (tmp->userhost) sprintf(tmpbuf,"%s!%s",tmp->nick,tmp->userhost);
                        else strcpy(tmpbuf,tmp->nick);
                        if (wild_match(tmpabk1->userhost,tmpbuf)) tmp->shitlist=NULL;
                    }
                }
            synch_whowas_unshit(tmpabk1);
            new_free(&(tmpabk1->userhost));
            new_free(&(tmpabk1->channels));
            new_free(&(tmpabk1->reason));
            new_free(&tmpabk1);
        }
        else {
            tmpabk=tmpabk2;
            tmpabk2=tmpabk2->next;
        }
    }
    if (!found) say("No shit list entries matched %s",userhost);
}

/* Does /CTCP nick VERSION */
void Version(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *target=NULL;

    if (args && *args && *args!='*') target=args;
    if (!target && !(target=get_channel_by_refnum(0))) {
        NoWindowChannel();
        return;
    }
    send_to_server("PRIVMSG %s :%cVERSION%c",target,CTCP_DELIM_CHAR,CTCP_DELIM_CHAR);
}

/* Unbans nick */
void Unban(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    void (*func)();
    char *tmpnick=(char *) 0;
    char *channel;
    char tmpbuf[mybufsize/4];
    NickList *joiner;

    if (*args) {
        channel=get_channel_by_refnum(0);
        if (channel) {
            if (is_chanop(channel,get_server_nickname(from_server))) {
                tmpnick=new_next_arg(args,&args);
                if (strchr(tmpnick,'!') || strchr(tmpnick,'@') || strchr(tmpnick,'?') ||
                    strchr(tmpnick,'*') || strchr(tmpnick,'.')) {
                    UnbanIt(tmpnick,channel,from_server);
                    return;
                }
                joiner=CheckJoiners(tmpnick,NULL,from_server,NULL);
                if (joiner) {
                    sprintf(tmpbuf,"%s!%s",joiner->nick,joiner->userhost);
                    UnbanIt(tmpbuf,channel,from_server);
                    return;
                }
                func=(void(*)())UnbanNew;
                inFlierWI++;
                add_to_whois_queue(tmpnick,func,"%s",channel);
            }
            else NotChanOp(channel);
        }
        else NoWindowChannel();
    }
    else PrintUsage("/UNBAN nick");
}

/* Unbans user who's not on your join list */
void UnbanNew(wistuff,tmpnick,channel)
WhoisStuff *wistuff;
char *tmpnick;
char *channel;
{
    char tmpbuf[mybufsize/4];

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    sprintf(tmpbuf,"%s!%s@%s",wistuff->nick,wistuff->user,wistuff->host);
    UnbanIt(tmpbuf,channel,from_server);
}

/* Handles bans */
void OnBans(args)
char **args;
{
    char *chan;
    char *daban;
    char *who;
    time_t when;
    int  server;

    if (unban>=2) {
        chan=*args;
        args++;
        daban=*args;
        args++;
        server=from_server;
        if (*args) {
            who=*args;
            args++;
            when=atoi(*args);
            AddBan(daban,chan,server,who,when,NULL);
        }
        else AddBan(daban,chan,server,NULL,time((time_t *) 0),NULL);
    }
    else if (unban==1) {  /* show bans */
        chan=*args;
        args++;
        daban=*args;
        args++;
        if (*args) {
            who=*args;
            args++;
            when=atoi(*args);
            say("%s %s by %s on %.19s",chan,daban,who,ctime(&when));
        }
        else say("%s %s",chan,daban);
    }
}

/* Clears channel of bans */
void CdBan(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  count=0;
    int  send=0;
    int  max=get_int_var(MAX_MODES_VAR);
    char *tmpchan=(char *) 0;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
    ChannelList *chan;
    struct bans *tmpban;

    if (*args) {
        tmpchan=new_next_arg(args,&args);
        if (is_channel(tmpchan)) strcpy(tmpbuf3,tmpchan);
        else sprintf(tmpbuf3,"#%s",tmpchan);
        tmpchan=tmpbuf3;
    }
    else if ((tmpchan=get_channel_by_refnum(0))==NULL) {
        NoWindowChannel();
        return;
    }
    chan=lookup_channel(tmpchan,from_server,0);
    if (!chan) return;
    if ((chan->status)&CHAN_CHOP) {
        *tmpbuf1='\0';
        *tmpbuf2='\0';
        sprintf(tmpbuf2,"MODE %s ",chan->channel);
        for (tmpban=chan->banlist;tmpban;tmpban=tmpban->next) {
            strcat(tmpbuf2," -b ");
            strcat(tmpbuf2,tmpban->ban);
            count++;
            send=1;
            if (count==max) {
                strcat(tmpbuf1,tmpbuf2);
                strcat(tmpbuf1,"\r\n");
                sprintf(tmpbuf2,"MODE %s ",chan->channel);
                count=0;
            }
            if (strlen(tmpbuf1)>=IRCD_BUFFER_SIZE-150) {
                send_to_server("%s",tmpbuf1);
                *tmpbuf1='\0';
                send=0;
            }
        }
        if (count) {
            strcat(tmpbuf1,tmpbuf2);
            strcat(tmpbuf1,"\r\n");
            send=1;
        }
        if (send) send_to_server("%s",tmpbuf1);
    }
    else NotChanOp(tmpchan);
}

/* Unignores user */
void NoIgnore(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *tmpnick=(char *) 0;
    char tmpbuf[mybufsize/4];

    if (*args) {
        tmpnick=new_next_arg(args,&args);
        sprintf(tmpbuf,"%s NONE",tmpnick);
        ignore(NULL,tmpbuf,NULL);
    }
    else PrintUsage("/NOIG nick");
}

/* Ignores user */
void Ignore(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  igtime=0;
    char *tmpstr;
    char *timestr;
    char *tmpnick;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    char tmpbuf3[mybufsize/4];
    void (*func)();
    NickList *joiner;

    if (*args) {
        tmpstr=new_next_arg(args,&args);
        if (!my_stricmp(tmpstr,"-t")) {
            timestr=new_next_arg(args,&args);
            tmpnick=new_next_arg(args,&args);
            if (!(timestr && *timestr) || !(tmpnick && *tmpnick)) {
                PrintUsage("/IG [-t time] nick [type]  default type is ALL");
                return;
            }
            igtime=atoi(timestr);
        }
        else tmpnick=tmpstr;
        if (!(args && *args)) args="ALL";
        if (!igtime) igtime=subargs?ShitIgnoreTime:IgnoreTime;
        sprintf(tmpbuf3,"%d",igtime);
        if (strchr(tmpnick,'@') || strchr(tmpnick,'?') ||
            strchr(tmpnick,'*') || strchr(tmpnick,'.')) {
            sprintf(tmpbuf1,"%s %s",tmpnick,args);
            ignore(NULL,tmpbuf1,tmpbuf3);
            sprintf(tmpbuf1,"%d IGNORE %s NONE",igtime,tmpnick);
            timercmd("TIMER",tmpbuf1,NULL);
            return;
        }
        joiner=CheckJoiners(tmpnick,NULL,from_server,NULL);
        if (joiner) {
            strcpy(tmpbuf2,joiner->userhost);
            UserDomainList(tmpbuf2);
            sprintf(tmpbuf1,"%s %s",tmpbuf2,args);
            ignore(NULL,tmpbuf1,tmpbuf3);
            sprintf(tmpbuf1,"%d IGNORE %s NONE",igtime,tmpbuf2);
            timercmd("TIMER",tmpbuf1,NULL);
            return;
        }
        func=(void(*)())IgnoreNew;
        inFlierWI++;
        add_to_whois_queue(tmpnick,func,"%d %s",igtime,args);
    }
    else PrintUsage("/IG [-t time] nick [type]  default type is ALL");
}

/* Ignores user who's not on your join list */
void IgnoreNew(wistuff,tmpnick,igtype)
WhoisStuff *wistuff;
char *tmpnick;
char *igtype;
{
    char *tmpstr;
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];

    if (inFlierWI) inFlierWI--;
    if (wistuff->not_on || !wistuff->nick || my_stricmp(wistuff->nick,tmpnick)) {
        say("Can't find %s on IRC",tmpnick);
        return;
    }
    sprintf(tmpbuf2,"%s@%s",wistuff->user,wistuff->host);
    UserDomainList(tmpbuf2);
    tmpstr=new_next_arg(igtype,&igtype);
    sprintf(tmpbuf1,"%s %s",tmpbuf2,igtype);
    ignore(NULL,tmpbuf1,tmpstr);
    sprintf(tmpbuf1,"%s IGNORE %s NONE",tmpstr,tmpbuf2);
    timercmd("TIMER",tmpbuf1,NULL);
}

/* Returns formatted time */
static char *ToolieTimeFormat(timediff)
time_t timediff;
{
    int timesec=0;
    int timemin=0;
    int timehour=0;
    int timeday=0;

    if (timediff>60) {
        timemin=timediff/60;
        timesec=timediff%60;
        sprintf(timereturn,"%dm%ds",timemin,timesec);
    }
    else sprintf(timereturn,"%lds",timediff);
    if (timemin>60) {
        timehour=timemin/60;
        timemin=timemin%60;
        sprintf(timereturn,"%dh%dm%ds",timehour,timemin,timesec);
    }
    if (timehour>24) {
        timeday=timehour/24;
        timehour=timehour%24;
        sprintf(timereturn,"%dd%dh%dm%ds",timeday,timehour,timemin,timesec);
    }
    return(timereturn);
}

#ifdef TOOLIE
/* Sets away with toolie idle timer, also updates timer */
void ToolieAway() {
    char tmpbuf[mybufsize/4];
    time_t timediff;

    timediff=time((time_t *) 0)-ToolieAwayTime;
    sprintf(tmpbuf,"-ALL %s %c%s%c [SZ%con%c:%c%s%c] ",ToolieA,bold,toolieawaystr,
            bold,bold,bold,bold,ToolieTimeFormat(timediff),bold);
    away("AWAY",tmpbuf,NULL);
}
#endif

/* Marks you as being away */
void SetAway(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  oldserver;
    char *filepath;
    char *awaystr;
    char tmpbuf[mybufsize/4];
    FILE *awayfile;
#if !defined(TOOLIE) || defined(VILAS)
    time_t timenow=time((time_t *) 0);
#endif /* TOOLIE */
    ChannelList *tmpchan;

    if (args && *args) awaystr=args;
    else awaystr=DefaultSetAway;
#if defined(VILAS)
    sprintf(tmpbuf,"-ALL %c%s%c  Away since %.16s",bold,awaystr,bold,ctime(&timenow));
    away("AWAY",tmpbuf,NULL);
#elif defined(TOOLIE)
    malloc_strcpy(&toolieawaystr,awaystr);
    ToolieAwayTime=time((time_t *) 0);
    SentAway=0;
    ToolieAway();
#else  /* TOOLIE */
    sprintf(tmpbuf,"-ALL %c%s%c [SZ%con%c]  Away since %.16s",bold,awaystr,bold,
            bold,bold,ctime(&timenow));
    away("AWAY",tmpbuf,NULL);
#endif /* VILAS */
    oldserver=from_server;
    for (tmpchan=server_list[curr_scr_win->server].chan_list;tmpchan;
         tmpchan=tmpchan->next) {
        from_server=tmpchan->server;
        if (tmpchan->ShowAway && tmpchan->channel) {
#if defined(VILAS)
            sprintf(tmpbuf,"%s is away. %c%s%c",tmpchan->channel,bold,awaystr,bold);
#elif defined(TOOLIE)
            sprintf(tmpbuf,"%s is away. %s %c%s%c [SZ%con%c]",tmpchan->channel,ToolieA,
                    bold,toolieawaystr,bold,bold,bold);
#else  /* TOOLIE */
            sprintf(tmpbuf,"%s is away. %c%s%c [SZ%con%c]",tmpchan->channel,bold,
                    awaystr,bold,bold,bold);
#endif /* VILAS */
            describe(NULL,tmpbuf,NULL);
        }
        from_server=oldserver;
    }
    from_server=oldserver;
    filepath=OpenCreateFile("ScrollZ.away",1);
    if ((awayfile=fopen(filepath,"a"))==NULL) say("Can't open file ScrollZ.away");
    else {
        fclose(awayfile);
        AwaySave("SetAway",0);
        update_all_status();
    }
}

/* Marks you as not being away */
void SetBack(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    AwaySave("SetBack",0);
    add_wait_prompt("Display message file (y/n/r) ? ",SetBack2,args,WAIT_PROMPT_KEY);
}

/* Handles prompt from SetBack */
void SetBack2(stuff,line)
char *stuff;
char *line;
{
    if (line && (*line=='y' || *line=='Y' || *line=='r' || *line=='R')) PlayBack(NULL,line,stuff);
    else add_wait_prompt("Delete message file (y/n) ? ",SetBackDelete,stuff,WAIT_PROMPT_KEY);
}

/* This asks user if he wants to delete ScrollZ.away file */
void SetBackDelete(stuff,line)
char *stuff;
char *line;
{
    int  oldserver;
    int  done;
    char *filepath;
    char *backstr;
    char tmpbuf[mybufsize/4];
    ChannelList *tmpchan;

    if (line && (*line=='y' || *line=='Y')) {
        filepath=OpenCreateFile("ScrollZ.away",1);
        done=remove(filepath);
        if (done==0) say("File ScrollZ.away has been deleted");
        else say("Can't delete file ScrollZ.away");
        AwayMsgNum=0;
        update_all_status();
    }
    if (!stuff) return;
    strcpy(tmpbuf,"-ALL");
    away("AWAY",tmpbuf,NULL);
#ifdef TOOLIE
    new_free(&toolieawaystr);
#endif
    if (*stuff) backstr=stuff;
    else backstr=DefaultSetBack;
    oldserver=from_server;
    for (tmpchan=server_list[curr_scr_win->server].chan_list;tmpchan;
         tmpchan=tmpchan->next) {
        from_server=tmpchan->server;
        if (tmpchan->ShowAway && tmpchan->channel) {
#if defined(VILAS)
            sprintf(tmpbuf,"%s is back. %c%s%c",tmpchan->channel,bold,backstr,bold);
#else
            sprintf(tmpbuf,"%s is back. %c%s%c [SZ%coff%c]",tmpchan->channel,bold,
                    backstr,bold,bold,bold);
#endif
            describe(NULL,tmpbuf,NULL);
        }
        from_server=oldserver;
    }
    from_server=oldserver;
}

/* Handles WHO reply */
void OnWho(nick,user,host,channel,stat)
char *nick;
char *user;
char *host;
char *channel;
char *stat;
{
    char tmpbuf1[mybufsize/4];
    char tmpbuf2[mybufsize/4];
    NickList *tmp,*last=NULL;
    WhowasList *whowas;
    ChannelList *chan;

    if ((chan=lookup_channel(channel,parsing_server_index,0))) {
        for (tmp=chan->nicks;tmp;tmp=tmp->next) {
            if (!my_stricmp(tmp->nick,nick)) break;
            last=tmp;
        }
        if (tmp) {
            sprintf(tmpbuf1,"%s@%s",user,host);
            if ((whowas=check_whowas_buffer(nick,tmpbuf1,channel,1))) {
                remove_nick_from_hash(chan,tmp);
                if (last) last->next=whowas->nicklist;
                else chan->nicks=whowas->nicklist;
                last=whowas->nicklist;
                last->next=tmp->next;
                last->chanop=tmp->chanop;
                last->voice=tmp->voice;
                last->curo=tmp->curo;
                last->curk=tmp->curk;
                last->curn=tmp->curn;
                last->deopt=tmp->deopt;
                last->kickt=tmp->kickt;
                last->nickt=tmp->nickt;
                last->deopp=tmp->deopp;
                last->kickp=tmp->kickp;
                last->nickp=tmp->nickp;
                last->minuso+=tmp->minuso;
                last->pluso+=tmp->pluso;
                last->minusb+=tmp->minusb;
                last->plusb+=tmp->plusb;
                last->kick+=tmp->kick;
                last->nickc+=tmp->nickc;
                last->publics+=tmp->publics;
                malloc_strcpy(&(last->nick),nick);
                new_free(&(tmp->nick));
                new_free(&(tmp->userhost));
                new_free(&tmp);
                new_free(&whowas);
                add_nick_to_hash(chan,last);
            }
            else {
                malloc_strcpy(&(tmp->userhost),tmpbuf1);
                sprintf(tmpbuf2,"%s!%s",nick,tmpbuf1);
                tmp->frlist=(struct friends *) FindMatch(tmpbuf2,channel);
                tmp->shitlist=(struct autobankicks *) FindShit(tmpbuf2,channel);
            }
        }
    }
}

/* Compare function for list.c */
int AddLast(element,toadd)
List *element;
List *toadd;
{
    return(0);
}

/* Adds word to your wordkick list */
void AddWord(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  add=0;
    char *tmpstr;
    char *channels;
    char tmpbuf[mybufsize/4];
    struct words *tmpword;

    channels=new_next_arg(args,&args);
    tmpstr=new_next_arg(args,&args);
    if (channels && tmpstr) {
        tmpword=CheckLine(channels,tmpstr);
        if (!tmpword) {
            tmpword=(struct words *) new_malloc(sizeof(struct words));
            tmpword->channels=(char *) 0;
            tmpword->word=(char *) 0;
            tmpword->reason=(char *) 0;
            tmpword->next=(struct words *) 0;
            add=1;
        }
        if (tmpword) {
            sprintf(tmpbuf,"*%s*",tmpstr);
            malloc_strcpy(&(tmpword->channels),channels);
            malloc_strcpy(&(tmpword->word),tmpbuf);
            while (*args && isspace(*args)) args++;
            if (*args) malloc_strcpy(&(tmpword->reason),args);
            else {
                sprintf(tmpbuf,"You said %s",tmpstr);
                malloc_strcpy(&(tmpword->reason),tmpbuf);
            }
            if (add) add_to_list_ext((List **) &wordlist,(List *) tmpword,
                                     (int (*) _((List *, List *))) AddLast);
            say("%s added to your wordkick list for %s",tmpword->word,tmpword->channels);
        }
    }
    else PrintUsage("/ADDW channels word [comment]");
}

/* Removes word from your wordkick list */
void RemoveWord(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channels;
    char *tmpstr;
    struct words *tmp=NULL;
    struct words *tmpword;

    channels=new_next_arg(args,&args);
    tmpstr=new_next_arg(args,&args);
    if (channels && tmpstr) {
        for (tmpword=wordlist;tmpword;tmpword=tmpword->next) {
            if (CheckChannel(tmpword->channels,channels) &&
                (wild_match(tmpword->word,tmpstr) || wild_match(tmpstr,tmpword->word)))
                break;
            tmp=tmpword;
        }
        if (tmpword) {
            say("%s removed from your wordkick list for %s",tmpword->word,
                tmpword->channels);
            if (tmp) tmp->next=tmpword->next;
            else wordlist=tmpword->next;
            new_free(&(tmpword->channels));
            new_free(&(tmpword->word));
            new_free(&(tmpword->reason));
            new_free(&tmpword);
        }
        else say("%s is not on your wordkick list for %s",tmpstr,channels);
    }
    else PrintUsage("/REMW channels word");
}

/* Lists all the word on your wordkick list */
void ListWords(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int count=1;
    struct words *tmpword;

    say("#   Channels        Filter                Reason");
    for (tmpword=wordlist;tmpword;tmpword=tmpword->next,count++)
        say("#%-2d %-15s %-20s  %s",count,tmpword->channels,tmpword->word,
            tmpword->reason);
    say("Total of %d words on your wordkick list",count-1);
}

/* Checks if there is a match with some of your words that are on wordkick list */
struct words *CheckLine(channels,line)
char *channels;
char *line;
{
    register struct words *tmpword;

    for (tmpword=wordlist;tmpword;tmpword=tmpword->next)
        if (CheckChannel(tmpword->channels,channels) && wild_match(tmpword->word,line))
            return(tmpword);
    return((struct words *) 0);
}

/* Adds nick to list of people who have messaged you */
void AddNick2List(nick)
char *nick;
{
    int count;
    struct nicks *nickstr=nicklist;
    struct nicks *nicktmp;

    nickstr=(struct nicks *) list_lookup((List **) &nicklist,nick,!USE_WILDCARDS,
                                         REMOVE_FROM_LIST);
    if (nickstr) {
        new_free(&(nickstr->nick));
        new_free(&nickstr);
    }
    if ((nickstr=(struct nicks *) new_malloc(sizeof(struct nicks)))) {
        nickstr->nick=(char *) 0;
        malloc_strcpy(&(nickstr->nick),nick);
        nickstr->next=nicklist;
        nicklist=nickstr;
        for (nickstr=nicklist,count=1;nickstr && count<10;nickstr=nickstr->next)
            count++;
        if (count>9 && nickstr) {
            for (nicktmp=nickstr->next;nicktmp;) {
                nickstr->next=NULL;
                nickstr=nicktmp;
                nicktmp=nicktmp->next;
                new_free(&(nickstr->nick));
                new_free(&(nickstr));
            }
        }
    }
    nickcur=nicklist;
}

/* Sets nickcur to the next element on linked list nicks (when TAB pressed) */
void NickNext()
{
    if (nickcur) nickcur=nickcur->next;
    if (!nickcur) nickcur=nicklist;
}

/* Adds splitter to list (with the appropriate server) */
int AddSplitter(nick,channel,servers)
char *nick;
char *channel;
char *servers;
{
    int    print=0;
    struct list *tmplist;
    struct wholeftstr *wholeft;
    struct wholeftch  *wholch;
    NickList *joiner;

    wholeft=(struct wholeftstr *) list_lookup((List **) &wholist,servers,!USE_WILDCARDS,
                                              !REMOVE_FROM_LIST);
    if (!wholeft) {
        wholeft=(struct wholeftstr *) new_malloc(sizeof(struct wholeftstr));
        wholeft->splitserver=(char *) 0;
        malloc_strcpy(&(wholeft->splitserver),servers);
        wholeft->time=time((time_t *) 0);
        wholeft->total=0;
        wholeft->count=0;
        wholeft->print=0;
        wholeft->channels=(struct wholeftch *) 0;
        wholeft->next=(struct wholeftstr *) 0;
        add_to_list_ext((List **) &wholist,(List *) wholeft,
                        (int (*) _((List *, List *))) AddLast);
        print=1;
    }
    wholch=(struct wholeftch *) list_lookup((List **) &(wholeft->channels),channel,
                                            !USE_WILDCARDS,!REMOVE_FROM_LIST);
    if (!wholch) {
        wholch=(struct wholeftch *) new_malloc(sizeof(struct wholeftch));
        wholch->channel=(char *) 0;
        wholch->nicklist=(struct list *) 0;
        wholch->next=(struct wholeftch *) 0;
        malloc_strcpy(&(wholch->channel),channel);
        add_to_list_ext((List **) &(wholeft->channels),(List *) wholch,
                        (int (*) _((List *, List *))) AddLast);
    }
    joiner=CheckJoiners(nick,NULL,from_server,NULL);
    if (joiner && joiner->userhost) {
        tmplist=(struct list *) new_malloc(sizeof(struct list));
        tmplist->nick=(char *) 0;
        tmplist->userhost=(char *) 0;
        tmplist->next=(struct list *) 0;
        malloc_strcpy(&(tmplist->nick),joiner->nick);
        malloc_strcpy(&(tmplist->userhost),joiner->userhost);
        add_to_list_ext((List **) &(wholch->nicklist),(List *) tmplist,
                        (int (*) _((List *, List *))) AddLast);
        wholeft->count++;
        wholeft->total++;
    }
    return(print);
}

/* Checks if net has joined and returns server name if so */
void Check4Join(userhost,servername)
char *userhost;
char *servername;
{
    struct wholeftstr *wholeft;
    struct wholeftstr *tmpwholeft;
    struct wholeftch  *wholch;
    struct wholeftch  *tmpch;
    struct list *tmpjoin;
    struct list *tmplist;

    wholeft=wholist;
    tmpwholeft=wholist;
    while (wholeft) {
        tmpch=wholeft->channels;
        wholch=wholeft->channels;
        while (wholch) {
            tmplist=wholch->nicklist;
            tmpjoin=wholch->nicklist;
            while (tmplist) {
                if (tmplist->userhost && !my_stricmp(userhost,tmplist->userhost)) {
                    wholeft->count--;
                    if (wholeft->print) strcpy(servername,"111");
                    else {
                        if ((wholeft->total<=3 && wholeft->count<=wholeft->total-1) ||
                            (wholeft->total>=4 && wholeft->total<=6 && wholeft->count<=wholeft->total-2) ||
                            (wholeft->total>=7 && wholeft->count<=(wholeft->total)/3)) {
                            strcpy(servername,wholeft->splitserver);
                            wholeft->print=1;
                        }
                        else strcpy(servername,"111");
                    }
                    if (tmplist==wholch->nicklist) wholch->nicklist=tmplist->next;
                    else tmpjoin->next=tmplist->next;
                    new_free(&(tmplist->nick));
                    new_free(&(tmplist->userhost));
                    new_free(&tmplist);
                    if (wholch->nicklist==NULL) {
                        if (wholch==wholeft->channels)
                            wholeft->channels=wholeft->channels->next;
                        else tmpch->next=wholch->next;
                        new_free(&(wholch->channel));
                        new_free(&wholch);
                    }
                    if (wholeft->channels==NULL) {
                        if (wholeft==wholist) wholist=wholist->next;
                        else tmpwholeft->next=wholeft->next;
                        new_free(&(wholeft->splitserver));
                        new_free(&wholeft);
                    }
                    return;
                }
                tmpjoin=tmplist;
                tmplist=tmplist->next;
            }
            tmpch=wholch;
            wholch=wholch->next;
        }
        tmpwholeft=wholeft;
        wholeft=wholeft->next;
    }
    strcpy(servername,"000");
}

/* Tells you all the nicks that went away with the split */
void WhoLeft(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  i;
    int  len;
    int  ctlen;
    char *tmpstr;
    char *server;
    char *leftnicks=(char *) 0;
    char tmpbuf1[mybufsize/2];
    char tmpbuf2[mybufsize/2];
    char tmpbuf3[mybufsize/2];
    char tmpbuf4[mybufsize/2];
    time_t timenow;
    struct list *tmplist;
    struct wholeftstr *wholeft;
    struct wholeftch *tmpch;

    say("Logged netsplit information");
    StripAnsi(CToolzstr,tmpbuf3,1);
    ctlen=strlen(tmpbuf3);
    timenow=time((time_t *) 0);
    for (wholeft=wholist;wholeft;wholeft=wholeft->next) {
        strcpy(tmpbuf1,wholeft->splitserver);
        tmpstr=tmpbuf1;
        server=new_next_arg(tmpstr,&tmpstr);
        strcpy(tmpbuf3,ToolieTimeFormat(timenow-wholeft->time));
#ifdef WANTANSI
        sprintf(tmpbuf2,"[%s%s%s %s<-%s %s%s%s]",
                CmdsColors[COLNETSPLIT].color3,tmpstr,Colors[COLOFF],
                CmdsColors[COLNETSPLIT].color6,Colors[COLOFF],
                CmdsColors[COLNETSPLIT].color3,server,Colors[COLOFF]);
        sprintf(tmpbuf4,": [%s%s%s]",CmdsColors[COLNETSPLIT].color2,tmpbuf3,Colors[COLOFF]);
#else
        sprintf(tmpbuf2,"[%s <- %s]",tmpstr,server);
        sprintf(tmpbuf4,": [%s]",tmpbuf3);
#endif
        len=CO-ctlen-29-strlen(server)-strlen(tmpstr)-strlen(tmpbuf3);
        *tmpbuf3='\0';
        for (i=0;len>0 && i<len;i++) strcat(tmpbuf3," ");
#ifdef WANTANSI
        say("%sChannel%s \002:\002 %sNicks%s %s%s %s",
            CmdsColors[COLNETSPLIT].color4,Colors[COLOFF],
            CmdsColors[COLNETSPLIT].color5,Colors[COLOFF],tmpbuf3,tmpbuf2,tmpbuf4);
#else
        say("Channel : Nicks %s%s %s",tmpbuf3,tmpbuf2,tmpbuf4);
#endif
        for (tmpch=wholeft->channels;tmpch;tmpch=tmpch->next) {
#ifdef WANTANSI
            sprintf(tmpbuf1,"%s%-7s%s \002:\002",
                    CmdsColors[COLNETSPLIT].color4,tmpch->channel,Colors[COLOFF]);
#else
            sprintf(tmpbuf1,"%s %-7s :",CToolzstr,tmpch->channel);
#endif
            malloc_strcpy(&leftnicks,tmpbuf1);
            for (tmplist=tmpch->nicklist;tmplist;tmplist=tmplist->next) {
#ifdef WANTANSI
                sprintf(tmpbuf1," %s%s%s",CmdsColors[COLNETSPLIT].color5,tmplist->nick,
                        Colors[COLOFF]);
#else
                sprintf(tmpbuf1," %s",tmplist->nick);
#endif
                malloc_strcat(&leftnicks,tmpbuf1);
            }
            say("%s",leftnicks);
            new_free(&leftnicks);
        }
    }
    say("End of netsplit information");
}

/* Kicks all the people that match the filter */
void FilterKick(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    char *channel;
    char *filter;
    char *mynick;
    char *comment=(char *) 0;
    char tmpbuf[mybufsize/4];
    NickList *joiner;
    ChannelList *chan;

    filter=new_next_arg(args,&args);
    if (filter) {
        channel=get_channel_by_refnum(0);
        mynick=get_server_nickname(from_server);
        if (channel) {
            chan=lookup_channel(channel,from_server,0);
            if (chan && ((chan->status)&CHAN_CHOP)) {
                if (args && *args) comment=args;
                else comment=DefaultFK;
                for (joiner=chan->nicks;joiner;joiner=joiner->next) {
                    sprintf(tmpbuf,"%s!%s",joiner->nick,joiner->userhost);
                    if ((!(joiner->chanop) || chan->KickOps) &&
                        my_stricmp(joiner->nick,mynick) && wild_match(filter,tmpbuf))
#if defined(VILAS) || defined(FET)
                        send_to_server("KICK %s %s :%s",channel,joiner->nick,comment);
#elif defined(TOOLIE)
                        send_to_server("KICK %s %s :%s %s <SZ-FK>",channel,joiner->nick,
                                       ToolieA,comment);
#else  /* TOOLIE */
                        send_to_server("KICK %s %s :<ScrollZ-FK> %s",channel,joiner->nick,
                                       comment);
#endif /* VILAS || FET */
                }
            }
            else NotChanOp(channel);
        }
        else NoWindowChannel();
    }
    else PrintUsage("/FK filter [reason]");
}

#ifdef EXTRAS
/* Bans all the people from your shitlist */
void DoBans(command,args,subargs)
char *command;
char *args;
char *subargs;
{
    int  count=0;
    int  max=get_int_var(MAX_MODES_VAR);
    char *channel=(char *) 0;
    char *banmodes=(char *) 0;
    struct autobankicks *tmpabk;

    channel=get_channel_by_refnum(0);
    if (channel) {
        if (is_chanop(channel,get_server_nickname(from_server))) {
            say("Doing bans from your shitlist");
            tmpabk=abklist;
            while (tmpabk) {
                if ((tmpabk->shit)&14 && CheckChannel(channel,tmpabk->channels)) {
                    malloc_strcat(&banmodes," +b ");
                    malloc_strcat(&banmodes,tmpabk->userhost);
                    count++;
                    if (count==max) {
                        send_to_server("MODE %s %s",channel,banmodes);
                        new_free(&banmodes);
                        count=0;
                    }
                }
                tmpabk=tmpabk->next;
            }
            if (count) {
                send_to_server("MODE %s %s",channel,banmodes);
                new_free(&banmodes);
            }
        }
        else NotChanOp(channel);
    }
    else NoWindowChannel();
}
#endif

/* This says you're not channel operator */
void NotChanOp(channel)
char *channel;
{
    say("You are not channel operator on %s",channel);
}

/* This says no current channel for this window */
void NoWindowChannel()
{
    say("No current channel for this window");
}
