;; nicelinks.scm - script for scirc
; by forcer, as an example for scirc scripting

; 364  RPL_LINKS		"<mask> <server> :<hopcount> <server info>"
; 365  RPL_ENDOFLINKS	"<mask> :End of /LINKS list"

(define nl-servers '())
(define nl-ownserver "")

(define (nl-getentry lis entry)
	(let ((value (assoc-ref lis entry)))
		(if (list? value)
			value
			'())))

(define (nl-RPL_LINKS from cmd to args)
	(define (adduplink server ulink)
		(let ((value (nl-getentry nl-servers server)))
		(set! nl-servers (assoc-set! (assoc-remove! nl-servers server) server
						 (append value (list ulink))))))
	(let* ((uplink (nextword args))
		   (server (nextword (cdr uplink))))
		(if (string=? (car uplink) (car server))
			(set! nl-ownserver (car server))
			(adduplink (car server) (car uplink)))))

(define (nl-RPL_ENDOFLINKS from cmd to args)
	(define (printtabs n)
		(display "*** ")
		(cond ((> n 0)
			(display "    ")
			(printtabs (- n 1)))))
	(let pserver ((server nl-ownserver)
				  (depth  0))
		(let ((lis (nl-getentry nl-servers server)))
			(printtabs depth)
			(display server)
			(if (> (length lis) 0)
				(display ":"))
			(newline)
			(let serv-loop ((servlis lis))
				(cond
					((null? servlis)
						#t)
					(#t
						(pserver (car servlis) (+ 1 depth))
						(serv-loop (cdr servlis)))))))
	(write-to #f "*** * :End of /LINKS list."))

(addhook 364 nl-RPL_LINKS)
(addhook 365 nl-RPL_ENDOFLINKS)
