//   $Id: kvi_usr.cpp,v 1.2 1998/09/20 20:24:21 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CLASS_NAME_ "KviUser"

#include "kvi_defs.h"
#include "kvi_macros.h"
#include "kvi_usr.h"
#include "kvi_app.h"
#include "kvi_debug.h"

#include <kconfig.h>

//============ KviUser ============//

KviUser::KviUser()
{
	_debug_entertrace("KviUser");
	readSettings();
	_debug_leavetrace("KviUser");
}

//============ ~KviUser ============//

KviUser::~KviUser()
{
	_debug_entertrace("~KviUser");
	saveSettings();
	_debug_leavetrace("~KviUser");
}

//============ readSettings ============//

void KviUser::readSettings()
{
	_debug_entertrace("readSettings");
	KConfig *lpC=_macro_kviConfig;
	lpC->setGroup("KviUser");

	szNick				=	lpC->readEntry("szNick",KVI_DEFAULT_NICK);
	szAltNick			=	lpC->readEntry("szAltNick",KVI_DEFAULT_ALT_NICK);
	szRealName			=	lpC->readEntry("szRealName",KVI_DEFAULT_REAL_NAME);
	szUserName			=	lpC->readEntry("szUserName",KVI_DEFAULT_USER_NAME);
	
	bool_wallops		=	lpC->readNumEntry("bool_wallops",false);
	bool_invisible		=	lpC->readNumEntry("bool_invisible",true);
	bool_servernotices	=	lpC->readNumEntry("bool_servernotices",false);

	_debug_leavetrace("readSettings");
}

//============ saveSettings ============//

void KviUser::saveSettings()
{
	_debug_entertrace("saveSettings");
	KConfig *lpC=_macro_kviConfig;
	lpC->setGroup("KviUser");

	lpC->writeEntry("szNick",szNick);
	lpC->writeEntry("szAltNick",szAltNick);
	lpC->writeEntry("szRealName",szRealName);
	lpC->writeEntry("szUserName",szUserName);
	lpC->writeEntry("bool_wallops",bool_wallops);
	lpC->writeEntry("bool_invisible",bool_invisible);
	lpC->writeEntry("bool_servernotices",bool_servernotices);

	lpC->sync();
	_debug_leavetrace("saveSettings");
}


