//   $Id: kvi_uparser.h,v 1.5 1998/10/06 14:42:55 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_UPARSER_H_INCLUDED_
#define _KVI_UPARSER_H_INCLUDED_

#include "kvi_types.h"

#include <qlist.h>

#define KVI_EventErr_Success 0
#define KVI_EventErr_Error (-1)
#define KVI_EventErr_Halt 1

class KviMdiChild;
class KviIdentifiers;
class KviProcessManager;
class KviTimerManager;
class KviFileManager;
class KviCache;
class KviHelp;
class KviFrame;
class KviIrcSocket;
class KviStatusWnd;
class KviAliasManager;
class KviMdiManager;
class KviGlobals;
class KviOptions;

class KviUserParser{
public:
	KviUserParser();
	~KviUserParser();
	static parseCmdTable cmdTab[];
	static const char *  errTab[];
	static const char *  fncTab[];

public:
	KviFrame			*m_lpFrm;
	KviIrcSocket		*m_lpSock;
	KviStatusWnd		*m_lpCons;
	KviMdiManager		*m_lpMdi;
	KviGlobals			*m_lpGlb;
	KviOptions			*m_lpOpt;
	KviAliasManager		*m_lpAliasManager;
	KviIdentifiers		*m_lpIdentifiers;
	KviProcessManager   *m_lpProcessManager;
	KviHelp				*m_lpHelp;
	QString				m_szLastDCCTarget;
	QString				m_szLastQueryTarget;
	QString				m_szLastSendTarget;
	KviTimerManager     *m_lpTimerManager;
	QList<KviVariable>	*m_lpVarList;
	QList<KviAliasStruct> *m_lpAliasList;
	KviCache            *m_lpCache;
	KviFileManager      *m_lpFileManager;
public:
	void activate(KviFrame *lpFrame);
	void parseUserInput(KviMdiChild *lpC,int winType,const char *winName,QString &szData);
	int parseUserCommand(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseCommand(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseBlock(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);

	int parseJoin(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parsePart(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseChat(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseQuery(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseRaw(      KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseNick(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseWhois(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseSet(      KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseUnset(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseEcho(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseTopic(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseMode(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseOp(       KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseDeop(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseBan(      KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseUnban(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseVoice(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseDevoice(  KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseKick(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseSay(      KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseCtcp(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseIf(       KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseHelp(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseSend(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseKban(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseWhowas(   KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseUserlist( KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseClonescan(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseMe(       KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseTimer(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseRun(      KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseExec(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseKillproc( KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseWriteproc(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseProclist( KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseWhile(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parsePlay(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseHalt(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseServer(   KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseNotice(   KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseAway(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseBack(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseWindow(   KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseForeach(  KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseDns(      KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseAscii(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseCache(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseReturn(   KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseInc(      KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseDec(      KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseSound(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseFile(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseAlias(    KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseKvidebug( KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseTalk(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseList(     KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);
	int parseConnstats(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP);

	int evaluateBoolean(KviMdiChild *lpC,const char **pC,bool *bResult,KviAliasParams *pP,bool hadBrace);

	int executeEvent(KviMdiChild *lpC,KviEventStruct *lpE,QString &szParams);
	int executePopup(KviMdiChild *lpC,QString &szAction);
	void addVariable(KviVariable *lpV);

	int executeAlias(KviMdiChild *lpC,KviAliasStruct *lpA,QString &szParams,KviAliasParams *pExtParams=0);
	int executeMode(QString &szChan,QString &szTrg,bool bPlus,char chMode);

	void handleError(KviMdiChild *lpC,int numErr,const char *pC);
};

#endif //_KVI_UPARSER_H_INCLUDED_
