//   $Id: kvi_uparser.cpp,v 1.7 1998/10/06 14:42:50 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviUserParser"

#include "kvi_app.h"
#include "kvi_macros.h"
#include "kvi_uparser.h"
#include "kvi_ascii.h"
#include "kvi_dns.h"
#include "kvi_cache.h"
#include "kvi_token.h"
#include "kvi_file.h"
#include "kvi_ident.h"
#include "kvi_timer.h"
#include "kvi_help.h"
#include "kvi_proc.h"
#include "kvi_frame.h"
#include "kvi_alias.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_opt.h"
#include "kvi_socket.h"
#include "kvi_global.h"
#include "kvi_chat.h"
#include "kvi_event.h"
#include "kvi_status.h"
#include "kvi_mdi.h"
#include "kvi_query.h"
#include "kvi_send.h"
#include "kvi_nick.h"
#include "kvi_chan.h"
#include "kvi_audio.h"
#include "kvi_userwnd.h"
#include "kvi_view.h"
#include "kvi_uglobal.h"
#include "kvi_listbox.h"
#include "kvi_voice.h"

//#include <kfiledialog.h>
#include <kmsgbox.h>

//skipUpToEnd had NOT '\n' before
#define _macro_skipSpacesAndTabs(_chptr) while((*_chptr) && ((*_chptr==' ')||(*_chptr=='\t')) )_chptr++
#define _macro_skipSenselessChars(_chptr) while((*_chptr) && ((*_chptr==' ')||(*_chptr=='\n')||(*_chptr=='\t')) )_chptr++
#define _macro_skipUpToEndOfCmd(_chptr) while((*_chptr) && (*_chptr!=';') && (*_chptr!=KVI_CHAR_END) && (*_chptr!='\n'))_chptr++
#define _macro_getCommandParameters(__str,__lPtr,__rPtr,__pWnd,__pPar) QString __str(__lPtr,(__rPtr-__lPtr)+1); \
							m_lpIdentifiers->substitute(__pWnd,__str,__pPar);__str=__str.stripWhiteSpace()

#define _KVI_ERR_Success                0 /* Success                                 */
#define _KVI_ERR_NoPointer              1 /* NULL Pointer                            */
#define _KVI_ERR_EndAfterOpenBrace      2 /* End after open brace                    */
#define _KVI_ERR_MissingRightBrace      3 /* Missing right brace                     */
#define _KVI_ERR_ExpectedRightBrace     4 /* There is a different char               */
#define _KVI_ERR_MissingSeparator       5 /* Missing ;...there is something else     */
#define _KVI_ERR_BlockWithoutOpenBrace  6 /* Called parseBlock without an open brace */
#define _KVI_ERR_UnexpectedEndInCmd     7 /* parseCommand found an unexpected end    */
#define _KVI_ERR_UnknownCommand         8 /* unhandled command...pC points to it...  */
#define _KVI_ERR_MissingChannel         9 /* missing channel name(s)                 */
#define _KVI_ERR_NotConnected          10 /* Can't send data                         */
#define _KVI_ERR_MissingTarget         11 /* Missing target nickname                 */
#define _KVI_ERR_MissingData           12 /* Missing data to send...(RAW)            */
#define _KVI_ERR_MissingNick           13 /* Missing nickname                        */
#define _KVI_ERR_UnexpectedChar        14 /* Unexpected right brace                  */
#define _KVI_ERR_MissingVariable       15 /* Missing variable name (SET & UNSET)     */
#define _KVI_ERR_ExpectedVariable      16 /* Expected '%'...found something else     */
#define _KVI_ERR_MissingValue          17 /* Variable value expected                 */
#define _KVI_ERR_CantUnsetTwo          18 /* Can't unset two variables               */
#define _KVI_ERR_WindowNotFound        19 /* Window not found                        */
#define _KVI_ERR_MissingWindow         20 /* Missing window name                     */
#define _KVI_ERR_MissingText           21 /* Missing text to ECHO                    */
#define _KVI_ERR_NotOnChannel          22 /* You 're not on a channel                */
#define _KVI_ERR_MissingMode           23 /* Missing mode string                     */
#define _KVI_ERR_MissingCtcpType       24 /* Missing CTCP type                       */
#define _KVI_ERR_InfiniteRecursion     25 /* Infinite SET recursion                  */
#define _KVI_ERR_MissingExpression     26 /* Missing expression in if command        */
#define _KVI_ERR_UnexpectedEndInExpr   27 /* Unexpected end in expression            */
#define _KVI_ERR_MissingCommand        28 /* Missing command in if evaluation        */
#define _KVI_ERR_NotMatchingPrnths     29 /* Not mathing parenthesis                 */
#define _KVI_ERR_OperandDontMatchOprtr 30 /* Operand don't match operator            */
#define _KVI_ERR_UnknownOperator       31 /* Unknown operator                        */
#define _KVI_ERR_CantSetSystemVar      32 /* Cannot SET/UNSET a system variable      */
#define _KVI_ERR_ThisIsNotAnAlias      33 /* There are no %0,%1,%2 vars              */
#define _KVI_ERR_NonChannelAction      34 /* ME works only on a channel or query     */
#define _KVI_ERR_MissingTimerName      35 /* Timer name missing                      */
#define _KVI_ERR_UnknownTimerCmd       36 /* Unknown timer command                   */
#define _KVI_ERR_MissingTimerTime      37 /* Missing timer timeout                   */
#define _KVI_ERR_MissingTimerCommand   38 /* Missing timer command to execute        */
#define _KVI_ERR_TooSmallTimeout       39 /* Timeout less that 100 msec is DANGEROUS */
#define _KVI_ERR_MissingProcName       40 /* Missing process name                    */
#define _KVI_ERR_MissingProcPid        41 /* Missing process pid                     */
#define _KVI_ERR_Halt                  42 /* Not an error in fact , just HALT :)     */
#define _KVI_ERR_MissingServer         43 /* Missing server name                     */
#define _KVI_ERR_UnknownWindowCommand  44 /* Unknown window command                  */
#define _KVI_ERR_WrongWindowName       45 /* The window name does't start with a '@' */
#define _KVI_ERR_NoHostToResolve       46 /* No host to resolve                      */
#define _KVI_ERR_CantStartResolver     47 /* Can't start the kvidns program          */
#define _KVI_ERR_MissingFileName       48 /* Missing file name                       */
#define _KVI_ERR_MissingOperation      49 /* Missing operation                       */
#define _KVI_ERR_MissingKey            50 /* Missing key                             */
#define _KVI_ERR_UnknownCacheOperation 51 /* Unknown cache operation                 */
#define _KVI_ERR_MissingReturnData     52 /* return nothing                          */
#define _KVI_ERR_UnknownFileOperation  53 /* unknown file operation                  */
#define _KVI_ERR_MissingFileIdent      54 /* Missing file identifier                 */
#define _KVI_ERR_FileNotOpen           55 /* file not open                           */
#define _KVI_ERR_MissingAliasName      56 /* missing alias name                      */
#define _KVI_ERR_MissingAliasBody      57 /* Missing alias code                      */
#define _KVI_ERR_NoAliasWithThatName   58 /* Alias remove : no alias found           */
#define _KVI_ERR_OnlyOneTalkAllowed    59 /* Only one talk connection allowed        */


#define _KVI_ERR_ErrorMask            255 /* ErrorMask (numError&_KVI_ERR_ErrorMask) */

#define _KVI_CMD_parseTopLevel      (0<<8) /*:)))*/
#define _KVI_CMD_parseUserCommand   (1<<8) /*256 */
#define _KVI_CMD_parseBlock         (2<<8) /*512 */
#define _KVI_CMD_parseCommand       (3<<8) /*768 */
#define _KVI_CMD_parseJoin          (4<<8) /*1024*/
#define _KVI_CMD_parsePart          (5<<8)
#define _KVI_CMD_parseChat          (6<<8)
#define _KVI_CMD_parseQuery         (7<<8)
#define _KVI_CMD_parseRaw           (8<<8)
#define _KVI_CMD_parseNick          (9<<8)
#define _KVI_CMD_parseWhois        (10<<8)
#define _KVI_CMD_parseSet          (11<<8)
#define _KVI_CMD_parseUnset        (12<<8)
#define _KVI_CMD_parseEcho         (13<<8)
#define _KVI_CMD_parseTopic        (14<<8)
#define _KVI_CMD_parseMode         (15<<8)
#define _KVI_CMD_parseOp           (16<<8)
#define _KVI_CMD_executeMode       (17<<8)
#define _KVI_CMD_parseDeop         (18<<8)
#define _KVI_CMD_parseBan          (19<<8)
#define _KVI_CMD_parseUnban        (20<<8)
#define _KVI_CMD_parseVoice        (21<<8)
#define _KVI_CMD_parseDevoice      (22<<8)
#define _KVI_CMD_parseKick         (23<<8)
#define _KVI_CMD_parseSay          (24<<8)
#define _KVI_CMD_parseCtcp         (25<<8)
#define _KVI_CMD_executeAlias      (26<<8)
#define _KVI_CMD_parseIf           (27<<8)
#define _KVI_CMD_evaluateBoolean   (28<<8)
#define _KVI_CMD_parseHelp         (29<<8)
#define _KVI_CMD_parseSend         (30<<8)
#define _KVI_CMD_executeEvent      (31<<8)
#define _KVI_CMD_parseKban         (32<<8)
#define _KVI_CMD_parseWhowas       (33<<8)
#define _KVI_CMD_parseUserlist     (34<<8)
#define _KVI_CMD_parseClonescan    (35<<8)
#define _KVI_CMD_parseMe           (36<<8)
#define _KVI_CMD_parseTimer        (37<<8)
#define _KVI_CMD_parseRun          (38<<8)
#define _KVI_CMD_parseExec         (39<<8)
#define _KVI_CMD_parseKillproc     (40<<8)
#define _KVI_CMD_parseWriteproc    (41<<8)
#define _KVI_CMD_parseProclist     (42<<8)
#define _KVI_CMD_parseWhile        (43<<8)
#define _KVI_CMD_parsePlay         (44<<8)
#define _KVI_CMD_parseHalt         (45<<8)
#define _KVI_CMD_executePopup      (46<<8)
#define _KVI_CMD_parseServer       (47<<8)
#define _KVI_CMD_parseNotice       (48<<8)
#define _KVI_CMD_parseAway         (49<<8)
#define _KVI_CMD_parseBack         (50<<8)
#define _KVI_CMD_parseMsg          (51<<8)
#define _KVI_CMD_parseWindow       (52<<8)
#define _KVI_CMD_parseForeach      (53<<8)
#define _KVI_CMD_parseDns          (54<<8)
#define _KVI_CMD_parseAscii        (55<<8)
#define _KVI_CMD_parseCache        (56<<8)
#define _KVI_CMD_parseReturn       (57<<8)
#define _KVI_CMD_parseInc          (58<<8)
#define _KVI_CMD_parseDec          (59<<8)
#define _KVI_CMD_parseSound        (60<<8)
#define _KVI_CMD_parseFile         (61<<8)
#define _KVI_CMD_parseAlias        (62<<8)
#define _KVI_CMD_parseKvidebug     (63<<8)
#define _KVI_CMD_parseTalk         (64<<8)
#define _KVI_CMD_parseList         (65<<8)
#define _KVI_CMD_parseConnstats    (66<<8)

#define _KVI_ERR_WhereMask          (~255)

//================ handlers Table ==================//
parseCmdTable KviUserParser::cmdTab[]={
	{ "OP"      , 2 , &KviUserParser::parseOp      },{ "DEOP"     , 4 , &KviUserParser::parseDeop      },
	{ "KICK"    , 4 , &KviUserParser::parseKick    },{ "SAY"      , 3 , &KviUserParser::parseSay       },
	{ "CHAT"    , 4 , &KviUserParser::parseChat    },{ "QUERY"    , 5 , &KviUserParser::parseQuery     },
	{ "RAW"     , 3 , &KviUserParser::parseRaw     },{ "NICK"     , 4 , &KviUserParser::parseNick      },
	{ "WHOIS"   , 5 , &KviUserParser::parseWhois   },{ "SET"      , 3 , &KviUserParser::parseSet       },
	{ "UNSET"   , 5 , &KviUserParser::parseUnset   },{ "ECHO"     , 4 , &KviUserParser::parseEcho      },
	{ "TOPIC"   , 5 , &KviUserParser::parseTopic   },{ "MODE"     , 4 , &KviUserParser::parseMode      },
	{ "JOIN"    , 4 , &KviUserParser::parseJoin    },{ "PART"     , 4 , &KviUserParser::parsePart      },
	{ "BAN"     , 3 , &KviUserParser::parseBan     },{ "UNBAN"    , 5 , &KviUserParser::parseUnban     },
	{ "VOICE"   , 5 , &KviUserParser::parseVoice   },{ "DEVOICE"  , 7 , &KviUserParser::parseDevoice   },
	{ "CTCP"    , 4 , &KviUserParser::parseCtcp    },{ "IF"       , 2 , &KviUserParser::parseIf        },
	{ "HELP"    , 4 , &KviUserParser::parseHelp    },{ "SEND"     , 4 , &KviUserParser::parseSend      },
	{ "KBAN"    , 4 , &KviUserParser::parseKban    },{ "WHOWAS"   , 6 , &KviUserParser::parseWhowas    },
	{ "USERLIST", 8 , &KviUserParser::parseUserlist},{ "CLONESCAN", 9 , &KviUserParser::parseClonescan },
	{ "ME"      , 2 , &KviUserParser::parseMe      },{ "TIMER"    , 5 , &KviUserParser::parseTimer     },
	{ "RUN"     , 3 , &KviUserParser::parseRun     },{ "EXEC"     , 4 , &KviUserParser::parseExec      },
	{ "KILLPROC", 8 , &KviUserParser::parseKillproc},{ "WRITEPROC", 9 , &KviUserParser::parseWriteproc },
	{ "PROCLIST", 8 , &KviUserParser::parseProclist},{ "WHILE"    , 5 , &KviUserParser::parseWhile     },
	{ "PLAY"    , 4 , &KviUserParser::parsePlay    },{ "HALT"     , 4 , &KviUserParser::parseHalt      },
	{ "SERVER"  , 6 , &KviUserParser::parseServer  },{ "NOTICE"   , 6 , &KviUserParser::parseNotice    },
	{ "AWAY"    , 4 , &KviUserParser::parseAway    },{ "BACK"     , 4 , &KviUserParser::parseBack      },
	{ "MSG"     , 3 , &KviUserParser::parseSay     },{ "WINDOW"   , 6 , &KviUserParser::parseWindow    },
	{ "FOREACH" , 7 , &KviUserParser::parseForeach },{ "DNS"      , 3 , &KviUserParser::parseDns       },
	{ "ASCII"   , 5 , &KviUserParser::parseAscii   },{ "CACHE"    , 5 , &KviUserParser::parseCache     },
	{ "RETURN"  , 6 , &KviUserParser::parseReturn  },{ "INC"      , 3 , &KviUserParser::parseInc       },
	{ "DEC"     , 3 , &KviUserParser::parseDec     },{ "SOUND"    , 5 , &KviUserParser::parseSound     },
	{ "FILE"    , 4 , &KviUserParser::parseFile    },{ "ALIAS"    , 5 , &KviUserParser::parseAlias     },
	{ "KVIDEBUG", 8 , &KviUserParser::parseKvidebug},{ "TALK"     , 4 , &KviUserParser::parseTalk      },
	{ "LIST"    , 4 , &KviUserParser::parseList    },{ "CONNSTATS", 9 , &KviUserParser::parseConnstats },
	{ 0         , 0 , 0                            }
};

// False i18n for xgettext

#define __i18n__(___text) ___text

//================ error Strings ====================//
const char * KviUserParser::errTab[]={
	__i18n__("Error 0 (success ?)"),
	__i18n__("Internal error : NULL pointer in data"),
	__i18n__("Unexpected end of command after open brace"),
	__i18n__("Unbalanced open brace"),
	__i18n__("Unexpected character, right brace expected"),
	__i18n__("Unexpected character, command separator expected"),
	__i18n__("Internal error : parseBlock call without a block"),
	__i18n__("Unexpected end of command"),
	__i18n__("Unknown command"),
	__i18n__("Missing channel name"),
	__i18n__("Can't send data, no active connection"),
	__i18n__("Missing target nickname"),
	__i18n__("No data to send"),
	__i18n__("Missing nickname"),
	__i18n__("Unexpected character"),
	__i18n__("Missing variable name"),
	__i18n__("Unexpected character, variable identifier expected"),
	__i18n__("Missing variable value"),
	__i18n__("OBSOLETE:Too many operands for unary operator UNSET"),
	__i18n__("Window not found"),
	__i18n__("Missing window name"),
	__i18n__("Missing text"),
	__i18n__("Missing channel name,and you're not on a channel"),
	__i18n__("Missing mode parameter"),
	__i18n__("Missing CTCP type"),
	__i18n__("Infinite recursion in variable evaluation"),
	__i18n__("Missing expression in if command"),
	__i18n__("Unexpected end in expression"),
	__i18n__("Missing command"),
	__i18n__("Not matching parenthesis"),
	__i18n__("Operand don't match operator"),
	__i18n__("Unknown operator"),
	__i18n__("Can not SET/UNSET a system variable"),
	__i18n__("This is not an alias (there are no %n variables,and no return value)"),
	__i18n__("Works only on channel or query windows..."),
	__i18n__("Missing timer name"),
	__i18n__("Unknown timer command"),
	__i18n__("Missing timer timeout"),
	__i18n__("Missing timer command"),
	__i18n__("Too small timeout"),
	__i18n__("Missing process name"),
	__i18n__("Missing process pid"),
	__i18n__("Execution halted"),
	__i18n__("Missing server name"),
	__i18n__("Unknown window operation"),
	__i18n__("Wrong window name. [Must start with a '*']"),
	__i18n__("No host to resolve"),
	__i18n__("Unable to start kvidns resolver program"),
	__i18n__("Missing file name"),
	__i18n__("Missing operation"),
	__i18n__("Missing key"),
	__i18n__("Unknown cache operation"),
	__i18n__("Missing return data"),
	__i18n__("Unknown file operation"),
	__i18n__("Missing file identifier"),
	__i18n__("File not open"),
	__i18n__("Missing alias name"),
	__i18n__("Missing alias implementation"),
	__i18n__("No alias with that name"),
	__i18n__("Sorry , only one talk connection allowed."),
	0
};
//=============== error Location Table ================//
const char * KviUserParser::fncTab[]={
	"COMMAND PARSER",  "COMMAND PARSER",     "COMMAND BLOCK",
	"COMMAND",         "JOIN",               "PART",
	"CHAT",            "QUERY",              "RAW",
	"NICK",            "WHOIS",              "SET",
	"UNSET",           "ECHO",               "TOPIC",
	"MODE",            "OP",                 "MODE EXECUTE",
	"DEOP",            "BAN",                "UNBAN",
	"VOICE",           "DEVOICE",            "KICK",
	"SAY",             "CTCP",               "ALIAS EXECUTE",
	"IF",              "EVAL BOOLEAN EXPR",  "HELP",
	"SEND",            "EVENT EXECUTE",      "KBAN",
	"WHOWAS",          "USERLIST",           "CLONESCAN",
	"ME",              "TIMER",              "RUN",
	"EXEC",            "KILLPROC",           "WRITEPROC",
	"PROCLIST",        "WHILE",              "PLAY",
	"HALT",            "POPUP EXECUTE",      "SERVER",
	"NOTICE",          "AWAY",               "BACK",
	"MSG",             "WINDOW",             "FOREACH",
	"DNS",             "ASCII",              "CACHE",
	"RETURN",          "INC",                "DEC",
	"SOUND",           "FILE",               "ALIAS",
	"KVIDEBUG",        "TALK",               "LIST",
	"CONNSTATS",
	0
};
//============ constructor & destructor ============//
KviUserParser::KviUserParser()
{
	m_lpVarList=new QList<KviVariable>;
	m_lpVarList->setAutoDelete(true);
	m_lpCache=new KviCache();
}
KviUserParser::~KviUserParser()
{
	while(!m_lpVarList->isEmpty())m_lpVarList->removeLast();
	delete m_lpVarList;
	delete m_lpIdentifiers;
	delete m_lpTimerManager;
	delete m_lpHelp;
	delete m_lpProcessManager;
	delete m_lpCache;
	delete m_lpFileManager;
}
//============ activate ============//
void KviUserParser::activate(KviFrame *lpFrame)
{
	_debug_entertrace("activate");
	m_lpFrm         = lpFrame;
	m_lpSock        = lpFrame->m_lpSock;
	m_lpMdi         = lpFrame->m_lpMdi;
	m_lpCons        = lpFrame->m_lpConsole;
	m_lpGlb         = lpFrame->m_lpGlb;
	m_lpOpt         = lpFrame->m_lpOpt;
	m_lpAliasManager= lpFrame->m_lpAliasManager;
	m_lpProcessManager= new KviProcessManager(lpFrame);
	m_lpHelp        = new KviHelp();
	m_lpAliasList   = m_lpAliasManager->m_lpAliasList;
	m_lpIdentifiers = new KviIdentifiers(lpFrame,this);
	m_lpTimerManager= new KviTimerManager(this);
	m_lpFileManager = new KviFileManager();
	m_szLastDCCTarget   ="";
	m_szLastQueryTarget ="";
	_debug_leavetrace("activate");
}
//============ addVariable ============//
void KviUserParser::addVariable(KviVariable *lpV)
{
	_debug_entertrace("addVariable");
	KviVariable *lpX=0;
	//inverse insertion....
	// zfgdjsk
	// ret
	// tempr
    // temp
    // alibaba
    // aaa
	int idx=0;
	for(lpX=m_lpVarList->first();lpX;lpX=m_lpVarList->next()){
		if(strcasecmp(lpV->szName.data(),lpX->szName.data())>0){
			m_lpVarList->insert(idx,lpV);
			return;
		}
		idx++;
	}
	m_lpVarList->append(lpV);
	_debug_leavetrace("addVariable");
}
//============ handleError ============//
void KviUserParser::handleError(KviMdiChild *lpC,int numErr,const char *pC)
{
	_debug_entertrace("handleError");
	int location=((numErr & _KVI_ERR_WhereMask)>>8);
	int errorNum=( numErr & _KVI_ERR_ErrorMask);
	if(errorNum==_KVI_ERR_Halt)return;
	if(pC && (*pC)){
		QString lastChars(pC,15);
		lastChars+="...";
		lpC->doFmtOutput(KVI_OUT_ERROR,"[%s]:[%s]: %s",fncTab[location],lastChars.data(),klocale->translate(errTab[errorNum]));
	} else lpC->doFmtOutput(KVI_OUT_ERROR,"[%s]: %s",fncTab[location],klocale->translate(errTab[errorNum]));
	_debug_leavetrace("handleError");
}
//============ parseUserInput ============//
void KviUserParser::parseUserInput(KviMdiChild *lpC,int winType,const char *winName,QString &szData)
{
	_debug_entertrace("parseUserInput");
	if(szData.isEmpty())return;
	const char *pC=szData.data();
	_macro_skipSenselessChars(pC);
	if(! (*pC)) return;
	if( ((*pC)=='/') || ((*pC)==m_lpOpt->chPersonalCommandPrefix) ){
		pC++;
		if(!(*pC))return;
		int numErr=parseUserCommand(lpC,&pC,0);
		if((*pC==KVI_CHAR_END)&&(!(numErr & _KVI_ERR_ErrorMask)))numErr=(_KVI_CMD_parseTopLevel|_KVI_ERR_UnexpectedChar);
		if(numErr & _KVI_ERR_ErrorMask)handleError(lpC,numErr,pC);
		return;
	} else {
		if(!((m_lpSock->m_bConnected)||(winType == KVI_WND_TYPE_USER)||(winType==KVI_WND_TYPE_CHAT))){
			lpC->doOutput(KVI_OUT_ERROR,i18n("You're not connected to a server"));
			return;
		}
	}
	if(lpC->m_bIdentParsingEnabled)m_lpIdentifiers->substitute(lpC,szData,0);
	switch(winType){
	case KVI_WND_TYPE_CHAN:
	case KVI_WND_TYPE_QUERY:
		{
			QString szNicko;
			m_lpFrm->formatNickOutputString(szNicko,m_lpGlb->szNick);
			lpC->doFmtOutput((winType==KVI_WND_TYPE_CHAN ? KVI_OUT_OWN : KVI_OUT_PRIVMSG),"%s%s",szNicko.data(),szData.data());
			m_lpSock->sendFmtData("PRIVMSG %s :%s",winName,szData.data());	
		}
		break;
	case KVI_WND_TYPE_CHAT:
		{
			if(!((KviChatWnd *)lpC)->m_bConnected)return;
			lpC->sendData(szData.data());
			QString szNicko;
			m_lpFrm->formatNickOutputString(szNicko,m_lpGlb->szNick);	
			lpC->doFmtOutput(KVI_OUT_OWN,"%s%s",szNicko.data(),szData.data());
		}
		break;		
	case KVI_WND_TYPE_STATUS:
		lpC->doFmtOutput(KVI_OUT_RAW,"[RAW TO SERVER] : %s",szData.data());
		m_lpSock->sendData(szData.data());	
		break;
	case KVI_WND_TYPE_USER:
		if(m_lpFrm->m_lpEventManager->lpEvent[KVI_Event_OnUserWndInput]->bEnabled){
			QString szPara=lpC->name();
			szPara+=' ';
			szPara+=szData;
			executeEvent(lpC,m_lpFrm->m_lpEventManager->lpEvent[KVI_Event_OnUserWndInput],szPara);
		}
		break;
	}
	_debug_leavetrace("parseUserInput");
}
//============ parseUserCommand ============//
int KviUserParser::parseUserCommand(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseUserCommand");
	//  **pC is the character
	//   *pC is the pointer to character
	//    pC is the pointer to the pointer to character
	if(!(*pC))return (_KVI_CMD_parseUserCommand|_KVI_ERR_NoPointer);	//empty string
	_macro_skipSenselessChars((*pC));
	if(! (**pC) )return (_KVI_CMD_parseUserCommand|_KVI_ERR_Success);
	int numError;
	if( (**pC)==KVI_CHAR_BEGIN ){
		numError=parseBlock(lpC,pC,pP);
		if(numError & _KVI_ERR_ErrorMask)return numError;
	} else {
		numError=parseCommand(lpC,pC,pP);
		if(numError & _KVI_ERR_ErrorMask)return numError;
	}
//  NEWLINE HANDLING REPLACEMENT
	while((**pC) && (((**pC)==' ') || ((**pC)=='\t')) ) (*pC)++; //check also for a new line
	if(!(**pC))return (_KVI_CMD_parseUserCommand|_KVI_ERR_Success);
	if((**pC) != KVI_CHAR_END){
		if((numError & _KVI_ERR_WhereMask)==_KVI_CMD_parseBlock){
			//we have parsed a block of commands , allow not using the separator
			if(((**pC) == ';')||((**pC) == '\n')){
				(*pC)++;
				_macro_skipSenselessChars((*pC));
				if((**pC) == KVI_CHAR_END)return (_KVI_CMD_parseUserCommand|_KVI_ERR_Success);
			} //else separator not used , we're pointing to a new command
		} else {
			//parsed a simple command
			if(((**pC) != ';')&&((**pC) != '\n'))return  (_KVI_CMD_parseUserCommand|_KVI_ERR_MissingSeparator); 
			(*pC)++;
			_macro_skipSenselessChars((*pC));
			if((**pC) == KVI_CHAR_END)return (_KVI_CMD_parseUserCommand|_KVI_ERR_Success);
		}
	} else {
		return (_KVI_CMD_parseUserCommand|_KVI_ERR_Success);
	}
	return parseUserCommand(lpC,pC,pP);
	_debug_leavetrace("parseUserCommand");
}
//============ parseBlock ============//
int KviUserParser::parseBlock(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseBlock");
	if((**pC) != KVI_CHAR_BEGIN)return (_KVI_CMD_parseBlock|_KVI_ERR_BlockWithoutOpenBrace);
	(*pC)++;
	if(!(**pC))return (_KVI_CMD_parseBlock|_KVI_ERR_EndAfterOpenBrace);
	int numError=parseUserCommand(lpC,pC,pP);
	if(numError & _KVI_ERR_ErrorMask)return numError;
	_macro_skipSenselessChars((*pC));
	if(!(**pC))return (_KVI_CMD_parseBlock|_KVI_ERR_MissingRightBrace); //here
	if(**pC != KVI_CHAR_END)return (_KVI_CMD_parseBlock|_KVI_ERR_ExpectedRightBrace);
	(*pC)++;
	return (_KVI_CMD_parseBlock|_KVI_ERR_Success);
	_debug_leavetrace("parseBlock");
}
//============ parseCommand ============//
int KviUserParser::parseCommand(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseCommand");
	if(!(*pC))return (_KVI_CMD_parseCommand|_KVI_ERR_NoPointer);
	if(!(**pC))return (_KVI_CMD_parseCommand|_KVI_ERR_UnexpectedEndInCmd);
	//Find the built in command...look un the handler proc in table
	if(**pC=='$'){ //First substitute the first word (a variable command)
		const char *pidx=(*pC);
		while((*pidx)&&(*pidx!=' ')&&(*pidx!='\t')&&(*pidx!='\n')&&(*pidx!=';'))pidx++;
		QString szC;
		if(!pidx)szC=QString(*pC);
		else szC=QString((*pC),(pidx-(*pC))+1);
		m_lpIdentifiers->substitute(lpC,szC,pP);
		szC=szC.stripWhiteSpace();
		const char *ptr=szC.data();
		for (int i=0;cmdTab[i].szName!=0;i++){
			if (!strcasecmp((ptr),cmdTab[i].szName)){
				if(pidx)(*pC)=pidx;
				else (*pC)+=strlen((*pC));
				_macro_skipSenselessChars((*pC));
				return (this->*(cmdTab[i].proc))(lpC,pC,pP);
			}
		}
		//Not found...look for an alias
		KviAliasStruct *lpA;
		for(lpA=m_lpAliasList->first();lpA;lpA=m_lpAliasList->next()){
			if(!strcasecmp((ptr),lpA->szName.data())){
				if(pidx)(*pC)=pidx;
				else (*pC)+=strlen((*pC));
				_macro_skipSenselessChars((*pC));
				QString szParams="";
				if(**pC){
					const char *rghPtr=(*pC);
					_macro_skipUpToEndOfCmd(rghPtr);
					szParams=QString((*pC),(rghPtr-(*pC))+1);
					m_lpIdentifiers->substitute(lpC,szParams,pP);
					(*pC)=rghPtr;
				}
				return executeAlias(lpC,lpA,szParams);
			}
		}
		//Not found...Break the executing chain...
		return (_KVI_CMD_parseCommand|_KVI_ERR_UnknownCommand);
	}
	//Normal command
	int nLen=strlen(*pC);
	const char *pSpace=0;
	for (int i=0;cmdTab[i].szName!=0;i++){
		if(nLen>=cmdTab[i].lenName){
			pSpace=(*pC)+cmdTab[i].lenName;
			if((*pSpace==' ')||(*pSpace=='\t')||(*pSpace=='\n')||(!(*pSpace))||(*pSpace==';')){
				if (!strncasecmp((*pC),cmdTab[i].szName,cmdTab[i].lenName)){
					(*pC)=pSpace;
					_macro_skipSenselessChars((*pC));
		 			return (this->*(cmdTab[i].proc))(lpC,pC,pP);
				}
			}
		}
	}
	//Not found...look for an alias
	KviAliasStruct *lpA;
	for(lpA=m_lpAliasList->first();lpA;lpA=m_lpAliasList->next()){
		int iLen=strlen(lpA->szName.data());
		if(!strncasecmp((*pC),lpA->szName.data(),iLen)){
			const char *ptrToEnd=(*pC)+iLen;
			if((*ptrToEnd==' ')||(*ptrToEnd=='\n')||(*ptrToEnd=='\t')||(*ptrToEnd==';')||(!(*ptrToEnd))){
				(*pC)=ptrToEnd;
				_macro_skipSenselessChars((*pC));
				QString szParams="";
				if(**pC){
					const char *rghPtr=(*pC);
					_macro_skipUpToEndOfCmd(rghPtr);
					szParams=QString((*pC),(rghPtr-(*pC))+1);
					m_lpIdentifiers->substitute(lpC,szParams,pP);
					*pC=rghPtr;
				}
				return executeAlias(lpC,lpA,szParams);
			}
		}
	}
	//Not found...Break the executing chain...
	return (_KVI_CMD_parseCommand|_KVI_ERR_UnknownCommand);
	_debug_leavetrace("parseCommand");
}
//============ executeAlias ============//
int KviUserParser::executeAlias(KviMdiChild *lpC,KviAliasStruct *lpA,QString &szParams,KviAliasParams *pExtParams)
{
	_debug_entertrace("executeAlias");
	KviAliasParams *pAliasParams=pExtParams;
	if(!pExtParams)pAliasParams=new KviAliasParams;
	pAliasParams->szReturn=KVI_STR_NULL;
	if(szParams.isEmpty()){
		for(int i=0;i<10;i++)pAliasParams->param[i]="";
	} else {
		pAliasParams->param[0]=szParams.stripWhiteSpace();
		for(int i=1;i<10;i++){
			szParams=szParams.stripWhiteSpace();	
			if(szParams.isEmpty())pAliasParams->param[i]="";
			else {
				int idx=szParams.find(' ');
				if((idx==-1)||(i==9)){pAliasParams->param[i]=szParams.data();szParams="";}
				else { pAliasParams->param[i]=szParams.left(idx);szParams.remove(0,idx+1);}
			};
		}
	}
	const char *pCh=lpA->szBuffer.data();
	const char *pBegin=0;
	QString *pAliasBuffer=new QString(1);
	while(*pCh){ 
		//skip newlines at the beginning
		while((*pCh)&&((*pCh==' ')||(*pCh=='\n')||(*pCh=='\t')))pCh++;
		if(*pCh){ //if there is text check for comments and skip it
			if(*pCh=='@')while((*pCh)&&(*pCh != '\n'))pCh++;
			else { //no comments run until next comment
				while(*pCh && (*pCh != '@')){
					pBegin=pCh; 
					//find the next newline
					while((*pCh) && (*pCh!='\n'))pCh++;
					if(*pCh){
						//abcdfer xa\n
						//!         |
						//pBegin    pCh
						//test
						if(pBegin != pCh){
							const char *pRetry=pCh;
							pRetry--;
							if(*pRetry=='\\'){
								pAliasBuffer->append(QString(pBegin,(pCh-pBegin)).data());
								pCh++; //skip the newline now
								pBegin=pCh;
								while((*pCh)&&((*pCh==' ')||(*pCh=='\n')||(*pCh=='\t')))pCh++;
								if(pBegin != pCh)pAliasBuffer->append(QString(pBegin,(pCh-pBegin)+1).data());
							}
						}
						//end test
						pAliasBuffer->append(QString(pBegin,(pCh-pBegin)+1).data());
						pBegin=pCh;
						while((*pCh)&&((*pCh==' ')||(*pCh=='\n')||(*pCh=='\t')))pCh++;
						if(pBegin != pCh)pAliasBuffer->append(QString(pBegin,(pCh-pBegin)+1).data());		
					} else { //if it was the end copy the remaining
						if(pCh != pBegin)pAliasBuffer->append(QString(pBegin,(pCh-pBegin)+1).data());
					}
				}
			}
		}
	}
	if(!pAliasBuffer->isEmpty()){
		pCh=pAliasBuffer->data();
		_macro_skipSenselessChars(pCh);
		if((*pCh) != '/'){
			delete pAliasBuffer;
			if(!pExtParams)delete pAliasParams;
			return (_KVI_CMD_executeAlias|_KVI_ERR_UnexpectedChar);
		}
		pCh++;
		if(*pCh){
			int nErr= parseUserCommand(lpC,&pCh,pAliasParams);
			if(!pExtParams)delete pAliasParams;
			delete pAliasBuffer;
			return nErr;
		} else {
			if(!pExtParams)delete pAliasParams;
			delete pAliasBuffer;
			return (_KVI_CMD_executeAlias|_KVI_ERR_UnexpectedEndInCmd);
		}
	}
	if(!pExtParams)delete pAliasParams;
	delete pAliasBuffer;
	_debug_leavetrace("executeAlias");
	return (_KVI_CMD_executeAlias|_KVI_ERR_Success);
}
//============ executeEvent ============//
int KviUserParser::executeEvent(KviMdiChild *lpC,KviEventStruct *lpE,QString &szParams)
{
	_debug_entertrace("executeEvent");
	KviAliasParams szAliasParams;
	if(szParams.isEmpty()){
		for(int i=0;i<10;i++)szAliasParams.param[i]="";
	} else {
		szAliasParams.param[0]=szParams.stripWhiteSpace();
		for(int i=1;i<10;i++){
			szParams=szParams.stripWhiteSpace();	
			if(szParams.isEmpty())szAliasParams.param[i]="";
			else {
				int idx=szParams.find(' ');
				if((idx==-1)||(i==9)){szAliasParams.param[i]=szParams.data();szParams="";}
				else {szAliasParams.param[i]=szParams.left(idx);szParams.remove(0,idx+1);}
			}
		}
	}
	const char *pC=lpE->szBuffer.data();
	const char *pBegin=0;
	QString szAliasBuffer="";
	while(*pC){
		while((*pC)&&((*pC==' ')||(*pC=='\n')||(*pC=='\t')))pC++;
		if(*pC){
			if(*pC=='@')while((*pC)&&(*pC != '\n'))pC++;
			else { 
				while(*pC && (*pC != '@')){
					pBegin=pC;
					while((*pC) && (*pC!='\n'))pC++;
					if(*pC){
						//test
						if(pBegin != pC){
							const char *pRetry=pC;
							pRetry--;
							if(*pRetry=='\\'){
								szAliasBuffer.append(QString(pBegin,(pC-pBegin)).data());
								pC++; //skip the newline now
								pBegin=pC;
								while((*pC)&&((*pC==' ')||(*pC=='\n')||(*pC=='\t')))pC++;
								if(pBegin != pC)szAliasBuffer.append(QString(pBegin,(pC-pBegin)+1).data());
							}
						}
						//end test
						szAliasBuffer.append(QString(pBegin,(pC-pBegin)+1).data());
						pBegin=pC;
						while((*pC)&&((*pC==' ')||(*pC=='\n')||(*pC=='\t')))pC++;
						if(pBegin != pC)szAliasBuffer.append(QString(pBegin,(pC-pBegin)+1).data());		
					} else { //if it was the end copy the remaining
						if(pC != pBegin)szAliasBuffer.append(QString(pBegin,(pC-pBegin)+1).data());
					}
				}
			}
		}
	}
	if(!szAliasBuffer.isEmpty()){
		pC=szAliasBuffer.data();
		_macro_skipSenselessChars(pC);
		if((*pC) != '/'){
			m_lpCons->doFmtOutput(KVI_OUT_ERROR,i18n("Error in event : %s"),lpE->szName.data());	
			handleError(m_lpCons,_KVI_CMD_executeEvent|_KVI_ERR_UnexpectedChar,pC);
			return KVI_EventErr_Error;
		}
		pC++;
		if(*pC){
			if(*pC){
				int numErr=parseUserCommand(lpC,&pC,&szAliasParams);
				if(numErr & _KVI_ERR_ErrorMask){
					if((numErr & _KVI_ERR_ErrorMask)==_KVI_ERR_Halt){
						return KVI_EventErr_Halt; //Stop
					} else {
						m_lpCons->doFmtOutput(KVI_OUT_ERROR,i18n("Error in event : %s"),lpE->szName.data());		
						handleError(m_lpCons,numErr,pC);
						return KVI_EventErr_Error;
					}
				} else return KVI_EventErr_Success;
			}
		}
		m_lpCons->doFmtOutput(KVI_OUT_ERROR,i18n("Error in event : %s"),lpE->szName.data());
		handleError(m_lpCons,(_KVI_CMD_executeEvent|_KVI_ERR_UnexpectedEndInCmd),pC);
		return KVI_EventErr_Error;
	}
	_debug_leavetrace("executeEvent");
	return KVI_EventErr_Success;
}
//============ executePopup ============//
int KviUserParser::executePopup(KviMdiChild *lpC,QString &szAction)
{
	_debug_entertrace("executePopup");
	const char *pC=szAction.data();
	const char *pBegin=0;
	QString szPopupBuffer="";
	while(*pC){
		while((*pC)&&((*pC==' ')||(*pC=='\n')||(*pC=='\t')))pC++;
		if(*pC){
			if(*pC=='@')while((*pC)&&(*pC != '\n'))pC++;
			else { 
				while(*pC && (*pC != '@')){
					pBegin=pC;
					while((*pC) && (*pC!='\n'))pC++;
					if(*pC){
						//test
						if(pBegin != pC){
							const char *pRetry=pC;
							pRetry--;
							if(*pRetry=='\\'){
								szPopupBuffer.append(QString(pBegin,(pC-pBegin)).data());
								pC++; //skip the newline now
								pBegin=pC;
								while((*pC)&&((*pC==' ')||(*pC=='\n')||(*pC=='\t')))pC++;
								if(pBegin != pC)szPopupBuffer.append(QString(pBegin,(pC-pBegin)+1).data());
							}
						}
						//end test
						szPopupBuffer.append(QString(pBegin,(pC-pBegin)+1).data());
						pBegin=pC;
						while((*pC)&&((*pC==' ')||(*pC=='\n')||(*pC=='\t')))pC++;
						if(pBegin != pC)szPopupBuffer.append(QString(pBegin,(pC-pBegin)+1).data());		
					} else { //if it was the end copy the remaining
						if(pC != pBegin)szPopupBuffer.append(QString(pBegin,(pC-pBegin)+1).data());
					}
				}
			}
		}
	}
	if(!szPopupBuffer.isEmpty()){
		pC=szPopupBuffer.data();
		_macro_skipSenselessChars(pC);
		if((*pC) != '/'){
			handleError(lpC,_KVI_CMD_executePopup|_KVI_ERR_UnexpectedChar,pC);
			return KVI_EventErr_Error;
		}
		pC++;
		if(*pC){
			if(*pC){
				int numErr=parseUserCommand(lpC,&pC,0);
				if(numErr & _KVI_ERR_ErrorMask){
					if((numErr & _KVI_ERR_ErrorMask)==_KVI_ERR_Halt){
						return KVI_EventErr_Halt; //Stop
					} else {
						handleError(lpC,numErr,pC);
						return KVI_EventErr_Error;
					}
				} else return KVI_EventErr_Success;
			}
		}
		handleError(lpC,(_KVI_CMD_executePopup|_KVI_ERR_UnexpectedEndInCmd),pC);
		return KVI_EventErr_Error;
	}
	_debug_leavetrace("executePopup");
	return KVI_EventErr_Success;
}
//============ executeMode ===========//
int KviUserParser::executeMode(QString &szChan,QString &szTrg,bool bPlus,char chMode)
{
	_debug_entertrace("executeMode");
	QString szTar="";
	int num=0;
	QString szMod=( bPlus ? "+" : "-" );
	while(!szTrg.isEmpty()){
		int idx=szTrg.find(',');
		if(!szTar.isEmpty())szTar+=' ';
		if(idx==-1){ szTar+=szTrg; szTrg="";}
		else { szTar+=szTrg.left(idx); szTrg.remove(0,idx+1); }
		num++;
		szMod+=chMode;
		if(num==3){
			num=0;
			if(m_lpSock->sendFmtData("MODE %s %s %s",szChan.data(),szMod.data(),szTar.data()))return (_KVI_CMD_executeMode|_KVI_ERR_NotConnected);	
			szMod=( bPlus ? "+" : "-" ); szTar="";
		}
	}
	if(num)if(m_lpSock->sendFmtData("MODE %s %s %s",szChan.data(),szMod.data(),szTar.data()))return (_KVI_CMD_executeMode|_KVI_ERR_NotConnected);	
	return (_KVI_CMD_executeMode|_KVI_ERR_Success);
	_debug_leavetrace("executeMode");
}
//============ evaluateBoolean ============//

//<boolean>  ::= [!]<boolean>
//<boolean>  ::= (<boolean>)
//<boolean>  ::= <boolean> <op> <boolean>

int KviUserParser::evaluateBoolean(KviMdiChild *lpC,const char ** pC,bool *bResult,KviAliasParams *pP,bool hadBrace)
{
	_debug_entertrace("evaluateBoolean");
	_macro_skipSenselessChars((*pC));
	if(!(**pC)){
		//empty expression is always false
		(*bResult)=false;
	} else {
		//First check for a NOT
		if(**pC=='!'){
			(*pC)++;
			_macro_skipSenselessChars((*pC));
			int numErr=evaluateBoolean(lpC,pC,bResult,pP,hadBrace);
			if(numErr & _KVI_ERR_ErrorMask)return numErr;
			(*bResult) = !(*bResult);
		} else if(**pC=='('){
			(*pC)++;
			_macro_skipSenselessChars((*pC));
			//if(!(**pC))return (_KVI_CMD_evaluateBoolean|_KVI_ERR_UnexpectedEndInExpr);	
			int numErr=evaluateBoolean(lpC,pC,bResult,pP,true);
			if(numErr & _KVI_ERR_ErrorMask)return numErr;
			if((**pC) != ')')return (_KVI_CMD_evaluateBoolean|_KVI_ERR_NotMatchingPrnths);
			(*pC)++;
			_macro_skipSenselessChars((*pC));
		} else { //first operand not in parenthesis
			//skip up to end,'&','|',')'
			const char *rghPtr=*pC;
			while((*rghPtr)&&(*rghPtr != '&')&&(*rghPtr != '|')&&(*rghPtr != ')'))rghPtr++;
			QString szOp((*pC),(rghPtr-(*pC))+1);
			szOp=szOp.stripWhiteSpace();
			//if(szOp.isEmpty())return (_KVI_CMD_evaluateBoolean|_KVI_ERR_MissingExpression);
			m_lpIdentifiers->substitute(lpC,szOp,pP);
			(*pC)=rghPtr;
			rghPtr=szOp.data();
			if(szOp.isEmpty())(*bResult)=false;
			else {
				(*bResult)= (	strcmp(rghPtr,KVI_STR_NULL)  &&
								strcmp(rghPtr,KVI_STR_FALSE) &&
								strcmp(rghPtr,"0") );
			}
		}
	}
	if(! (**pC))return (_KVI_CMD_evaluateBoolean|_KVI_ERR_Success);
	if(**pC==')'){
		if(hadBrace)return (_KVI_CMD_evaluateBoolean|_KVI_ERR_Success);
		else return (_KVI_CMD_evaluateBoolean|_KVI_ERR_NotMatchingPrnths);
	} else if((**pC=='&') || (**pC=='|')){
		char chOperator=**pC;
		(*pC)++;
		//if(!(**pC))return (_KVI_CMD_evaluateBoolean|_KVI_ERR_UnexpectedEndInExpr);
		bool bResult2=false;
		int numErr=evaluateBoolean(lpC,pC,&bResult2,pP,hadBrace);
		if(numErr & _KVI_ERR_ErrorMask)return numErr;
		if(chOperator=='&')(*bResult)= ((*bResult) && bResult2);
		else (*bResult)= ((*bResult) || bResult2);
	} else return (_KVI_CMD_evaluateBoolean|_KVI_ERR_UnknownOperator);
	_debug_leavetrace("evaluateBoolean");
	return (_KVI_CMD_evaluateBoolean|_KVI_ERR_Success);
}

//#include "kvi_uparser2.cpp"
//   WAS Id: kvi_uparser2.cpp,v 1.9 1998/10/01 00:40:08 pragma Exp
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//============ parseIf ============//
int KviUserParser::parseIf(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseIf");
	if(!(**pC))return (_KVI_CMD_parseIf|_KVI_ERR_MissingExpression);
	if((**pC) != '(')return (_KVI_CMD_parseIf|_KVI_ERR_UnexpectedChar);
	const char *rghPtr=(*pC);
	int match=1;
	while(match){
		(rghPtr)++;
		if(!(*rghPtr))return (_KVI_CMD_parseIf|_KVI_ERR_UnexpectedEndInExpr);
		if(*rghPtr=='(')match++;
		if(*rghPtr==')')match--;
	}
	(rghPtr)++;
	if(!(*rghPtr))return (_KVI_CMD_parseIf|_KVI_ERR_UnexpectedEndInExpr);
	(*pC)++; //skip the first (
	QString szExpr((*pC),(rghPtr-(*pC)));
	(*pC)=rghPtr;
	//m_lpIdentifiers->substitute(lpC,szExpr,pP);
	//Copy the then piece
	//szExpr= ( something )
	_macro_skipSenselessChars((*pC));
	QString szThen;
	QString szElse;
	if(!(**pC))return (_KVI_CMD_parseIf|_KVI_ERR_MissingCommand);
	if(**pC==KVI_CHAR_BEGIN){ //strip up to matching brace
		rghPtr=(*pC);
		match=1;
		while(match){
			(rghPtr)++;
			if(!(*rghPtr))return (_KVI_CMD_parseIf|_KVI_ERR_UnexpectedEndInCmd);
			if(*rghPtr==KVI_CHAR_BEGIN)match++;
			if(*rghPtr==KVI_CHAR_END)match--;
		}
		(rghPtr)++;
		if(!(*rghPtr))return (_KVI_CMD_parseIf|_KVI_ERR_UnexpectedEndInCmd);
		szThen=QString((*pC),(rghPtr-(*pC))+1);
		//ADDING NEWLINE HANDLING the line below added '\n'
		//match==0 here!
		_macro_skipSpacesAndTabs(rghPtr);
		if((*rghPtr !=';')&&(*rghPtr != '\n'))match=1; //need else
		(*pC)=rghPtr;
	} else { //strip up to ;
		rghPtr=(*pC);
		_macro_skipUpToEndOfCmd(rghPtr);
		szThen=QString((*pC),(rghPtr-(*pC))+1);
		(*pC)=rghPtr;
	}
	rghPtr=(*pC);
	if(rghPtr){
		if(!match){
			rghPtr++;
			_macro_skipSenselessChars(rghPtr);
		}
		if(strncasecmp("else",rghPtr,4)){
			if(match)return (_KVI_CMD_parseIf|_KVI_ERR_MissingSeparator);
		} else { //got else command
			rghPtr+=4;
			_macro_skipSenselessChars(rghPtr);
			if(!*rghPtr)return (_KVI_CMD_parseIf|_KVI_ERR_MissingCommand);
			(*pC)=rghPtr;
			if(**pC==KVI_CHAR_BEGIN){ //strip up to matching brace
				rghPtr=(*pC);
				match=1;
				while(match){
					(rghPtr)++;
					if(!(*rghPtr))return (_KVI_CMD_parseIf|_KVI_ERR_UnexpectedEndInCmd);
					if(*rghPtr==KVI_CHAR_BEGIN)match++;
					if(*rghPtr==KVI_CHAR_END)match--;
				}
				(rghPtr)++;
				if(!(*rghPtr))return (_KVI_CMD_parseIf|_KVI_ERR_UnexpectedEndInCmd);
				szElse=QString((*pC),(rghPtr-(*pC))+1);
				//NEWLINE HANDLING = same as above
				_macro_skipSpacesAndTabs(rghPtr);
				if((*rghPtr !=';')&&(*rghPtr != '\n'))return (_KVI_CMD_parseIf|_KVI_ERR_MissingSeparator);
				(*pC)=rghPtr;
			} else { //strip up to ;
				rghPtr=(*pC);
				_macro_skipUpToEndOfCmd(rghPtr);
				szElse=QString((*pC),(rghPtr-(*pC))+1);
				(*pC)=rghPtr;
			}	
		}
	}
	const char *pBool=szExpr.data();
	bool bEvalToTrue;
	int numErr=evaluateBoolean(lpC,&pBool,&bEvalToTrue,pP,false);
	if(numErr & _KVI_ERR_ErrorMask)return numErr;
	if(bEvalToTrue){
		const char *pCmd=szThen.data();
		return parseUserCommand(lpC,&pCmd,pP);
	} else {
		if(!szElse.isEmpty()){
			const char *pCmd=szElse.data();
			return parseUserCommand(lpC,&pCmd,pP);
		} else return (_KVI_CMD_parseIf|_KVI_ERR_Success);
	}
	_debug_leavetrace("parseIf");
}
//============ parseWhile ============//
int KviUserParser::parseWhile(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseWhile");
	if(!(**pC))return (_KVI_CMD_parseWhile|_KVI_ERR_MissingExpression);
	if((**pC) != '(')return (_KVI_CMD_parseWhile|_KVI_ERR_UnexpectedChar);
	const char *rghPtr=(*pC);
	int match=1;
	while(match){
		(rghPtr)++;
		if(!(*rghPtr))return (_KVI_CMD_parseWhile|_KVI_ERR_UnexpectedEndInExpr);
		if(*rghPtr=='(')match++;
		if(*rghPtr==')')match--;
	}
	(rghPtr)++;
	if(!(*rghPtr))return (_KVI_CMD_parseWhile|_KVI_ERR_UnexpectedEndInExpr);
	(*pC)++; //skip the first (
	QString szExpr((*pC),(rghPtr-(*pC)));
	(*pC)=rghPtr;
	//Got the expression
	_macro_skipSenselessChars((*pC));
	QString szThen;
	if(!(**pC))return (_KVI_CMD_parseWhile|_KVI_ERR_MissingCommand);
	if(**pC==KVI_CHAR_BEGIN){ //strip up to matching brace
		rghPtr=(*pC);
		match=1;
		while(match){
			(rghPtr)++;
			if(!(*rghPtr))return (_KVI_CMD_parseWhile|_KVI_ERR_UnexpectedEndInCmd);
			if(*rghPtr==KVI_CHAR_BEGIN)match++;
			if(*rghPtr==KVI_CHAR_END)match--;
		}
		(rghPtr)++;
		if(!(*rghPtr))return (_KVI_CMD_parseWhile|_KVI_ERR_UnexpectedEndInCmd);
		szThen=QString((*pC),(rghPtr-(*pC))+1);
		//newline handling....same as in if
		_macro_skipSpacesAndTabs(rghPtr);
		if((*rghPtr !=';')&&(*rghPtr != '\n'))return (_KVI_CMD_parseWhile|_KVI_ERR_MissingSeparator);
		(*pC)=rghPtr;
	} else { //strip up to ;
		rghPtr=(*pC);
		_macro_skipUpToEndOfCmd(rghPtr);
		szThen=QString((*pC),(rghPtr-(*pC))+1);
		(*pC)=rghPtr;
	}
	bool bEvalToTrue=true;
	while(bEvalToTrue){
		const char *pBool=szExpr.data();
		int numErr=evaluateBoolean(lpC,&pBool,&bEvalToTrue,pP,false);
		if(numErr & _KVI_ERR_ErrorMask)return numErr;
		if(bEvalToTrue){
			const char *pCmd=szThen.data();
			numErr=parseUserCommand(lpC,&pCmd,pP);
			if(numErr & _KVI_ERR_ErrorMask)return numErr;
		}
	}
	_debug_leavetrace("parseWhile");
	return (_KVI_CMD_parseWhile|_KVI_ERR_Success);
}
//============ parseJoin ============//
int KviUserParser::parseJoin(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseJoin");
	if(!(**pC))return (_KVI_CMD_parseJoin|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseJoin|_KVI_ERR_MissingChannel);
	if(m_lpSock->sendFmtData("JOIN %s",szCmd.data()))return (_KVI_CMD_parseJoin|_KVI_ERR_NotConnected);
	(*pC)=rghPtr;
	_debug_leavetrace("parseJoin");
	return (_KVI_CMD_parseJoin|_KVI_ERR_Success);
}
//============ parseChat ============//
int KviUserParser::parseChat(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseChat");
	if(!(**pC))return (_KVI_CMD_parseChat|_KVI_ERR_MissingTarget);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseChat|_KVI_ERR_MissingTarget);
	QString szTrg="";
	if(szCmd.find('.') != -1){
		//daemon chat request: ip and port
		szTrg=getStringToken(szCmd,' ');
		szTrg=szTrg.stripWhiteSpace();
		szCmd=szCmd.stripWhiteSpace();
		QString szChatName="[DCC-CHAT]:-"+szTrg;
		if(m_lpMdi->findWindow(szChatName.data())||(szTrg==m_szLastDCCTarget)){
			lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[DCC CHAT] : A previous DCC CHAT to %s already exists"),szTrg.data());
		} else {
			m_szLastDCCTarget=szTrg.copy();
			KviChatWnd *lpW=m_lpFrm->createChatWnd(szChatName.data());
			lpW->connectToDaemon(szCmd,szTrg);
		}
	} else {
		while(!szCmd.isEmpty()){
			szTrg=getStringToken(szCmd,',');
			szTrg=szTrg.stripWhiteSpace();	
			QString szChatName="[DCC-CHAT]:-"+szTrg;
			if(m_lpMdi->findWindow(szChatName.data())||(szTrg==m_szLastDCCTarget)){
				lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[DCC CHAT] : A previous DCC CHAT to %s already exists"),szTrg.data());
			} else {
				m_szLastDCCTarget=szTrg.copy();
				KviChatWnd *lpW=m_lpFrm->createChatWnd(szChatName.data());
				lpW->requestChat(szTrg.data());
			}
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseChat");
	return (_KVI_CMD_parseChat|_KVI_ERR_Success);
}
//============ parseTalk ============//
int KviUserParser::parseTalk(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseTalk");
	if(!(**pC))return (_KVI_CMD_parseTalk|_KVI_ERR_MissingTarget);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseTalk|_KVI_ERR_MissingTarget);
	if(szCmd.find(',') != -1)return (_KVI_CMD_parseTalk|_KVI_ERR_OnlyOneTalkAllowed);
	QString szChatName="[DCC-VOICE]:-"+szCmd;
	if(m_lpFrm->m_lpVoiceWnd)return (_KVI_CMD_parseTalk|_KVI_ERR_OnlyOneTalkAllowed);
	KviVoiceWnd *lpW=m_lpFrm->createVoiceWnd(szChatName.data());
	lpW->requestConnection(szCmd.data());
	(*pC)=rghPtr;
	_debug_leavetrace("parseTalk");
	return (_KVI_CMD_parseTalk|_KVI_ERR_Success);
}
//============ parseQuery ============//
int KviUserParser::parseQuery(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseQuery");
	if(!(**pC))return (_KVI_CMD_parseQuery|_KVI_ERR_MissingTarget);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseQuery|_KVI_ERR_MissingTarget);
	if(!m_lpSock->m_bConnected)return (_KVI_CMD_parseQuery|_KVI_ERR_NotConnected);
	QString szTrg;
	while(!szCmd.isEmpty()){
		szTrg=getStringToken(szCmd,',');
		szTrg=szTrg.stripWhiteSpace();
		//little hack by Anodine
		KviMdiChild *lpW=m_lpMdi->findWindow(szTrg.data());
		if(lpW){
			if(lpW->m_bMinimized)lpW->minimizeWindow();
			lpW->setFocus();
			lpW->raise();
		} else {
			if(szTrg==m_szLastQueryTarget){
				//the window is being created but it is not in the list yet...
				//it can happen when you use for example /QUERY Pragma,Pragma (stupid?...yes , but may happen)
				lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[QUERY] : A previous QUERY to %s already exists"),szTrg.data());			
			} else {
				m_szLastQueryTarget=szTrg.copy();
				KviQueryWnd *lpW=m_lpFrm->createQueryWnd(szTrg.data());	
				lpW->doFmtOutput(KVI_OUT_INTERNAL,i18n("Starting conversation with %s"),szTrg.data());	
			}
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseQuery");
	return (_KVI_CMD_parseQuery|_KVI_ERR_Success);
}
//============ parsePart ============//
int KviUserParser::parsePart(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parsePart");
	if(!(**pC))return (_KVI_CMD_parsePart|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parsePart|_KVI_ERR_MissingChannel);
	if((szCmd[0]!='#')&&(szCmd[0]!='&'))return (_KVI_CMD_parsePart|_KVI_ERR_MissingChannel);
	int idx=szCmd.find(' ');
	if(idx!=-1)szCmd.insert(idx+1,':');
	else {
		if(!m_lpOpt->szPartMsg.isEmpty()){
			szCmd+=" :";szCmd+=m_lpOpt->szPartMsg;m_lpIdentifiers->substitute(lpC,szCmd,pP);
		}
	}
	if(m_lpSock->sendFmtData("PART %s",szCmd.data()))return (_KVI_CMD_parsePart|_KVI_ERR_NotConnected);
	(*pC)=rghPtr;
	_debug_leavetrace("parsePart");
	return (_KVI_CMD_parsePart|_KVI_ERR_Success);
}
//============ parseRaw ============//
int KviUserParser::parseRaw(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseRaw");
	if(!(**pC))return (_KVI_CMD_parseRaw|_KVI_ERR_MissingData);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseRaw|_KVI_ERR_MissingData);
	bool bShowRaw=true;
	if(!strncmp(szCmd.data(),"-s",2)){ //-silent switch
		bShowRaw=false;
		szCmd.remove(0,2);
		szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty())return (_KVI_CMD_parseRaw|_KVI_ERR_MissingData);	
	}
	if(m_lpSock->sendData(szCmd.data()))return (_KVI_CMD_parseRaw|_KVI_ERR_NotConnected);
	if(bShowRaw)m_lpCons->doFmtOutput(KVI_OUT_RAW,i18n("[SENDING TO SERVER] : %s"),szCmd.data());
	(*pC)=rghPtr;
	_debug_leavetrace("parseRaw");
	return (_KVI_CMD_parseRaw|_KVI_ERR_Success);
}
//============ parseNick ============//
int KviUserParser::parseNick(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseNick");
	if(!(**pC))return (_KVI_CMD_parseNick|_KVI_ERR_MissingNick);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseNick|_KVI_ERR_MissingNick);
	if(m_lpSock->sendFmtData("NICK %s",szCmd.data()))return (_KVI_CMD_parseNick|_KVI_ERR_NotConnected);
	(*pC)=rghPtr;
	_debug_leavetrace("parseNick");
	return (_KVI_CMD_parseNick|_KVI_ERR_Success);
}
//============ parseList ============//
int KviUserParser::parseList(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseList");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty()){
		if(m_lpSock->sendData("LIST"))return (_KVI_CMD_parseList|_KVI_ERR_NotConnected);
	} else {
		if(m_lpSock->sendFmtData("LIST %s",szCmd.data()))return (_KVI_CMD_parseList|_KVI_ERR_NotConnected);
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseList");
	return (_KVI_CMD_parseList|_KVI_ERR_Success);
}
//============ parseConnstats ============//
int KviUserParser::parseConnstats(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseConnstats");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	(*pC)=rghPtr;
	if(m_lpGlb->startTime==(time_t)0){
		lpC->doOutput(KVI_OUT_ERROR,i18n("No previous connection : no stats available"));
		return (_KVI_CMD_parseConnstats|_KVI_ERR_Success);	
	}
	lpC->doOutput(KVI_OUT_INTERNAL,i18n("Connection status report:"));
	lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Last server connection to : %s [%s:%s]"),
			m_lpGlb->szServerName.data(),m_lpGlb->szServerIp.data(),m_lpGlb->szPort.data());
	lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Last network              : %s"),m_lpGlb->szNetworkName.data());
	QDateTime start;
	start.setTime_t(m_lpGlb->startTime);
	QDateTime end;
	if(m_lpSock->m_bConnected)end=QDateTime::currentDateTime();
	else end.setTime_t(m_lpGlb->endTime);
	QString szStart=start.toString();
	if(m_lpSock->m_bConnected)lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Connection started at     : %s (in progress)"),szStart.data());
	else {
		lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Connection started at     : %s"),szStart.data());
		QString szEnd=end.toString();
		lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Connection terminated at  : %s"),szEnd.data());
	}
	uint secs=start.secsTo(end);
	if(secs==0)secs=1; //no divisio by 0 thnx
	uint hrs=secs / 3600;
	uint seconds=secs % 3600;
	uint mins=seconds / 60;
	seconds=seconds % 60;
	lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Total time                : %u hrs. %u min. %u sec."),hrs,mins,seconds);
	uint app=m_lpSock->m_uiSentBytes / secs;
	lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Sent bytes                : %u (%u bytes/sec)"),m_lpSock->m_uiSentBytes,app);
	app=m_lpSock->m_uiSentPackets / secs;
	lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Sent packets              : %u (%u packets/sec)"),m_lpSock->m_uiSentPackets,app);
	app=m_lpSock->m_uiReceivedBytes / secs;
	lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Received bytes            : %u (%u bytes/sec)"),m_lpSock->m_uiReceivedBytes,app);
	app=m_lpSock->m_uiReceivedPackets / secs;
	lpC->doFmtOutput(KVI_OUT_INTERNAL,i18n("Received packets          : %u (%u packets/sec)"),m_lpSock->m_uiReceivedPackets,app);
	_debug_leavetrace("parseConnstats");
	return (_KVI_CMD_parseConnstats|_KVI_ERR_Success);
}
//============ parseWhois ============//
int KviUserParser::parseWhois(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseWhois");
	if(!(**pC))return (_KVI_CMD_parseWhois|_KVI_ERR_MissingNick);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseWhois|_KVI_ERR_MissingNick);
	if(szCmd.length()>3){
		if((szCmd[0]=='-')&&(szCmd[1]=='i')&&(szCmd[2]==' ')){
			szCmd.remove(0,3);
			szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseWhois|_KVI_ERR_MissingNick);
			int idxComma=szCmd.find(',');
			QString szFirstNick="";
			if(idxComma != -1){ szFirstNick=szCmd.left(idxComma); }
			else { szFirstNick=szCmd.copy(); }
			szCmd.prepend(" ");
			szCmd.prepend(szFirstNick.data());
		}
	}
	if(m_lpSock->sendFmtData("WHOIS %s",szCmd.data()))return (_KVI_CMD_parseWhois|_KVI_ERR_NotConnected);
	(*pC)=rghPtr;
	_debug_leavetrace("parseWhois");
	return (_KVI_CMD_parseWhois|_KVI_ERR_Success);
}
//============ parseSet ============//
int KviUserParser::parseSet(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseSet");
	if(!(**pC))return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.length()<2)return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
	if(szCmd[0] != '$')return (_KVI_CMD_parseSet|_KVI_ERR_ExpectedVariable);
	if(szCmd[1] == '_')return (_KVI_CMD_parseSet|_KVI_ERR_CantSetSystemVar);
	QString szVariable;
	int idx=szCmd.find(' ');
	if(idx!=-1){
		szVariable=szCmd.left(idx);szCmd.remove(0,idx+1);
		if(szVariable.length()<2)return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
		if(szVariable[1]=='%'){
			if(!strncmp(szVariable.data(),"$%ext_dynamic[",14)){
				szVariable.remove(0,14);
				szVariable.resize(szVariable.length()); //cut the last ]
				szVariable=szVariable.stripWhiteSpace();
				if(szVariable.isEmpty())return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
				if(szVariable[0] != '$')return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
				szVariable.remove(0,1);
				m_lpIdentifiers->substitute(lpC,szVariable,pP);
				szVariable.prepend("$");
			}
			else return (_KVI_CMD_parseSet|_KVI_ERR_CantSetSystemVar);
			if(szVariable.length()<2)return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
			if(szVariable[0] != '$')return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
			if((szVariable[1]=='_')||(szVariable[1]=='%'))return (_KVI_CMD_parseSet|_KVI_ERR_CantSetSystemVar);
		}
		m_lpIdentifiers->substitute(lpC,szCmd,pP);szCmd=szCmd.stripWhiteSpace();
		if(szCmd.find(szVariable.data())!= -1)return (_KVI_CMD_parseSet|_KVI_ERR_InfiniteRecursion);
		if(szCmd.isEmpty())return (_KVI_CMD_parseSet|_KVI_ERR_MissingValue);
	} else return (_KVI_CMD_parseSet|_KVI_ERR_MissingValue);
	if((szVariable[1]>='0')&&(szVariable[1]<='9')&&(szVariable.length()==2)){
		if(!pP)return (_KVI_CMD_parseSet|_KVI_ERR_ThisIsNotAnAlias);
		szVariable.remove(0,1);
		int index=szVariable.toInt();
		pP->param[index]=szCmd.copy();
	} else {
		KviVariable *lpV=0;
		for(lpV=m_lpVarList->first();lpV;lpV=m_lpVarList->next()){
			if(!strcasecmp(lpV->szName.data(),szVariable.data())){
				lpV->szValue=szCmd.copy();
				(*pC)=rghPtr;
				return (_KVI_CMD_parseSet|_KVI_ERR_Success);
			}
		}
		lpV=new KviVariable;
		lpV->szName=szVariable.copy();
		lpV->szValue=szCmd.copy();
		addVariable(lpV);
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseSet");
	return (_KVI_CMD_parseSet|_KVI_ERR_Success);	
}
//============ parseDec ============//
int KviUserParser::parseDec(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseDec");
	if(!(**pC))return (_KVI_CMD_parseDec|_KVI_ERR_MissingVariable);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.length()<2)return (_KVI_CMD_parseDec|_KVI_ERR_MissingVariable);
	if(szCmd[0] != '$')return (_KVI_CMD_parseDec|_KVI_ERR_ExpectedVariable);
	if(szCmd[1] == '_')return (_KVI_CMD_parseDec|_KVI_ERR_CantSetSystemVar);
	if(szCmd[1]=='%'){
		if(!strncmp(szCmd.data(),"$%ext_dynamic[",14)){
			szCmd.remove(0,14);
			szCmd.resize(szCmd.length()); //cut the last ]
			szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseDec|_KVI_ERR_MissingVariable);
			if(szCmd[0] != '$')return (_KVI_CMD_parseDec|_KVI_ERR_MissingVariable);
			szCmd.remove(0,1);
			m_lpIdentifiers->substitute(lpC,szCmd,pP);
			szCmd.prepend("$");
		}
		else return (_KVI_CMD_parseDec|_KVI_ERR_CantSetSystemVar);
		if(szCmd.length()<2)return (_KVI_CMD_parseDec|_KVI_ERR_MissingVariable);
		if(szCmd[0] != '$')return (_KVI_CMD_parseDec|_KVI_ERR_MissingVariable);
		if((szCmd[1]=='_')||(szCmd[1]=='%'))return (_KVI_CMD_parseDec|_KVI_ERR_CantSetSystemVar);
	}
	if((szCmd[1]>='0')&&(szCmd[1]<='9')&&(szCmd.length()==2)){
		if(!pP)return (_KVI_CMD_parseDec|_KVI_ERR_ThisIsNotAnAlias);
		szCmd.remove(0,1);
		int index=szCmd.toInt();
		bool bOk=false;
		long number=pP->param[index].toLong(&bOk);
		if(bOk)pP->param[index].setNum(((long)(number-1)));
	} else {
		KviVariable *lpV=0;
		for(lpV=m_lpVarList->first();lpV;lpV=m_lpVarList->next()){
			if(!strcasecmp(lpV->szName.data(),szCmd.data())){
				bool bOk=false;
				long number=lpV->szValue.toLong(&bOk);
				if(bOk)lpV->szValue.setNum(((long)(number-1)));	
				(*pC)=rghPtr;
				return (_KVI_CMD_parseDec|_KVI_ERR_Success);
			}
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseDec");
	return (_KVI_CMD_parseDec|_KVI_ERR_Success);
}
//============ parseInc ============//
int KviUserParser::parseInc(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseInc");
	if(!(**pC))return (_KVI_CMD_parseInc|_KVI_ERR_MissingVariable);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.length()<2)return (_KVI_CMD_parseInc|_KVI_ERR_MissingVariable);
	if(szCmd[0] != '$')return (_KVI_CMD_parseInc|_KVI_ERR_ExpectedVariable);
	if(szCmd[1] == '_')return (_KVI_CMD_parseInc|_KVI_ERR_CantSetSystemVar);
	if(szCmd[1]=='%'){
		if(!strncmp(szCmd.data(),"$%ext_dynamic[",14)){
			szCmd.remove(0,14);
			szCmd.resize(szCmd.length()); //cut the last ]
			szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseInc|_KVI_ERR_MissingVariable);
			if(szCmd[0] != '$')return (_KVI_CMD_parseInc|_KVI_ERR_MissingVariable);
			szCmd.remove(0,1);
			m_lpIdentifiers->substitute(lpC,szCmd,pP);
			szCmd.prepend("$");
		}
		else return (_KVI_CMD_parseInc|_KVI_ERR_CantSetSystemVar);
		if(szCmd.length()<2)return (_KVI_CMD_parseInc|_KVI_ERR_MissingVariable);
		if(szCmd[0] != '$')return (_KVI_CMD_parseInc|_KVI_ERR_MissingVariable);
		if((szCmd[1]=='_')||(szCmd[1]=='%'))return (_KVI_CMD_parseInc|_KVI_ERR_CantSetSystemVar);
	}
	if((szCmd[1]>='0')&&(szCmd[1]<='9')&&(szCmd.length()==2)){
		if(!pP)return (_KVI_CMD_parseInc|_KVI_ERR_ThisIsNotAnAlias);
		szCmd.remove(0,1);
		int index=szCmd.toInt();
		bool bOk=false;
		long number=pP->param[index].toLong(&bOk);
		if(bOk)pP->param[index].setNum(((long)(number+1)));
	} else {
		KviVariable *lpV=0;
		for(lpV=m_lpVarList->first();lpV;lpV=m_lpVarList->next()){
			if(!strcasecmp(lpV->szName.data(),szCmd.data())){
				bool bOk=false;
				long number=lpV->szValue.toLong(&bOk);
				if(bOk)lpV->szValue.setNum(((long)(number+1)));	
				(*pC)=rghPtr;	
				return (_KVI_CMD_parseInc|_KVI_ERR_Success);
			}
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseInc");
	return (_KVI_CMD_parseInc|_KVI_ERR_Success);
}
//============ parseUnset ============//
int KviUserParser::parseUnset(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseUnset");
	if(!(**pC))return (_KVI_CMD_parseUnset|_KVI_ERR_MissingVariable);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.length()<2)return (_KVI_CMD_parseUnset|_KVI_ERR_MissingVariable);
	if(szCmd[0] != '$')return (_KVI_CMD_parseUnset|_KVI_ERR_ExpectedVariable);
	if(szCmd[1] == '_')return (_KVI_CMD_parseUnset|_KVI_ERR_CantSetSystemVar);
//	int idx=szCmd.find(' ');
//	if(idx!=-1)return (_KVI_CMD_parseUnset|_KVI_ERR_CantUnsetTwo);
	if(szCmd[1]=='%'){
		if(!strncmp(szCmd.data(),"$%ext_dynamic[",14)){
			szCmd.remove(0,14);
			szCmd.resize(szCmd.length()); //cut the last ]
			szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseUnset|_KVI_ERR_MissingVariable);
			if(szCmd[0] != '$')return (_KVI_CMD_parseUnset|_KVI_ERR_MissingVariable);
			szCmd.remove(0,1);
			m_lpIdentifiers->substitute(lpC,szCmd,pP);
			szCmd.prepend("$");
		}
		else return (_KVI_CMD_parseUnset|_KVI_ERR_CantSetSystemVar);
		if(szCmd.length()<2)return (_KVI_CMD_parseUnset|_KVI_ERR_MissingVariable);
		if(szCmd[0] != '$')return (_KVI_CMD_parseUnset|_KVI_ERR_MissingVariable);
		if((szCmd[1]=='_')||(szCmd[1]=='%'))return (_KVI_CMD_parseUnset|_KVI_ERR_CantSetSystemVar);
	}
	if((szCmd[1]>='0')&&(szCmd[1]<='9')&&(szCmd.length()==2)){
		if(!pP)return (_KVI_CMD_parseUnset|_KVI_ERR_ThisIsNotAnAlias);
		szCmd.remove(0,1);
		int index=szCmd.toInt();
		pP->param[index]=KVI_STR_NULL;
	} else {
		KviVariable *lpV=0;
		for(lpV=m_lpVarList->first();lpV;lpV=m_lpVarList->next()){
			if(!strcasecmp(lpV->szName.data(),szCmd.data())){
				m_lpVarList->removeRef(lpV);
				(*pC)=rghPtr;		
				return (_KVI_CMD_parseUnset|_KVI_ERR_Success);
			}
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseUnset");
	return (_KVI_CMD_parseUnset|_KVI_ERR_Success);
}
//============ parseEcho ============//
int KviUserParser::parseEcho(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseEcho");
	if(!(**pC))return (_KVI_CMD_parseEcho|_KVI_ERR_MissingWindow);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseEcho|_KVI_ERR_MissingWindow);
	QString szWindow;
	int idx=szCmd.find(' ');
	if(idx!=-1){
		szWindow=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty())return (_KVI_CMD_parseEcho|_KVI_ERR_MissingText);
	} else return (_KVI_CMD_parseEcho|_KVI_ERR_MissingText);
	KviMdiChild *lpW=m_lpMdi->findWindow(szWindow.data());
	if(lpW){
		lpW->doOutput(KVI_OUT_ECHO,szCmd.data());
		(*pC)=rghPtr;	
		return (_KVI_CMD_parseEcho|_KVI_ERR_Success);
	} else return (_KVI_CMD_parseEcho|_KVI_ERR_WindowNotFound);
	_debug_leavetrace("parseEcho");
}
//============ parseCtcp ============//
int KviUserParser::parseCtcp(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseCtcp");
	if(!(**pC))return (_KVI_CMD_parseCtcp|_KVI_ERR_MissingCtcpType);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseCtcp|_KVI_ERR_MissingCtcpType);
	QString szType="";
	int idx=szCmd.find(' ');
	if(idx!=-1){ //search fot the nick after a space...
		szType=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty())return (_KVI_CMD_parseCtcp|_KVI_ERR_MissingNick);
	} else return (_KVI_CMD_parseCtcp|_KVI_ERR_MissingNick);
	szType=szType.upper();
	QString szTarget=getStringToken(szCmd);
	//szType=CTCP szCmd now contains the target list and optionally the ctcp arguments
	szCmd=szCmd.stripWhiteSpace();
	QString szTrg;
	while(!szTarget.isEmpty()){
		szTrg=getStringToken(szTarget,',');
		if(szType != "PING"){
			if(szCmd.isEmpty()){
				if(m_lpSock->sendFmtData("PRIVMSG %s :%c%s%c",szTrg.data(),0x01,szType.data(),0x01))return (_KVI_CMD_parseCtcp|_KVI_ERR_NotConnected);
			} else {
				if(m_lpSock->sendFmtData("PRIVMSG %s :%c%s %s%c",szTrg.data(),0x01,szType.data(),szCmd.data(),0x01))return (_KVI_CMD_parseCtcp|_KVI_ERR_NotConnected);
			}
		} else {
			if(m_lpSock->sendFmtData("PRIVMSG %s :%cPING %u%c",
				szTrg.data(),0x01,(uint)time(0),0x01))return(_KVI_CMD_parseCtcp|_KVI_ERR_NotConnected);
 		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseCtcp");
	return (_KVI_CMD_parseCtcp|_KVI_ERR_Success);
}
//============ parseMe ============//
int KviUserParser::parseMe(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseMe");
	if(!(**pC))return (_KVI_CMD_parseMe|_KVI_ERR_MissingText);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseMe|_KVI_ERR_MissingText);
	if((lpC->type()==KVI_WND_TYPE_CHAN)||(lpC->type()==KVI_WND_TYPE_QUERY)){
		if(m_lpSock->sendFmtData("PRIVMSG %s :%cACTION %s%c",lpC->name(),0x01,szCmd.data(),0x01))return (_KVI_CMD_parseMe|_KVI_ERR_NotConnected);
		lpC->doFmtOutput(KVI_OUT_ACTION,"%s %s",m_lpGlb->szNick.data(),szCmd.data());
	} else if(lpC->type()==KVI_WND_TYPE_CHAT){
		if(!((KviChatWnd *)lpC)->m_bConnected)return (_KVI_CMD_parseMe|_KVI_ERR_NotConnected);
		QString szDCCCmd;
		szDCCCmd+=0x01;
		szDCCCmd+="ACTION ";
		szDCCCmd+=szCmd.data();
		szDCCCmd+=0x01;
		lpC->sendData(szDCCCmd.data());
		lpC->doFmtOutput(KVI_OUT_ACTION,"%s %s",m_lpGlb->szNick.data(),szCmd.data());
	} else return (_KVI_CMD_parseMe|_KVI_ERR_NonChannelAction);
	(*pC)=rghPtr;
	_debug_leavetrace("parseMe");
	return (_KVI_CMD_parseMe|_KVI_ERR_Success);
}
//============ parseNotice ============//
int KviUserParser::parseNotice(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseNotice");
	if(!(**pC))return (_KVI_CMD_parseNotice|_KVI_ERR_MissingTarget);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())return (_KVI_CMD_parseNotice|_KVI_ERR_MissingTarget);
	QString szTarget;
	int idx=szCmd.find(' ');
	if(idx!=-1){
		szTarget=szCmd.left(idx);
		m_lpIdentifiers->substitute(lpC,szTarget,pP);
		szTarget=szTarget.stripWhiteSpace();
		szCmd.remove(0,idx+1);
		szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty())return (_KVI_CMD_parseNotice|_KVI_ERR_MissingText);
	} else return (_KVI_CMD_parseNotice|_KVI_ERR_MissingText);
	QString szTrg;
	while(!szTarget.isEmpty()){
		szTrg=getStringToken(szTarget,',');
		KviMdiChild *lpW=m_lpMdi->findWindow(szTrg.data());
		m_lpIdentifiers->substitute(lpC,szCmd,pP);
		if(m_lpSock->sendFmtData("NOTICE %s :%s",szTrg.data(),szCmd.data()))return (_KVI_CMD_parseNotice|_KVI_ERR_NotConnected);		
		if(lpW){
			if((lpW->type()==KVI_WND_TYPE_QUERY)||(lpW->type()==KVI_WND_TYPE_CHAN)){
				QString szNicko;
				m_lpFrm->formatNickOutputString(szNicko,m_lpGlb->szNick);
				lpW->doFmtOutput(KVI_OUT_NOTICE,"%s%s",szNicko.data(),szCmd.data());
			} else {
				lpC->doFmtOutput(KVI_OUT_NOTICE,"[>> %s >>] : %s",szTrg.data(),szCmd.data());	
			}
		} else {
			lpC->doFmtOutput(KVI_OUT_NOTICE,"[>> %s >>] : %s",szTrg.data(),szCmd.data());	
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseNotice");
	return (_KVI_CMD_parseNotice|_KVI_ERR_Success);
}
//============ parseSay ============//
int KviUserParser::parseSay(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseSay");
	if(!(**pC))return (_KVI_CMD_parseSay|_KVI_ERR_MissingWindow);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	m_lpIdentifiers->substitute(lpC,szCmd,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseSay|_KVI_ERR_MissingWindow);
	QString szTarget;
	int idx=szCmd.find(' ');
	if(idx!=-1){
		szTarget=szCmd.left(idx);
//		m_lpIdentifiers->substitute(lpC,szTarget,pP);
		szTarget=szTarget.stripWhiteSpace();
		szCmd.remove(0,idx+1);
		szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty())return (_KVI_CMD_parseSay|_KVI_ERR_MissingText);
	} else return (_KVI_CMD_parseSay|_KVI_ERR_MissingText);
	QString szTrg;
	while(!szTarget.isEmpty()){
		szTrg=getStringToken(szTarget,',');
		KviMdiChild *lpW=m_lpMdi->findWindow(szTrg.data());
//		m_lpIdentifiers->substitute(lpC,szCmd,pP);
		if(lpW){
			if( ((lpW->type())==KVI_WND_TYPE_CHAT)||((lpW->type())==KVI_WND_TYPE_CHAN)||
				((lpW->type())==KVI_WND_TYPE_QUERY) )parseUserInput(lpW,lpW->type(),lpW->name(),szCmd);
			else {
				if(m_lpSock->sendFmtData("PRIVMSG %s :%s",szTrg.data(),szCmd.data()))return (_KVI_CMD_parseSay|_KVI_ERR_NotConnected);
				lpC->doFmtOutput(KVI_OUT_PRIVMSG,"[>> %s >>] : %s",szTrg.data(),szCmd.data());		
			}
		} else {
			if(m_lpSock->sendFmtData("PRIVMSG %s :%s",szTrg.data(),szCmd.data()))return (_KVI_CMD_parseSay|_KVI_ERR_NotConnected);	
			lpC->doFmtOutput(KVI_OUT_PRIVMSG,"[>> %s >>] : %s",szTrg.data(),szCmd.data());	
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseSay");
	return (_KVI_CMD_parseSay|_KVI_ERR_Success);
}
//============ parseTopic ============//
int KviUserParser::parseTopic(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseTopic");
	if(!(**pC))return (_KVI_CMD_parseTopic|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseTopic|_KVI_ERR_MissingChannel);
	QString szChannel;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		int idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())szCmd=" ";
		} else {szChannel=szCmd;szCmd=" ";}
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseTopic|_KVI_ERR_NotOnChannel);
	}
	if(m_lpSock->sendFmtData("TOPIC %s :%s",szChannel.data(),szCmd.data()))return (_KVI_CMD_parseTopic|_KVI_ERR_NotConnected);
	(*pC)=rghPtr;
	_debug_leavetrace("parseTopic");
	return (_KVI_CMD_parseTopic|_KVI_ERR_Success);
}
//============ parseMode ============//
int KviUserParser::parseMode(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseMode");
	if(!(**pC))return (_KVI_CMD_parseMode|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	m_lpIdentifiers->substitute(lpC,szCmd,pP);szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())return (_KVI_CMD_parseMode|_KVI_ERR_MissingChannel);
	QString szChannel;
	int idx=szCmd.find(' ');
	if(idx != -1){
		szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty())return (_KVI_CMD_parseMode|_KVI_ERR_MissingMode);
	} else return (_KVI_CMD_parseMode|_KVI_ERR_MissingMode);
	if(m_lpSock->sendFmtData("MODE %s %s",szChannel.data(),szCmd.data()))return (_KVI_CMD_parseMode|_KVI_ERR_NotConnected);
	(*pC)=rghPtr;
	_debug_leavetrace("parseMode");
	return (_KVI_CMD_parseMode|_KVI_ERR_Success);
}
//============ parseKick ============//
int KviUserParser::parseKick(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseKick");
	if(!(**pC))return (_KVI_CMD_parseKick|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseKick|_KVI_ERR_MissingChannel);
	QString szChannel;
	int idx=0;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseKick|_KVI_ERR_MissingNick);
		} else return (_KVI_CMD_parseKick|_KVI_ERR_MissingNick);
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseKick|_KVI_ERR_NotOnChannel);
	}
	QString szTrg;
	idx=szCmd.find(' ');
	if(idx != -1){
		szTrg=szCmd.left(idx);
		szCmd.remove(0,idx+1);
		szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty()){
			if(m_lpOpt->szKickMsg.isEmpty())szCmd="Bye";
			else {szCmd=m_lpOpt->szKickMsg;m_lpIdentifiers->substitute(lpC,szCmd,pP);}
		}
	} else {
		szTrg=szCmd.copy();
		if(m_lpOpt->szKickMsg.isEmpty())szCmd="Bye";
		else { szCmd=m_lpOpt->szKickMsg;m_lpIdentifiers->substitute(lpC,szCmd,pP);}
	}
	QString szTarget;
	while(!szTrg.isEmpty()){
		szTarget=getStringToken(szTrg,',');
		if(m_lpSock->sendFmtData("KICK %s %s :%s",szChannel.data(),szTarget.data(),szCmd.data()))return (_KVI_CMD_parseKick|_KVI_ERR_NotConnected);
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseKick");
	return (_KVI_CMD_parseKick|_KVI_ERR_Success);
}
//============ parseOp ============//
int KviUserParser::parseOp(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseOp");
	if(!(**pC))return (_KVI_CMD_parseOp|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseOp|_KVI_ERR_MissingChannel);
	QString szChannel;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		int idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseOp|_KVI_ERR_MissingNick);
		} else return (_KVI_CMD_parseOp|_KVI_ERR_MissingNick);
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseOp|_KVI_ERR_NotOnChannel);
	}
	int numError=executeMode(szChannel,szCmd,true,'o');
	if(numError & _KVI_ERR_ErrorMask)return numError;
	(*pC)=rghPtr;
	_debug_leavetrace("parseOp");
	return (_KVI_CMD_parseOp|_KVI_ERR_Success);
}
//============ parseDeop ============//
int KviUserParser::parseDeop(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseDeop");
	if(!(**pC))return (_KVI_CMD_parseDeop|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseDeop|_KVI_ERR_MissingChannel);
	QString szChannel;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		int idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseDeop|_KVI_ERR_MissingNick);
		} else return (_KVI_CMD_parseDeop|_KVI_ERR_MissingNick);
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseDeop|_KVI_ERR_NotOnChannel);
	}
	int numError=executeMode(szChannel,szCmd,false,'o');
	if(numError & _KVI_ERR_ErrorMask)return numError;
	(*pC)=rghPtr;
	_debug_leavetrace("parseDeop");
	return (_KVI_CMD_parseDeop|_KVI_ERR_Success);
}
//============ parseBan ============//
int KviUserParser::parseBan(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseBan");
	if(!(**pC))return (_KVI_CMD_parseBan|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseBan|_KVI_ERR_MissingChannel);
	QString szChannel;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		int idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseBan|_KVI_ERR_MissingNick);
		} else return (_KVI_CMD_parseBan|_KVI_ERR_MissingNick);
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseBan|_KVI_ERR_NotOnChannel);
	}
	int numError=executeMode(szChannel,szCmd,true,'b');
	if(numError & _KVI_ERR_ErrorMask)return numError;
	(*pC)=rghPtr;
	_debug_leavetrace("parseBan");
	return (_KVI_CMD_parseBan|_KVI_ERR_Success);
}
//============ parseUnban ============//
int KviUserParser::parseUnban(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseUnban");
	if(!(**pC))return (_KVI_CMD_parseUnban|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseUnban|_KVI_ERR_MissingChannel);
	QString szChannel;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		int idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseUnban|_KVI_ERR_MissingNick);
		} else return (_KVI_CMD_parseUnban|_KVI_ERR_MissingNick);
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseUnban|_KVI_ERR_NotOnChannel);
	}
	int numError=executeMode(szChannel,szCmd,false,'b');
	if(numError & _KVI_ERR_ErrorMask)return numError;
	(*pC)=rghPtr;
	_debug_leavetrace("parseUnban");
	return (_KVI_CMD_parseUnban|_KVI_ERR_Success);
}
//============ parseVoice ============//
int KviUserParser::parseVoice(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseVoice");
	if(!(**pC))return (_KVI_CMD_parseVoice|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseVoice|_KVI_ERR_MissingChannel);
	QString szChannel;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		int idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseVoice|_KVI_ERR_MissingNick);
		} else return (_KVI_CMD_parseVoice|_KVI_ERR_MissingNick);
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseVoice|_KVI_ERR_NotOnChannel);
	}
	int numError=executeMode(szChannel,szCmd,true,'v');
	if(numError & _KVI_ERR_ErrorMask)return numError;
	(*pC)=rghPtr;
	_debug_leavetrace("parseVoice");
	return (_KVI_CMD_parseVoice|_KVI_ERR_Success);
}
//============ parseDevoice ============//
int KviUserParser::parseDevoice(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseDevoice");
	if(!(**pC))return (_KVI_CMD_parseDevoice|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseDevoice|_KVI_ERR_MissingChannel);
	QString szChannel;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		int idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseDevoice|_KVI_ERR_MissingNick);
		} else return (_KVI_CMD_parseDevoice|_KVI_ERR_MissingNick);
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseDevoice|_KVI_ERR_NotOnChannel);
	}
	int numError=executeMode(szChannel,szCmd,false,'v');
	if(numError & _KVI_ERR_ErrorMask)return numError;
	(*pC)=rghPtr;
	_debug_leavetrace("parseDevoice");
	return (_KVI_CMD_parseDevoice|_KVI_ERR_Success);
}
//============ parseHelp ============//
int KviUserParser::parseHelp(KviMdiChild *lpC,const char ** pC,KviAliasParams *)
{
	_debug_entertrace("parseHelp");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	(*pC)=rghPtr;
	QString szTrg;
	szCmd=szCmd.stripWhiteSpace();
	m_lpHelp->doHelp(lpC,szCmd);
	_debug_leavetrace("parseHelp");
	return (_KVI_CMD_parseHelp|_KVI_ERR_Success);
}
//============ parseSend ============//
int KviUserParser::parseSend(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseSend");
	if(!(**pC))return (_KVI_CMD_parseSend|_KVI_ERR_MissingTarget);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseSend|_KVI_ERR_MissingTarget);
	QString szTargets=getStringToken(szCmd);
	szCmd=szCmd.stripWhiteSpace();
	QString szTrg="";
	if(szTargets.find('.') != -1){
		//daemon chat request: ip and port
		szCmd=szCmd.stripWhiteSpace();
		QString szPort=getStringToken(szCmd);
		if(szPort.isEmpty())return (_KVI_CMD_parseSend|_KVI_ERR_MissingTarget);
		szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty()){
			QString szSnd=i18n("Choose a file to send to ");
			szSnd+=szTargets;
			m_lpFrm->m_bFocusManagingEnabled=false;
			szCmd=QString(_macro_getOpenFileName(szSnd.data(),0,0));
			m_lpFrm->m_bFocusManagingEnabled=true;
		}
		if((!szCmd.isEmpty())&&(szCmd.right(1) != "/")){
			QString szSendName="[DCC-SEND]:-"+szTargets+" "+szCmd;
			if(m_lpMdi->findWindow(szSendName.data())||(szSendName==m_szLastSendTarget)){
				lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[DCC SEND] : A previous DCC SEND with the same file name to %s already exists"),szTargets.data());
			} else {
				m_szLastSendTarget=szSendName.copy();
				KviSendWnd *lpW=m_lpFrm->createSendWnd(szSendName.data(),m_lpOpt->bMinimizeDCCSend);
				lpW->sendToDaemon(szPort,szTargets,szCmd.data());
			}
		} else {
			if(szCmd.right(1)=="/")return (_KVI_CMD_parseSend|_KVI_ERR_MissingFileName);
		}
	} else {
		while(!szTargets.isEmpty()){
			szTrg=getStringToken(szTargets,',');
			szTrg=szTrg.stripWhiteSpace();
			if(szCmd.isEmpty()){
				QString szSnd=i18n("Choose a file to send to ");
				szSnd+=szTrg;
				m_lpFrm->m_bFocusManagingEnabled=false;
				szCmd=QString(_macro_getOpenFileName(szSnd.data(),0,0));
				m_lpFrm->m_bFocusManagingEnabled=true;
			}
			if((!szCmd.isEmpty())&&(szCmd.right(1) != "/")){
				QString szSendName="[DCC-SEND]:-"+szTrg+" "+szCmd;
				if(m_lpMdi->findWindow(szSendName.data())||(szSendName==m_szLastSendTarget)){
					lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[DCC SEND] : A previous DCC SEND with the same file name to %s already exists"),szTrg.data());
				} else {
					m_szLastSendTarget=szSendName.copy();
					KviSendWnd *lpW=m_lpFrm->createSendWnd(szSendName.data(),m_lpOpt->bMinimizeDCCSend);
					lpW->requestSend(szTrg.data(),szCmd.data());
				}
			} else {
				if(szCmd.right(1)=="/")return (_KVI_CMD_parseSend|_KVI_ERR_MissingFileName);
				else break;
			}
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseSend");
	return (_KVI_CMD_parseSend|_KVI_ERR_Success);
}
//============ parseKick ============//
int KviUserParser::parseKban(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseKban");
	if(!(**pC))return (_KVI_CMD_parseKban|_KVI_ERR_MissingChannel);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseKban|_KVI_ERR_MissingChannel);
	QString szChannel;
	int idx=0;
	if((szCmd[0]=='#')||(szCmd[0]=='&')){
		idx=szCmd.find(' ');
		if(idx != -1){
			szChannel=szCmd.left(idx);szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();
			if(szCmd.isEmpty())return (_KVI_CMD_parseKban|_KVI_ERR_MissingNick);
		} else return (_KVI_CMD_parseKban|_KVI_ERR_MissingNick);
	} else {
		if(lpC->type()==KVI_WND_TYPE_CHAN)szChannel=lpC->name();
		else return (_KVI_CMD_parseKban|_KVI_ERR_NotOnChannel);
	}
	QString szTrg;
	idx=szCmd.find(' ');
	if(idx != -1){
		szTrg=szCmd.left(idx);
		szCmd.remove(0,idx+1);
		szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty()){
			if(m_lpOpt->szKickMsg.isEmpty())szCmd="Bye";
			else {szCmd=m_lpOpt->szKickMsg;m_lpIdentifiers->substitute(lpC,szCmd,pP);}
		}
	} else {
		szTrg=szCmd.copy();
		if(m_lpOpt->szKickMsg.isEmpty())szCmd="Bye";
		else { szCmd=m_lpOpt->szKickMsg;m_lpIdentifiers->substitute(lpC,szCmd,pP);}
	}
	QString szTarget;
	while(!szTrg.isEmpty()){
		szTarget=getStringToken(szTrg,',');
		if(m_lpSock->sendFmtData("KICK %s %s :%s",szChannel.data(),szTarget.data(),szCmd.data()))return (_KVI_CMD_parseKban|_KVI_ERR_NotConnected);
		m_lpSock->sendFmtData("MODE %s +b %s",szChannel.data(),szTarget.data());
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseKban");
	return (_KVI_CMD_parseKban|_KVI_ERR_Success);
}
//============ parseWhowas ============//
int KviUserParser::parseWhowas(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseWhowas");
	if(!(**pC))return (_KVI_CMD_parseWhowas|_KVI_ERR_MissingNick);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseWhowas|_KVI_ERR_MissingNick);
	int idx=szCmd.find(' ');
	QString szTrg;
	if(idx == -1){ szTrg=szCmd.copy(); szCmd=""; }
	else { szTrg=szCmd.left(idx); szCmd.remove(0,idx+1); }
	szCmd=szCmd.stripWhiteSpace();
	QString szT;
	while(!szTrg.isEmpty()){
		szT=getStringToken(szTrg,',');
		if(szCmd.isEmpty()){
			if(m_lpSock->sendFmtData("WHOWAS %s",szT.data()))return (_KVI_CMD_parseWhowas|_KVI_ERR_NotConnected);
		} else {
			if(m_lpSock->sendFmtData("WHOWAS %s %s",szT.data(),szCmd.data()))return (_KVI_CMD_parseWhowas|_KVI_ERR_NotConnected);
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseWhowas");
	return (_KVI_CMD_parseWhowas|_KVI_ERR_Success);
}
//============ parseUserlist ============//
int KviUserParser::parseUserlist(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseUserlist");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd="";
	if(**pC){
		szCmd=QString((*pC),(rghPtr-(*pC))+1);
		m_lpIdentifiers->substitute(lpC,szCmd,pP);szCmd=szCmd.stripWhiteSpace();
	}
	QString szChan="";
	if(szCmd.isEmpty()){
		if(lpC->type() != KVI_WND_TYPE_CHAN)return (_KVI_CMD_parseUserlist|_KVI_ERR_NotOnChannel);
		else szChan=lpC->name();
	} else {
		if(szCmd[0]=='#' || szCmd[0]=='&'){
			int idx=szCmd.find(' ');
			if(idx != -1){ szChan=szCmd.left(idx); szCmd.remove(0,idx+1); }
			else { szChan=szCmd.copy(); szCmd=""; }
		} else {
			if(lpC->type() != KVI_WND_TYPE_CHAN)return (_KVI_CMD_parseUserlist|_KVI_ERR_NotOnChannel);
			else szChan=lpC->name();
		}
	}
	QString szTrg;
	KviChanWnd *lpWnd=0;
	KviMdiChild *lpChild=0;
	if(!szChan.isEmpty()){
		lpChild=m_lpMdi->findWindow(szChan.data());
		if(!lpChild)return (_KVI_CMD_parseUserlist|_KVI_ERR_WindowNotFound);
		if(lpChild->type() != KVI_WND_TYPE_CHAN)return (_KVI_CMD_parseUserlist|_KVI_ERR_NotOnChannel);
		lpWnd=(KviChanWnd *)lpChild;
	} else return (_KVI_CMD_parseUserlist|_KVI_ERR_NotOnChannel);
	if(!szCmd.isEmpty()){
		while(!szCmd.isEmpty()){
			szTrg=getStringToken(szCmd,',');
			szTrg=szTrg.stripWhiteSpace();
			KviNewNick *lpN=lpWnd->getNick(szTrg.data());
			if(lpN){
				QString szWho="[ USER : ";
				szWho+=szTrg;
				if(szWho.length()<19)szWho.setExpand(18,' ');
				szWho+=" ] is ";
				szWho+=lpN->szNick;
				szWho+='!';
				szWho+=lpN->szUserName;
				szWho+='@';
				szWho+=lpN->szAddress;
				lpC->doOutput(KVI_OUT_WHO,szWho.data());
			} else {
				lpC->doFmtOutput(KVI_OUT_ERROR,i18n("User %s not found on %s"),szTrg.data(),szChan.data());
			}
		}
	} else {
		lpWnd->doUserList();
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseUserlist");
	return (_KVI_CMD_parseUserlist|_KVI_ERR_Success);
}
//============ parseClonescan ============//
int KviUserParser::parseClonescan(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseClonescan");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd="";
	if(**pC){
		szCmd=QString((*pC),(rghPtr-(*pC))+1);
		m_lpIdentifiers->substitute(lpC,szCmd,pP);szCmd=szCmd.stripWhiteSpace();
	}
	QString szChan="";
	if(szCmd.isEmpty()){
		if(lpC->type() != KVI_WND_TYPE_CHAN)return (_KVI_CMD_parseClonescan|_KVI_ERR_NotOnChannel);
		else szChan=lpC->name();
	} else {
		if(szCmd[0]=='#' || szCmd[0]=='&'){
			szChan=getStringToken(szCmd);
		} else {
			if(lpC->type() != KVI_WND_TYPE_CHAN)return (_KVI_CMD_parseClonescan|_KVI_ERR_NotOnChannel);
			else szChan=lpC->name();
		}
	}
	QString szTrg;
	KviChanWnd *lpWnd=0;
	KviMdiChild *lpChild=0;
	if(!szChan.isEmpty()){
		lpChild=m_lpMdi->findWindow(szChan.data());
		if(!lpChild)return (_KVI_CMD_parseClonescan|_KVI_ERR_WindowNotFound);
		if(lpChild->type() != KVI_WND_TYPE_CHAN)return (_KVI_CMD_parseClonescan|_KVI_ERR_NotOnChannel);
		lpWnd=(KviChanWnd *)lpChild;
	} else return (_KVI_CMD_parseClonescan|_KVI_ERR_NotOnChannel);
	bool bFound=false;
	if(!szCmd.isEmpty()){
		while(!szCmd.isEmpty()){
			szTrg=getStringToken(szCmd,',');
			szTrg=szTrg.stripWhiteSpace();
			KviNewNick *lpN=lpWnd->getNick(szTrg.data());
			bFound=lpWnd->doSingleCloneScan(lpN);
		}
		if(!bFound)lpC->doOutput(KVI_OUT_CLONE,i18n("CLONESCAN TERMINATED : No clones found"));
	} else {
		lpWnd->doGlobalCloneScan();
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseClonescan");
	return (_KVI_CMD_parseClonescan|_KVI_ERR_Success);
}
//============ parseTimer ============//
// timer start|stop|list|killall <name> 
int KviUserParser::parseTimer(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseTimer");
	if(!(**pC))return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerName);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	m_lpIdentifiers->substitute(lpC,szCmd,pP);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerName);
	int idx=szCmd.find(' ');
	QString szOperation;
	if(idx != -1){ szOperation=szCmd.left(idx); szCmd.remove(0,idx+1); }
	else { szOperation=szCmd; szCmd=""; }
	if(!strncasecmp(szOperation.data(),"start",5)){
		if(szCmd.isEmpty())return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerName);
		int idx=szCmd.find(' ');
		if(idx != -1){
			QString szTimerName=szCmd.left(idx);
			szCmd.remove(0,idx+1);
			szCmd=szCmd.stripWhiteSpace();
			idx=szCmd.find(' ');
			if(idx != -1){
				QString szTimeout=szCmd.left(idx);
				szCmd.remove(0,idx+1);
				szCmd=szCmd.stripWhiteSpace();
				bool bOK=false;
				uint iTimeout=szTimeout.toUInt(&bOK);
				if(bOK){
					if(iTimeout<100)return (_KVI_CMD_parseTimer|_KVI_ERR_TooSmallTimeout);
					if(szCmd.isEmpty())return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerCommand);
					szCmd+=';'; //terminate the command...need it (?)
					m_lpTimerManager->startNamedTimer(szTimerName.data(),szCmd.data(),lpC,iTimeout);
				} else return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerTime);
			} else return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerCommand);
		} else return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerTime);	
	} else if(!strncasecmp(szOperation.data(),"shot",4)){
		if(szCmd.isEmpty())return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerTime);
		int idx=szCmd.find(' ');
		if(idx != -1){
			QString szTimeout=szCmd.left(idx);
			szCmd.remove(0,idx+1);
			szCmd=szCmd.stripWhiteSpace();
			bool bOK=false;
			uint iTimeout=szTimeout.toUInt(&bOK);
			if(bOK){
				if(iTimeout<100)return (_KVI_CMD_parseTimer|_KVI_ERR_TooSmallTimeout);
				if(szCmd.isEmpty())return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerCommand);
				szCmd+=';'; //terminate the command...need it (?)
				m_lpTimerManager->startNamedTimer("_SINGLE SHOT_",szCmd.data(),lpC,iTimeout);
			} else return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerTime);
		} else return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerCommand);	
	} else if(!strncasecmp(szOperation.data(),"stop",4)){
		szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty())return (_KVI_CMD_parseTimer|_KVI_ERR_MissingTimerName);
		m_lpTimerManager->stopTimer(szCmd.data());
	} else if(!strncasecmp(szOperation.data(),"list",4)){
		KviTimerStruct *lpT=0;
		if(m_lpTimerManager->m_lpTimerList->isEmpty()){
			lpC->doOutput(KVI_OUT_TIME,i18n("Timer list : No active timers."));
		} else {
			for(lpT=m_lpTimerManager->m_lpTimerList->first();lpT;lpT=m_lpTimerManager->m_lpTimerList->next()){
				lpC->doFmtOutput(KVI_OUT_TIME,i18n("Timer : [%s] Timeout : %d msec. Window : %s Command : %s"),
						lpT->szName.data(),lpT->interval,lpT->lpWindow->name(),lpT->szCommand.data());
			}
		}
	} else if(!strncasecmp(szOperation.data(),"kill",4)){
		m_lpTimerManager->stopAllTimers();
	} else return (_KVI_CMD_parseTimer|_KVI_ERR_UnknownTimerCmd);
	(*pC)=rghPtr;
	_debug_leavetrace("parseTimer");
	return (_KVI_CMD_parseTimer|_KVI_ERR_Success);
}
//============ parseRun ============//
int KviUserParser::parseRun(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseRun");
	if(!(**pC))return (_KVI_CMD_parseRun|_KVI_ERR_MissingProcName);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseRun|_KVI_ERR_MissingProcName);
	m_lpProcessManager->runProcess(szCmd.data());
	(*pC)=rghPtr;
	_debug_leavetrace("parseRun");
	return (_KVI_CMD_parseRun|_KVI_ERR_Success);
}
//============ parseExec ============//
int KviUserParser::parseExec(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseExec");
	if(!(**pC))return (_KVI_CMD_parseExec|_KVI_ERR_MissingProcName);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseExec|_KVI_ERR_MissingProcName);
	m_lpProcessManager->execProcess(szCmd.data());
	(*pC)=rghPtr;
	_debug_leavetrace("parseExec");
	return (_KVI_CMD_parseExec|_KVI_ERR_Success);
}
//============ parseProclist ============//
int KviUserParser::parseProclist(KviMdiChild *lpC,const char ** pC,KviAliasParams *)
{
	_debug_entertrace("parseProclist");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	KviProcParams *lpP=0;
	if(m_lpProcessManager->m_lpProcList->isEmpty()){
		lpC->doFmtOutput(KVI_OUT_STDIN,i18n("Proclist : No processes running."));
	} else {
		for(lpP=m_lpProcessManager->m_lpProcList->first();lpP;lpP=m_lpProcessManager->m_lpProcList->next()){
			lpC->doFmtOutput(KVI_OUT_STDIN,i18n("Pid : %d  Commandline : %s"),lpP->lpProc->getPid(),lpP->szCmdLine.data());
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseProclist");
	return (_KVI_CMD_parseProclist|_KVI_ERR_Success);
}
//============ parseKillproc ============//
int KviUserParser::parseKillproc(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseKillproc");
	if(!(**pC))return (_KVI_CMD_parseKillproc|_KVI_ERR_MissingProcPid);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseKillproc|_KVI_ERR_MissingProcPid);
	if(!strcasecmp(szCmd.data(),"all")){
		m_lpProcessManager->killAll();
	} else {
		bool bOK=false;
		int aPid=szCmd.toInt(&bOK);
		if(!bOK)return (_KVI_CMD_parseKillproc|_KVI_ERR_MissingProcPid);
		m_lpProcessManager->killProcess(aPid);
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseKillproc");
	return (_KVI_CMD_parseKillproc|_KVI_ERR_Success);
}
//============ parseWriteproc ============//
int KviUserParser::parseWriteproc(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseWriteproc");
	if(!(**pC))return (_KVI_CMD_parseWriteproc|_KVI_ERR_MissingProcPid);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseWriteproc|_KVI_ERR_MissingProcPid);
	int idx=szCmd.find(' ');
	QString szPid;
	if(idx==-1){ szPid=szCmd.copy(); szCmd=""; }
	else { szPid=szCmd.left(idx); szCmd.remove(0,idx+1); szCmd=szCmd.stripWhiteSpace(); }
	bool bOK=false;
	int aPid=szPid.toInt(&bOK);
	if(!bOK)return (_KVI_CMD_parseWriteproc|_KVI_ERR_MissingProcPid);
	//Append a LF to the end of the string...maybe
	//Make it optional for next version
	szCmd+='\n';
	m_lpProcessManager->writeProcess(aPid,szCmd.data());
	(*pC)=rghPtr;
	_debug_leavetrace("parseWriteproc");
	return (_KVI_CMD_parseWriteproc|_KVI_ERR_Success);
}
//============ parsePlay ============//
int KviUserParser::parsePlay(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parsePlay");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty()){
		QString szHome(_macro_getKVircHomeDirectory("Audio"));
		szCmd=QString(_macro_getOpenFileName(i18n("Choose an audio file..."),szHome.data(),
			i18n("*.wav|Wav files (*.wav)\n*.mp3|Mpeg audio file (*.mp3)\n*.au|Sun audio files (*.au)\n*.mid|Midi files (*.mid)\n*.*|All files")));
		if(szCmd.isEmpty())return (_KVI_CMD_parsePlay|_KVI_ERR_Success);
	}
	switch(m_lpFrm->m_lpAudio->playSound(szCmd.data())){
		case KVI_AUDIO_FILE_NOT_FOUND:
			lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[PLAY] : Sound file %s not found"),szCmd.data());
			break;
		case KVI_AUDIO_NO_SOUND_SERVER:
			lpC->doOutput(KVI_OUT_ERROR,i18n("[PLAY] : Sound server not active or not ready."));
			break;
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parsePlay");
	return (_KVI_CMD_parsePlay|_KVI_ERR_Success);
}
//============ parseHalt ============//
int KviUserParser::parseHalt(KviMdiChild *,const char **,KviAliasParams *)
{
	_debug_entertrace("parseHalt");
	_debug_leavetrace("parseHalt");
	return (_KVI_CMD_parseHalt|_KVI_ERR_Halt);
}
//============ parseServer ============//
int KviUserParser::parseServer(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseServer");
	if(!(**pC))return (_KVI_CMD_parseServer|_KVI_ERR_MissingServer);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseServer|_KVI_ERR_MissingServer);
	int idx=szCmd.find(' ');
	QString szServer;
	int iPort=6667;
	if(idx!=-1){
		szServer=szCmd.left(idx);
		szCmd.remove(0,idx+1);
		szCmd=szCmd.stripWhiteSpace();
		bool bOK=false;
		iPort=szCmd.toInt(&bOK);
		if(!bOK)iPort=6667;
	} else szServer=szCmd;
	m_lpFrm->hopServer(szServer,iPort);
	(*pC)=rghPtr;
	_debug_leavetrace("parseServer");
	return (_KVI_CMD_parseServer|_KVI_ERR_Success);
}
//============ parseAway ============//
int KviUserParser::parseAway(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseAway");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())szCmd=m_lpOpt->szAwayMsg.stripWhiteSpace();
	if(szCmd.isEmpty())szCmd="Away since $_date $_time";
	m_lpIdentifiers->substitute(lpC,szCmd,pP);
	if(m_lpSock->sendFmtData("AWAY :%s",szCmd.data()))return (_KVI_CMD_parseAway|_KVI_ERR_NotConnected);
	(*pC)=rghPtr;
	_debug_leavetrace("parseAway");
	return (_KVI_CMD_parseAway|_KVI_ERR_Success);
}
//============ parseBack ============//
int KviUserParser::parseBack(KviMdiChild *,const char ** pC,KviAliasParams *)
{
	_debug_entertrace("parseBack");
	_macro_skipUpToEndOfCmd((*pC));
	if(m_lpSock->sendData("AWAY"))return (_KVI_CMD_parseBack|_KVI_ERR_NotConnected);
	_debug_leavetrace("parseBack");
	return (_KVI_CMD_parseBack|_KVI_ERR_Success);
}
//============ parseWindow ============//
//WINDOW [open|close|hide|show] <@name> noinput hidden noclose size=x,y,w,h background=file.ext
// images=true|false timestamp=true|false font=font_name,size
int KviUserParser::parseWindow(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseWindow");
	if(!(**pC))return (_KVI_CMD_parseWindow|_KVI_ERR_MissingWindow);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseWindow|_KVI_ERR_MissingWindow);
	m_lpIdentifiers->substitute(lpC,szCmd,pP);
	int idx=szCmd.find(' ');
	QString szCommand="";
	if(idx != -1){ szCommand=szCmd.left(idx); szCmd.remove(0,idx+1);szCmd=szCmd.stripWhiteSpace();}
	else return (_KVI_CMD_parseWindow|_KVI_ERR_MissingWindow);
	if(szCmd.isEmpty())return (_KVI_CMD_parseWindow|_KVI_ERR_MissingWindow);
	if(!strncasecmp(szCommand.data(),"open",4)){
		if(szCmd[0] != '*')return (_KVI_CMD_parseWindow|_KVI_ERR_WrongWindowName);
		//check if the name contains spaces (and flags...)
		idx=szCmd.find(' ');
		QString szWinName="";
		if(idx != -1){ szWinName=szCmd.left(idx); szCmd.remove(0,idx);szCmd=szCmd.stripWhiteSpace(); }
		else { szWinName=szCmd.copy(); szCmd=""; }
		KviMdiChild *lpX=m_lpMdi->findWindow(szWinName.data());
		if(!lpX){ //create it
			bool hasInp=true;
			bool hidden=false;
			bool hasClo=true;
			QRect geom(0,0,100,100);
			bool gotSize=false;
			QString szBack="";
			KviUserWnd *lpW=0;
			if(szCmd.isEmpty()){
				lpW=m_lpFrm->createUserWnd(szWinName.data(),hidden,hasInp);
			} else {
				//check for flags.
				int spIndex=szCmd.find(' ');
				QString szArg="";
				QString szTimestamp="";
				QString szImages="";
				uint fontSize=0;
				QString szFont;
				while(!szCmd.isEmpty()){
					if(spIndex==-1){ szArg=szCmd.copy(); szCmd=""; }
					else { szArg=szCmd.left(spIndex); szCmd.remove(0,spIndex+1); szCmd=szCmd.stripWhiteSpace(); }
					if(!strcasecmp("noclose",szArg.data()))hasClo=false;
					else if(!strcasecmp("noinput",szArg.data()))hasInp=false;
					else if(!strcasecmp("hidden",szArg.data()))hidden=true;
					else if(!strncasecmp("size=",szArg.data(),5)){
						gotSize=true;
						int idxEq=szArg.find('=');
						QString szRect=szArg.right(szArg.length()-(idxEq+1));
						int g[4];
						g[0]=0;
						g[1]=0;
						g[2]=200;
						g[3]=200;
						sscanf(szRect.data(),"%d,%d,%d,%d",&g[0],&g[1],&g[2],&g[3]);
						geom.setRect(g[0],g[1],g[2],g[3]);
					} else if(!strncasecmp("background=",szArg.data(),11)){
						int idxEq=szArg.find('=');
						if(idxEq != -1)szBack=szArg.right(szArg.length()-(idxEq+1));
					} else if(!strncasecmp("timestamp=",szArg.data(),10)){
						int idxEq=szArg.find('=');
						if(idxEq != -1)szTimestamp=szArg.right(szArg.length()-(idxEq+1));		
					} else if(!strncasecmp("images=",szArg.data(),7)){
						int idxEq=szArg.find('=');
						if(idxEq != -1)szImages=szArg.right(szArg.length()-(idxEq+1));
					} else if(!strncasecmp("font=",szArg.data(),5)){
						int idxEq=szArg.find('=');
						if(idxEq != -1){
							QString szFontTmp=szArg.right(szArg.length()-(idxEq+1));
							int idx=szFontTmp.find(',');
							if(idx != -1){
								szFont=szFontTmp.left(idx);
								szFontTmp.remove(0,idx+1);
								bool bOk=false;
								fontSize=szFontTmp.toUInt(&bOk);
								if(!bOk)fontSize=12;
							} else {
								fontSize=12;
								szFont=szFontTmp.copy();
							}
						}
					}
					spIndex=szCmd.find(' ');
				}
				//debug("Back = %s",szBack.data());
				//create the wnd
				const char *szB=( szBack.isEmpty() ? 0 : szBack.data());
				QRect *ptrToGeom= (gotSize ? (&geom) : 0);
				lpW=m_lpFrm->createUserWnd(szWinName.data(),hidden,hasInp,szB,ptrToGeom);
				lpW->enableClose(hasClo);
				if(!szTimestamp.isEmpty()){
					if(!strncasecmp(szTimestamp.data(),"true",4))lpW->m_lpOutput->m_bTimestamp=true;
					else if(!strncasecmp(szTimestamp.data(),"false",5))lpW->m_lpOutput->m_bTimestamp=false;
				}
				if(!szImages.isEmpty()){
					if(!strncasecmp(szImages.data(),"true",4))lpW->m_lpOutput->m_bShowPixmaps=true;
					else if(!strncasecmp(szImages.data(),"false",5))lpW->m_lpOutput->m_bShowPixmaps=false;
				}
				if(!szFont.isEmpty()){
					QFont fnt(szFont.data(),fontSize);
					lpW->m_lpOutput->setFont(fnt);
				}
			}
		}
	} else if(!strncasecmp(szCommand.data(),"close",5)){
		if(szCmd[0] != '*')return (_KVI_CMD_parseWindow|_KVI_ERR_WrongWindowName);
		KviMdiChild *lpW=m_lpMdi->findWindow(szCmd.data());
		if(!lpW)return (_KVI_CMD_parseWindow|_KVI_ERR_WindowNotFound);
		lpW->closeSlot();
	} else if(!strncasecmp(szCommand.data(),"hide",4)){
		KviMdiChild *lpW=m_lpMdi->findWindow(szCmd.data());
		if(!lpW)return (_KVI_CMD_parseWindow|_KVI_ERR_WindowNotFound);
		if(!lpW->m_bMinimized)lpW->minimizeWindow(); //minimize
		m_lpMdi->focusTopChild();
	} else if(!strncasecmp(szCommand.data(),"show",4)){
		KviMdiChild *lpW=m_lpMdi->findWindow(szCmd.data());
		if(!lpW)return (_KVI_CMD_parseWindow|_KVI_ERR_WindowNotFound);
		if(lpW->m_bMinimized)lpW->minimizeWindow(); //restore
		lpW->raise();
		lpW->setFocus();
	} else if(!strncasecmp(szCommand.data(),"maximize",8)){
		KviMdiChild *lpW=m_lpMdi->findWindow(szCmd.data());
		if(!lpW)return (_KVI_CMD_parseWindow|_KVI_ERR_WindowNotFound);
		if(!lpW->m_bMaximized)lpW->maximizeWindow();
		lpW->raise();
		lpW->setFocus();
	} else if(!strncasecmp(szCommand.data(),"restore",7)){
		KviMdiChild *lpW=m_lpMdi->findWindow(szCmd.data());
		if(!lpW)return (_KVI_CMD_parseWindow|_KVI_ERR_WindowNotFound);
		if(lpW->m_bMaximized)lpW->maximizeWindow();
		lpW->raise();
		lpW->setFocus();
	} else if(!strncasecmp(szCommand.data(),"setimage",8)){
		QString szWinName="";
		if(szCmd.isEmpty())return (_KVI_CMD_parseWindow|_KVI_ERR_MissingWindow);
		idx=szCmd.find(' ');
		if(idx != -1){ szWinName=szCmd.left(idx); szCmd.remove(0,idx);szCmd=szCmd.stripWhiteSpace(); }
		else return (_KVI_CMD_parseWindow|_KVI_ERR_MissingFileName);
		KviMdiChild *lpW=m_lpMdi->findWindow(szWinName.data());
		if(!lpW)return (_KVI_CMD_parseWindow|_KVI_ERR_WindowNotFound);
		if(lpW->m_lpOutput){
			lpW->m_lpOutput->setUserBackground(szCmd.data());
			lpW->m_lpOutput->repaint(false);
		}
	} else if(!strncasecmp(szCommand.data(),"tile",4)){
		if(!szCmd.isEmpty()){
			if(!strncasecmp(szCmd.data(),"vert",4))m_lpMdi->tileVert();
			else if(!strncasecmp(szCmd.data(),"horz",4))m_lpMdi->tileHorz();
			else if(!strncasecmp(szCmd.data(),"pragma",6))m_lpMdi->tilePragma();
			else if(!strncasecmp(szCmd.data(),"anodine",7))m_lpMdi->tileAnodine();
			else m_lpMdi->tilePragma(); //default
		} else m_lpMdi->tileAnodine(); //default
	} else if(!strncasecmp(szCommand.data(),"cascade",7)){
		m_lpMdi->cascadeWindows();
	} else return (_KVI_CMD_parseWindow|_KVI_ERR_UnknownWindowCommand);
	(*pC)=rghPtr;
	_debug_leavetrace("parseWindow");
	return (_KVI_CMD_parseWindow|_KVI_ERR_Success);
}
//============ parseForeach ============//
int KviUserParser::parseForeach(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseForeach");
	if(!(**pC))return (_KVI_CMD_parseForeach|_KVI_ERR_MissingExpression);
	if((**pC) != '(')return (_KVI_CMD_parseForeach|_KVI_ERR_UnexpectedChar);
	const char *rghPtr=(*pC);
	int match=1;
	while(match){
		(rghPtr)++;
		if(!(*rghPtr))return (_KVI_CMD_parseForeach|_KVI_ERR_UnexpectedEndInExpr);
		if(*rghPtr=='(')match++;
		if(*rghPtr==')')match--;
	}
	(rghPtr)++;
	if(!(*rghPtr))return (_KVI_CMD_parseForeach|_KVI_ERR_UnexpectedEndInExpr);
	(*pC)++; //skip the first (
	QString szExpr((*pC),(rghPtr-(*pC)));
	(*pC)=rghPtr;
	//Got the expression
	_macro_skipSenselessChars((*pC));
	QString szThen;
	if(!(**pC))return (_KVI_CMD_parseForeach|_KVI_ERR_MissingCommand);
	if(**pC==KVI_CHAR_BEGIN){ //strip up to matching brace
		rghPtr=(*pC);
		match=1;
		while(match){
			(rghPtr)++;
			if(!(*rghPtr))return (_KVI_CMD_parseForeach|_KVI_ERR_UnexpectedEndInCmd);
			if(*rghPtr==KVI_CHAR_BEGIN)match++;
			if(*rghPtr==KVI_CHAR_END)match--;
		}
		(rghPtr)++;
		if(!(*rghPtr))return (_KVI_CMD_parseForeach|_KVI_ERR_UnexpectedEndInCmd);
		szThen=QString((*pC),(rghPtr-(*pC))+1);
		//newline handling...same as in if
		_macro_skipSpacesAndTabs(rghPtr);
		if((*rghPtr !=';')&&(*rghPtr != '\n'))return (_KVI_CMD_parseForeach|_KVI_ERR_MissingSeparator);
		(*pC)=rghPtr;
	} else { //strip up to ;
		rghPtr=(*pC);
		_macro_skipUpToEndOfCmd(rghPtr);
		szThen=QString((*pC),(rghPtr-(*pC))+1);
		(*pC)=rghPtr;
	}
	////Now evaluate the parameters passed
	QString szVar;
	int idx=szExpr.find(',');
	if(idx > 1){
		szVar=szExpr.left(idx);szExpr.remove(0,idx+1);
	} else return (_KVI_CMD_parseForeach|_KVI_ERR_MissingVariable);

	KviVariable *lpX=0;
	int varIdx=0;
	if((szVar[1]>='0')&&(szVar[1]<='9')&&(szVar.length()==2)){
		if(!pP)return (_KVI_CMD_parseForeach|_KVI_ERR_ThisIsNotAnAlias);
		szVar.remove(0,1);
		varIdx=szVar.toInt();
	} else {
		KviVariable *lpV=0;
		for(lpV=m_lpVarList->first();((lpV) && (!lpX));lpV=m_lpVarList->next()){
			if(!strcasecmp(lpV->szName.data(),szVar.data())){
				lpX=lpV;
			}
		}
		if(!lpX){
			lpX=new KviVariable;
			lpX->szName=szVar.copy();
			addVariable(lpX);
		}
	}
	//now lpX points to the var to set or is 0 --> varIdx is the index to the parameter to store
	m_lpIdentifiers->substitute(lpC,szExpr,pP);
	QString * pStr=( lpX ? (&(lpX->szValue)) : (&(pP->param[varIdx])) );
	while(!szExpr.isEmpty()){
		int cmdIdx=szExpr.find(',');
		if(cmdIdx != -1){ (*pStr)=szExpr.left(cmdIdx); szExpr.remove(0,cmdIdx+1); }
		else { (*pStr)=szExpr.copy(); szExpr=""; }
		const char *pCmd=szThen.data();
		int numErr=parseUserCommand(lpC,&pCmd,pP);
		if(numErr & _KVI_ERR_ErrorMask)return numErr;
		if(lpX){ //we were using a variable
			if(m_lpVarList->findRef(lpX) == -1){ //someone deleted the variable
				//recreate it
				lpX=new KviVariable;
				lpX->szName=szVar.copy();
				addVariable(lpX);
				pStr = (&lpX->szValue);
			}
		}
	}
	if(lpX)m_lpVarList->removeRef(lpX);
	_debug_leavetrace("parseForeach");
	return (_KVI_CMD_parseForeach|_KVI_ERR_Success);
}
//============ parseDns ============//
int KviUserParser::parseDns(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseDns");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())return (_KVI_CMD_parseDns|_KVI_ERR_NoHostToResolve);
	m_lpIdentifiers->substitute(lpC,szCmd,pP);
	if(!m_lpFrm->m_lpDns->queryDns(szCmd.data()))return (_KVI_CMD_parseDns|_KVI_ERR_CantStartResolver);
	(*pC)=rghPtr;
	_debug_leavetrace("parseDns");
	return (_KVI_CMD_parseDns|_KVI_ERR_Success);
}
//============ parseAscii ============//
int KviUserParser::parseAscii(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseAscii");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	int timeout=1000;
	KviMdiChild *lpWnd=lpC;
	QString szFile="";
	if(szCmd.isEmpty()){
//		QString szSnd=i18n("Choose a file to play");
		QString szHome(_macro_getKVircHomeDirectory("Ascii"));
//		m_lpFrm->m_bFocusManagingEnabled=false;
		szFile=_macro_getOpenFileName(i18n("Choose an ascii file..."),szHome.data(),0);
//		m_lpFrm->m_bFocusManagingEnabled=true;
		if(szFile.isEmpty())return (_KVI_CMD_parseAscii|_KVI_ERR_Success);
	} else { //at least file name
		int idx=szCmd.find(' ');
		if(idx==-1){
			szFile=szCmd.copy();
		} else {
			szFile=szCmd.left(idx);
			szCmd.remove(0,idx+1);
			szCmd=szCmd.stripWhiteSpace();
			QString szWindow;
			idx=szCmd.find(' ');
			if(idx==-1){
				szWindow=szCmd.copy();
			} else {
				szWindow=szCmd.left(idx);
				szCmd.remove(0,idx+1);
				szCmd=szCmd.stripWhiteSpace();
				bool bOk=false;
				timeout=szCmd.toUInt(&bOk);
				if(!bOk)timeout=1000;
			}
			KviMdiChild *lpX=m_lpFrm->m_lpMdi->findWindow(szWindow.data());
			if(lpX)lpWnd=lpX;
			else {
				lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[ASCII] : Can't play file : window %s not found"),szWindow.data());
				(*pC)=rghPtr;
				_debug_leavetrace("parseAscii");
				return (_KVI_CMD_parseAscii|_KVI_ERR_Success);
			}
		}
	}
	if(!strncasecmp(szFile.data(),"-stop",5))m_lpFrm->m_lpAsciiPlayer->stopAll();
	else {
		if(!m_lpFrm->m_lpAsciiPlayer->playAscii(szFile.data(),lpWnd,timeout)){
			lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[ASCII] : Can't play file : file %s not found"),szFile.data());
		}
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseAscii");
	return (_KVI_CMD_parseAscii|_KVI_ERR_Success);
}
//============ parseCache ============//
//cache load section key variable
//cache store section key data
//cache clear
//cache remove section key
//cache remove section
//cache flush
int KviUserParser::parseCache(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseCache");
	if(!(**pC))return (_KVI_CMD_parseCache|_KVI_ERR_MissingOperation);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
//	m_lpIdentifiers->substitute(lpC,szCmd,pP);
	szCmd=szCmd.stripWhiteSpace();
//	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseCache|_KVI_ERR_MissingOperation);
	if(!strncasecmp(szCmd.data(),"load",4)){
		KviIrcToken token(szCmd);
		QString szDum=token.nextWord();
		QString szSec=token.nextWord();
		QString szKey=token.nextWord();
		QString szVar=token.nextWord();
		if(szSec.isEmpty() || szKey.isEmpty() || (szVar.length()<2))return (_KVI_CMD_parseCache|_KVI_ERR_MissingKey);
		if(szVar[0] != '$')return (_KVI_CMD_parseCache|_KVI_ERR_MissingKey);
		if(szVar[1]=='_')return (_KVI_CMD_parseCache|_KVI_ERR_CantSetSystemVar);
		if(szVar[1]=='%'){
			if(!strncmp(szVar.data(),"$%ext_dynamic[",14)){
				szVar.remove(0,14);
				szVar.resize(szVar.length()); //cut the last ]
				szVar=szVar.stripWhiteSpace();
				if(szVar.length()<2)return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
				if(szVar[0] != '$')return (_KVI_CMD_parseSet|_KVI_ERR_MissingVariable);
				szVar.remove(0,1);
				m_lpIdentifiers->substitute(lpC,szVar,pP);
				szVar.prepend("$");
			}
			else return (_KVI_CMD_parseCache|_KVI_ERR_CantSetSystemVar);
			if(szVar.length() <2)return (_KVI_CMD_parseCache|_KVI_ERR_MissingKey);
			if(szVar[0] != '$')return (_KVI_CMD_parseCache|_KVI_ERR_MissingKey);
			if((szVar[1]=='_')||(szVar[1]=='%'))return (_KVI_CMD_parseCache|_KVI_ERR_CantSetSystemVar);
		}
		QString szVal="";
		m_lpIdentifiers->substitute(lpC,szSec,pP);
		m_lpIdentifiers->substitute(lpC,szKey,pP);
		szVal=m_lpCache->getKey(szSec.data(),szKey.data());
		if(szVal.isEmpty())szVal=KVI_STR_NULL;
		if((szVar[1]>='0')&&(szVar[1]<='9')&&(szVar.length()==2)){
			if(!pP)return (_KVI_CMD_parseCache|_KVI_ERR_ThisIsNotAnAlias);
			szVar.remove(0,1);
			int index=szVar.toInt();
			pP->param[index]=szVal.copy();
		} else {
			KviVariable *lpV=0;
			for(lpV=m_lpVarList->first();lpV;lpV=m_lpVarList->next()){
				if(!strcasecmp(lpV->szName.data(),szVar.data())){
					lpV->szValue=szVal.copy();
					(*pC)=rghPtr;
					return (_KVI_CMD_parseCache|_KVI_ERR_Success);
				}
			}
			lpV=new KviVariable;
			lpV->szName=szVar.copy();
			lpV->szValue=szVal.copy();
			addVariable(lpV);
		}
	} else if(!strncasecmp(szCmd.data(),"store",5)){
		m_lpIdentifiers->substitute(lpC,szCmd,pP);
		KviIrcToken token(szCmd);
		QString szDum=token.nextWord();
		QString szSec=token.nextWord();
		QString szKey=token.nextWord();
		if(szSec.isEmpty() || szKey.isEmpty() || token.szString.isEmpty())return (_KVI_CMD_parseCache|_KVI_ERR_MissingKey);
		m_lpCache->insertKey(szSec.data(),szKey.data(),token.szString.data());
	} else if(!strncasecmp(szCmd.data(),"clear",5)){
		m_lpCache->clearCache();
	} else if(!strncasecmp(szCmd.data(),"show",4)){
		m_lpCache->echoToWindow(lpC);
	} else if(!strncasecmp(szCmd.data(),"flush",5)){
		if(!m_lpCache->writeCache()){
			KMsgBox::message(m_lpFrm,i18n("File I/O error"),i18n("Unable to flush cache."));
		}
	} else if(!strncasecmp(szCmd.data(),"remove",6)){
		m_lpIdentifiers->substitute(lpC,szCmd,pP);
		KviIrcToken token(szCmd);
		QString szDum=token.nextWord();
		QString szSec=token.nextWord();
		QString szKey=token.nextWord();
		if(szSec.isEmpty())return (_KVI_CMD_parseCache|_KVI_ERR_MissingKey);
		if(szKey.isEmpty()){
			m_lpCache->removeSection(szSec.data());
		} else {
			m_lpCache->removeKey(szSec.data(),szKey.data());
		}
	} else return (_KVI_CMD_parseCache|_KVI_ERR_UnknownCacheOperation);
	(*pC)=rghPtr;
	_debug_leavetrace("parseCache");
	return (_KVI_CMD_parseCache|_KVI_ERR_Success);
}
//============ parseReturn ============//
int KviUserParser::parseReturn(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseReturn");
	if(!pP)return (_KVI_CMD_parseReturn|_KVI_ERR_ThisIsNotAnAlias);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())return (_KVI_CMD_parseReturn|_KVI_ERR_MissingReturnData);
	m_lpIdentifiers->substitute(lpC,szCmd,pP);
	pP->szReturn=szCmd.copy();
	(*pC)=rghPtr;
	_debug_leavetrace("parseReturn");
	return (_KVI_CMD_parseReturn|_KVI_ERR_Success);
}
//============ parseSound ============//
int KviUserParser::parseSound(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseSound");
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	_macro_getCommandParameters(szCmd,(*pC),rghPtr,lpC,pP);
	KviMdiChild *lpWnd=0;
	QString szTarget=getStringToken(szCmd);
	if(szTarget.isEmpty()){
		lpWnd=lpC;
		szTarget=lpC->name();
	} else lpWnd=m_lpFrm->m_lpMdi->findWindow(szTarget.data());
	if(!lpWnd)return (_KVI_CMD_parseSound|_KVI_ERR_WindowNotFound);
	if((lpWnd->type()!=KVI_WND_TYPE_CHAN)&&(lpWnd->type()!=KVI_WND_TYPE_QUERY)) return (_KVI_CMD_parseSound|_KVI_ERR_NonChannelAction);
	if(szCmd.isEmpty()){
//		QString szSnd=i18n("Choose a sound file to play");
		QString szHome(_macro_getKVircHomeDirectory("Audio"));
//		m_lpFrm->m_bFocusManagingEnabled=false;
		szCmd=_macro_getOpenFileName(i18n("Choose a sound file..."),szHome.data(),
			i18n("*.wav|Wav files (*.wav)\n*.mp3|Mpeg audio file (*.mp3)\n*.au|Sun audio files (*.au)\n*.mid|Midi files (*.mid)\n*.*|All files"));
//		m_lpFrm->m_bFocusManagingEnabled=true;
		szCmd=szCmd.stripWhiteSpace();
		if(szCmd.isEmpty())return (_KVI_CMD_parseSound|_KVI_ERR_Success);
	}
	QString szFile=szCmd.data();
	int idx=szFile.find('/');
	while(idx != -1){
		szFile.remove(0,idx+1);
		idx=szFile.find('/');
	}
	if(m_lpSock->sendFmtData("PRIVMSG %s :%cSOUND %s%c",szTarget.data(),0x01,szFile.data(),0x01))
				return (_KVI_CMD_parseSound|_KVI_ERR_NotConnected);
	lpWnd->doFmtOutput(KVI_OUT_SOUND,i18n("%s plays %s"),m_lpGlb->szNick.data(),szFile.data());
	switch(m_lpFrm->m_lpAudio->playSound(szCmd.data())){
		case KVI_AUDIO_FILE_NOT_FOUND:
			lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[SOUND] : Sound file %s not found"),szCmd.data());
			break;
		case KVI_AUDIO_NO_SOUND_SERVER:
			lpC->doOutput(KVI_OUT_ERROR,i18n("[SOUND] : Sound server not active or not ready."));
			break;
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseSound");
	return (_KVI_CMD_parseSound|_KVI_ERR_Success);
}
//===============parseFile==============//

int KviUserParser::parseFile(KviMdiChild *lpC,const char ** pC,KviAliasParams *pP)
{
	_debug_entertrace("parseFile");
	if(!(**pC))return (_KVI_CMD_parseFile|_KVI_ERR_MissingOperation);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	m_lpIdentifiers->substitute(lpC,szCmd,pP);
	if(szCmd.isEmpty())return (_KVI_CMD_parseFile|_KVI_ERR_MissingOperation);
	int idx=szCmd.find(' ');
	QString szOp="";
	if(idx != -1){
		szOp=szCmd.left(idx);
		szCmd.remove(0,idx+1);
	} else if(!strncasecmp(szCmd.data(),"show",4)){
		m_lpFileManager->showFiles(lpC);
		(*pC)=rghPtr;
		return (_KVI_CMD_parseFile|_KVI_ERR_Success);	
	} else return (_KVI_CMD_parseFile|_KVI_ERR_MissingOperation);
	if(!strncasecmp(szOp.data(),"open",4)){
		if(szCmd.isEmpty())return (_KVI_CMD_parseFile|_KVI_ERR_MissingFileIdent);
		idx=szCmd.find(' ');
		QString szIdent="";
		if(idx != -1){
			szIdent=szCmd.left(idx);
			szCmd.remove(0,idx+1);
		} else return (_KVI_CMD_parseFile|_KVI_ERR_MissingFileName);
		idx=szCmd.find(' ');
		QString szFile="";
		int flags=KVI_FILE_OPEN_READ;
		if(idx != -1){
			szFile=szCmd.left(idx);
			szCmd.remove(0,idx+1);
			if(szCmd.find("write") != -1){
				flags=KVI_FILE_OPEN_WRITE;
				if(szCmd.find("truncate") != -1)flags |= KVI_FILE_OPEN_TRUNCATE;
			} else {
				if(szCmd.find("circular") != -1)flags |= KVI_FILE_OPEN_CIRCULAR;
			}
		} else {
			szFile=szCmd.copy();
			szCmd="";
		}
		if(!m_lpFileManager->fileOpen(szIdent.data(),szFile.data(),flags)){
			lpC->doFmtOutput(KVI_OUT_ERROR,i18n("[FILE open] : File %s not found , or insufficient permissions for operation"),szFile.data());
		}
		(*pC)=rghPtr;
		return (_KVI_CMD_parseFile|_KVI_ERR_Success);
	} else if(!strncasecmp(szOp.data(),"close",5)){
		if(szCmd.isEmpty())return (_KVI_CMD_parseFile|_KVI_ERR_MissingFileIdent);
		if(!m_lpFileManager->fileClose(szCmd.data()))return (_KVI_CMD_parseFile|_KVI_ERR_FileNotOpen);
	} else return (_KVI_CMD_parseFile|_KVI_ERR_UnknownFileOperation);
	(*pC)=rghPtr;
	_debug_leavetrace("parseFile");
	return (_KVI_CMD_parseFile|_KVI_ERR_Success);
}
//============ parseAlias ============//
//
// By now handle only simple aliases such as
// /ALIAS J /join $0
// /ALIAS WHO /if ($0) raw who $0;
int KviUserParser::parseAlias(KviMdiChild *,const char ** pC,KviAliasParams *)
{
	_debug_entertrace("parseAlias");
	if(!(**pC))return (_KVI_CMD_parseAlias|_KVI_ERR_MissingAliasName);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())return (_KVI_CMD_parseAlias|_KVI_ERR_MissingAliasName);
	int idx=szCmd.find(' ');
	if(idx==-1)return (_KVI_CMD_parseAlias|_KVI_ERR_MissingAliasBody);
	QString szName=szCmd.left(idx);
	szCmd.remove(0,idx+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())return (_KVI_CMD_parseAlias|_KVI_ERR_MissingAliasName);	
	if((!strncasecmp(szName.data(),"-r",2))&&(szName.length()==2)){ //remove it
		KviAliasStruct *pS=m_lpAliasManager->getAlias(szCmd.data());
		if(!pS)return (_KVI_CMD_parseAlias|_KVI_ERR_NoAliasWithThatName);
		m_lpAliasManager->removeAlias(szCmd.data());
	} else { //add it
		szName=szName.upper();
		m_lpAliasManager->addAlias(szName.data(),szCmd);
		m_lpAliasManager->sortAliases();
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseAlias");
	return (_KVI_CMD_parseAlias|_KVI_ERR_Success);
}

//============ parseKvidebug ============//
// KVIDEBUG : internal debug command : undocumented
//   /KVIDEBUG parameters
//   parameters list:
//      ulist #channel : dumps the channel user list to channel
//
int KviUserParser::parseKvidebug(KviMdiChild *lpC,const char ** pC,KviAliasParams *)
{
	_debug_entertrace("parseKvidebug");
	if(!(**pC))return (_KVI_CMD_parseKvidebug|_KVI_ERR_MissingText);
	const char *rghPtr=(*pC);
	_macro_skipUpToEndOfCmd(rghPtr);
	QString szCmd((*pC),(rghPtr-(*pC))+1);
	szCmd=szCmd.stripWhiteSpace();
	if(szCmd.isEmpty())return (_KVI_CMD_parseKvidebug|_KVI_ERR_MissingText);
	if(!strncasecmp(szCmd.data(),"ulist",5)){
		int idx=szCmd.find(' ');
		if(idx!=-1){
			szCmd.remove(0,idx+1);
			szCmd=szCmd.stripWhiteSpace();
			KviMdiChild *lpX=m_lpMdi->findWindow(szCmd.data());
			if(lpX){
				if(lpX->type()==KVI_WND_TYPE_CHAN){
					KviChanWnd *lpW=(KviChanWnd *)lpX;
					KviNewNick *lpN=0;
					KviListBoxEntry *lpE;
					lpC->doFmtOutput(KVI_OUT_INTERNAL,"# Dumping user list for channel %s",szCmd.data());
					for(lpE=lpW->m_lpListBox->m_lpNickList->first();lpE;lpE=lpW->m_lpListBox->m_lpNickList->next()){
						lpN=lpE->lpNick;
						lpC->doFmtOutput(KVI_OUT_INTERNAL,"Entry :%s!%s@%s , KviNewNick ptr :%u\n    isOp :%d isVoice :%d ",
							lpN->szNick.data(),lpN->szUserName.data(),lpN->szAddress.data(),(unsigned long)lpN,
							(int)lpE->bOp,(int)lpE->bVoice);
					}
					lpC->doFmtOutput(KVI_OUT_INTERNAL,"# Total entries : %d",lpW->m_lpListBox->m_lpNickList->count());
				} else return (_KVI_CMD_parseKvidebug|_KVI_ERR_MissingWindow);
			} else return (_KVI_CMD_parseKvidebug|_KVI_ERR_MissingWindow);
		} else m_lpFrm->m_lpGlobalUserList->dump(lpC);
	}
	(*pC)=rghPtr;
	_debug_leavetrace("parseKvidebug");
	return (_KVI_CMD_parseKvidebug|_KVI_ERR_Success);
}
///////////////////////OLD LOGS FOR kvi_uparser2.cpp
// Revision 1.9  1998/10/01 00:40:08  pragma
// Added /alias command
//
// Revision 1.8  1998/09/28 13:36:25  pragma
// Added a patch by Anodine
//
// Revision 1.7  1998/09/25 15:58:42  pragma
// Moving ti use the KviProxy class.
//
// Revision 1.6  1998/09/23 12:41:59  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.5  1998/09/16 18:25:10  fritz
// Fixed typo.
//
// Revision 1.4  1998/09/16 17:17:10  fritz
// Starting i18n.
//
// Revision 1.3  1998/09/16 16:13:25  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
//////////////////////////////////////////////

//
// $Log: kvi_uparser.cpp,v $
// Revision 1.7  1998/10/06 14:42:50  pragma
// Tons of changes
//
//
