//   $Id: kvi_uldlg.h,v 1.2 1998/09/23 23:15:16 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_ULDLG_H_INCLUDED_
#define _KVI_ULDLG_H_INCLUDED_

#include <ktablistbox.h>
#include <kintegerline.h>
#include <krestrictedline.h>

#include <qdialog.h>
#include <qcheckbox.h>
#include <qlist.h>
#include <qwidgetstack.h>

#include "kvi_mlined.h"

class KviUserListDialog;

class KviUserEditDialog : public QDialog{
	Q_OBJECT
public:
	KviUserEditDialog(KviUserListDialog *parent,KviUserStruct *lpS,KviFrame *lpFrm);
	~KviUserEditDialog();
public:
	KviUserStruct *m_lpUser;
	KRestrictedLine *m_lpNick;
	KRestrictedLine *m_lpUsr;
	KRestrictedLine *m_lpHost;
	QMultiLineEdit *m_lpNotes;
	KviMultiLineEdit *m_lpJoinAct;
	KviMultiLineEdit *m_lpNotifyAct;
	KviMultiLineEdit *m_lpCtcpAct;
	QLabel *m_lpParams;
	QWidgetStack *m_lpLabelStack;
	QWidgetStack *m_lpEditStack;
	QComboBox *m_lpCombo;
	QCheckBox *m_lpEnableJoin;
	QCheckBox *m_lpEnableNotify;
	QCheckBox *m_lpEnableCtcp;
	QCheckBox *m_lpNotify;
	QCheckBox *m_lpIgnore;
public slots:
	void invokeHelp();
	void okPressed();
	void comboActivated(int nIndex);
};

class KviUserListDialog : public QDialog{
	Q_OBJECT
public:
	KviUserListDialog(KviFrame *lpFrm,KviUserManager *lpMng,KviOptions *lpOpt);
	~KviUserListDialog();
public:
	KviUserManager *m_lpUserManager;
	QList<KviUserStruct> *m_lpLocalList;
	KviOptions *m_lpOpt;
	QCheckBox *m_lpEnableNotify;
	QCheckBox *m_lpNotifyInActive;
	QCheckBox *m_lpEnableActOnJoin;
	QCheckBox *m_lpEnableActOnNotify;
	QCheckBox *m_lpEnableActOnCtcp;
	QCheckBox *m_lpEnableIgnore;
	KIntegerLine *m_lpNotifyTime;
	KviFrame *m_lpFrm;
	KTabListBox *m_lpBox;
	QPushButton *m_lpEdit;
	QPushButton *m_lpRemove;
	QPushButton *m_lpClear;
	int m_iLastItem;
protected:
	void fillBox();
	void insertBoxItem(KviUserStruct *lpS,int index=-1);
protected slots:
	void clearList();
	void invokeHelp();
	void okPressed();
	void addUser();
	void removeUser();
	void editUser();
	void itemSelected(int index,int);
	void midClickEdit(int index,int);
};
#endif //_KVI_ULDLG_H_INCLUDED_
