//   $Id: kvi_tskbtn.h,v 1.2 1998/09/20 20:24:13 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_TASKBARBUTTON_H_INCLUDED_
#define _KVI_TASKBARBUTTON_H_INCLUDED_

#include <qpushbt.h>
#include <qpixmap.h>
#include <qtooltip.h>

class KviNewTaskBarButton : public QWidget
{
	Q_OBJECT
public:
	KviNewTaskBarButton(const char *text,QWidget *parent,QPixmap *icon,int nId,bool bProgress=false);
	~KviNewTaskBarButton();
public:
	int     m_id;
	bool    m_bHighlighted;
	bool    m_bProgress;
	int     m_iProgressState;
	bool    m_bIsOn;
	QString m_szText;
	bool    m_bPressed;
public:
	void setOn(bool bOn);
	void setText(const char *szText);
	void setProgress(int progress);
	void highlight();
protected:
	QPixmap *m_lpIconPixmap;
protected:
	virtual void paintEvent(QPaintEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void leaveEvent(QEvent *);
signals:
	void rightClick(int id);
	void stateChanged(int id,bool bIsOn);
};








///////////// OLD CLASS


//class KviTaskBarButton : public QPushButton
//{//
//	Q_OBJECT
//public:
////	KviTaskBarButton(const char *text,QWidget *parent,const char *iconName,int nID,bool bProgress=false);
//	~KviTaskBarButton();
//
//	int		m_nID;
//	bool	m_bHighlited;
//	bool    m_bProgress;
//	int     m_iProgressState;
//
//	void	Highlight(bool high);
//protected:
//	QPixmap m_IconPixmap;
//	
//	virtual void drawButtonLabel(QPainter * paint);
//	virtual void drawButton(QPainter * paint);
//	virtual bool eventFilter(QObject *,QEvent *ev);
//};

#endif // _KVI_TASKBARBUTTON_H_INCLUDED_
