//
//   File : kvi_tskbtn.cpp (/usr/cvs/kvirc/kvirc/kvi_tskbtn.cpp)
//   Last modified : Sun Nov 22 1998 19:58:40 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviTaskBarButton"

#include "kvi_macros.h"
#include "kvi_tskbtn.h"
#include "kvi_debug.h"
#include "kvi_app.h"

#include <kiconloader.h>

#include <qpainter.h>
#include <qdrawutil.h>

//============ KviNewTaskBarButton ============//

KviNewTaskBarButton::KviNewTaskBarButton(const char *text,QWidget *parent,QPixmap *icon,int nId,bool bProgress=false)
:QWidget(parent,0)
{
	_debug_entertrace("KviNewTaskBarButton");
	m_id             = nId;
	m_bHighlighted   = false;
	m_bProgress      = bProgress;
	m_iProgressState = 0;
	m_bIsOn          = false;
	m_szText         = text;
	m_lpIconPixmap   = icon;
	m_bPressed       = false;
	QToolTip::add(this,text);
	_debug_leavetrace("KviNewTaskBarButton");
}

//============ ~KviNewTaskBarButton ============//

KviNewTaskBarButton::~KviNewTaskBarButton()
{
	_debug_entertrace("~KviNewTaskBatButton");
	_debug_leavetrace("~KviNewTaskBarButton");
}

//============ paintEvent ============//

void KviNewTaskBarButton::paintEvent(QPaintEvent *e)
{
	_debug_entertrace("paintEvent");
	int w=width();
	int h=height();
	if(!(w && h))return;
	QPixmap *buffer= new QPixmap(w,h);
	register QPainter *p=new QPainter(buffer);
	QColorGroup cg= colorGroup();
	QBrush br(cg.background());
	if(m_bPressed)qDrawWinPanel(p,0,0,w,h,cg,true,&br);
	else qDrawShadePanel(p,0,0,w,h,cg,m_bIsOn,1,&br);
	if(!m_lpIconPixmap->isNull())p->drawPixmap(3,(h-m_lpIconPixmap->height())/2,(*m_lpIconPixmap));
	if(m_bProgress){
		int wdth=(((w-28)*m_iProgressState)/100);
		p->setPen(QApplication::winStyleHighlightColor());
		p->drawRect( 25,3,w-28,h-5);
		p->fillRect( 25,3,wdth,h-5,QApplication::winStyleHighlightColor());
	}
    p->setBrush(NoBrush);
	if(m_bIsOn){
		m_bHighlighted=false;
		QFont the_font=font();
		the_font.setBold(true);
		p->setFont(the_font);
		p->setPen(cg.text());
	} else {
		p->setFont(font());
		if(m_bHighlighted)p->setPen(red);
		else p->setPen(cg.text());
	}
	//get the available width
	int textWidth=w-32;
	QFontMetrics fm(p->font());
	if(fm.width(m_szText.data()) >= textWidth){
		int pntWdth=fm.width("...");
		textWidth-=pntWdth;
		if(textWidth>0)p->drawText(25+textWidth,0,pntWdth,h,AlignVCenter|AlignLeft,"...");
	}
	if(textWidth>0)p->drawText(25,0,textWidth,h,AlignVCenter|AlignLeft,m_szText.data());
	p->end();
	delete p;
	int cx,cy,cw,ch;
	e->rect().coords(&cx,&cy,&cw,&ch);
	bitBlt(this,cx,cy,buffer,cx,cy,cw+1,ch+1,CopyROP);
	delete buffer;
	_debug_leavetrace("paintEvent");
}

//============ mousePressEvent ============//

void KviNewTaskBarButton::mousePressEvent(QMouseEvent *)
{
	_debug_entertrace("mousePressEvent");
	m_bPressed=true;
	repaint(false);
	_debug_leavetrace("mousePressEvent");
}

//============ mouseReleaseEvent ============//

void KviNewTaskBarButton::mouseReleaseEvent(QMouseEvent *e)
{
	_debug_entertrace("mouseReleaseEvent");
	m_bPressed=false;
	m_bHighlighted=false;
	if((!m_bIsOn) || (e->button()==LeftButton)){
		m_bIsOn=!m_bIsOn;
		repaint(false);
		emit stateChanged(m_id,m_bIsOn);
	} else repaint(false);
	if(e->button()==RightButton)emit rightClick(m_id);
	_debug_leavetrace("mouseReleaseEvent");
}

//============ leaveEvent ============//

void KviNewTaskBarButton::leaveEvent(QEvent *)
{
	_debug_entertrace("leaveEvent");
	if(m_bPressed){
		m_bPressed=false;
		repaint(false);
	}
	_debug_leavetrace("leaveEvent");
}

//============ setOn ============//

void KviNewTaskBarButton::setOn(bool bOn)
{
	_debug_entertrace("setOn");
	if(bOn != m_bIsOn){
		m_bIsOn=bOn;
		repaint(false);
	}
	_debug_leavetrace("setOn");
}

//============ setText ============//

void KviNewTaskBarButton::setText(const char *szText)
{
	_debug_entertrace("setText");
	m_szText=szText;
	QToolTip::remove(this);
	QToolTip::add(this,szText);
	repaint(false);
	_debug_leavetrace("setText");
}

//============ setProgress ============//

void KviNewTaskBarButton::setProgress(int progress)
{
	_debug_entertrace("setProgress");
	m_iProgressState=progress;
	repaint(false);
	_debug_leavetrace("setProgress");
}

//============ highlight ============//

void KviNewTaskBarButton::highlight()
{
	_debug_entertrace("highlight");
	if(!m_bIsOn){
		if(!m_bHighlighted){
			m_bHighlighted=true;
			repaint(false);
		}
	}
	_debug_leavetrace("highlight");
}

#include "m_kvi_tskbtn.moc"

//
// $Log: kvi_tskbtn.cpp,v $
//
// Revision X.X  Sun Nov 22 1998 19:58:52  pragma
// Rewritten the entire class ,
// fixed the 'too long text out of button painting'.
//
// Revision 1.3  1998/09/20 20:24:13  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.2  1998/09/15 13:19:40  pragma
// Taskbar buttons progress view fix.
//
//
