//   $Id: kvi_translate.h,v 1.2 1998/09/20 20:24:12 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_TRANSLATE_H_INCLUDED_
#define _KVI_TRANSLATE_H_INCLUDED_

#include <qstring.h>

class KviTranslator{
public:
	KviTranslator();
	~KviTranslator();
protected:
	unsigned char serverToClientTab[256];
	unsigned char clientToServerTab[256];
	QString m_szMapFileName;
	bool m_bDefault;
public:
	void setDefaultTranslationMap();
	bool setTranslationMap(const char *szMapFileName);
	void translateToClient(QString &szString);
	void translateToServer(QString &szString);
	const char *getMapFileName(){return m_szMapFileName.data();};
};

#endif //_KVI_TRANSLATE_H_INCLUDED_
