//
//   File : kvi_toolbar.cpp (/usr/cvs/kvirc/kvirc/kvi_toolbar.cpp)
//   Last modified : Sun Dec 13 1998 20:07:27 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_macros.h"
#include "kvi_toolbar.h"
#include "kvi_frame.h"
#include "kvi_debug.h"
#include "kvi_mdi.h"
#include "kvi_app.h"

#include <kiconloader.h>

//============ KviToolBar ============//

KviToolBar::KviToolBar(KviFrame *lpFrm) : KToolBar(lpFrm,"KviToolBar")
{
	_debug_entertrace("KviToolBar");
	m_lpFrm=lpFrm;
	setup();
	_debug_leavetrace("KviToolBar");
}

//============ ~KviToolBar ============//

KviToolBar::~KviToolBar()
{
	_debug_entertrace("~KviToolBar");
	_debug_leavetrace("~KviToolBar");
}

//============ setup ============//

void KviToolBar::setup()
{
	//insert buttons
	_debug_entertrace("setup");
	KIconLoader *lpI=_macro_kviIconLoader;
	insertButton(lpI->loadIcon("kvi_tlb_conn.gif"),1,SIGNAL(clicked()),
					m_lpFrm,SLOT(connectionSlot()),true,i18n("Connect"));
	QFrame *f=new QFrame(this);
	f->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	insertWidget(1000,2,f);
	insertButton(lpI->loadIcon("kvi_tlb_links.gif"),2,SIGNAL(clicked()),
					m_lpFrm,SLOT(doLinksWindow()),true,i18n("Query links"));
	insertButton(lpI->loadIcon("kvi_tlb_chan.gif"),3,SIGNAL(clicked()),
					m_lpFrm,SLOT(doChansWindow()),true,i18n("Query channels list"));
	f=new QFrame(this);
	f->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	insertWidget(1001,2,f);
	insertButton(lpI->loadIcon("kvi_tlb_usr.gif"),4,SIGNAL(clicked()),
					m_lpFrm,SLOT(doUserDialog()),true,i18n("User settings..."));
	insertButton(lpI->loadIcon("kvi_tlb_srv.gif"),5,SIGNAL(clicked()),
					m_lpFrm,SLOT(doServerDialog()),true,i18n("Servers and proxy..."));
	insertButton(lpI->loadIcon("kvi_tlb_opt.gif"),6,SIGNAL(clicked()),
					m_lpFrm,SLOT(doOptionsDialog()),true,i18n("Misc options..."));
	insertButton(lpI->loadIcon("kvi_tlb_dccopt.gif"),7,SIGNAL(clicked()),
					m_lpFrm,SLOT(doDccOptionsDialog()),true,i18n("DCC options..."));
	insertButton(lpI->loadIcon("kvi_tlb_ulist.gif"),8,SIGNAL(clicked()),
					m_lpFrm,SLOT(doUserListDialog()),true,i18n("User list..."));
	insertButton(lpI->loadIcon("kvi_tlb_int.gif"),9,SIGNAL(clicked()),
					m_lpFrm,SLOT(doInterfaceDialog()),true,i18n("User interface settings..."));
 	insertButton(lpI->loadIcon("kvi_tlb_clr.gif"),10,SIGNAL(clicked()),
					m_lpFrm,SLOT(doIrcColorsDialog()),true,i18n("Irc colors settings..."));
	f=new QFrame(this);
	f->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	insertWidget(1002,2,f);
	insertButton(lpI->loadIcon("kvi_tlb_alias.gif"),11,SIGNAL(clicked()),
					m_lpFrm,SLOT(doAliasDialog()),true,i18n("Aliases...(alias Macros:) )"));
 	insertButton(lpI->loadIcon("kvi_tlb_event.gif"),12,SIGNAL(clicked()),
					m_lpFrm,SLOT(doEventDialog()),true,i18n("Events"));
	insertButton(lpI->loadIcon("kvi_tlb_pop.gif"),13,SIGNAL(clicked()),
					m_lpFrm,SLOT(doPopupDialog()),true,i18n("Popups"));
	f=new QFrame(this);
	f->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	insertWidget(1003,2,f);
	insertButton(lpI->loadIcon("kvi_tlb_load.gif"),14,SIGNAL(clicked()),
					m_lpFrm,SLOT(loadScript()),true,i18n("Load a script"));
	insertButton(lpI->loadIcon("kvi_tlb_save.gif"),15,SIGNAL(clicked()),
					m_lpFrm,SLOT(saveScript()),true,i18n("Save current script"));
	f=new QFrame(this);
	f->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	insertWidget(1004,2,f);
	insertButton(lpI->loadIcon("kvi_tlb_help.gif"),16,SIGNAL(clicked()),
					_macro_kviApplication,SLOT(appHelpActivated()),true,i18n("Help index"));
 	insertButton(lpI->loadIcon("kvi_tlb_kvirc.gif"),17,SIGNAL(clicked()),
					m_lpFrm,SLOT(slotAboutKvirc()),true,i18n("Version"));
	connect(this,SIGNAL(moved(BarPosition)),this,SLOT(toolbarMoved(BarPosition)));

	setFocusProxy(m_lpFrm->m_lpMdi);
	_debug_leavetrace("setup");
}

//============ toolbarMoved ============//

void KviToolBar::toolbarMoved(BarPosition pos)
{
	//adjust the separators when the toolbar changes orientation
	_debug_entertrace("toolbarMoved");
	KToolBarButton *lpBtn=getButton(1);
	int wdth = 26;
	int hght = 26;
	if(lpBtn){
		wdth=lpBtn->width();
		hght=lpBtn->height();
	}
	if((pos==Left) || (pos==Right))hght=2; else wdth=2;
	QWidget *lpTF=getWidget(1000);
	lpTF->resize(wdth,hght);
	lpTF=getWidget(1001);
	lpTF->resize(wdth,hght);
	lpTF=getWidget(1002);
	lpTF->resize(wdth,hght);
	lpTF=getWidget(1003);
	lpTF->resize(wdth,hght);
	lpTF=getWidget(1004);
	lpTF->resize(wdth,hght);
	_debug_leavetrace("toolbarMoved");
}

#include "m_kvi_toolbar.moc"

//
// $Log: kvi_toolbar.cpp,v $
// Revision 1.4  1998/09/28 13:30:35  pragma
// Added the channel list button
//
// Revision 1.3  1998/09/23 12:41:55  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.2  1998/09/20 20:24:10  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.1  1998/09/18 14:31:18  pragma
// Code arrangement:
// Moved the kvi_frame toolbar to a new KviToolBar class.
//
